#include "colors.inc"
#include "golds.inc"
#include "stones.inc"
#include "woods.inc"
#include "glass.inc"

#include "fem_head02.inc"
#include "ribbons02.inc" 
 
 
global_settings
{
  max_trace_level 10
  assumed_gamma 1.33
}



light_source{<1000,1000,-1000>
        color White
}

camera{location<0,15,-15>
        look_at<0,15,0>
}



#declare island01 =        
height_field {
        tga "SkyIsland2.tga"
        water_level 0.1
        smooth
        pigment{
                spherical
                color_map {
                        [0 rgb<0.6,0.55,0.3>]
                        [0.3 rgb<0.6,0.5,0.25>] 
                        [0.45 rgb<0.8,0.6,0.1>]
                        [1 rgb<0.1,0.3,0>]
                }
                frequency 1
                scale x*2
                translate<.5,.5,0.7>
        }                   
        normal { bumps 1 scale .01 }
        scale <5,3,5>
        rotate x*180
}

#declare island02 =        
height_field {
        tga "SkyIsland3.tga"
        water_level 0.1
        smooth
        pigment{
                spherical
                color_map {
                        [0 rgb<0.4,0.55,0.3>]
                        [0.3 rgb<0.4,0.5,0.25>] 
                        [0.45 rgb<0.5,0.6,0.1>]
                        [1 rgb<0.1,0.3,0>]
                 }
                frequency 1
                scale x*2
                translate<.5,.5,0.7>
        }                   
        normal { bumps 1 scale .01 }
        scale <5,0.1,5>
        translate<0,-0.3,-5>
}

#declare island03 =
union{
        object{island01}
        object{island02}
}


#declare Sky1 = pigment { 
	gradient y
	turbulence 0.1
	color_map {
		[ 0 rgb<0.43, 0.43, 0.8> ]
                [ 1 rgb<0.13, 0.12, 0.5> ]
	}
        scale 2000
}



sky_sphere {
	pigment { Sky1 }
}




#declare CloudTexture = texture {
	pigment {
		bozo
		turbulence 1
		color_map {
		[ 0 rgbt<1, 1, 1, 1> ]
		[ 0.5 rgbt<1, 1, 1, 1> ]
		[ 1 rgbt<.49, 0.75, 1, 0.8> ]
		}
		scale 2000
	}

	finish {
		ambient 1
		diffuse 0
	}
}




plane {
	y, 1500
	hollow
	texture { CloudTexture }
}
fog {
	distance 2000
	fog_type 2
	color rgb<.65, 0.65, 0.65>
	fog_offset 0
	fog_alt 25
	turbulence 1
}


object{island03
        translate<-10,20,10>
}


 plane{<0,1,0>, 0 
        texture{
                pigment{color rgb<0.8,0.8,0.4>}
                normal{bumps 01 scale 0.01}
        }
        hollow
  }


union{
        object{Mask01
                texture{ 
                pigment{color Yellow}
                finish{phong 1}
                }
        }
        object{Ribbons02
                texture{ 
                pigment{color Green}
                finish{phong 1}
                }
        }
        scale<0.02,0.06,0.04>
        rotate y*70
        translate<8,20,5>
     
}

union{
        object{Mask01
                texture{ 
                pigment{color Red}
                finish{phong 1}
                }
        }
        object{Ribbons02
                texture{ 
                pigment{color Blue}
                finish{phong 1}
                }
        }
        scale<0.02,0.06,0.04>
        rotate y*-70
        translate<-8,10,1>
      
}



#declare outline =
 
 sphere_sweep {
    cubic_spline
    40,
    <0,-1,0>, 4
    <0,-1,0>, 4
    <-1,1.5,0>, 3.9
    <-2,3,0>, 3.8
    <-3,3.6,0>, 3.7
    <-3.5,4,0>, 3.6
    <-4,5,0>, 3.5
    <-4,6,0>, 3.4
    <-4.5,7,0>, 3.3
    <-5,8,0>, 3.2
    <-6,9,0>, 3.1
    <-7,9,0>, 3
    <-7.5,9.5,0>, 2.9
    <-8,10,0>, 2.8
    <-8.5,11,0>, 2.7
    <-8.5,12,0>, 2.6
    <-8.5,13,0>, 2.5
    <-8.75,14,0>, 2.4
    <-9.5,15,0>, 2.3
    <-11,16,0>, 2.2
    <-10.5,17,0>, 2.1
    <-12,18,0>, 2
    <-12,19,0>, 1.9
    <-12,20,0>, 1.8
    <-11.5,21,0>, 1.7
    <-13,22,0>, 1.6
    <-14,23,0>, 1.5
    <-14,24,0>, 1.4
    <-13,25,0>, 1.3
    <-12.5,26,0>, 1.2
    <-12,27,0>, 1.1
    <-11,28,0>, 1
    <-11,29,0>, 0.9
    <-11.25,29,0>, 0.8
    <-11,30,0>, 0.7
    <-10.5,31,0>, 0.6
    <-10,32,0>, 0.5
    <-9.5,33,0>, 0.4
    <-9,34,0>, 0.3
    <-9,35,0>, 0.2
    tolerance 0.1
 }

#declare brow = mesh {
	smooth_triangle { <0.0000, -0.2286, -1.0000>, <-1.0000, 0.0000, 0.0000>, <0.0000, 0.7714, -1.0000>, <-1.0000, 0.0000, 0.0000>, <0.0000, 0.3714, 0.2000>, <-1.0000, 0.0000, 0.0000> }
	smooth_triangle { <0.0000, 1.5714, 0.1000>, <-1.0000, 0.0000, 0.0000>, <0.0000, 0.3714, 0.2000>, <-1.0000, 0.0000, 0.0000>, <0.0000, 0.7714, -1.0000>, <-1.0000, 0.0000, 0.0000> }
	smooth_triangle { <0.0000, 0.7714, -1.0000>, <-1.0000, 0.0000, 0.0000>, <0.0000, 1.5714, -1.1000>, <-1.0000, 0.0000, 0.0000>, <0.0000, 1.5714, 0.1000>, <-1.0000, 0.0000, 0.0000> }
	smooth_triangle { <0.0000, 0.7714, -1.0000>, <-1.0000, 0.0000, 0.0000>, <0.0000, 0.7714, -2.0000>, <-1.0000, 0.0000, 0.0000>, <0.0000, 1.5714, -1.1000>, <-1.0000, 0.0000, 0.0000> }
	smooth_triangle { <0.0000, 0.7714, -2.0000>, <-1.0000, 0.0000, 0.0000>, <0.0000, 0.6714, -3.0000>, <-1.0000, 0.0000, 0.0000>, <0.0000, 1.5714, -1.1000>, <-1.0000, 0.0000, 0.0000> }
	smooth_triangle { <0.0000, 0.6714, -3.0000>, <-1.0000, 0.0000, 0.0000>, <0.0000, 0.5714, -4.2000>, <-1.0000, 0.0000, 0.0000>, <0.0000, 1.5714, -1.1000>, <-1.0000, 0.0000, 0.0000> }
	smooth_triangle { <0.0000, 0.5714, -4.2000>, <-1.0000, 0.0000, 0.0000>, <0.0000, 0.5714, -5.3000>, <-1.0000, 0.0000, 0.0000>, <0.0000, 1.5714, -1.1000>, <-1.0000, 0.0000, 0.0000> }
}

#declare hair = mesh {
	smooth_triangle { <-1.3232, -0.5143, -8.3938>, <-0.9563, 0.0000, -0.2924>, <-0.1245, 0.7857, -12.3147>, <-0.9563, 0.0000, -0.2924>, <-1.4694, 1.3857, -7.9157>, <-0.9838, 0.0590, -0.1693> }
	smooth_triangle { <0.1725, 0.6054, -5.4143>, <-0.9744, -0.2250, 0.0000>, <-0.0300, 1.4823, -6.6143>, <-0.9744, -0.2250, 0.0000>, <-0.0300, 1.4823, -4.9143>, <-0.9744, -0.2250, 0.0000> }
	smooth_triangle { <0.3074, 0.0207, -3.2143>, <-0.9744, -0.2250, 0.0000>, <0.1725, 0.6054, -5.4143>, <-0.9744, -0.2250, 0.0000>, <-0.0300, 1.4823, -4.9143>, <-0.9744, -0.2250, 0.0000> }
	smooth_triangle { <0.3299, -0.0767, -1.1143>, <-0.9744, -0.2250, 0.0000>, <0.3074, 0.0207, -3.2143>, <-0.9744, -0.2250, 0.0000>, <-0.0300, 1.4823, -4.9143>, <-0.9744, -0.2250, 0.0000> }
	smooth_triangle { <0.1275, 0.8002, -0.0143>, <-0.9744, -0.2250, -0.0000>, <0.3299, -0.0767, -1.1143>, <-0.9744, -0.2250, 0.0000>, <-0.0300, 1.4823, -4.9143>, <-0.9744, -0.2250, 0.0000> }
	smooth_triangle { <-0.1200, 1.8720, 0.1857>, <-0.9744, -0.2250, -0.0000>, <0.1275, 0.8002, -0.0143>, <-0.9744, -0.2250, -0.0000>, <-0.0300, 1.4823, -4.9143>, <-0.9744, -0.2250, 0.0000> }
	smooth_triangle { <-0.4799, 3.4310, -1.1143>, <-0.9970, -0.0668, -0.0387>, <-0.1200, 1.8720, 0.1857>, <-0.9744, -0.2250, -0.0000>, <-0.0300, 1.4823, -4.9143>, <-0.9744, -0.2250, 0.0000> }
	smooth_triangle { <-0.0300, 1.4823, -4.9143>, <-0.9744, -0.2250, 0.0000>, <-0.2774, 2.5541, -4.8143>, <-0.9959, 0.0620, -0.0666>, <-0.4799, 3.4310, -1.1143>, <-0.9970, -0.0668, -0.0387> }
	smooth_triangle { <0.0000, 4.4857, -2.8143>, <-0.9829, 0.1802, -0.0377>, <-0.4799, 3.4310, -1.1143>, <-0.9970, -0.0668, -0.0387>, <-0.2774, 2.5541, -4.8143>, <-0.9959, 0.0620, -0.0666> }
	smooth_triangle { <0.0000, 5.1857, -4.7143>, <-0.9962, 0.0716, -0.0497>, <0.0000, 4.4857, -2.8143>, <-0.9829, 0.1802, -0.0377>, <-0.2774, 2.5541, -4.8143>, <-0.9959, 0.0620, -0.0666> }
	smooth_triangle { <-0.2774, 2.5541, -4.8143>, <-0.9959, 0.0620, -0.0666>, <0.0000, 2.9857, -6.0143>, <-0.9974, 0.0369, -0.0624>, <0.0000, 5.1857, -4.7143>, <-0.9962, 0.0716, -0.0497> }
	smooth_triangle { <0.0000, 5.1857, -4.7143>, <-0.9962, 0.0716, -0.0497>, <0.0000, 2.9857, -6.0143>, <-0.9974, 0.0369, -0.0624>, <0.0000, 5.9857, -7.5143>, <-0.9950, 0.0091, 0.0996> }
	smooth_triangle { <0.0000, 5.9857, -7.5143>, <-0.9950, 0.0091, 0.0996>, <0.0000, 2.9857, -6.0143>, <-0.9974, 0.0369, -0.0624>, <0.0000, 2.6857, -7.2143>, <-0.9294, 0.1462, 0.3389> }
	smooth_triangle { <0.0000, 5.9857, -7.5143>, <-0.9950, 0.0091, 0.0996>, <0.0000, 2.6857, -7.2143>, <-0.9294, 0.1462, 0.3389>, <-0.7970, 6.2857, -10.1152>, <-0.9572, 0.1532, 0.2457> }
	smooth_triangle { <0.0000, 2.6857, -7.2143>, <-0.9294, 0.1462, 0.3389>, <-1.4694, 1.3857, -7.9157>, <-0.9838, 0.0590, -0.1693>, <-0.7970, 6.2857, -10.1152>, <-0.9572, 0.1532, 0.2457> }
	smooth_triangle { <-0.0953, 6.6857, -12.4103>, <-0.9563, 0.0000, -0.2924>, <-0.7970, 6.2857, -10.1152>, <-0.9572, 0.1532, 0.2457>, <-1.4694, 1.3857, -7.9157>, <-0.9838, 0.0590, -0.1693> }
	smooth_triangle { <-1.4694, 1.3857, -7.9157>, <-0.9838, 0.0590, -0.1693>, <0.5480, 6.3857, -14.5142>, <-0.9894, -0.1448, -0.0135>, <-0.0953, 6.6857, -12.4103>, <-0.9563, 0.0000, -0.2924> }
	smooth_triangle { <-1.4694, 1.3857, -7.9157>, <-0.9838, 0.0590, -0.1693>, <0.8696, 4.2857, -15.5661>, <-0.9621, -0.0309, 0.2709>, <0.5480, 6.3857, -14.5142>, <-0.9894, -0.1448, -0.0135> }
	smooth_triangle { <0.8696, 4.2857, -15.5661>, <-0.9621, -0.0309, 0.2709>, <-0.4931, 4.2666, -16.3193>, <-0.9028, 0.0439, 0.4278>, <-0.4983, 5.6185, -16.4690>, <-0.9435, -0.1006, 0.3157> }
	smooth_triangle { <-0.4983, 5.6185, -16.4690>, <-0.9435, -0.1006, 0.3157>, <0.5480, 6.3857, -14.5142>, <-0.9894, -0.1448, -0.0135>, <0.8696, 4.2857, -15.5661>, <-0.9621, -0.0309, 0.2709> }
	smooth_triangle { <-0.4931, 4.2666, -16.3193>, <-0.9028, 0.0439, 0.4278>, <-0.2014, 4.4904, -17.9821>, <-0.9842, -0.0233, -0.1758>, <-0.4983, 5.6185, -16.4690>, <-0.9435, -0.1006, 0.3157> }
	smooth_triangle { <-0.2014, 4.4904, -17.9821>, <-0.9842, -0.0233, -0.1758>, <-0.1170, 5.2119, -18.5497>, <-0.9842, -0.0233, -0.1758>, <-0.4983, 5.6185, -16.4690>, <-0.9435, -0.1006, 0.3157> }
	smooth_triangle { <-0.2014, 4.4904, -17.9821>, <-0.9842, -0.0233, -0.1758>, <0.1128, 4.6349, -19.7598>, <-0.9842, -0.0233, -0.1758>, <-0.1170, 5.2119, -18.5497>, <-0.9842, -0.0233, -0.1758> }
	smooth_triangle { <-0.1245, 0.7857, -12.3147>, <-0.9563, 0.0000, -0.2924>, <0.2556, 1.1857, -13.5579>, <-0.9707, 0.0386, -0.2372>, <-1.4694, 1.3857, -7.9157>, <-0.9838, 0.0590, -0.1693> }
	smooth_triangle { <-1.4694, 1.3857, -7.9157>, <-0.9838, 0.0590, -0.1693>, <0.2556, 1.1857, -13.5579>, <-0.9707, 0.0386, -0.2372>, <0.8696, 4.2857, -15.5661>, <-0.9621, -0.0309, 0.2709> }
	smooth_triangle { <0.2556, 1.1857, -13.5579>, <-0.9707, 0.0386, -0.2372>, <0.4709, 0.5244, -15.8948>, <-0.9522, -0.0112, 0.3054>, <0.8696, 4.2857, -15.5661>, <-0.9621, -0.0309, 0.2709> }
	smooth_triangle { <0.4709, 0.5244, -15.8948>, <-0.9522, -0.0112, 0.3054>, <-0.3588, 3.1644, -16.9252>, <-0.9842, -0.0521, 0.1692>, <0.8696, 4.2857, -15.5661>, <-0.9621, -0.0309, 0.2709> }
	smooth_triangle { <0.4709, 0.5244, -15.8948>, <-0.9522, -0.0112, 0.3054>, <-0.1577, 0.5708, -17.7081>, <-0.9923, -0.0993, 0.0741>, <-0.3588, 3.1644, -16.9252>, <-0.9842, -0.0521, 0.1692> }
	smooth_triangle { <-0.1577, 0.5708, -17.7081>, <-0.9923, -0.0993, 0.0741>, <0.1230, 1.3044, -19.3764>, <-0.9842, -0.0233, -0.1758>, <-0.3588, 3.1644, -16.9252>, <-0.9842, -0.0521, 0.1692> }
	smooth_triangle { <-0.3588, 3.1644, -16.9252>, <-0.9842, -0.0521, 0.1692>, <0.1230, 1.3044, -19.3764>, <-0.9842, -0.0233, -0.1758>, <0.1179, 2.9697, -19.5681>, <-0.9842, -0.0233, -0.1758> }
	smooth_triangle { <0.1230, 1.3044, -19.3764>, <-0.9842, -0.0233, -0.1758>, <0.4428, 1.6642, -21.2144>, <-0.9842, -0.0233, -0.1758>, <0.1179, 2.9697, -19.5681>, <-0.9842, -0.0233, -0.1758> }
	smooth_triangle { <0.4428, 1.6642, -21.2144>, <-0.9842, -0.0233, -0.1758>, <0.5497, 2.9334, -21.9810>, <-0.9842, -0.0233, -0.1758>, <0.1179, 2.9697, -19.5681>, <-0.9842, -0.0233, -0.1758> }
	smooth_triangle { <0.4428, 1.6642, -21.2144>, <-0.9842, -0.0233, -0.1758>, <0.7513, 1.9069, -22.9739>, <-0.9842, -0.0233, -0.1758>, <0.5497, 2.9334, -21.9810>, <-0.9842, -0.0233, -0.1758> }
	smooth_triangle { <-1.3232, -0.5143, -8.3938>, <-0.9563, 0.0000, -0.2924>, <-1.1186, -1.5143, -9.0633>, <-0.9563, -0.0000, -0.2924>, <-0.1245, 0.7857, -12.3147>, <-0.9563, 0.0000, -0.2924> }
	smooth_triangle { <-1.1186, -1.5143, -9.0633>, <-0.9563, -0.0000, -0.2924>, <0.1094, -0.3143, -13.0797>, <-0.9633, -0.0109, -0.2683>, <-0.1245, 0.7857, -12.3147>, <-0.9563, 0.0000, -0.2924> }
	smooth_triangle { <-1.1186, -1.5143, -9.0633>, <-0.9563, -0.0000, -0.2924>, <-0.5923, -2.2143, -10.7846>, <-0.9563, -0.0000, -0.2924>, <0.1094, -0.3143, -13.0797>, <-0.9633, -0.0109, -0.2683> }
	smooth_triangle { <-0.5923, -2.2143, -10.7846>, <-0.9563, -0.0000, -0.2924>, <-0.0368, -2.5143, -12.6016>, <-0.9563, 0.0000, -0.2924>, <0.1094, -0.3143, -13.0797>, <-0.9633, -0.0109, -0.2683> }
	smooth_triangle { <-0.0368, -2.5143, -12.6016>, <-0.9563, 0.0000, -0.2924>, <0.4018, -2.6143, -14.0360>, <-0.9695, -0.0759, -0.2329>, <0.1094, -0.3143, -13.0797>, <-0.9633, -0.0109, -0.2683> }
	smooth_triangle { <0.4018, -2.6143, -14.0360>, <-0.9695, -0.0759, -0.2329>, <0.7180, -1.3218, -16.2830>, <-0.9736, -0.2196, -0.0628>, <0.1094, -0.3143, -13.0797>, <-0.9633, -0.0109, -0.2683> }
	smooth_triangle { <0.4018, -2.6143, -14.0360>, <-0.9695, -0.0759, -0.2329>, <1.2100, -2.8579, -17.1650>, <-0.9543, -0.2394, 0.1790>, <0.7180, -1.3218, -16.2830>, <-0.9736, -0.2196, -0.0628> }
	smooth_triangle { <1.2100, -2.8579, -17.1650>, <-0.9543, -0.2394, 0.1790>, <0.0717, -1.2599, -18.7502>, <-0.9621, -0.1862, 0.1992>, <0.7180, -1.3218, -16.2830>, <-0.9736, -0.2196, -0.0628> }
	smooth_triangle { <1.2100, -2.8579, -17.1650>, <-0.9543, -0.2394, 0.1790>, <0.1274, -2.5549, -18.8907>, <-0.9812, -0.0620, 0.1827>, <0.0717, -1.2599, -18.7502>, <-0.9621, -0.1862, 0.1992> }
	smooth_triangle { <0.1274, -2.5549, -18.8907>, <-0.9812, -0.0620, 0.1827>, <0.5034, -1.9230, -21.0791>, <-0.9842, -0.0233, -0.1758>, <0.0717, -1.2599, -18.7502>, <-0.9621, -0.1862, 0.1992> }
}


object{outline
        texture{T_Wood32
                rotate x*90
        }                  

    translate <5,0,60>
}        

object{brow
        texture{
                pigment{color rgb<0.2,0.5,0.3>}
                normal{bumps 01 scale <5,0.1,1>}
        }

    rotate y*-90
    translate <-6,29,59.3>
 }

object{brow
        texture{
                pigment{color rgb<0.2,0.5,0.3>}
                normal{bumps 01 scale <5,0.1,1>}
        }

    rotate y*-90
    rotate x*-180
    rotate z*30
    translate <-6,28,59.3>
 }


object{hair
        texture{
                pigment{color rgb<0.2,0.5,0.3>}
                normal{bumps 01 scale <5,0.1,1>}
        }

    rotate y*-110
    translate <-5,34,59.8>
    no_shadow
 }
object{hair
        texture{
                pigment{color rgb<0.2,0.5,0.3>}
                normal{bumps 01 scale <5,0.1,1>}
        }

    rotate y*-110
    translate <-5,34,60>
 }

//////////////////////////////////////////////////////////////

  #declare r_violet1 = color rgbf<1.0, 0.5, 1.0, 1.0>;
  #declare r_violet2 = color rgbf<1.0, 0.5, 1.0, 0.8>;
  #declare r_indigo  = color rgbf<0.5, 0.5, 1.0, 0.8>;
  #declare r_blue    = color rgbf<0.2, 0.2, 1.0, 0.8>;
  #declare r_cyan    = color rgbf<0.2, 1.0, 1.0, 0.8>;
  #declare r_green   = color rgbf<0.2, 1.0, 0.2, 0.8>;
  #declare r_yellow  = color rgbf<1.0, 1.0, 0.2, 0.8>;
  #declare r_orange  = color rgbf<1.0, 0.5, 0.2, 0.8>;
  #declare r_red1    = color rgbf<1.0, 0.2, 0.2, 0.8>;
  #declare r_red2    = color rgbf<1.0, 0.2, 0.2, 1.0>;

rainbow {
    angle 30
    width 5
    arc_angle 140
    falloff_angle 60
    distance 900
    direction <0, -0.15, 1>
    jitter 0.01
    color_map {
      [0.000  color r_violet1 transmit 0.98]
      [0.100  color r_violet2 transmit 0.96]
      [0.214  color r_indigo  transmit 0.94]
      [0.328  color r_blue    transmit 0.92]
      [0.442  color r_cyan    transmit 0.90]
      [0.556  color r_green   transmit 0.92]
      [0.670  color r_yellow  transmit 0.94]
      [0.784  color r_orange  transmit 0.96]
      [0.900  color r_red1    transmit 0.98]
    }
  }


                                                                           
#declare ladder =
union{
        cylinder{<-1,0,0>, <-1,1000,0>, 0.1}
        cylinder{<1,0,0>, <1,1000,0>, 0.1}                
        #declare Y = 1;
        #while(Y < 99)
        cylinder{<-1,Y,0>, <1,Y,0>,0.1}
        #declare Y = Y+1;
        #end
}

object{ladder
        texture{T_Wood28
                rotate x*90
        }
        rotate<-10,35,0>
        translate<-9,19.5,10>
}



#declare Fire_Object = 
      difference{
      sphere { <0,0,0>,2 scale y*5}
      box {<4,-5,-4>,<-4,0,4>}
      texture {
        pigment {color rgbt 1}}   
        interior {
                caustics 0.8
		media {
			emission 0.5
			//scattering {0.5, 0.2}
			intervals 1
			samples 5
			method 3
			density {bozo scale 0.6 turbulence 0.3 
			                color_map {
					[0    rgb <1,1,1>]
					[0.1  rgb <0.7,0.5,0.2>]
					[0.3  rgb <0.5,0.3,0.2>]
					[0.4  rgb <1.0,0.5,0.3>]
					[0.5  rgb 0]
					[1    rgb 0]
                                        }
				}
          	scale y*5
	        }
	        
        }
        hollow
        no_shadow
  }

//cistern
#declare PoolTexture = texture {
	pigment { rgbf <0.78, 0.78, 0.99, 0.75> }
	finish {
	        ambient 0.1
	        diffuse 0.1
	        reflection .5
	        specular 1
	        roughness .001
	        #if (version<3.1)
	            ior 1.5
	        #end
	}       
	
	normal {
                bumps 0.4
	}
}

#declare Column =
        merge{  
                cylinder{<0,0,0>, <0,18,0>, 0.5
                        texture{T_Grnt2}
                }
                sphere{<0,18,0> 2
                        texture{T_Gold_3C}
                }
                sphere{<0,2,0> 2
                        texture{T_Gold_3C}
                }

        }


#declare Cistern =
union{
        torus{7.75, 0.5
                texture{T_Gold_3C}
                translate y*5
        }
        torus{7.75, 0.5
                texture{T_Gold_3C}
                translate y*0.2
        }
        difference{
                cylinder{<0,0,0>, <0,5,0>, 8}
                cylinder{<0,0.5,0>, <0,5.5,0>, 7.5}
                texture{T_Grnt28}
        }
      
        cylinder{<0,0.5,0>, <0,4.5,0>, 7.5
                texture{PoolTexture}
        }

        cylinder{<0,0,0>, <0,0.2,0>, 20
                texture{T_Stone32}
                }
        torus{20, 0.5
                texture{T_Gold_3C}
                translate y*0.2
        }
        
        #declare Angle = 0;
        #while(Angle < 360)
        object{Column
                translate z*-9
                rotate y*Angle
                rotate y*22.5
        }
        #declare Angle = Angle + 45;
        #end
}


object{Cistern
        translate <30,0,120>
}
object{Fire_Object
        translate <30,4.5,120>}

//Bubbles rising from the flame
sphere{<0,0,0>,2
        texture{
                pigment{color rgbt<0.8, 0.2, 0.8, 0.7>
                }
                finish{phong 1
                        reflection 0.2}
        }
        hollow
        translate <30,20,120>
}
                            
sphere{<0,0,0>,2
        texture{
                pigment{color rgbt<0.8, 0.2, 0.2, 0.7>
                }
                finish{phong 1
                        reflection 0.2}
        }
        hollow
        translate <26,25,120>
}

sphere{<0,0,0>,2
        texture{
                pigment{color rgbt<0.8, 0.2, 0.8, 0.7>
                }
                finish{phong 1
                        reflection 0.2}
        }
        hollow
        translate <31,30,120>
}

sphere{<0,0,0>,2
        texture{
                pigment{color rgbt<0.8, 0.2, 0.2, 0.7>
                }
                finish{phong 1
                        reflection 0.2}
        }
        hollow
        translate <27,35,120>
}

sphere{<0,0,0>,2
        texture{
                pigment{color rgbt<0.8, 0.2, 0.2, 0.7>
                }
                finish{phong 1
                        reflection 0.2}
        }
        hollow
        translate <29,40,120>
}


#declare droplet =
  sor {
    8,
    <0.0,  0.0>,
    <0.1,   0.1>,
    <1.25,   0.5>,
    <1.75,   1.5>,
    <1.3,   3>,
    <0.5,   6>,
    <0.01,  9>,
    <0.0,  19>
    sturm
    texture { T_Old_Glass }
    interior{I_Glass} 
    hollow
    scale <0.1,0.25,0.1>
    rotate z*10
    translate y*15
  }

object {droplet}
object {droplet
        translate <10,5,5>
}
object {droplet
        translate <-7,2,10>
}
object {droplet
        translate <15,10,7>
}
object {droplet
        translate <-14,8,15>
}
object {droplet
        translate <2,13,18>
}
object {droplet
        translate <-5,13,10>
}

object {droplet
        translate <10,2,0>
}

object {droplet
        translate <-9,-1,0>
}

#declare Y = sin(pi*(10/180)) + 0.5;
#declare coil_01 =
union{
        difference{
                torus{2,0.2}
                box{<-3,-0.3,-3> <0,0.3,3>}
                rotate x*10
        }
        difference{
                torus{2,0.2}
                box{<3,-0.3,-3> <0,0.3,3>}
                rotate x*-10
                translate y*Y
        }
        difference{
                torus{2,0.2}
                box{<-3,-0.3,-3> <0,0.3,3>}
                rotate x*10
                translate y*Y*2
        }
        difference{
                torus{2,0.2}
                box{<3,-0.3,-3> <0,0.3,3>}
                rotate x*-10
                translate y*Y*3
        }
        difference{
                torus{2,0.2}
                box{<-3,-0.3,-3> <0,0.3,3>}
                rotate x*10
                translate y*Y*4
        }
        difference{
                torus{2,0.2}
                box{<3,-0.3,-3> <0,0.3,3>}
                rotate x*-10
                translate y*Y*5
        }
        difference{
                torus{2,0.2}
                box{<-3,-0.3,-3> <0,0.3,3>}
                rotate x*10
                translate y*Y*6
        }
        difference{
                torus{2,0.2}
                box{<3,-0.3,-3> <0,0.3,3>}
                rotate x*-10
                translate y*Y*7
        }
        difference{
                torus{2,0.2}
                box{<-3,-0.3,-3> <0,0.3,3>}
                rotate x*10
                translate y*Y*8
        }
        difference{
                torus{2,0.2}
                box{<3,-0.3,-3> <0,0.3,3>}
                rotate x*-10
                translate y*Y*9
        }
        difference{
                torus{2,0.2}
                box{<-3,-0.3,-3> <0,0.3,3>}
                rotate x*10
                translate y*Y*10
        }
        rotate y*90
}


#declare clock_01 =
union{
        difference{
                union{
                        cylinder{<0,0,0>,<0,0.5,0> 1.2}
                        torus{1.1,0.1 translate y*0.5}
                }
                cylinder{<0,-1,0>,<0,1,0> 1}
                texture{
                        pigment{color Red}
                        finish{phong 0.5}
                }
        
        }
        cylinder{<0,0,0>,<0,0.5,0> 1
                texture{
                        pigment{color White}
                        finish{phong 0.25}
                }
        }
        
        object{coil_01
                pigment{color Black}
                scale <0.1,0.25,0.1>
                translate<0,0.5,0>
        }
        
        cylinder{<0,0,0>,<0,0.1,0> 0.25
                texture{
                        pigment{color Black}
                        finish{phong 0.5}
                }
                translate<0,2.25,0>
        }
        union{
                cylinder{<0,0.05,0>,<1,0.05,0> 0.05}
                cone{<1,0.05,0>, 0.075, <1.25,0.05,0>, 0}
                texture{
                        pigment{color Black}
                        finish{phong 0.5}
                }
                translate<0,2.25,0>
                rotate y*45
        }
        union{
                cylinder{<0,0.05,0>,<0.75,0.05,0> 0.05}
                cone{<0.75,0.05,0>, 0.075, <1,0.05,0>, 0}
                texture{
                        pigment{color Black}
                        finish{phong 0.5}
                }
                translate<0,2.25,0>
                rotate y*125
        }
        text {
                ttf "timrom.ttf" "12" 0.25, 0
                pigment { Black }
                rotate x*90
                scale 0.5
                translate <-0.2,1.55,0.55>
        }

        text {
                ttf "timrom.ttf" "3" 0.25, 0
                pigment { Black }
                rotate x*90
                rotate y*-90
                scale 0.5
                translate <-0.2,2.55,0.55>
                rotate y*120
        }

        text {
                ttf "timrom.ttf" "6" 0.25, 0
                pigment { Black }
                rotate x*90
                rotate y*-240
                scale 0.5
                translate <-0.2,0.85,0.85>
                rotate y*200
        }

        text {
                ttf "timrom.ttf" "9" 0.25, 0
                pigment { Black }
                rotate x*90
                rotate y*50
                scale 0.5
                translate <-0.2,1.55,0.75>
                rotate y*-80
        }

        union{
                difference{
                        sphere{<0,0.25,1.21> 0.30}
                        box{<-0.5,-1,0.5> <0.5,1,1.21>}
                }
                sphere{<0,0.25,1.51> 0.025}
                texture{T_Gold_3C}
                hollow
                rotate y*20
        }

        union{
                difference{
                        sphere{<0,0.25,1.21> 0.30}
                        box{<-0.5,-1,0.5> <0.5,1,1.21>}
                }
                sphere{<0,0.25,1.46> 0.025}
                texture{T_Gold_3C}
                hollow
                rotate y*-20                
        }

        union{
                sphere{<0,0.25,1.36> 0.1}
                cylinder{<0,0.25,1>, <0,0.25,1.36>, 0.05}
                texture{T_Gold_3C}
             
        }
        cylinder{<0,0.25,0>, <0,0.25,-2>, 0.2
                        texture{
                                pigment{color Black}
                                finish{phong 0.5}
                        }
        }
        sphere{<0,0.25,-2> 0.4
                        texture{
                                pigment{color Black}
                                finish{phong 0.5}
                        }
        }
        translate z*2
        rotate y*20
        //translate z*-2        
        
}



#declare clock_02 =
union{
        object{clock_01 translate z*2}
        cylinder{<0,0.25,0>, <0,0.25,2>, 0.2
                        texture{
                                pigment{color Black}
                                finish{phong 0.5}
                        }
        }
        sphere{<0,0.25,0> 0.4
                        texture{
                                pigment{color Black}
                                finish{phong 0.5}
                        }
        }
    
}


object{clock_02
        rotate x*-90
        scale 3
        translate<12,0,20>
}
