//////////////////////////////////////////////////////////////////////////
// CoffeeTable.inc  20030816 Copyright(C) K.E. Ayers Designs, 2003      //
//                                                                      //
// An oak coffee table with a glass insert.                             //
//////////////////////////////////////////////////////////////////////////

#declare TableLength            = 54.0;
#declare TableDepth             = 27.0;
#declare TableTopThickness      = 4.0;
#declare TableLegLength         = 12.0;
#declare TableLegThickness      = 4;
#declare TableHgt               = TableLegLength + TableTopThickness;
#declare TableTopBorder         = 4;
#declare TableLegXOfs           = (TableLength / 2)
                                    - (TableLegThickness / 2)
                                    - 3/4;
#declare TableLegZOfs           = (TableDepth  / 2)
                                    - (TableLegThickness / 2)
                                    - 3/4;

#declare TableTopInsertTexture =
texture {
    pigment { color rgbf < 0.8, 1.0, 0.95, 0.9 > }
    finish {
        ambient     Ambient
        diffuse     Diffuse
        reflection  0.25
        refraction  0.9
        ior         1.5
        specular    0.8
        roughness   0.0001
    }
}

#declare TableTextureScale      = TableTopThickness * 0.2;


// Coffee table component parts

#declare TableTopCutout =
intersection {
    plane { <  1,  0,  0 > TableLength / 2 - TableTopBorder }
    plane { < -1,  0,  0 > TableLength / 2 - TableTopBorder }
    plane { <  0,  0,  1 > TableDepth  / 2 - TableTopBorder }
    plane { <  0,  0, -1 > TableDepth  / 2 - TableTopBorder }
}

#declare TableTopSlab =
box {
    <-TableLength / 2, 0, -TableDepth / 2 >
    < TableLength / 2, TableTopThickness,  TableDepth / 2 >
}

#declare TableTop =
difference {
    object { TableTopSlab }
    object { TableTopCutout }
    texture {
        LightOakTexture
        rotate < 0, 90, -3 >
        scale TableTextureScale
        translate < 0, -TableTopThickness, 0 >
        finish { VarnishFinish }
    }
}

#declare TableTopInsert =
intersection {
    object { TableTopSlab }
    object { TableTopCutout }
    plane {
        < 0, -1, 0 >, 0
        translate < 0, TableTopThickness - 1/2, 0 >
    }
    texture { TableTopInsertTexture }
}

#declare TableLeg =
box {
    < -TableLegThickness / 2,              0, -TableLegThickness / 2 >
    <  TableLegThickness / 2, TableLegLength,  TableLegThickness / 2 >
    texture {
        LightOakTexture
        rotate < 87, 0, 0 >
        scale TableTextureScale
        finish { VarnishFinish }
    }
}

#declare TableBody =
union {
    object { TableTop translate < 0, TableLegLength, 0 > }
    object { TableLeg translate < -TableLegXOfs, 0, -TableLegZOfs > }
    object { TableLeg translate < -TableLegXOfs, 0,  TableLegZOfs > }
    object { TableLeg translate <  TableLegXOfs, 0, -TableLegZOfs > }
    object { TableLeg translate <  TableLegXOfs, 0,  TableLegZOfs > }
}

#declare BowlTexture =
texture {
    pigment {
        radial
        turbulence 2.0
        color_map {
            [ 0.0   color rgb < 0.4, 0.0, 0.0 > ]
            [ 0.5   color rgb < 0.4, 0.0, 0.0 > ]
            [ 0.6   color rgb < 1.0, 1.0, 1.0 > ]
            [ 0.7   color rgb < 0.0, 1.0, 0.0 > ]
            [ 0.8   color rgb < 0.0, 1.0, 1.0 > ]
            [ 0.85  color rgb < 0.0, 0.0, 1.0 > ]
            [ 0.9   color rgb < 0.5, 0.5, 0.2 > ]
            [ 1.0   color rgb < 0.4, 0.0, 0.0 > ]
        }
        frequency 7
    }
    finish { PolishedFinish }
}

#declare BowlRad                = TableDepth * 0.3;
#declare BowlHgtScale           = 0.5;
#declare BowlBaseRad            = BowlRad / 2;
#declare BowlBaseTopRad         = BowlBaseRad * 0.75;
#declare BowlBaseHgt            = (BowlRad * BowlHgtScale) / 4;

#declare Bowl =
union {
    difference {
        intersection {
            sphere {
                < 0, 0, 0 >, BowlRad
                scale < 1, BowlHgtScale, 1 >
            }
            plane { < 0, 1, 0 >, 0 }
        }
        sphere {
            < 0, 0, 0 >, BowlRad - 1/4
            scale < 1, BowlHgtScale, 1 >
        }
        texture { BowlTexture }
        translate < 0, BowlBaseHgt + (BowlRad * BowlHgtScale), 0 >
    }
    cone {
        < 0, 0, 0 >, BowlBaseRad,
        < 0, BowlBaseHgt, 0 >, BowlBaseTopRad
        texture {
            pigment { color Black }
            finish { FlatFinish }
        }
    }
    cylinder {
        < 0, BowlBaseHgt * 7/16, 0 >,
        < 0, BowlBaseHgt * 9/16, 0 >,
        (BowlBaseRad + BowlBaseTopRad) * 0.525
        texture { PolishedBrassTexture }
    }
}


#declare RugLength              = TableLength + 24.0;
#declare RugDepth               = TableDepth  + 24.0;
#declare RugThick               = 1/2;

#declare RugTexture =
texture {
    pigment {
        gradient < 1.0, 0.0, 1.0 >
        turbulence 0.5
        color_map {
            [ 0.0   color rgb < 0.0, 0.3, 0.2 > ]
            [ 0.5   color rgb < 0.0, 0.6, 0.8 > ]
            [ 0.65  color rgb < 0.0, 0.6, 0.8 > ]
            [ 0.75  color rgb < 1.0, 1.0, 1.0 > ]
            [ 0.85  color rgb < 1.0, 1.0, 1.0 > ]
            [ 0.9   color rgb < 1.0, 0.0, 0.0 > ]
            [ 1.0   color rgb < 0.0, 0.0, 0.0 > ]
        }
    }
}

#declare Rug =
box {
    < -RugLength / 2, 0,        -RugDepth / 2 >
    <  RugLength / 2, RugThick,  RugDepth / 2 >
    texture { RugTexture scale < RugLength / 16, 1, RugDepth / 16 > }
}


#declare CoffeeTable =
union {
    object { TableBody }
    object {
        TableTopInsert
        translate < 0, TableLegLength, 0 >
    }
    object {
        Bowl
        translate < 0, TableHgt, 0 >
    }
    object { Rug }
}
