//////////////////////////////////////////////////////////////////////////
// CornerWindow.inc  20030816 Copyright(C) K.E. Ayers Designs, 2003     //
//                                                                      //
// A corner window looking onto star-filled sky!                        //
//////////////////////////////////////////////////////////////////////////

#declare WindowWid              = 48;
#declare WindowHgt              = 66;
#declare WindowDepth            = 6;
#declare WinPaneThick           = 1 / 4;
#declare WinFrameThick          = 1;
#declare WinDivThick            = 1;
#declare WinFrameWid            = WindowWid + (2 * WinFrameThick);
#declare WinFrameHgt            = WindowHgt + (2 * WinFrameThick);
#declare WinSillDepth           = WindowDepth * 3 / 2;

#declare WindowFrameTexture =
texture { PictureFrameTexture }

#declare WinFrameHorizElem =
intersection {
    plane { <  0, -1,  0 >, 0 }
    plane { <  0,  1,  0 >, 0 translate < 0, WinFrameThick, 0 > }
    plane { <  0,  0, -1 >, 0 translate < 0, 0, -WindowDepth / 2 > }
    plane { <  0,  0,  1 >, 0 translate < 0, 0,  WindowDepth / 2 > }
    plane {
        < -1, 0, 0 >, 0
        rotate < 0, 0, 45 >
        translate < -((WindowWid / 2) - 1/8), 0, 0 >
    }
    plane {
        <  1, 0, 0 >, 0
        rotate < 0, 0, -45 >
        translate < (WindowWid / 2) - 1/8, 0, 0 >
    }
    texture {
        PictureFrameTexture
        scale PaintingFrameTextureScale
        rotate < 0, 90, 0 >
    }
}

#declare WinFrameVertElem =
intersection {
    plane { < -1,  0,  0 >, 0 }
    plane { <  1,  0,  0 >, 0 translate < WinFrameThick, 0, 0 > }
    plane { <  0,  0, -1 >, 0 translate < 0, 0, -WindowDepth / 2 > }
    plane { <  0,  0,  1 >, 0 translate < 0, 0,  WindowDepth / 2 > }
    plane {
        < 0, 1, 0 >, 0
        rotate < 0, 0, 45 >
        translate < 0, (WindowHgt / 2) - 1/8, 0 >
    }
    plane {
        < 0, -1, 0 >, 0
        rotate < 0, 0, -45 >
        translate < 0, -((WindowHgt / 2) - 1/8), 0 >
    }
    texture {
        PictureFrameTexture
        scale PaintingFrameTextureScale
        rotate < -89, 0, 0 >
    }
}

#declare WindowFrame =
union {
    object {
        WinFrameHorizElem
        translate < 0, WindowHgt / 2, 0 >
    }
    object {
        WinFrameHorizElem
        scale < 1, -1, 1 >
        translate < 0, -WindowHgt / 2, 0 >
    }
    object {
        WinFrameVertElem
        translate < WindowWid / 2, 0, 0 >
    }
    object {
        WinFrameVertElem
        scale < -1, 1, 1 >
        translate < -WindowWid / 2, 0, 0 >
    }
}

#declare WinVDiv =
box {
    < -WinDivThick / 2, -WindowHgt / 2, -WindowDepth / 2 >
    <  WinDivThick / 2,  WindowHgt / 2,  WindowDepth / 2 >
    texture {
        WindowFrameTexture
        scale PaintingFrameTextureScale
        rotate < 90, 0, 0 >
    }
}

#declare WinHDiv =
box {
    < -WindowWid / 2, -WinDivThick / 2, -WindowDepth / 2 >
    <  WindowWid / 2,  WinDivThick / 2,  WindowDepth / 2 >
    texture {
        WindowFrameTexture
        scale PaintingFrameTextureScale
        rotate < 0, 90, 0 >
    }
}

#declare WinSillTop   = -WinFrameHgt / 2;
#declare WinSillBot   =  WinSillTop - WinFrameThick;
#declare WinSillBack  =  WindowDepth / 2;
#declare WinSillFront =  WinSillBack - WinSillDepth;
#declare WinSillXOfs  =  WinFrameWid / 2;
#declare WinSillLeft  = -WinSillXOfs;
#declare WinSillRight =  WinSillXOfs;

#declare WindowSill =
box {
        < WinSillLeft,  WinSillBot, WinSillFront >
        < WinSillRight, WinSillTop, WinSillBack >
    texture { WindowFrameTexture rotate < 0, -89, 0 > }
}

#declare NumStars   = 50;
#declare StarRad    = WindowWid * 0.0125;
#declare R         = seed(0);
#declare S          = 0;

#declare WindowPane =
union {
    box {
        < -WindowWid / 2, -WindowHgt / 2, -WinPaneThick / 2 >
        <  WindowWid / 2,  WindowHgt / 2,  WinPaneThick / 2 >
        texture { pigment { color Black } }
    }

    // Create a random starfield.
    #while (S < NumStars)
        #declare SX = (rand(R) * WindowWid) - (WindowWid / 2);
        #declare SY = (rand(R) * WindowHgt) - (WindowHgt / 2);
        #declare SR = (rand(R) * 0.5 + 0.75) * StarRad;

        #switch (rand(R))
            #range(0, 0.5)
                #declare SC = color rgb < 1.0, 1.0, 1.0 >;
            #break
            #range(0.5, 0.7)
                #declare SC = color rgb < 1.0, 1.0, 0.6 >;
            #break
            #range(0.7, 0.85)
                #declare SC = color rgb < 1.0, 0.6, 0.6 >;
            #break
            #range(0.85, 1.0)
                #declare SC = color rgb < 0.6, 0.6, 1.0 >;
            #break
        #end

        sphere {
            < SX, SY, -WinPaneThick / 2 >, SR
            scale < 1, 1, 0.25 >
            texture {
                pigment { color SC }
                finish { ambient 1 diffuse 0 }
            }
        }

        #declare S = S + 1;
    #end
}

// We'll also see a crescent moon through the window.
#declare MoonRad            = WindowWid / 5;
#declare MoonWhite          = color rgb  < 1.0,   1.0,   1.0         >;
#declare MoonLightGray      = color rgb  < 0.85,  0.85,  0.85        >;
#declare MoonDarkGray       = color rgb  < 0.7,   0.7,   0.7         >;
#declare MoonBlack          = color rgbf < 0.05,  0.05,  0.05,  0.05 >;

#declare MoonTexture =
texture {
    pigment {
        bozo
        turbulence 0.75
        color_map {
            [ 0.0   color MoonWhite ]
            [ 0.6   color MoonWhite ]
            [ 0.7   color MoonLightGray ]
            [ 0.8   color MoonDarkGray ]
            [ 0.9   color MoonLightGray ]
            [ 1.001 color MoonWhite ]
        }
    }
    scale MoonRad * 0.25
    finish  { ambient 1.0 diffuse 0 }
}
texture {
    pigment {
        radial
        color_map {
            [ 0.0   color Clear ]
            [ 0.1   color Clear ]
            [ 0.2   color MoonBlack ]
            [ 1.0   color MoonBlack ]
        }
    }
}

#declare CrescentMoon =
sphere {
    < 0, 0, 0 >, MoonRad
    texture { MoonTexture }
    rotate < 0, 0, -25 >
    scale < 1, 1, 0.01 >
}

#declare WinFrameAssy =
union {
    object { WindowFrame }
    object { WinVDiv }
    object { WinHDiv }
    object { WindowSill }
}

#declare WinCornerOfs = (WinFrameWid + WindowDepth) / 2;

#declare Window =
union {
    union {
        object { WinFrameAssy }
        object { WindowPane }
        object {
            CrescentMoon
            translate < WindowWid * 0.2,
                            WindowHgt * 0.25,
                            -WinPaneThick / 2 >
        }
        translate < -WinCornerOfs, 0, 0 >
    }
    union {
        object { WinFrameAssy }
        object { WindowPane rotate < 0, 0, 180 > }
        rotate < 0, 90, 0 >
        translate < 0, 0, -WinCornerOfs >
    }
}
