//////////////////////////////////////////////////////////////////////////
// FloorLamp.inc  20030816 Copyright(C) K.E. Ayers Designs, 2003        //
//                                                                      //
// A floor lamp on a table by the sofa.                                 //
//////////////////////////////////////////////////////////////////////////

#declare LampBaseSize       = 12;
#declare LampShadeHgt       = LampBaseSize * 1.5;
#declare LampShadeTopRad    = LampBaseSize * 0.33;
#declare LampShadeBotRad    = LampBaseSize * 0.67;
#declare LBConeHgt          = LampBaseSize;
#declare LampBaseHgt        = LampBaseSize + (LBConeHgt * 2);
#declare LampShadePos       = LampBaseHgt + LampShadeHgt / 3;
#declare LampHgt            = LampBaseHgt + LampShadeHgt
                                - (LampShadeHgt / 3);

#declare LampPedestalTexture =
texture { LightOakTexture finish { VarnishFinish } rotate < 90, 0, 0 > }

#declare LampBaseTexture =
texture { PolishedBrassTexture }

#declare LightColor     = color rgb  < 0.9, 0.9, 0.6 >;
#declare LampShadeColor = color rgbf < 0.7, 0.9, 1.0, 0.9 >;

#declare LampShadeTexture =
texture {
    pigment {
        radial
        color_map {
            [ 0.0   color LampShadeColor ]
            [ 0.375 color LampShadeColor ]
            [ 0.5   color rgb < 0.0, 0.1, 0.2 > ]
            [ 0.625 color LampShadeColor ]
        }
        frequency 20
    }
}

#declare LampShadeOutside =
cone {
    < 0, -LampShadeHgt / 2, 0 > LampShadeBotRad
    < 0,  LampShadeHgt / 2, 0 > LampShadeTopRad
}

#declare LampShadeInside =
cone {
    < 0, -LampShadeHgt / 2, 0 > LampShadeBotRad - 0.125
    < 0,  LampShadeHgt / 2, 0 > LampShadeTopRad - 0.125
}

#declare LampShadeBody =
difference {
    object { LampShadeOutside }
    object { LampShadeInside scale < 1, 1, 1.01 > }
    texture { LampShadeTexture finish { ambient 1 diffuse 0 } }
    //no_shadow
}

#declare LampShade =
union {
    object { LampShadeBody }
    light_source {
        < 0, 0, 0 > color LightColor
        looks_like {
            object {
                LampShadeInside
                texture {
                    pigment { color LightColor }
                    finish  { ambient 1 diffuse 0 }
                }
            }
        }
    }
}

#declare LampPedestalLeft   = -LampBaseSize / 2;
#declare LampPedestalBottom =  0;
#declare LampPedestalFront  = -LampBaseSize / 2;
#declare LampPedestalRight  =  LampBaseSize / 2;
#declare LampPedestalTop    =  LampBaseSize;
#declare LampPedestalBack   =  LampBaseSize / 2;
#declare T                  =  3/4;

#declare LampPedestal =
difference {
    box {
        < LampPedestalLeft,  LampPedestalBottom, LampPedestalFront >,
        < LampPedestalRight, LampPedestalTop,    LampPedestalBack  >
    }
    box {
        < LampPedestalLeft+T,  LampPedestalBottom+T, LampPedestalFront-T >,
        < LampPedestalRight-T, LampPedestalTop-T,    LampPedestalBack-T  >
    }
    cylinder {
        < LampPedestalLeft-T,  0, 0 >,    
        < LampPedestalRight+T, 0, 0 >,
        LampBaseSize / 4
        scale < 1, 0.75, 1.25 >
        translate < 0, LampPedestalTop * 3/4, 0 >
    }
    texture { LampPedestalTexture }
}

#declare LampBase =
union {
    cone {
        < 0, LampBaseSize, 0 > LampBaseSize / 3
        < 0, LampBaseSize + LBConeHgt, 0> 0
    }
    sphere {
        < 0, LampBaseSize + LBConeHgt, 0 > LampBaseSize / 4
    }
    cone {
        < 0, LampBaseSize + LBConeHgt, 0 > 0
        < 0, LampBaseSize + (LBConeHgt * 2), 0 > LampBaseSize / 3
    }
    texture { LampBaseTexture }
}

#declare FloorLamp =
union {
    object { LampPedestal rotate < 0, 90, 0 > }
    object { LampBase }
    object { LampShade translate < 0, LampShadePos, 0 > }
}
