//////////////////////////////////////////////////////////////////////////
// Painting.inc  20030816 Copyright(C) K.E. Ayers Designs, 2003         //
//                                                                      //
// An abstract painting hanging above the sofa.                         //
//////////////////////////////////////////////////////////////////////////

#declare PaintingFrameWidth         = 60.0;
#declare PaintingFrameHeight        = 36.0;
#declare PaintingFrameBorder        = 4.0;
#declare PaintingFrameDepth         = 1.0;

#declare PaintingXOfs  = PaintingFrameWidth / 2 - PaintingFrameBorder;
#declare PaintingYOfs  = PaintingFrameHeight / 2 - PaintingFrameBorder;

#declare PictureFrameTexture =
texture { DarkOakTexture finish { VarnishFinish } }

#declare PaintingFrameTextureScale = PaintingFrameBorder * 0.2;

#declare PaintingTexture =
texture {
    pigment {
        gradient < 1, 1, 0 >
        turbulence 1.75
        color_map {
                [0.0,  0.2   color Black           color Maroon]
                [0.2,  0.6   color Maroon          color White]
                [0.6,  0.8   color White           color MediumTurquoise]
                [0.8,  1.00  color MediumTurquoise color Black]
        }
        scale PaintingFrameHeight * 0.5
    }
    finish { MatteFinish }
}

#declare PaintingFrameHorizElem =
intersection {
    plane { <  0, -1,  0 >, 0 }
    plane { <  0,  1,  0 >, 0 translate < 0, PaintingFrameBorder, 0 > }
    plane { <  0,  0, -1 >, 0 translate < 0, 0, -PaintingFrameDepth / 2 > }
    plane { <  0,  0,  1 >, 0 translate < 0, 0,  PaintingFrameDepth / 2 > }
    plane {
        < -1, 0, 0 >, 0
        rotate < 0, 0, 45 >
        translate < -(PaintingXOfs - 1/8), 0, 0 >
    }
    plane {
        <  1, 0, 0 >, 0
        rotate < 0, 0, -45 >
        translate < PaintingXOfs - 1/8, 0, 0 >
    }
    texture {
        PictureFrameTexture
        scale PaintingFrameTextureScale
        rotate < 0, 90, 0 >
    }
}

#declare PaintingFrameVertElem =
intersection {
    plane { < -1,  0,  0 >, 0 }
    plane { <  1,  0,  0 >, 0 translate < PaintingFrameBorder, 0, 0 > }
    plane { <  0,  0, -1 >, 0 translate < 0, 0, -PaintingFrameDepth / 2 > }
    plane { <  0,  0,  1 >, 0 translate < 0, 0,  PaintingFrameDepth / 2 > }
    plane {
        < 0, 1, 0 >, 0
        rotate < 0, 0, 45 >
        translate < 0, PaintingYOfs - 1/8, 0 >
    }
    plane {
        < 0, -1, 0 >, 0
        rotate < 0, 0, -45 >
        translate < 0, -(PaintingYOfs - 1/8), 0 >
    }
    texture {
        PictureFrameTexture
        scale PaintingFrameTextureScale
        rotate < 90, 0, 0 >
    }
}

#declare PaintingFrame =
union {
    object {
        PaintingFrameHorizElem
        translate < 0, PaintingYOfs, 0 >
    }
    object {
        PaintingFrameHorizElem
        scale < 1, -1, 1 >
        translate < 0, -PaintingYOfs, 0 >
    }
    object {
        PaintingFrameVertElem
        translate < PaintingXOfs, 0, 0 >
    }
    object {
        PaintingFrameVertElem
        scale < -1, 1, 1 >
        translate < -PaintingXOfs, 0, 0 >
    }
}

#declare PaintingBody =
box {
    < -PaintingXOfs, -PaintingYOfs,  0 >
    <  PaintingXOfs,  PaintingYOfs,  0 >
    texture { PaintingTexture }
}

#declare Painting =
union {
    object { PaintingFrame }
    object { PaintingBody }
}
