//////////////////////////////////////////////////////////////////////////
// PottedPlant.inc  20030816 Copyright(C) K.E. Ayers Designs, 2003      //
//                                                                      //
// A potted plant.                                                      //
//////////////////////////////////////////////////////////////////////////

#declare PotRadius              = 13.0;
#declare PotThickness           = 1.0;
#declare PotInsideRadius        = PotRadius - PotThickness;
#declare PotHeight              = 15.0;
#declare DirtDepth              = 2.0;

#declare PlantStemRadius        = 3.0;
#declare PlantHeight            = 48.0;
#declare BranchLength           = 18.0;

#declare FoliageRad             = 12;

#declare PlantTrunkTexture =
texture {
    DarkOakTexture
    scale PlantStemRadius * 0.1
    rotate < 87, 0, 0 >
}

#declare PotTexture =
texture
{
    pigment { Pink_Granite scale PotRadius * 0.3 }
    finish { MatteFinish }
}


#declare DirtTexture =
texture {
    pigment {
        granite
        color_map {
            [ 0.0   color rgb < 0.4, 0.2, 0.0 > ]
            [ 0.4   color rgb < 0.4, 0.2, 0.0 > ]
            [ 0.45  color rgb < 0.7, 0.4, 0.0 > ]
            [ 0.5   color rgb < 1.0, 1.0, 1.0 > ]
            [ 0.55  color rgb < 0.7, 0.4, 0.0 > ]
            [ 1.0   color rgb < 0.4, 0.2, 0.0 > ]
        }
        scale PotRadius * 0.2
    }
}

#declare FoliageTexture =
texture {
    pigment {
        bozo
        turbulence 1.25
        color_map {
            [ 0.0   color rgb  < 0.0, 0.5, 0.0 > ]
            [ 0.2   color rgb  < 0.0, 0.5, 0.0 > ]
            [ 0.3   color rgb  < 0.4, 0.7, 0.0 > ]
            [ 0.4   color rgb  < 0.0, 0.5, 0.0 > ]
            [ 0.55  color rgbf < 1.0, 1.0, 1.0, 1.0 > ]
            [ 0.95  color rgbf < 1.0, 1.0, 1.0, 1.0 > ]
            [ 1.0   color rgb  < 0.0, 0.6, 0.0 > ]
        }
    }
    finish { FlatFinish }
}

#declare PotBody =
cylinder {
    < 0, 0, 0 >
    < 0, PotHeight, 0 >
    PotRadius
}

#declare PotHole =
cylinder {
    < 0, PotThickness, 0 >
    < 0, PotHeight + 1, 0 >
    PotInsideRadius
}    

#declare Pot =
object {
    difference {
        object { PotBody }
        object { PotHole }
    }
    texture { PotTexture }
}

#declare Dirt =
cylinder {
    < 0, PotThickness, 0 >
    < 0, PotHeight - DirtDepth, 0 >
    PotInsideRadius
    texture { DirtTexture }
}

#declare PlantTrunk =
cone {
    < 0, PotThickness, 0 > PlantStemRadius
    < 0, PlantHeight, 0 > 0
    texture { PlantTrunkTexture }
}

#declare PlantTopFoliage =
sphere {
    < 0, PlantHeight, 0 > FoliageRad
    texture { FoliageTexture scale FoliageRad * 0.2 }
}

#declare Plant =
union {
    object { PlantTrunk }
    object { PlantTopFoliage }
}

#declare PottedPlant =
union {
    object { Pot }
    object { Dirt }
    object { Plant }
}
