//////////////////////////////////////////////////////////////////////////
// Sculpture.inc  20030816 Copyright(C) K.E. Ayers Designs, 2003        //
//                                                                      //
// A free-form floor sculpture.                                         //
//////////////////////////////////////////////////////////////////////////

// This sculpture has a large spherical base and
// a number of spherical segments, spiraling upward.
// Segments get smaller toward the top.  The base and
// each segment consists of a glass sphere encasing a
// smaller metallic sphere.  The segments are connected
// by brass rods piercing the central sphere.

#declare SculptBaseRad          = 9;
#declare SculptHgt              = 60;
#declare SculptNumSeg           = 12;
#declare SculptSpiralAngle      = 360 + 90;
#declare SculptSegRot           = SculptSpiralAngle / (SculptNumSeg - 1);
#declare SculptSegRad           = SculptBaseRad * 0.4;
#declare SculptSegRadScale      = 0.925;
#declare SculptSegXOfs          = (SculptBaseRad + SculptSegRad) * 0.8;
#declare SculptSegXOfsScale     = 0.9;
#declare SculptSegYOfs          = SculptSegXOfs;
#declare SculptSegYOfsStep      = (SculptHgt - SculptSegYOfs) / SculptNumSeg;
#declare SculptCenterRadScale   = 0.4;
#declare SculptSegRodRad        = 1/4;
#declare SculptPedestalRad      = SculptBaseRad * 0.75;
#declare SculptPedestalThick    = 2;



#declare SculptureCenterTexture =    
texture {
    pigment { color rgb < 0.0, 0.7, 0.4 > }
    finish {
        ambient     Ambient
        diffuse     Diffuse
        metallic
        specular    1.0
        roughness   0.01
        brilliance  4.0
    }
}

#declare SculptureOuterTexture =
texture {
    pigment { color rgbf < 0.7, 1.0, 0.9, 0.9 > }
    finish {
        ambient     Ambient
        diffuse     Diffuse
        refraction  on
        ior         1.1
        reflection  0.1
        specular    1.0
        roughness   0.001
    }
}

#declare PrevCenter = < 0, 0, 0 >;
#declare YRot       = 0;
#declare XOfs       = SculptSegXOfs;
#declare YOfs       = SculptSegYOfs;
#declare SegRad     = SculptSegRad;
#declare SegNum     = 1;

#declare SculptureBody =
union {
    // The base.
    sphere {
        < 0, 0, 0 >, SculptBaseRad
        texture { SculptureOuterTexture }
    }
    sphere {
        < 0, 0, 0 >, SculptBaseRad * SculptCenterRadScale
        texture { SculptureCenterTexture }
    }

    #while (SegNum <= SculptNumSeg)
        #declare SegCenter = vrotate(<XOfs,0,0>,<0,-YRot,0>) + <0,YOfs,0>;

        sphere {
            SegCenter, SegRad
            texture { SculptureOuterTexture }
        }
        sphere {
            SegCenter, SegRad * SculptCenterRadScale
            texture { SculptureCenterTexture }
        }
        cylinder {
            <0, SegCenter.y, 0>, SegCenter, SculptSegRodRad
            texture { PolishedBrassTexture }
        }

        #declare PrevCenter = SegCenter;
        #declare XOfs       = XOfs   * SculptSegXOfsScale;
        #declare YOfs       = YOfs   + SculptSegYOfsStep;
        #declare YRot       = YRot   + SculptSegRot;
        #declare SegRad     = SegRad * SculptSegRadScale;
        #declare SegNum     = SegNum + 1;
    #end

    cylinder {
        < 0, 0, 0 >,
        < 0, PrevCenter.y + SculptSegRodRad, 0 >,
        5/16
        texture { PolishedBrassTexture }
    }
    sphere {
        < 0, PrevCenter.y + SculptSegRodRad + 1/2, 0 >, 3/4
        texture { PolishedBrassTexture }
    }
}

#declare Sculpture =
union {
    intersection {
        object {
            SculptureBody
            rotate < 0, -45, 0 >
            translate < 0, (SculptBaseRad * 0.75) + SculptPedestalThick, 0 >
        }
        plane { < 0, -1, 0 >, 0 translate < 0, SculptPedestalThick, 0 > }
    }
    cone {
        < 0, 0, 0 >,
            SculptPedestalRad,
        < 0, SculptPedestalThick, 0 >,
            SculptPedestalRad - (SculptPedestalThick / 2)
        texture { PolishedBrassTexture }
    }
}
