//////////////////////////////////////////////////////////////////////////
// SkyLoft.pov  20030816 Copyright(C) K.E. Ayers Designs, 2003          //
//                                                                      //
// A fanciful loft in the sky.                                          //
//////////////////////////////////////////////////////////////////////////

// Include the standard POV-Ray stuff

#include "colors.inc"
#include "textures.inc"


//////////////////////////////////////////////////////////////////////////
// 20010226 -- KEA                                                      //
// ===============                                                      //
// The 'clock' variable determines which objects will be rendered.      //
//                                                                      //
// Skyloft has evolved from "just a picture".  The concept now embodies //
// the use of multiple layers, on separate layers of glass, creating a  //
// "layered print" that provides an additional sense of the scene's     //
// depth.  Individual objects are hand trimmed from the printed pages   //
// and cemented to layers of glass.  When the glass layers are          //
// sandwiched together, the objects appear to "float" above one         //
// another.                                                             //
//                                                                      //
// To facilitate this, the clock variable will be used to selectively   //
// enable the objects that appear on the various layers.  Sections in   //
// the initialization file ("SkyLoft.ini") set the renderer's clock,    //
// which controls the set of objects that are rendered for a specific   //
// layer.  The layer values are:                                        //
//                                                                      //
//  LAYER NAME  CLOCK   OBJECTS                                         //
//  ==========  =====   ==============================================  //
//  Comp          0.0   Composite, the default -- sky and all objects.  //
//                      The final layered print will need two copies    //
//                      of the composite.  One, printed on canvas, is   //
//                      used as the background layer.  From the other   //
//                      composite print we can cut out all objects      //
//                      except the sofa and potted plant.               //
//  Sky           1.0   The sky, clouds and planet below -- in case we  //
//                      just want the sky as a background.              //
//  Sofa          2.0   The sofa and potted plant.                      //
//                                                                      //
// Note that, since the mirror and sculpture reflect many other objects //
// within the scene, they must be cut from a composite print.  However, //
// in the final piece, they will appear on the "wall" layer.            //
//////////////////////////////////////////////////////////////////////////


// The clock values that define our layers.
        #declare IncludeSky           = true;
#declare CompositeLayer = 0.0;
#declare SkyLayer       = 1.0;
#declare SofaLayer      = 2.0;

// Assume all objects are off.
#declare IncludeStaircase     = false;
#declare IncludeCoffeeTable   = false;
#declare IncludeSofa          = false;
#declare IncludeFloorLamp     = false;
#declare IncludePottedPlant   = false;
#declare IncludePainting      = false;
#declare IncludeHangingMirror = false;
#declare IncludeSculpture     = false;
#declare IncludeWindow        = false;

// The sky is always on ... but it might be plain white!
#declare IncludeSky      = true;
#declare WhiteBackground = false;

//#declare IncludeAll = false;
#declare IncludeAll = true;

#switch (clock)
    #case (CompositeLayer)
        #debug "\nRendering the composite scene\n"
        #declare IncludeStaircase     = true;
        #declare IncludeCoffeeTable   = true;
        #declare IncludeSofa          = true;
        #declare IncludeFloorLamp     = true;
        #declare IncludePottedPlant   = true;
        #declare IncludePainting      = true;
        #declare IncludeHangingMirror = true;
        #declare IncludeSculpture     = true;
        #declare IncludeWindow        = true;
    #break

    #case (SkyLayer)
        #debug "\nRendering for the sky layer\n"
        #declare IncludeSky      = true;
        #declare WhiteBackground = false;
    #break

    #case (SofaLayer)
        #debug "\nRendering for the wall layer\n"
        #declare IncludePainting    = true;
        #declare IncludePottedPlant = true;
        #declare IncludeSofa        = true;
    #break
#end


//////////////////////////////////////////////////////////////////////////
// Define our global constants.                                         //
//////////////////////////////////////////////////////////////////////////

#declare Ambient                = 0.3;
#declare Diffuse                = 0.6;


//////////////////////////////////////////////////////////////////////////
// Define our global textures.                                          //
//////////////////////////////////////////////////////////////////////////

#include "SkyLoftTextures.inc"


//////////////////////////////////////////////////////////////////////////
// Define our component objects.                                        //
//////////////////////////////////////////////////////////////////////////


#include "Staircase.inc"
#include "CoffeeTable.inc"
#include "Sofa.inc"
#include "PottedPlant.inc"
#include "Painting.inc"
#include "Mirror.inc"
#include "FloorLamp.inc"
#include "Sculpture.inc"
#include "CornerWindow.inc"
#include "SkyLoftSky.inc"


//////////////////////////////////////////////////////////////////////////
// Define the viewing parameters
//////////////////////////////////////////////////////////////////////////

camera { location < -24, 80, -96 > look_at < 72, 24, 50 > }

//////////////////////////////////////////////////////////////////////////
// Place the scene's light sources
//////////////////////////////////////////////////////////////////////////

//light_source { <  48, 96, -60 > color White }
light_source { < -48, 120, 72 > color White }

//////////////////////////////////////////////////////////////////////////
// Place the objects in the scene
//////////////////////////////////////////////////////////////////////////

#if (IncludeStaircase)
    object { Staircase translate < 36, 0, 36 > }
#end

#if (IncludeCoffeeTable)
    object { CoffeeTable rotate < 0, 90, 0 > translate < 66, 0, 48 > }
#end

#if (IncludeSofa)
    object { Sofa rotate < 0, 90, 0 > translate < 120, 0, 48 > }
#end

#if (IncludeFloorLamp)
    object { FloorLamp translate < 120, 0, -6 > }
#end

#if (IncludePottedPlant)
    object { PottedPlant translate < 66, 0, 120 > }
#end

#if (IncludePainting)
    object { Painting rotate < 0, -90, 0 > translate < 144, 48, 49 > }
#end

#if (IncludeHangingMirror)
    object { HangingMirror  translate < 66, 48, 150 > }
#end

#if (IncludeSculpture)
    object { Sculpture translate < 12, 0, 132 > finish { Shiny } }
#end

#if (IncludeWindow)
    object { Window translate < 186, 52, 198 > }
#end
