//////////////////////////////////////////////////////////////////////////
// SkyLoftSky.inc  20030816 Copyright(C) K.E. Ayers Designs, 2003       //
//                                                                      //
// The loft's walls are the sky!                                        //
//////////////////////////////////////////////////////////////////////////

#if (IncludeSky)
    #if (WhiteBackground)
        #declare SkyDist                = 1000;
        #declare SkyTextureScale        = SkyDist * 60 / 1000;

        #declare SkyTexture = 
        texture {
            pigment { color White }
            finish { ambient 1 diffuse 0 }
        }

        sphere {
            < 0, 0, 0 >, SkyDist
            texture { SkyTexture scale SkyTextureScale }
            hollow
        }
    #else
        #declare SkyRad                 = 40000;
        #declare CloudLayerRad          = SkyRad * 2.5;
        #declare CloudLayerOfs          = SkyRad * 150 / 20000;
        #declare SkyTextureScale        = SkyRad * 0.5;
        #declare CloudTextureScale      = CloudLayerOfs *  50 / 100;
        #declare GroundTextureScale     = CloudLayerOfs *  45 / 100;
        #declare EarthOfs               = -(CloudLayerRad
                                                + CloudLayerOfs * 0.75);

        #declare SkyColor        = color rgb < 0.15, 0.15, 0.5  >;
        #declare WaterColor      = color rgb < 0.3,  0.3,  0.75 >;
        #declare HorizonColor    = color rgb < 0.55, 0.55, 1.0  >;
        #declare CloudLightColor = color rgb < 0.9,  0.9,  1.0  >;
        #declare CloudDarkColor  = color rgb < 0.3,  0.3,  0.4  >;
        #declare GroundGreen     = color rgb < 0.0,  0.4,  0.0  >;
        #declare GroundDarkGreen = color rgb < 0.1,  0.3,  0.0  >;
        #declare GroundBrown     = color rgb < 0.5,  0.4,  0.2  >;

        #declare SkyTexture =
        // The sky is deep blue, fading to light blue
        // near the horizon.
        texture {
            pigment {
                radial
                color_map {
                    [ 0.0   color SkyColor ]
                    [ 0.5   color SkyColor ]
                    [ 0.56  color HorizonColor ]
                    [ 0.75  color SkyColor ]
                    [ 1.0   color SkyColor ]
                }
            }
            rotate <  90, 120,   0 >
            finish { ambient 1 diffuse 0 }
        }
        texture {
            pigment {
                onion
                turbulence 0.8
                octaves 7
                color_map {
                    [0.0   color Clear ]
                    [0.25  color Clear ]
                    [0.5   color White ]
                    [0.75  color Clear ]
                    [1.0   color Clear ]
                }
            }
            rotate <  90, 75, -140 >
            scale SkyTextureScale
            finish { ambient 1 diffuse 0 }
        }
        #declare EarthTexture = 
        texture {
            pigment {
                bozo
                turbulence 0.6
                color_map {
                    [ 0.0   color GroundGreen     ]
                    [ 0.2   color GroundDarkGreen ]
                    [ 0.275 color GroundGreen     ]
                    [ 0.5   color WaterColor      ]    
                    [ 0.725 color GroundGreen     ]
                    [ 0.9   color GroundBrown     ]
                    [ 1.0   color GroundGreen     ]
                }
            }
            scale GroundTextureScale
            finish { ambient 1 diffuse 0 }
        }
        texture {
            pigment {
                leopard
                turbulence 2.0
                octaves 8
                color_map {
                    [ 0.0   color Clear ]
                    [ 0.35  color White ]
                    [ 0.65  color White ]
                    [ 1.0   color Clear ]
                }
            }
            scale CloudTextureScale
            finish { ambient 1 diffuse 0 }
        }

        // This is our "sky sphere"
        sphere {
            < 0, 0, 0 >, SkyRad
            texture { SkyTexture }
            //rotate <  0,  120,   0 >
            hollow
        }
        union {
            // This is our "sky sphere"
            sphere {
                < 0, 0, 0 >, SkyRad
                texture { SkyTexture }
                //rotate <  0,  120,   0 >
                hollow
            }

            // We'll add in a "ground sphere", which provides the
            // layer of cloud cover and the ground peeking through
            // breaks in the clouds.
            intersection {
                sphere {
                    < 0, 0, 0 >, CloudLayerRad
                }
                plane { < 0, 0, -1 >, 0 translate < 0, 0, 100 > }
                texture { EarthTexture }
                translate < 0, EarthOfs, 0 >
                rotate < 22,  0,  -16 >
                hollow
            }
        }
    #end    // #if (WhiteBackground)
#end    // #if (IncludeSky)
