
/**********************************************************/
// Persistence of Vision Ray Tracer World definition file
// File name   : This is not a shark.pov
// Version     : 3.5
// Image size  : Render with 600x800 for best results
// Description : 
//               
// Date        : 08/22/2003    (22.08.2003)
// Author      : Thomas A. M. de Groot
// E-mail      : t.degroot@inter.nl.net
 
// Copyright (C) 2003. All rights reserved.
/**********************************************************/

default {
  texture {
    pigment { rgb <1,0,0> }
  }
}

#version 3.5;

/* // Scene Comment

This scene was created with Moray V3.5RC2 For Windows
Copyright (c) 1993-2003 Lutz + Kretzschmar.

*/

#include "functions.inc"
#include "math.inc"
#include "transforms.inc"


global_settings {
  adc_bailout 0.003922
  //ambient_light <0.007843,0.007843,0.007843>
  assumed_gamma 1.0
  hf_gray_16 off
  irid_wavelength <0.247059,0.176471,0.137255>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
  noise_generator 3
  charset ascii
  radiosity {
    brightness       1.0
    count            35
    error_bound      1.8
    gray_threshold   0.6
    low_error_factor 0.5
    minimum_reuse    0.015
    nearest_count    5
    recursion_limit  4
    #if (version>3.1)
      adc_bailout      0.01
      max_sample       -1.0
      media            on
      normal           off
      always_sample    1

      pretrace_start   0.08
      pretrace_end     0.04
    #end
  }
}

background { color <0.290,0.290,0.541> }

fog {
  fog_type 2    // Ground Fog
  distance     50.0
  color <0.756863,0.807843,0.882353,0.0,0.0>
  turbulence   <100.0,100.0,100.0>
    omega      0.5
    lambda     2.0
    octaves    6
    turb_depth 100.0
  up           <0,0,1>
  fog_offset   -50.0
  fog_alt      10.0
}

camera {  //  Camera Camera01
  location  <    -19.580,     -29.800,       5.000>
  sky       <    0.00000,     0.00000,     1.00000> // Use right handed-system 
  up        <        0.0,         0.0,         1.0> // Where Z is up
  right     <    0.70048,         0.0,         0.0> // Right Vector is adjusted to compensate for spherical (Moray) vs. planar (POV-Ray) aspect ratio
  angle         54.40000    // Vertical      72.533
  look_at   <      0.000,       0.000,       0.000>
}

//
// *******  L I G H T S *******
//

light_source {   // Light001
  <0.0, 0.0, 0.0>
  color rgb <1.000, 1.000, 1.000>*1.5000
  photons {
  }
  translate  <-180.0, -250.0, 100.0>
}


//
// ********  MATERIALS  *******
//

#include "surrealisticlandscape.inc"


//
// ********  OBJECTS  *******
//

// InsertCode_Skysphere
/***************************************************
 Fast sky by Rune S. Johansen
****************************************************/
// Initial declarations:
#declare Moray = true;  //set to true if you want to use it in Moray
#declare SkyScale = 300;
#declare SkyRot = 70;

#include "C:\VirtualReality\Data files\POV-Ray files\Specific Includes\Rune Johansen\FastSky\fastsky.inc"


/***************************************************
 Shark from Taschen edition: 500 3D Objects, Vol. 1
****************************************************/
#include "C:\VirtualReality\Data files\POV-Ray files\POV objects\Taschen\Shark\wsharkf__p.inc"

#declare P_WSTOF1_Ref = object {
  P_WSTOF
}
#declare P_WSHBODYF1_Ref = object {
  P_WSHBODYF
}
union { // WSHARKF__group
  object { P_WSTOF1_Ref }
  object { P_WSHBODYF1_Ref }
  translate  <-130.06848, 480.56817, -2531.56952>
  scale 0.001
  rotate <15.0, 2.0, 30.0>
  translate  <-13.627316, -12.444944, 9.0>
}


/***************************************************
 Isosurface
****************************************************/
// Isosurface001
// Isosurface plugin 1.3beta by S. Shonfield, morayplugin@yahoo.ca
#declare F1=function{pattern{granite turbulence 0.3 scale <20,10,10>}} ;
#declare F2=function{pattern{crackle turbulence 0.8 scale <15,10,10>}} ;
isosurface {
   function {
      z - F1(x,y,z)*0.3 - F2(x,y,z)*1.0 + f_noise3d(x*1, y*1, z*10)*0.5 
   }
   contained_by {box{<-30,-30,-5>,<30,30,5>}}
   threshold 0.1
   accuracy 0.01
   max_gradient 2
   max_trace 1
material { Gradient }

scale <1,1,10>
rotate <0,0,0>
translate <0,0,0>
} // end isosurface


// InsertCode_pods
/***************************************************
 Chris Colefax's mesh and hair macro's
****************************************************/
#include "pcm.mcr"
#include "pcmhair.mcr"

   #declare hair_length = .6;
   #declare hair_thickness = .05;
   #declare hair_rotation = x*75;
   #declare hair_sky = x;             // Causes hair to fall in -x direction
   #declare hairs_per_patch = 500;
   #declare hair_rotate_to_surface = true;
   #declare hair_objects_per_unit = 100;
   #declare hair_texture = texture {
      pigment {wrinkles color_map {[0 rgb <1, 0, 0>] [1 rgb <1, 1, 0>]} scale .6}
      finish {phong .3 phong_size 25}}
   #declare apply_hair_materials_to_mesh = true;
   triangle_patch_hairs_object ()

#declare Seed =
   union {
     object {read_mesh ("FlatSphere.pcm") 
   	scale <0.8,0.5,0.9>
     }
     object {read_mesh ("LongStrand3.pcm")
        scale <0.1, 0.4, 0.1>
     }
     scale <1, 1, -1>
     rotate <90, 0, 0>
   }

object {Seed
    scale 0.4
    rotate <13, 3, 0>
    translate <-17.5, -28, 6>
}
   
object {Seed
    scale 0.3
    rotate 137.5*z
    rotate <11, 4, 0>
    translate <-18.5, -28, 5>
}

object {Seed
    scale 1.0
    rotate -137.5*z
    rotate <11, 4, 0>
    translate <-17, -20, 9>
}



