// Persistence of Vision Ray Tracer Scene Description File
// File: .pov
// Vers: 3.5
// Desc: "First Post" type image
// Date: 8/23/03
// Auth: James Moore

#include "metals.inc"

camera {
	up y
	right image_width/image_height*x
	angle 50
	location <-4, 3, -4>
	look_at y*1
}

light_source {<0.575, 4.99, 0> rgb <2, 0, 0>
	rotate y*0
	area_light <4, 0, 0>, <0, 0, 4>, 3, 3
}
light_source {<0.55, 4.99, 0> rgb <0, 2, 0>
	area_light <4, 0, 0>, <0, 0, 4>, 3, 3
	rotate y*120
}
light_source {<0.55, 4.99, 0> rgb <0, 0, 2>
	area_light <4, 0, 0>, <0, 0, 4>, 3, 3
	rotate y*240
}

#declare t_col1=
texture {
	pigment {
		wrinkles
		scale 0.5
		turbulence 0.2
		color_map {
			[0 rgb 1]
			[0.5 red 1]
			[1 rgb 1]
		}
	}
	normal {
		average
		normal_map {
			[1 checker 0.5]
			[0.5 wrinkles scale 0.5 turbulence 0.2]
		}
	}
	finish {
		specular 0.3
		roughness 0.2
	}
}

#declare t_col2=
texture {
	pigment {
		wrinkles
		scale 0.5
		turbulence 0.2
		color_map {
			[0 red 1]
			[0.5 rgb 1]
			[1 red 1]
		}
	}
	normal {
		average
		normal_map {
			[1 checker 0.5]
			[0.5 wrinkles scale 0.5 turbulence 0.2]
		}
	}
	finish {
		specular 0.3
		roughness 0.2
	}
}

box {<-5, 0, -5>, 5
	hollow
	texture {
		checker
		texture {t_col1}
		texture {t_col2}
	}
}

sphere {<1, 0.75, 0>, 0.5
	texture {
		T_Chrome_5E
		normal {granite 0.02 scale 0.1}
	}
	rotate y*60
}

sphere {<1, 0.75, 0>, 0.5
	texture {
		T_Chrome_5E
		normal {granite 0.02 scale 0.1}
	}
	rotate y*180
}

sphere {<1, 0.75, 0>, 0.5
	texture {
		T_Chrome_5E
		normal {granite 0.02 scale 0.1}
	}
	rotate y*300
}

fog {
	fog_type 2
	distance 1
	rgbf 0.75
	fog_offset 0.1
	fog_alt 0.1
	turbulence 0.8
}
