// Persistence of Vision Ray Tracer Scene Description File
// File: .pov
// Vers: 3.5
// Desc: produces blob/mesh trees
// Date: 8/23/03
// Auth: James Moore

#include "functions.inc"
#include "rand.inc"
#include "math.inc"
#include "transforms.inc"


#declare rlim=6;
#macro btree (rlvl, loc, rad, ht, ang, rsf, hsf, sd)
	#local c=0;
	#local maxc=ht;
	#local step=maxc/15;
	#while (c<=maxc)
		#write (file, "    sphere {0, 1, 1\n"
			#local xs=RRand(0.75, 1, sd);
			#local zs=RRand(0.75, 1, sd);
			#local xt=RRand(-rad*0.15, rad*0.15, sd);
			#local zt=RRand(-rad*0.15, rad*0.15, sd);
			#local r=rad*(maxc-c+1);
			#write (file, "      scale ") #write (file, <r*xs, r*1.2, r*zs>)
			#write (file, "\n      translate ") #write (file,<xt, c, zt>)
			#write (file, "\n      rotate ") #write (file, ang)
			#write (file, "\n      translate ") #write (file, loc)
		#write (file, "\n    }\n")
		#local c=c+step;
	#end

	#if (rlvl<rlim)
		#local xang=35;
		btree (rlvl+1, vtransform (y*ht, transform {rotate ang translate loc}), rad*rsf, ht*hsf, ang/2+<xang, 0, 0>+VRand_In_Box(-15, 15, sd), hsf*RRand(0.85, 1.15, sd), rsf*RRand(0.9, 1.1, sd), sd)
		btree (rlvl+1, vtransform (y*ht*RRand(0.8, 1, sd), transform {rotate ang translate loc}), rad*rsf, ht*hsf, ang/2+<xang, 120, 0>+VRand_In_Box(-15, 15, sd), hsf*RRand(0.85, 1.15, sd), rsf*RRand(0.9, 1.1, sd), sd)
		btree (rlvl+1, vtransform (y*ht*RRand(0.6, 1, sd), transform {rotate ang translate loc}), rad*rsf, ht*hsf, ang/2+<xang, 240, 0>+VRand_In_Box(-15, 15, sd), hsf*RRand(0.85, 1.15, sd), rsf*RRand(0.9, 1.1, sd), sd)
	#end
#end

#macro square (p1, p2, p3, p4)
	#write (file, "    triangle {")
	#write (file, p1)
	#write (file, ",")
	#write (file, p2)
	#write (file, ",")
	#write (file, p3)
	#write (file, "}\n")
	#write (file, "    triangle {")
	#write (file, p2)
	#write (file, ",")
	#write (file, p3)
	#write (file, ",")
	#write (file, p4)
	#write (file, "}\n")
#end

#declare sd2=seed(1);
#macro moss (rlvl, loc, rad, ht, ang, rsf, hsf, sd)

	//keep random seeds the same as tree
	#local c=0;
	#local maxc=ht;
	#local step=maxc/15;
	#while (c<=maxc)
		#local xs=RRand(0.75, 1, sd);
		#local zs=RRand(0.75, 1, sd);
		#local xt=RRand(-rad*0.15, rad*0.15, sd);
		#local zt=RRand(-rad*0.15, rad*0.15, sd);
		#local r=rad*(maxc-c+1);
		#local c=c+step;
	#end

	//moss on smallest branches
	#if ((rlvl >= rlim-2)&(RRand(0, 1, sd2)<0.75))
		#local yy=ht*RRand(0.8, 1.5, sd2);
		#local step=ht/5;
		#local prevp1=vtransform(<0, ht*0.2, 0>, transform {rotate ang translate loc});
		#local prevp2=vtransform(<0, ht*0.8, 0>, transform {rotate ang translate loc});
		#while (yy>0)
			#local p3=prevp1;
			#local p4=prevp2;
			#local htf1=0.5-pow(RRand(0.1, 0.4, sd2)*yy, 0.5);
			#local htf2=0.5+pow(RRand(0.1, 0.4, sd2)*yy, 0.5);
			#local p1=vtransform(<0, ht*htf1, 0>, transform {rotate ang translate loc})-y*yy;
			#local p2=vtransform(<0, ht*htf2, 0>, transform {rotate ang translate loc})-y*yy;
			#local mid=p1+(p2-p1)/2;
			square (p1, p2, p3, p4)
			#local yy=yy-step;
		#end
	#end

	#if (rlvl<rlim)
		#local xang=35;
		moss (rlvl+1, vtransform (y*ht, transform {rotate ang translate loc}), rad*rsf, ht*hsf, ang/2+<xang, 0, 0>+VRand_In_Box(-15, 15, sd), hsf*RRand(0.85, 1.15, sd), rsf*RRand(0.9, 1.1, sd), sd)
		moss (rlvl+1, vtransform (y*ht*RRand(0.8, 1, sd), transform {rotate ang translate loc}), rad*rsf, ht*hsf, ang/2+<xang, 120, 0>+VRand_In_Box(-15, 15, sd), hsf*RRand(0.85, 1.15, sd), rsf*RRand(0.9, 1.1, sd), sd)
		moss (rlvl+1, vtransform (y*ht*RRand(0.6, 1, sd), transform {rotate ang translate loc}), rad*rsf, ht*hsf, ang/2+<xang, 240, 0>+VRand_In_Box(-15, 15, sd), hsf*RRand(0.85, 1.15, sd), rsf*RRand(0.9, 1.1, sd), sd)
	#end
#end

//---------------------------------------------------------------
//---------------------------------------------------------------

#declare fn=array[10];
#declare fn[0]="tree0.inc";
#declare fn[1]="tree1.inc";
#declare fn[2]="tree2.inc";
#declare fn[3]="tree3.inc";
#declare fn[4]="tree4.inc";
#declare fn[5]="tree5.inc";
#declare fn[6]="tree6.inc";
#declare fn[7]="tree7.inc";
#declare fn[8]="tree8.inc";
#declare fn[9]="tree9.inc";
#declare tr=clock;
#debug "\nOpening file"
#fopen file fn[tr] write
#write (file, "union {\n")
#write (file, "  blob {\n")
#write (file, "    threshold 0.1\n")
btree (0, y*-0.3, 0.06, 1, 0, 0.5, 0.5, seed(tr))
#write (file, "    texture {t_tree}\n")
#write (file, "  }\n")
#write (file, "  mesh {\n")
moss (0, y*-0.3, 0.06, 1, 0, 0.5, 0.5, seed(tr))
#write (file, "    texture {t_moss}\n")
#write (file, "  }\n")
#write (file, "}\n")
#write (file, "\n")
#fclose file
#debug "Closing file\n"

//---------------------------------------------------------------
//---------------------------------------------------------------

