
#declare old_red_paint =
texture{
pigment{
wrinkles
turbulence .4
omega 0.6
color_map{
	[0.00 color rgb <.40,.15,0> ]
	[1.00 color rgb <.525,.05,0> ]
		}
	}

finish{ specular .05 roughness 1/75 ambient scene_ambient }
normal{ dents .1 }
}



#declare old_black_paint =
texture{
pigment{
wrinkles
turbulence .4
omega 0.6
color_map{
	[0.00 color rgb <.15,.15,.1> ]
	[1.00 color rgb <.1,.1,.1> ]
		}
	}

finish{ specular .05 roughness 1/75 ambient scene_ambient }
normal{ dents .1 }
}





#declare old_green_paint =
texture{
pigment{
	wrinkles
	turbulence .4
	color_map{
		[0.00 color rgb <.55,.75,.65> ]
		[1.00 color rgb <.45,.6,.3> ]
			}
		}
finish{ specular 0 roughness 1 ambient scene_ambient }

}





#declare road_tex =
texture{
pigment{
	granite
	turbulence .2
	omega .6
	scale .1
	color_map{
	[0.00 color rgb <.25,.25,.25> ]
	[0.15 color rgb <.35,.35,.35> ]
	[0.30 color rgb <.25,.25,.25> ]
	[1.00 color rgb <.35,.35,.35> ]
			}
		}
finish{ specular 0 roughness 1 ambient scene_ambient }

}





#declare paint_01 =
pigment{
average
pigment_map{
[	crackle
	turbulence .52
	omega .81
	form <-1,1,0>
	metric 2
	pigment_map{
		[0.00 color rgb <.85,.75,.65> ]
		[0.10 color rgb <1,.975,.9> ]
		[1.00 wrinkles
		turbulence .2
			color_map{
				[0.00 color rgb <1,1,1> ]
				[0.10 color rgb <1,.975,.9> ]
				[0.50 color rgb <.85,.75,.45> ]
				[1.00 color rgb <1,.975,.9> ]
					} ]
			} ]
[	wrinkles
	turbulence .2
	color_map{
		[0.00 color rgb <1,1,1> ]
		[0.20 color rgb <1,.975,.9> ]
		[0.50 color rgb <.85,.80,.55> ]
		[0.75 color rgb <1,.975,.9> ]
		[1.00 color rgb <.975,.95,.85> ]
			} ]
		}
	}





#declare paint_02 =
pigment{
	wrinkles
	turbulence .2
	color_map{
		[0.00 color rgb <.9,.875,.8> ]
		[0.20 color rgb <.85,.80,.55> ]
		[0.55 color rgb <.6,.5,.25> ]
		[1.00 color rgb <.875,.85,.75> ]
			}
	}







#declare wall_texture_01 =
texture{
pigment{
average
pigment_map{
[1.00
	crackle
	turbulence .075
	octaves 8
	omega .65
	form <-1,1,0>
	metric 2
	offset 0.0
//	solid
	scale <1,1,1> * 3
	pigment_map{
		[0.00 paint_02 ]
//		[0.04 paint_02 ]
		[0.20 paint_01 ]
		[1.00 paint_01 ]
			} ]

[1.00
	crackle
	turbulence .075
	octaves 8
	omega .65
	form <-1,1,0>
	metric 2
	offset 0.0
//	solid
	scale <1,1,1> * .1
	pigment_map{
		[0.00 color rgb <.2,.275,.25> ]
//		[0.04 paint_02 ]
		[0.20 paint_01 ]
		[1.00 paint_01 ]
			} ]

[4.00 paint_01 ]
		}
	}

finish{
	specular 0
	roughness 1
	ambient scene_ambient
	diffuse 1
		}

	normal{
	average
	normal_map{
		[ dents .25 ]
		[ granite .1 scale .1 ]
		[ crackle .5     
		turbulence .52
		omega .81     
		form <-1,1,0> 
		metric 2 ]    
		
			}
		}
	scale .5
}


#declare rust_01 =
pigment{
	bozo
	turbulence .4
	lambda 3.3
	omega .7
	frequency 4
	color_map{
		[0.00 color rgb <.35,.2,.10>/2 ]
		[0.50 color rgb <.375,.25,.075> ]
		[1.00 color rgb <.35,.275,.10> ]
			}
}

#declare old_table_texture_01 =
texture{
pigment{
	bozo
	turbulence .4
	lambda 3.3
	color_map{
		[0.00 color rgb <.35,.275,.10>/2 ]
		[0.35 color rgb <.2,.2,.225> ]
		[1.00 color rgb <.35,.35,.35> ]
			}
		}

	finish{
	specular 0
	roughness 1
	ambient scene_ambient
	diffuse 1
		}

}



#declare old_table_texture_02 =
texture{
pigment{
	bozo
	turbulence .2
	frequency 1
	omega .75
	pigment_map{
		[0.00 rust_01 ]
		[0.20 rust_01 ]
		[0.25 rust_01 transmit 1 ]
		[1.00 rust_01 transmit 1 ]
			}
			scale 1
		}

finish{
	specular 0
	roughness 1
	ambient scene_ambient
	diffuse 1
		}

}



#declare old_table_finish =
finish{
	specular 0
	roughness 1
	ambient scene_ambient
	diffuse 1
		}



#declare glass =
texture{
pigment{ color rgbt <.9,.9,.9,.975> }
finish{ specular 1 roughness 1/512 reflection{ .01, .1 } ambient scene_ambient diffuse 1 }
normal{ bumps .005 scale .1 }
}



#declare dirty1 =
pigment{
	wrinkles
	scale .25
	turbulence .34
	color_map{
		[0.00 color rgbt <.33,.272,.05,.5> ]
//		[0.25 color rgbt <.13,.372,.05,1> ]
		[0.75 color rgbt <.13,.2,.15,0> ]
		[1.00 color rgbt <.23,.275,.05,.25> ]
			}
	}



#declare dirty2 =
pigment{
	wrinkles
	scale .125
	turbulence .14
//	sine_wave
	omega .8
	color_map{
		[0.00 color rgbt <.6,.525,.25,.75> ]
		[0.10 color rgbt <1,1,1,.45> ]
		[0.35 color rgbt <.6,.525,.25,.25> ]
//		[0.25 color rgbt <.6,.525,.25,1> ]
		[0.55 color rgbt <.6,.525,.25,1> ]
		[1.00 color rgbt <.6,.525,.25,.25> ]
			}
	}




#declare layer_of_filth_01 =
texture{
pigment{
gradient y
turbulence .075
omega .8
triangle_wave
scale <1,1,.5>
pigment_map{
		[0.00 dirty1 transmit .25 ]
		[0.05 dirty1 transmit .45 ]
		[0.30 dirty1 transmit .85 ]
//		[0.30 color rgbt <.3,.25,.15,.9> ]
		[0.85 color rgbt <.3,.25,.15,1> ]
		[1.00 color rgbt <.3,.25,.15,1> ]
			}
		}
		
		finish{
	specular 0
	roughness 1
	ambient scene_ambient
		}

}


#declare layer_of_filth_02 =
texture{
pigment{
gradient z
turbulence .075
omega .8
scale <1,.5,5/6>
triangle_wave
pigment_map{
		[0.00 dirty2 transmit .25 ]
		[0.05 dirty2 transmit .45 ]
		[0.30 dirty2 transmit .85 ]
//		[0.30 color rgbt <.3,.25,.15,.9> ]
		[0.85 color rgbt <.3,.25,.15,1> ]
		[1.00 color rgbt <.3,.25,.15,1> ]
			}
		}
	finish{
	specular 0
	roughness 1
	ambient scene_ambient
		}
}




#local g_dirt_01 =
pigment{
granite
turbulence .2
omega .6
	color_map{
	[0.00 color rgb <.6,.4,0> ]
	[0.25 color rgb <.45,.35,0>/2 ]
	[1.00 color rgb <.45,.35,0> ]
		}
}


#declare ground_tex =
texture{
	pigment{
	wrinkles
	turbulence .4
	omega .6
	scale 2
	pigment_map{
		[0.00 g_dirt_01 ]
		[0.25 color rgb <.45,.35,0>/2 ]
		[0.50 g_dirt_01 ]
		[1.00 color rgb <.45,.35,0> ]
				}
			}

	finish{
	specular 0
	roughness 1
	ambient scene_ambient
		}
}



#declare stone_tex =
texture{
	pigment{
	granite
	turbulence .4
	omega .6
	scale 2
	color_map{
		[0.00 color rgb <.40,.40,.40> ]
		[1.00 color rgb <.45,.35,.3> ]
				}
			}

	finish{
	specular 0
	roughness 1
	ambient scene_ambient + <.025,.025,.025>
		}
}





#declare wood_texture =
texture{
pigment{
	wood
	scale <1,1/2,1>/10
	translate <0,0,5>
	turbulence .1
	color_map{
	[0.00 color rgb <.75,.725,.5> ]
	[1.00 color rgb <.4,.35,.3> ]
		}
	}

	finish{
	specular 0
	roughness 1
	ambient scene_ambient
		}
	}




#declare grass1 =
texture{
pigment{
	wrinkles
	turbulence .3
	lambda 2.4
	omega .78
	color_map{
		[0.000 color rgb <.15,.45,0> ]
		[1.000 color rgb <.1,.5,0> ]
			}
		}

	finish{
	specular 0
	roughness 1
	ambient scene_ambient
		}
}












#macro grass_options(g_dir,mi_height,ma_height,g_ratio,g_thick)
#declare g_direction = vnormalize(g_dir);
#declare min_height = mi_height;
#declare max_height = ma_height;
#declare g_ratio = g_ratio;
#declare g_thickness = g_thick;

#end





#macro grass(amount,bound1,bound2,r_value)

#local g_xdist = abs(bound1.x - bound2.x);
#local g_zdist = abs(bound1.z - bound2.z);
#local min_x = min(bound1.x,bound2.x);
#local min_z = min(bound1.z,bound2.z);
#local min_y = min(bound1.y,bound2.y);
#local g_hdiff = abs(max_height - min_height);
#local g_mh = min(min_height,max_height);
#local s1 = seed(1);
#local s2 = seed(2 + rand(s1));


#local counter = 0;
#while(counter < amount)
// calculate grass
#local s3 = seed(5 + counter);
#declare g_direction = vnormalize(<g_direction.x + r_value * rand(s3),g_direction.y + r_value * rand(s3),g_direction.z + r_value * rand(s3)>);

#local grass_loc = <g_xdist*rand(s1),0,g_zdist*rand(s1)> + <min_x,min_y,min_z>;
#local gh2 = rand(seed(s2 + s3)) * g_hdiff + g_mh;
#local gh1 = gh2/(2+rand(s2));
#local ghrat1 = gh1/max_height;
#local ghrat2 = gh2/max_height;

#local gx1 = (g_thickness + rand(s1)/10 )/2;
#local gx2 = (g_thickness + rand(s1)/10 )/(2 + rand(s1));
#local gz1 = g_direction.z * ghrat1;
#local gz2 = g_direction.z * ghrat2;
#local gxd = (g_direction.x * ghrat1);

// make grass
triangle{ <-gx1,0,0> + grass_loc, <gx1,0,0> + grass_loc, <gx2 + gxd,gh1,gz1> + grass_loc }
triangle{ <-gx1,0,0> + grass_loc, <gx1,0,0> + grass_loc, <-gx2+ gxd,gh1,gz1> + grass_loc }
triangle{ <-gx2 + gxd,gh1,gz1> + grass_loc, <gx2 + gxd,gh1,gz1> + grass_loc, <(g_direction.x * ghrat2),gh2,gz2> + grass_loc }
/*
polygon{ 5, <-gx1,0,0>, <gx1,0,0>, <gx2 + (g_direction.x * ghrat1),gh1,gz1>, <-gx2 + (g_direction.x * ghrat1),gh1,gz1>, <-gx1,0,0> translate grass_loc }
polygon{ 4, <-gx2 + (g_direction.x * ghrat1),gh1,gz1>, <gx2 + (g_direction.x * ghrat1),gh1,gz1>, <gx2 + (g_direction.x * ghrat2),gh2,gz2>, <-gx2 + (g_direction.x * ghrat1),gh1,gz1> translate grass_loc }
*/
#local counter = counter + 1;

#end

#end




#macro sweep(s_precision,s0,s1,s2,s3,s_radius)
#local dx = s0.x;
#local cx = 3*(s1.x - s0.x);
#local bx = 3*(s2.x - s1.x) - cx;
#local ax = s3.x - s0.x - cx - bx;

#local dy = s0.y;
#local cy = 3*(s1.y - s0.y);
#local by = 3*(s2.y - s1.y) - cy;
#local ay = s3.y - s0.y - cy - by;

#local dz = s0.z;
#local cz = 3*(s1.z - s0.z);
#local bz = 3*(s2.z - s1.z) - cz;
#local az = s3.z - s0.z - cz - bz;

#local s_dt = 1/s_precision;
#local s_t = s_dt;
#while(s_t <= 1)
#local sx = ax * pow(s_t,3) + bx * pow(s_t,2) + cx * s_t + dx;
#local sy = ay * pow(s_t,3) + by * pow(s_t,2) + cy * s_t + dy;
#local sz = az * pow(s_t,3) + bz * pow(s_t,2) + cz * s_t + dz;

#local sxp = ax * pow((s_t - s_dt),3) + bx * pow((s_t - s_dt),2) + cx * (s_t - s_dt) + dx;
#local syp = ay * pow((s_t - s_dt),3) + by * pow((s_t - s_dt),2) + cy * (s_t - s_dt) + dy;
#local szp = az * pow((s_t - s_dt),3) + bz * pow((s_t - s_dt),2) + cz * (s_t - s_dt) + dz;

sphere{ <sx,sy,sz>, s_radius }
cylinder{ <sxp,syp,szp>, <sx,sy,sz>, s_radius }
#local s_t = s_t + s_dt;
#end
sphere{ s3, s_radius }
sphere{ s0, s_radius }


#end







#macro sweep2(s_precision,s0,s1,s2,s3,s_radius)
#local dx = s0.x;
#local cx = 3*(s1.x - s0.x);
#local bx = 3*(s2.x - s1.x) - cx;
#local ax = s3.x - s0.x - cx - bx;

#local dy = s0.y;
#local cy = 3*(s1.y - s0.y);
#local by = 3*(s2.y - s1.y) - cy;
#local ay = s3.y - s0.y - cy - by;

#local dz = s0.z;
#local cz = 3*(s1.z - s0.z);
#local bz = 3*(s2.z - s1.z) - cz;
#local az = s3.z - s0.z - cz - bz;


#local s_dt = 1/s_precision;
#local s_t = 0;

#while(s_t <= 1)
#local sx = ax * pow(s_t,3) + bx * pow(s_t,2) + cx * s_t + dx;
#local sy = ay * pow(s_t,3) + by * pow(s_t,2) + cy * s_t + dy;
#local sz = az * pow(s_t,3) + bz * pow(s_t,2) + cz * s_t + dz;

sphere{ <0,0,0> s_radius scale <1,2,2>/2 translate <sx,sy,sz> }
#local s_t = s_t + s_dt;
#end


#end

