/*
   ----------------         Decay - IRTC Competition            ------------------------ 
   ----------------               the_lizard.pov                ------------------------
   ----------------              31.October 2003                ------------------------
   ----------------       copyright by Norbert W. Kern          ------------------------
   ----------------      norbert-werner.kern@t-online.de        ------------------------ 
*/

#version 3.5;

// Renderered in two passes because of better radiosity effects:
// First pass: clou = 0; Save_Rad = 1; 
//Second pass: clou = 1; Save_Rad = 2; 

#declare qual = 2;      // 0=low quality rad settings; 1=mid quality; 2=final render                                              
#declare comp = 1;      // 0=simple gorge walls; 1=complex gorge for final render                                                    
#declare abov = 0;      // 0=scene file camera; 1=view from above; green cylinder shows camera location and viewpoint             
#declare gorg = 1;      // 0 no gorge; 1=gorge walls                                                                              
#declare rock = 1;      // 0 no rock; 1=rock                                                                                      
#declare rive = 1;      // 0 no river; 1=river  
#declare clou = 1;      // 0 no clouds; 1=clouds
#declare tree = 1;      // 0 no tree; 1=tree                                                                                      
#declare eagl = 1;      // 0 no eagle; 1=eagle                                                                                    
#declare liza = 1;      // 0 no lizard; 1=lizard                                                                                  

#declare Save_Rad  = 2;  // 1=save rad; 2=load rad data; 0=no rad storing
                
global_settings {
        #declare a_g = 1;
        assumed_gamma a_g
        max_trace_level 33
        noise_generator 2 
        radiosity {
                #if (Save_Rad = 2)
                        pretrace_start 1
                #else                        
                        pretrace_start 0.08
                #end
                #if (qual = 2)
                        #if (Save_Rad = 2)
                                pretrace_end 1
                        #else                        
                                pretrace_end 0.01
                        #end
                        count 100                
                        nearest_count 2      
                        error_bound 0.5
                        recursion_limit 2
                #end
                #if (qual = 1)
                        #if (Save_Rad = 2)
                                pretrace_end 1
                        #else                        
                                pretrace_end 0.02
                        #end
                        count 50                
                        nearest_count 1      
                        error_bound 1
                        recursion_limit 2
                #end                        
                #if (qual = 0)
                        #if (Save_Rad = 2)
                                pretrace_end 1
                        #else                        
                                pretrace_end 0.04
                        #end
                        count 20                
                        nearest_count 1      
                        error_bound 2
                        recursion_limit 1
                #end                        
                low_error_factor 0.5            
                gray_threshold 0  
                minimum_reuse 0.015 
                brightness 1.1      
                adc_bailout 0.005
                normal on
                media off
                #if (Save_Rad = 1)
                        save_file "pov.rad"
                #else
                        #if (Save_Rad = 2)
                                load_file "pov.rad" 
                                always_sample off
                        #end
                #end                          
        }
}        

camera {
        ultra_wide_angle
        location <1,0,-0.025> 
        right x*image_width/image_height 
        look_at <0,0,0> 
        angle 120
}
#if (abov) 
        camera {
                location  <0,6,-0.025> 
                right x 
                look_at <0,0,0> 
                angle 35
        } 
        cylinder {<1,0,-0.025>,<0,0,0>,0.03 pigment {color rgb y}} 
#end

#declare lights = <80000,150000,-5000>;
light_source {
        lights,
        <1,0.836,0.567>*8 
        #if (qual = 2)
                area_light <6000,0,0> <0,0,6000> 5,5 adaptive 0 jitter circular orient
        #end
        #if (qual = 1)
                area_light <6000,0,0> <0,0,6000> 3,3 adaptive 0 jitter circular orient
        #end                        
} 

#macro G(Color,g)
        rgb <pow(Color.x,g),pow(Color.y,g),pow(Color.z,g)>
#end 

#declare Gamma = 2.2/a_g;

sky_sphere {
        pigment {
                gradient y 
                color_map {
                        [0.0000 color G(<212,221,239>/255,Gamma)]
                        [0.1029 color G(<219,229,244>/255,Gamma)]
                        [0.1512 color G(<233,241,250>/255,Gamma)]
                        [0.1949 color G(<223,239,252>/255,Gamma)]
                        [0.2444 color G(<201,227,252>/255,Gamma)]
                        [0.2921 color G(<180,213,250>/255,Gamma)]
                        [0.3732 color G(<144,180,239>/255,Gamma)]
                        [0.4255 color G(<137,172,235>/255,Gamma)]
                        [0.7067 color G(< 97,126,198>/255,Gamma)]
                        [0.7740 color G(< 92,119,190>/255,Gamma)]
                        [0.8275 color G(< 88,114,185>/255,Gamma)]
                        [0.8850 color G(< 85,111,180>/255,Gamma)]                        
                        [0.9425 color G(< 82,107,175>/255,Gamma)]                        
                        [1.0000 color G(< 79,103,170>/255,Gamma)]
                }
        }
}

#include "functions.inc"

//_________________________________________________________________________________

#declare stone1_pig =
pigment { 
        image_map {png "s1h" interpolate 2}
        translate -0.5
        scale 5
        warp {turbulence 0.3 lambda 2}
}

#declare stone2_pig =
pigment { 
        image_map {png "s2h" interpolate 2}
        translate -0.5
        scale 5
        warp {turbulence 0.3 lambda 2}
}

#declare stone_tex =
texture {
        pigment{ 
                marble  
                warp {turbulence 0.2 lambda 3}
                pigment_map {
                        [0 stone1_pig]
                        [1 stone2_pig]
                }
        }
        #if (qual)
                normal {
                        marble 0.3
                        warp {turbulence 0.2 lambda 3}
                }
        #end
        finish {ambient 0 diffuse 2 specular 0.2 roughness 0.003}
        rotate z*90
        scale <1.5,1.9,0.8>*0.07
}

//  right  _________________________________________________________________________________

#declare f1_spl =  
function {
        spline {
                natural_spline
                -1,   <1.0, 0.0,0>,
                -0.9, <1.0, 0.0,0>,
                -0.5, <0.1, 0.2,0>,
                0.0,  <0.1, 0.1,0>,
                0.5,  <0.2, 0.2,0>,
                1,    <0.0,-0.0,0>
        }
}

#declare f1_pig =
function {
        pigment {
                granite
                color_map {
                        [0 color rgb 0]
                        [1 color rgb 1]
                }
        }
}

#declare gorge_right =
isosurface {
        function {
                z
                -f1_spl(x).x-f1_spl(y).y
                #if (comp)
                        -f_snoise3d(x*5,y*30,z*5)*0.07
                        +f_snoise3d(x*12,y*200,z*12)*0.01
                        -f1_pig(x*2,y*4,z*2).gray*0.05
                #end
        }
        #if (qual)
                max_gradient 3
                accuracy 0.0001
        #else
                max_gradient 3
                accuracy 0.0005        
        #end
        contained_by {box {<-1.1,-2,-1.1>,<1,1,1.1>}} open
        scale <1,2,1> 
        translate -0.7*y
        texture {stone_tex}
}

//  left  _________________________________________________________________________________

#declare f2_spl = 
function {
        spline {
                natural_spline
                -1.1,   <1.1, 0.0,0>,
                -0.5, <0.1, 0.2,0>,
                0.0,  <0.1, 0.1,0>,
                0.5,  <0.2, 0.2,0>,
                1,    <0.0,-0.4,0>
        }
}

#declare f2_Pig =
function {
        pigment {
                granite
                color_map {
                        [0 color rgb 0]
                        [1 color rgb 1]
                }
        }
}

#declare gorge_left =
isosurface {
        function {
                z
                -f2_spl(x).x-f2_spl(y).y
                #if (comp)
                        +f_snoise3d(x*5,y*30,z*5)*0.06
                        -f_snoise3d(x*12,y*200,z*12)*0.01
                        +f2_Pig(x*2,y*4,z*2).gray*0.05
                #end
        }
        #if (qual)
                max_gradient 3
                accuracy 0.0001
        #else
                max_gradient 3
                accuracy 0.0005        
        #end
        contained_by {box {<-1.1,-2,-1.1>,<1,1,1.1>}} open
        scale <1,2,1> 
        translate -0.7*y
        texture {stone_tex}
        translate <0,0,-0.5>
}

//_________________________________________________________________________________

#if (gorg)
        object {gorge_right}
        object {gorge_left}
        union {
                box {<-2,-2,-2>,<2,-2.1,2>}
                box {<-2,-2,-1>,<2,1,-2>}
                box {<-2,-2,0.8>,<2,1,2>}
                box {<-1.1,-2,-1>,<-2,1,1>}
                box {<-1.1,-2,-1.025>,<-2,1,0.975> rotate y*20}
                difference {
                        box {<1,-2,-1>,<2,1,1>}
                        cylinder {<1.1,-2.01,-0.25>,<1.1,1.01,-0.25>,0.5}
                }
                scale <1,2,1> translate -0.7*y
                texture {stone_tex}
        }
#end

//_________________________________________________________________________________

#if (rock)

#declare f3_Pig =
function {
        pigment {
                granite
                color_map {
                        [0 color rgb 0]
                        [1 color rgb 1]
                }
        }
}

#declare rock1_pig =
pigment { 
        image_map {png "r3g" interpolate 2}
        translate -0.5
        scale 5
        warp {turbulence 0.3 lambda 2}
}

#declare rock_tex =
texture {
        pigment{ 
                marble  
                warp {turbulence 0.3 lambda 3}
                pigment_map {
                        [0   stone1_pig]
                        [0.8 stone2_pig]
                        [1   rock1_pig]
                }
        }
        #if (qual)
                normal {
                        marble 0.3
                        warp {turbulence 0.2 lambda 3}
                }
        #end
        finish {ambient 0 diffuse 2 specular 0.2 roughness 0.003}
        rotate z*90
        scale 0.07
}
 
 
object {
        isosurface { 
                function {
                        f_sphere(x/8,(y*(1.05+y/5))/10,z/8,1)                               
                        -f_snoise3d(x*5*0.03,y*15*0.03,z*5*0.03)*0.29
                        +f_snoise3d(x*12*0.03,y*100*0.03,z*12*0.03)*0.032
                        -f3_Pig(x*2*0.03,y*2*0.03,z*2*0.03).gray*0.2
                }
                #if (qual)
                        max_gradient 3
                        accuracy 0.0001
                #else
                        max_gradient 3
                        accuracy 0.0005        
                #end 
                contained_by {sphere {0,13.5}}
        }     
        scale <1,10/8,1>*0.0285
        rotate <-36,5,-3>
        texture {rock_tex translate -0.4 rotate <-36,5,-3>}
        translate <0.3,0.1+0.04,0.13-0.02> 
}

#end

//_________________________________________________________________________________

#if (rive)

#declare rive1_norm =
normal {                                                 
        function {                                       
                f_ridged_mf (x,y,z,0.1,3,7,0.7,0.7,2)    
        }                                                
        0.5                                              
        scale 0.045                                      
}                                                        
#declare rive2_norm =
normal {                                                 
        function {                                       
                f_ridged_mf (x,y,z,0.1,3,7,0.7,0.7,2)    
        }                                                
        0.4                                              
        scale 0.015                                      
}       

plane {
        y,-1.8 
        hollow  
        material {     
                texture {
                        pigment {rgbf <0.3,0.375,0.2,1>}
                        normal {
                                average
                                normal_map {
                                        [1 rive1_norm]
                                        [1 rive2_norm]
                                }    
                        } 
                        finish { 
                                ambient 0 
                                diffuse 0.4 
                                specular 250 
                                roughness 0.015 
                                reflection {0.03,0.92 fresnel on} 
                                conserve_energy  
                        }
                }   
                interior { 
                        ior 1.334                                                
                        media {
                                absorption <0.7,0.5,1,0.3>
                                scattering {
                                        2 
                                        <0.6,0.75,0.4>
                                        extinction 2
                                }
                        } 
                }
        }       
}

#end

//_________________________________________________________________________________

#if (clou) 
        #include "3dclouds.inc" 
#end

#if (tree)
        #include "tree6_file.inc"
#end

#if (eagl)
        #include "eagle4_file.inc"
#end

#if (liza)
        #include "lizard3_file.inc"
#end

//_________________________________________________________________________________
