// Persistence of Vision Ray Tracer Scene Description File
// File: key.inc
// Vers: 3.5
// Desc: A key
// Date: 2003/10/12
// Auth: Maurizio Tomasi

#local HalfKey =
height_field
{
    png "key.png"
    smooth
    water_level 0.01
    
    translate <-0.5, 0, -0.5>
    scale <1, 0.08, 642/450>
}

#declare Key =
union
{
    object { HalfKey }
    object { HalfKey scale <1, -1, 1> }
    
    texture
    {
        pigment
        {
            color rgb <0.4, 0.4, 0.5>
        }
        
        finish
        {
            specular 0.2
            roughness 0.05
            metallic
        }
    }
    
    rotate -90*z
}

//--------------------------------------------------------

#declare Lock =
height_field
{
    png "lock.png"
    water_level 0.01
    
    translate <-0.5, 0, -0.5>
    scale <1, 0.05, 850/660> * 1.2
    rotate -90*x
    rotate 180*y
    
    texture
    {
        pigment
        {
            color rgb <0.8, 0.8, 0.4>
        }
        
        finish
        {
            specular 0.25
            roughness 0.02
            metallic
        }
    }
}
