// Persistence of Vision Ray Tracer Scene Description File
// File: new-wood.inc
// Vers: 3.5
// Desc: Wood textures (taken from woods.inc and slightly modified)
// Date: 2003/05/20 (date of creation of this file, but the textures
//                   were already created at that time)
// Auth: Maurizio Tomasi

#ifndef (__NEW_WOOD_INC__)
#declare __NEW_WOOD_INC__ = 1;

#local M_Wood1a = array[3];
#local M_Wood1b = array[3];
#local M_Wood2a = array[3];
#local M_Wood2b = array[3];

#local M_Wood1a[0] = 
color_map {
    [0.00 0.25   color rgb < 0.444, 0.310, 0.178> * 0.7 * 0.9
                 color rgb < 0.481, 0.325, 0.190> * 0.8 * 0.9]
    [0.25 0.40   color rgb < 0.481, 0.325, 0.190> * 0.8 * 0.9
                 color rgb < 0.497, 0.333, 0.190> * 0.5 * 0.9]
    [0.40 0.50   color rgb < 0.497, 0.333, 0.190> * 0.5 * 0.9
                 color rgb < 0.454, 0.310, 0.175> * 0.6 * 0.9]
    [0.50 0.70   color rgb < 0.454, 0.310, 0.175> * 0.6 * 0.9
                 color rgb < 0.509, 0.322, 0.202> * 0.4 * 0.9]
    [0.70 0.98   color rgb < 0.509, 0.322, 0.202> * 0.4 * 0.9
                 color rgb < 0.481, 0.325, 0.186> * 0.4 * 0.9]
    [0.98 1.00   color rgb < 0.481, 0.325, 0.186> * 0.4 * 0.9
                 color rgb < 0.454, 0.310, 0.178> * 0.7 * 0.9]
}
#local M_Wood1a[1] = 
color_map {
    [0.00 0.25   color rgb < 0.444, 0.310, 0.178> * 0.7
                 color rgb < 0.481, 0.325, 0.190> * 0.8 ]
    [0.25 0.40   color rgb < 0.481, 0.325, 0.190> * 0.8
                 color rgb < 0.497, 0.333, 0.190> * 0.5 ]
    [0.40 0.50   color rgb < 0.497, 0.333, 0.190> * 0.5
                 color rgb < 0.454, 0.310, 0.175> * 0.6 ]
    [0.50 0.70   color rgb < 0.454, 0.310, 0.175> * 0.6 
                 color rgb < 0.509, 0.322, 0.202> * 0.4 ]
    [0.70 0.98   color rgb < 0.509, 0.322, 0.202> * 0.4
                 color rgb < 0.481, 0.325, 0.186> * 0.4 ]
    [0.98 1.00   color rgb < 0.481, 0.325, 0.186> * 0.4
                 color rgb < 0.454, 0.310, 0.178> * 0.7 ]
}
#local M_Wood1a[2] = 
color_map {
    [0.00 0.25   color rgb < 0.454, 0.310, 0.178> * 0.7 * 1.1
                 color rgb < 0.481, 0.325, 0.190> * 0.8 * 1.1]
    [0.25 0.40   color rgb < 0.481, 0.325, 0.190> * 0.8 * 1.1
                 color rgb < 0.497, 0.333, 0.190> * 0.5 * 1.1]
    [0.40 0.50   color rgb < 0.497, 0.333, 0.190> * 0.5 * 1.1
                 color rgb < 0.454, 0.310, 0.175> * 0.6 * 1.1]
    [0.50 0.70   color rgb < 0.454, 0.310, 0.175> * 0.6 * 1.1
                 color rgb < 0.509, 0.322, 0.202> * 0.4 * 1.1]
    [0.70 0.98   color rgb < 0.509, 0.322, 0.202> * 0.4 * 1.1
                 color rgb < 0.481, 0.325, 0.186> * 0.4 * 1.1]
    [0.98 1.00   color rgb < 0.481, 0.325, 0.186> * 0.4 * 1.1
                 color rgb < 0.454, 0.310, 0.178> * 0.7 * 1.1]
}

#local M_Wood1b[0] = 
color_map {
    [0.00 0.25   color rgb < 0.404, 0.210, 0.128> * 0.95 transmit 0.20
                 color rgb < 0.431, 0.225, 0.140> * 0.95 transmit 0.80]
    [0.25 0.40   color rgb < 0.431, 0.225, 0.140> * 0.95 transmit 0.80
                 color rgb < 0.447, 0.233, 0.140> * 0.95 transmit 0.20]
    [0.40 0.50   color rgb < 0.447, 0.233, 0.140> * 0.95 transmit 0.20
                 color rgb < 0.404, 0.210, 0.125> * 0.95 transmit 0.60]
    [0.50 0.70   color rgb < 0.404, 0.210, 0.125> * 0.95 transmit 0.60
                 color rgb < 0.459, 0.222, 0.152> * 0.95 transmit 0.20]
    [0.70 0.98   color rgb < 0.459, 0.222, 0.152> * 0.95 transmit 0.20
                 color rgb < 0.431, 0.225, 0.136> * 0.95 transmit 0.40]
    [0.98 1.00   color rgb < 0.431, 0.225, 0.136> * 0.95 transmit 0.40
                 color rgb < 0.404, 0.210, 0.128> * 0.95 transmit 0.10]
}
#local M_Wood1b[1] = 
color_map {
    [0.00 0.25   color rgb < 0.404, 0.210, 0.178> transmit 0.20
                 color rgb < 0.431, 0.225, 0.190> transmit 0.80]
    [0.25 0.40   color rgb < 0.431, 0.225, 0.190> transmit 0.80
                 color rgb < 0.447, 0.233, 0.190> transmit 0.20]
    [0.40 0.50   color rgb < 0.447, 0.233, 0.190> transmit 0.20
                 color rgb < 0.404, 0.210, 0.175> transmit 0.60]
    [0.50 0.70   color rgb < 0.404, 0.210, 0.175> transmit 0.60
                 color rgb < 0.459, 0.222, 0.202> transmit 0.20]
    [0.70 0.98   color rgb < 0.459, 0.222, 0.202> transmit 0.20
                 color rgb < 0.431, 0.225, 0.186> transmit 0.40]
    [0.98 1.00   color rgb < 0.431, 0.225, 0.186> transmit 0.40
                 color rgb < 0.404, 0.210, 0.178> transmit 0.10]
}
#local M_Wood1b[2] = 
color_map {
    [0.00 0.25   color rgb < 0.404, 0.210, 0.178> * 1.1 transmit 0.20
                 color rgb < 0.431, 0.225, 0.190> * 1.1 transmit 0.80]
    [0.25 0.40   color rgb < 0.431, 0.225, 0.190> * 1.1 transmit 0.80
                 color rgb < 0.447, 0.233, 0.190> * 1.1 transmit 0.20]
    [0.40 0.50   color rgb < 0.447, 0.233, 0.190> * 1.1 transmit 0.20
                 color rgb < 0.404, 0.210, 0.175> * 1.1 transmit 0.60]
    [0.50 0.70   color rgb < 0.404, 0.210, 0.175> * 1.1 transmit 0.60
                 color rgb < 0.459, 0.222, 0.202> * 1.1 transmit 0.20]
    [0.70 0.98   color rgb < 0.459, 0.222, 0.202> * 1.1 transmit 0.20
                 color rgb < 0.431, 0.225, 0.186> * 1.1 transmit 0.40]
    [0.98 1.00   color rgb < 0.431, 0.225, 0.186> * 1.1 transmit 0.40
                 color rgb < 0.404, 0.210, 0.178> * 1.1 transmit 0.10]
}

#local M_Wood2a[0] = 
color_map {
    [0.00 0.25   color rgb < 0.504, 0.310, 0.178> * 0.7 * 1.2
                 color rgb < 0.531, 0.325, 0.190> * 0.8 * 1.2 ]
    [0.25 0.40   color rgb < 0.531, 0.325, 0.190> * 0.8 * 1.2
                 color rgb < 0.547, 0.333, 0.190> * 0.5 * 1.2]
    [0.40 0.50   color rgb < 0.547, 0.333, 0.190> * 0.5 * 1.2
                 color rgb < 0.504, 0.310, 0.175> * 0.6 * 1.2]
    [0.50 0.70   color rgb < 0.504, 0.310, 0.175> * 0.6 * 1.2
                 color rgb < 0.559, 0.322, 0.202> * 0.4 * 1.2]
    [0.70 0.98   color rgb < 0.559, 0.322, 0.202> * 0.4 * 1.2
                 color rgb < 0.531, 0.325, 0.186> * 0.4 * 1.2]
    [0.98 1.00   color rgb < 0.531, 0.325, 0.186> * 0.4 * 1.2
                 color rgb < 0.504, 0.310, 0.178> * 0.7 * 1.2]
}
#local M_Wood2a[1] = 
color_map {
    [0.00 0.25   color rgb < 0.504, 0.310, 0.178> * 0.7 * 1.3
                 color rgb < 0.531, 0.325, 0.190> * 0.8 * 1.3 ]
    [0.25 0.40   color rgb < 0.531, 0.325, 0.190> * 0.8 * 1.3
                 color rgb < 0.547, 0.333, 0.190> * 0.5 * 1.3]
    [0.40 0.50   color rgb < 0.547, 0.333, 0.190> * 0.5 * 1.3
                 color rgb < 0.504, 0.310, 0.175> * 0.6 * 1.3]
    [0.50 0.70   color rgb < 0.504, 0.310, 0.175> * 0.6 * 1.3
                 color rgb < 0.559, 0.322, 0.202> * 0.4 * 1.3]
    [0.70 0.98   color rgb < 0.559, 0.322, 0.202> * 0.4 * 1.3
                 color rgb < 0.531, 0.325, 0.186> * 0.4 * 1.3]
    [0.98 1.00   color rgb < 0.531, 0.325, 0.186> * 0.4 * 1.3
                 color rgb < 0.504, 0.310, 0.178> * 0.7 * 1.3]
}
#local M_Wood2a[2] = 
color_map {
    [0.00 0.25   color rgb < 0.454, 0.310, 0.178> * 0.7 * 1.4
                 color rgb < 0.481, 0.325, 0.190> * 0.8 * 1.4 ]
    [0.25 0.40   color rgb < 0.481, 0.325, 0.190> * 0.8 * 1.4
                 color rgb < 0.497, 0.333, 0.190> * 0.5 * 1.4]
    [0.40 0.50   color rgb < 0.497, 0.333, 0.190> * 0.5 * 1.4
                 color rgb < 0.454, 0.310, 0.175> * 0.6 * 1.4]
    [0.50 0.70   color rgb < 0.454, 0.310, 0.175> * 0.6 * 1.4
                 color rgb < 0.509, 0.322, 0.202> * 0.4 * 1.4]
    [0.70 0.98   color rgb < 0.509, 0.322, 0.202> * 0.4 * 1.4
                 color rgb < 0.481, 0.325, 0.186> * 0.4 * 1.4]
    [0.98 1.00   color rgb < 0.481, 0.325, 0.186> * 0.4 * 1.4
                 color rgb < 0.454, 0.310, 0.178> * 0.7 * 1.4]
}

#local M_Wood2b[0] = 
color_map {
    [0.00 0.25   color rgb < 0.404, 0.210, 0.178> * 1.2 transmit 0.20
                 color rgb < 0.431, 0.225, 0.190> * 1.2 transmit 0.80]
    [0.25 0.40   color rgb < 0.431, 0.225, 0.190> * 1.2 transmit 0.80
                 color rgb < 0.447, 0.233, 0.190> * 1.2 transmit 0.20]
    [0.40 0.50   color rgb < 0.447, 0.233, 0.190> * 1.2 transmit 0.20
                 color rgb < 0.404, 0.210, 0.175> * 1.2 transmit 0.60]
    [0.50 0.70   color rgb < 0.404, 0.210, 0.175> * 1.2 transmit 0.60
                 color rgb < 0.459, 0.222, 0.202> * 1.2 transmit 0.20]
    [0.70 0.98   color rgb < 0.459, 0.222, 0.202> * 1.2 transmit 0.20
                 color rgb < 0.431, 0.225, 0.186> * 1.2 transmit 0.40]
    [0.98 1.00   color rgb < 0.431, 0.225, 0.186> * 1.2 transmit 0.40
                 color rgb < 0.404, 0.210, 0.178> * 1.2 transmit 0.10]
}
#local M_Wood2b[1] = 
color_map {
    [0.00 0.25   color rgb < 0.404, 0.210, 0.178> * 1.3 transmit 0.20
                 color rgb < 0.431, 0.225, 0.190> * 1.3 transmit 0.80]
    [0.25 0.40   color rgb < 0.431, 0.225, 0.190> * 1.3 transmit 0.80
                 color rgb < 0.447, 0.233, 0.190> * 1.3 transmit 0.20]
    [0.40 0.50   color rgb < 0.447, 0.233, 0.190> * 1.3 transmit 0.20
                 color rgb < 0.404, 0.210, 0.175> * 1.3 transmit 0.60]
    [0.50 0.70   color rgb < 0.404, 0.210, 0.175> * 1.3 transmit 0.60
                 color rgb < 0.459, 0.222, 0.202> * 1.3 transmit 0.20]
    [0.70 0.98   color rgb < 0.459, 0.222, 0.202> * 1.3 transmit 0.20
                 color rgb < 0.431, 0.225, 0.186> * 1.3 transmit 0.40]
    [0.98 1.00   color rgb < 0.431, 0.225, 0.186> * 1.3 transmit 0.40
                 color rgb < 0.404, 0.210, 0.178> * 1.3 transmit 0.10]
}
#local M_Wood2b[2] = 
color_map {
    [0.00 0.25   color rgb < 0.404, 0.210, 0.178> * 1.3 transmit 0.20
                 color rgb < 0.431, 0.225, 0.190> * 1.3 transmit 0.80]
    [0.25 0.40   color rgb < 0.431, 0.225, 0.190> * 1.3 transmit 0.80
                 color rgb < 0.447, 0.233, 0.190> * 1.3 transmit 0.20]
    [0.40 0.50   color rgb < 0.447, 0.233, 0.190> * 1.3 transmit 0.20
                 color rgb < 0.404, 0.210, 0.175> * 1.3 transmit 0.60]
    [0.50 0.70   color rgb < 0.404, 0.210, 0.175> * 1.3 transmit 0.60
                 color rgb < 0.459, 0.222, 0.202> * 1.3 transmit 0.20]
    [0.70 0.98   color rgb < 0.459, 0.222, 0.202> * 1.3 transmit 0.20
                 color rgb < 0.431, 0.225, 0.186> * 1.3 transmit 0.40]
    [0.98 1.00   color rgb < 0.431, 0.225, 0.186> * 1.3 transmit 0.40
                 color rgb < 0.404, 0.210, 0.178> * 1.3 transmit 0.10]
}

#local P_WoodGrain1a = array[3];
#local P_WoodGrain1b = array[3];
#local P_WoodGrain2a = array[3];
#local P_WoodGrain2b = array[3];

#local Count = 0;
#while (Count < 3)
    #local P_WoodGrain1a[Count] =
    pigment {
        bozo
        color_map { M_Wood1a[Count] }
        turbulence 0.04
        scale <0.05 0.05 1>
    }
    #local Count = Count + 1;
#end

#local Count = 0;
#while (Count < 3)
    #local P_WoodGrain1b[Count] =
    pigment {
        wood
        color_map { M_Wood1a[Count] }
        scale <0.20 0.20 1>
        turbulence 0.04
        rotate <-2, 2, 0>
    }
    #local Count = Count + 1;
#end

#local Count = 0;
#while (Count < 3)
    #local P_WoodGrain2a[Count] =
    pigment {
        bozo
        color_map { M_Wood2a[Count] }
        turbulence 0.04
        scale <0.05 0.05 1>
    }
    #local Count = Count + 1;
#end

#local Count = 0;
#while (Count < 3)
    #local P_WoodGrain2b[Count] =
    pigment {
        wood
        color_map { M_Wood2a[Count] }
        scale <0.20 0.20 1>
        turbulence 0.04
        rotate <-2, 2, 0>
    }
    #local Count = Count + 1;
#end

#declare WoodFinish1 = 
    finish { specular 0.03 roughness 0.03 }

#declare WoodFinish2 = 
    finish { specular 0.01 roughness 0.05 }

#declare Wood1 = array[3];
#declare Wood2 = array[3];

#local Count = 0;
#while (Count < 3)
    #declare Wood1[Count] =
    texture 
    {  
        pigment
        { 
            P_WoodGrain1a[Count]
            color_map { M_Wood1a[Count] }
        }
    } 
    texture 
    {  
        pigment
        { 
            P_WoodGrain1b[Count]
            color_map { M_Wood1b[Count] }
        }
    }
    #local Count = Count + 1;
#end

#local Count = 0;
#while (Count < 3)
    #declare Wood2[Count] =
    texture 
    {  
        pigment
        { 
            P_WoodGrain2a[Count]
            color_map { M_Wood2a[Count] }
        }
    } 
    texture 
    {  
        pigment
        { 
            P_WoodGrain2b[Count] 
            color_map { M_Wood2b[Count] }
        }
    }
    #local Count = Count + 1;
#end

#end // ! __NEW_WOOD_INC__
