// Persistence of Vision Ray Tracer Scene Description File
// File: portrait.inc
// Vers: 3.5
// Desc: Portrait in a frame
// Date: 2003/09/28
// Auth: Maurizio Tomasi

#macro CreatePainting (FrameHFFileName, FrameColor, FrameDiffuse, 
    RotateFrame, PaintingFileName, PaintingDiffuse,
    AspectRatio, PaintingScale)
    
    union
    {
        height_field
        {
            png FrameHFFileName
            smooth
            water_level 0.05
            
            rotate -90*x
            translate <-0.5, -0.5, 0>
            scale <1, 1, 0.03>
            
            texture
            {
                pigment { color rgb FrameColor }
                normal { granite 0.2 scale 0.2 }
                finish { diffuse FrameDiffuse specular 0.3 roughness 0.02 metallic }
            }
            
            #if (RotateFrame)
                rotate 90*z
            #end
        }
        
        box
        {
            <-0.5, -0.5, 0.01>, <0.5, 0.5, 0.0>
            
            texture
            {
                pigment
                {
                    image_map
                    {
                        jpeg PaintingFileName
                        interpolate 2
                        once
                    }
                }
                
                finish
                {
                    crand 0.1
                    diffuse PaintingDiffuse
                }
                
                translate <-0.5, -0.5, 0>
            }
            
            
            scale PaintingScale
        }
        
        scale <1, AspectRatio, 1>
    }
    
#end

#local FrameColor = <0.70, 0.63, 0.42>;

#declare Painting01 =
object
{
    CreatePainting ("frame01.png", FrameColor, 0.35, false, 
        "boldini01.jpg", 0.35, 583/800, 0.7)
}

#declare Painting02 =
object
{
    CreatePainting ("frame01.png", FrameColor, 0.35, true, 
        "boldini02.jpg", 0.35, 1020/841, 0.7)
}

#declare Portrait =
object
{
    CreatePainting ("frame02.png", FrameColor * 0.95, 0.25, false, 
        "portrait.jpg", 0.35, 452/342, 0.7)
}

