// Persistence of Vision Ray Tracer Scene Description File
// File: spiral.inc
// Vers: 3.5
// Desc: A spiral-like motive
// Date: 2003/10/01
// Auth: Maurizio Tomasi

#macro Spiral (Psi, Gamma, Radius, Steps)

    sphere_sweep
    {
        #local TwoTimesPi = 2 * pi;
        #local Increment = 2 * pi / Steps;
        
        b_spline
        Steps + 3,

        #local A = -Increment;
        #while (A <= TwoTimesPi + Increment)
            <(Psi * sin (A) + A / TwoTimesPi), (1 - cos (A)) / 2, Gamma * sin (A)>, Radius
            
            #local A = A + 2 * pi / Steps;
        #end
        
        tolerance 1.0e-2
        
        bounded_by { box { <0, 0, -Gamma>, <1, 1, Gamma> } }
    }

#end
