// Persistence of Vision Ray Tracer Scene Description File
// File: writing-desk.pov
// Vers: 3.5
// Desc: A writing desk in the Second Empire style (2nd half of the XIX century)
// Date: 2003/09/20
// Auth: Maurizio Tomasi
    
#version 3.5;

#include "colors.inc"
#include "woods.inc"
#include "shapes.inc"
#include "shapes2.inc"
#include "rand.inc"

#include "desk-leg.inc"


#local Wood =
texture
{
    T_Wood2
    
    finish
    {
        specular 0.7
        roughness 0.03
    }
    normal
    {
        bozo 1.5
        scale 0.4
    }
}
texture
{
    // This gives a colder tint to T_Wood2
    pigment { color rgbt <0.5, 0.5, 1.0, 0.91> }
}


#local InlayWood =
texture
{
    T_Wood1
    
    finish
    {
        specular 0.7
        roughness 0.03
    }
    normal
    {
        bozo 0.3
        scale 0.5
    }
    
    scale 0.1
}




// Fully contained by box { <-1, -0.5, 0>, <1, 0.5, -1> }
#local Drawer = // Without the handle
difference
{
    object
    {
        Round_Box_Union (<-1, -0.5, 0>, <1, 0.5, -1>, 0.05)
    }
    
    box
    {
        <-0.9, -0.4, -0.1>, <0.9, 1, -0.9>
    }
}

#local DrawerHandle =
union
{
    cylinder
    {
        <0, 0, 0>, <0, 0, 0.05>, 0.01
    }
    
    height_field
    {
        png "desk-handle.png"
        water_level 0.01
        smooth
        
        translate <-0.5, 0, -0.5>
        scale <1, 0.03, 1> * 0.30
        rotate 90*x
        translate 0.05*z
    }
}

#local DrawerHandleTexture =
texture
{
    pigment { color rgb <0.8, 0.8, 0.4> }
    finish { specular 0.6 roughness 0.01 metallic }
}                


#local DeskSeed = seed (16721);


////////////////////////////////////////////////////////////////////////////
// Shell and writing plane

#local ShellHalf =
union
{
    box { <-6, 0.35, -3>, <-5.63, 4, 0.97> }

    difference
    {    
        prism
        {
            quadratic_spline
            0, 0.37, 5,
            
            <4.0, -0.98>, <3.63, 0.9>, <0.37, 3.0>, <0.37, 0.9>, <3.63, 0.9>
            
        }
        
        // Cut the bottom half
        box
        {
            <-1, -1, -4>, <0.35, 1, 4>
        }
        
        translate -0.37*y
        rotate 90*z
        translate -6*x
    }
}


#local Shell =
union
{
    box
    {
        <-6, 0, -3>, <6, 0.35, 3>
        
    }
    
    box
    {
        <-6, 0.35, -2.7>, <6, 4, -3>
    }
    
    box
    {
        <-6, 3.63, 0.97>, <6, 4.0, -3>
    }
    
    object { ShellHalf }
    object { ShellHalf scale <-1, 1, 1> }

    texture 
    { 
        Wood 
        rotate <RRand (-3, 3, DeskSeed), RRand (87, 93, DeskSeed), 0> 
        translate VRand (DeskSeed)
        scale 1.5 
    }
}


#local WritingPlane =
union
{
    object
    {
        Round_Box_Union (<-5.63, 0.35, 5.0>, <5.63, 0.70, -1.0>, 0.05)
        
        texture 
        { 
            Wood
            rotate <RRand (-3, 3, DeskSeed), 0, RRand (87, 93, DeskSeed)> 
            translate VRand (DeskSeed)
            scale 1.3 
        }
    }
    
    object
    {
        Round_Box_Union (<-5.10, 0.50, 4.5>, <5.10, 0.80, -0.5>, 0.08)
        texture
        {
            pigment { color rgb <0.20, 0.25, 0.15> }
            finish
            {
                crand 0.15
                
                specular 0.8
                roughness 0.1
            }
        }
    }
}


#local SmallDrawerCase =
union
{
    difference
    {
        object
        {
            Round_Box_Union (<-5.63, 3.64, 1.0>, <5.63, 2.45, -2.7>, 0.05)
        }
        
        union
        {
            #local Count = -1;
            #while (Count <= 1)
                object 
                { 
                    box { <-1, -0.5, 0.5>, <1, 0.5, -1> }
                    scale <1.5, 0.65, 1>
                    translate <3.7 * Count, 3.05, 1.0>
                }
                #declare Count = Count + 1;
            #end
        }

        texture 
        { 
            Wood 
            rotate <RRand (-3, 3, DeskSeed), RRand (87, 93, DeskSeed), 0> 
            translate VRand (DeskSeed)
            scale 1.5 
        }
    }

    #local Count = -1;
    #while (Count <= 1)
        union
        { 
            object
            {
                Drawer
                scale <1.5, 0.65, 1>

                texture
                {
                    material_map
                    {
                        png "drawer-motive.png"
                        once
                    
                        texture 
                        {
                            Wood 
                            rotate <RRand (87, 93, DeskSeed), 
                                RRand (-5, 5, DeskSeed), 
                                RRand (-5, 5, DeskSeed)> 
                            translate VRand (DeskSeed)
                            scale 0.3
                        }

                        texture 
                        {
                            InlayWood
                            
                            rotate <RRand (87, 93, DeskSeed), RRand (-3, 3, DeskSeed), 0> 
                            translate VRand (DeskSeed)
                        }
                    }
                    
                    translate <-0.5, -0.5, 0>
                    scale <6.5, 1.2, 1>*0.42
                }
                
            }
            
            object
            {
                DrawerHandle
                texture { DrawerHandleTexture }
            }
            
            translate <3.7 * Count, 3.05, 1.0 + RRand (0.05, 0.40, DeskSeed)>
        }
        #declare Count = Count + 1;
    #end
}


////////////////////////////////////////////////////////////////////////////
// Top drawer

#local TopDrawerCase =
union
{
    difference
    {
        object
        {
            Round_Box_Union (<-6, 4.0, 1.0>, <5.9, 6.0, -3.0>, 0.15)
        }
        
        union
        {
            #local Count = -1;
            #while (Count <= 1)
                object 
                { 
                    box { <-1, -0.5, 0.5>, <1, 0.5, -1> }
                    scale <1.5, 1.1, 1>
                    translate <4 * Count, 5.0, 1.0>
                }
                #declare Count = Count + 1;
            #end
        }

        texture 
        { 
            Wood 
            rotate <RRand (-3, 3, DeskSeed), RRand (87, 93, DeskSeed), 0> 
            translate VRand (DeskSeed)
            scale 1.5 
        }
    }

    #local Count = -1;
    #while (Count <= 1)
        union
        { 
            object
            {
                Drawer
                scale <1.5, 1.1, 1>

                texture
                {
                    material_map
                    {
                        png "drawer-motive.png"
                        once
                    
                        texture 
                        {
                            Wood 
                            rotate <RRand (87, 93, DeskSeed), 
                                RRand (-5, 5, DeskSeed), 
                                RRand (-5, 5, DeskSeed)> 
                            translate VRand (DeskSeed)
                            scale 0.3
                        }

                        texture 
                        {
                            InlayWood
                            
                            rotate <RRand (87, 93, DeskSeed), RRand (-3, 3, DeskSeed), 0> 
                            translate VRand (DeskSeed)
                        }
                    }
                    
                    translate <-0.5, -0.5, 0>
                    scale <6.0, 1.6, 1>*0.45
                }
            }
            
            object
            {
                DrawerHandle
                texture { DrawerHandleTexture }
            }
            
            translate <4 * Count, 5.0, 1.0 + RRand (0.05, 0.40, DeskSeed)>
        }
        #declare Count = Count + 1;
    #end
}


////////////////////////////////////////////////////////////////////////////
// Base

#local HalfBottomStep =
union
{
    // Side panel
    polygon
    {
        5,
        <6, 0, 3>, <6, 0, -3>,
        <6.18, -0.2, -3.12>, <6.18, -0.2, 3.12>, <6, 0, 3>
    }
    
    // Front panel
    polygon
    {
        5,
        <6, 0, -3>, <0, 0, -3>,
        <0, -0.2, -3.12>, <6.18, -0.2, -3.12>, <6, 0, -3>
    }
    
    // Rear panel
    polygon
    {
        5,
        <6, 0, 3>, <0, 0, 3>,
        <0, -0.2, 3.12>, <6.18, -0.2, 3.12>, <6, 0, 3>
    }
    
    // Bottom panel
    polygon
    {
        5,
        <6.18, -0.2, 3.12>, <6.18, -0.2, -3.12>,
        <0, -0.2, -3.12>, <0, -0.2, 3.12>, <6.18, -0.2, 3.12>
    }
}


#local HalfBottomDrawer =
difference
{
    box
    {
        <6.18, -0.2, 3.12>, <2.86, -1.5, -3.12>
    }
    
    box
    {
        <6.00, -0.4, 3.5>, <3.00, -1.3, -2.9>
    }
}

#local BottomDrawer =
union
{
    // The two drawers
    
    union
    {
        object { HalfBottomDrawer }
        object { HalfBottomDrawer scale <-1, 1, 1> }

        texture 
        { 
            Wood 
            rotate <RRand (-3, 3, DeskSeed), RRand (87, 93, DeskSeed), 0> 
            translate VRand (DeskSeed)
        }
    }
    
    union
    {
        #local Count = -1;
        #while (Count <= 1)
            union
            {
                object
                {
                    Drawer
                    scale <1.5, 0.9, 1>

                    texture
                    {
                        material_map
                        {
                            png "drawer-motive.png"
                            once
                        
                            texture 
                            {
                                Wood 
                                rotate <RRand (87, 93, DeskSeed), 
                                    RRand (-5, 5, DeskSeed), 
                                    RRand (-5, 5, DeskSeed)> 
                                translate VRand (DeskSeed)
                                scale 0.3
                            }
    
                            texture 
                            {
                                InlayWood
                                
                                rotate <RRand (87, 93, DeskSeed), RRand (-3, 3, DeskSeed), 0> 
                                translate VRand (DeskSeed)
                            }
                        }
                        
                        translate <-0.5, -0.5, 0>
                        scale <6.0, 1.35, 1>*0.45
                    }
                }

                object
                {
                    DrawerHandle
                    texture { DrawerHandleTexture }
                }
                
                translate <Count * 4.5, -0.85, 3.12 + RRand (0.05, 0.40, DeskSeed)>
            }
            #declare Count = Count + 2;
        #end
    }
    

    
    // A nice step which joins the base with the shell
    union
    {
        object { HalfBottomStep }
        object { HalfBottomStep scale <-1, 1, 1> }
        
        texture 
        { 
            Wood 
            rotate <RRand (-3, 3, DeskSeed), 0, 0> 
            translate VRand (DeskSeed)
            scale 1.2
        }
    }
}


////////////////////////////////////////////////////////////////////////////
// Complete object

#declare WritingDesk = 
union
{ 
    object { Shell }
    
    object { BottomDrawer }
    
    object { WritingPlane }
    
    object { SmallDrawerCase }

    object { TopDrawerCase }
    
    #local LegXCoord = array[4];
    #local LegZCoord = array[4];
    
    #local LegXCoord[0] =  5.4; #local LegXCoord[1] =  5.4;
    #local LegXCoord[2] = -5.4; #local LegXCoord[3] = -5.4;
    
    #local LegZCoord[0] = -2.5; #local LegZCoord[1] =  2.0;
    #local LegZCoord[2] = -2.5; #local LegZCoord[3] =  2.0;
    
    #local Count = 0;
    #while (Count < 4)
        object 
        { 
            DeskLeg 
            scale 4.5 
            translate <LegXCoord [Count], -1.5 - 4.5, LegZCoord [Count]> 
            
            texture 
            { 
                Wood 
                rotate <RRand (-3, 3, DeskSeed), 0, 0> 
                translate VRand (DeskSeed)
            }
        }
        
        #declare Count = Count + 1;
    #end
    
    translate 6*y
}
