#include "colors.inc"
#include "woods.inc"
#include "table.inc"
#include "lampe.inc"
#include "BMW M5_pov.inc"
#include "M_TREE4_pov.inc"
    
#declare White2 = rgb 1;    
#declare Yellow2  = rgb <1,1,0>;

global_settings {
/*    radiosity {
      pretrace_start 0.08           // start pretrace at this size
      pretrace_end   0.04           // end pretrace at this size
      count 35                      // higher -> higher quality (1..1600) [35]
      nearest_count 5               // higher -> higher quality (1..10) [5]
      error_bound 1.8               // higher -> smoother, less accurate [1.8]
      recursion_limit 3             // how much interreflections are calculated (1..5+) [3]
      low_error_factor .5           // reduce error_bound during last pretrace step
      gray_threshold 0.0            // increase for weakening colors (0..1) [0]
      minimum_reuse 0.015           // reuse of old radiosity samples [0.015]
      brightness 1                  // brightness of radiosity effects (0..1) [1]

      adc_bailout 0.01/2
      //normal on                   // take surface normals into account [off]
      //media on                    // take media into account [off]
      //save_file "file_name"       // save radiosity data
      //load_file "file_name"       // load saved radiosity data
      //always_sample off           // turn sampling in final trace off [on]
      //max_sample 1.0              // maximum brightness of samples
    }*/
   ambient_light 0.3 
}

#default {finish {ambient 0.1}}
    

#declare TextureDollar = texture {pigment {uv_mapping image_map {jpeg "dollar.jpg" map_type 0} scale 0.01 scale y*4} finish {diffuse 0.5}}


camera { // rendu final
	perspective 
	location <-2, 2, -8>
	right x*image_width/image_height
	up y
	look_at <1, 2.0, 0.0>
}
/*camera { // rendu final 2
	perspective 
	location <-0.5, 2, -7>
	right x*image_width/image_height
	up y
	look_at <2.7, 2.0, 0.0>
} */
/*camera {  // prs lampe
	perspective 
	location <7, 2, 0>
	right x*image_width/image_height
	up y
	look_at <8.5, 1.26, 1>
} */

#declare Lune =
	light_group {
		sphere {0, 2 texture {pigment {color White2} finish {ambient 0 diffuse 0.8 brilliance 0.7}}}
		light_source {<30, 5, 15> color White2}
		global_lights off
	}

//object {Lune translate <-0.5, 1, 4>*10 no_shadow}
object {Lune  translate <-0.4, 1, 4>*10 scale 1000 no_shadow}



difference { // facade
	box {0 <20, 3.5, 0.02>}
	box {0 <7, 3, 0.5> translate <1, -0.01, -0.25>}
	texture {TextureDollar}
}


box {0 <0.02, 3.5, 5> translate 9*x texture {TextureDollar}} //mur interieur
#declare Porte = box {0 <0.03, 2.7, 1.2> rotate y*-70 translate <9, 0, 2>} // porte

object {Porte texture {pigment {image_map {jpeg "dollar.jpg" map_type 0} scale 1} finish {diffuse 0.5}} }

box {0 <0.02, 3.5, 5> texture {TextureDollar} }// pignon

difference { // toit
	box {<0, -0.5, -0.5> <20, 0.5, 0.5> rotate x*45 scale <0.99, 1.3, 3.5355339> translate <0.01, 3.5, 2.5>}
	box {<0, 0, 0> <20, 3.5, 5>}
	texture {TextureDollar}
}

light_group { 
       light_source {<-20, 75, 100> color White2*0} //lumire de la Lune :)
       difference { // mur du fond
	box {0 <20, 3.5, 0.02> translate z*5}
	box {0 <1, 1, 0.5> translate <4, 1.5, 5-0.01>} // fentre
	texture {TextureDollar}
        }
        box {0 <20, 0.02, 5> texture {TextureDollar}} // sol
        global_lights on
}

light_source {<-20, 75, 100> color White2*2} //lumire de la Lune :)  pour le reste de la scne


object {
      BMW_M5
scale 0.04 rotate x*-90 rotate y*130 translate <-2, 0.9, -1.3>

}


//sol
plane {
  y, 
  0
  texture {pigment {rgb <25, 12, 5>/100}
  normal {
    bumps 1         // any pattern optionally followed by an intensity value [0.5]
    bump_size 5.0   // optional
  }
 finish {ambient 0.1 diffuse 0.6}}
  
}
    

 
 
light_group {     
        light_source {<6, 1, 1> color Yellow*1}
        //la table         
        object {Table scale 0.7 translate <3, 1.27*0.7, 2>}
        global_lights on
}
       

//la lampe
object {Lampe rotate y*30 scale 1 translate <8.5, 0.5*1.26, 1>}                                              


object {M_TREE4 scale 0.1 rotate x*-90 translate <-3, 0, 10>}
object {M_TREE4 scale 0.2 rotate x*-90 translate <-1, 0, 15>}
object {M_TREE4 scale 0.15 rotate x*-90 translate <2, 0, 20>}

sky_sphere {pigment {image_map {jpeg "stars.jpg" map_type 0} scale 0.5}}                  

fog {
  fog_type   2
  distance   70
  color      rgb 0.5 // gray
  fog_offset 0
  fog_alt    5
  turbulence 1
}
