//  Persistence of Vision Raytracer V3.1
//  World definition file.
//
//  Contains 4 lights, 12 materials and 190 primitives.
//
//  This file was generated for POV-Ray V3.1 by
//  Moray V3.3a For Windows Copyright (c) 1993-2001 Lutz + Kretzschmar
//

//  Date : 10/30/2003    (30.10.2003)
//

/*
  The text between these two comments is in MorayPOV.INC and is
  automatically included in all POV files that Moray exports.
*/

default {
  texture {
    pigment { rgb <1,0,0> }
  }
}

/* // Scene Comment

This scene was created with Moray For Windows.

*/ // End Scene Comment

global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.9
  hf_gray_16 off
  irid_wavelength <0.247059,0.176471,0.137255>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
}

background { color <0.000,0.000,0.000> }

camera {  //  Camera Camera
  location  <    -11.080,      -5.245,       2.668>
  sky       <    0.00000,     0.00000,     1.00000> // Use right handed-system 
  up        <        0.0,         0.0,         1.0> // Where Z is up
  right     <    2.12433,         0.0,         0.0> // Right Vector is adjusted to compensate for spherical (Moray) vs. planar (POV-Ray) aspect ratio
  angle         54.40000    // Vertical      27.200
  look_at   <     -3.720,       0.310,       1.940>
}

//
// *******  L I G H T S *******
//

#declare LampLight01 = light_source {
  <0.0, 0.0, 0.0>
  color rgb <1.000, 0.500, 0.000>*0.6000
  fade_distance  2.0
  fade_power 3.0
}

#declare LampLight02 = light_source {
  <0.0, 0.0, 0.0>
  color rgb <1.000, 0.500, 0.000>*0.6000
  fade_distance  2.0
  fade_power 3.0
}

#declare LampLight03 = light_source {
  <0.0, 0.0, 0.0>
  color rgb <1.000, 0.500, 0.000>*0.6000
  fade_distance  2.0
  fade_power 3.0
}

#declare Reaction = light_source {
  <0.0, 0.0, 0.0>
  color rgb <0.829, 0.114, 0.000>*2.0000
  fade_distance  10.0
  fade_power 3.0
  media_interaction off
  translate  <-0.015152, 0.0, 4.454545>
}

light_source {   // Moon
  <0.0, 0.0, 0.0>
  color rgb <1.000, 0.900, 0.800>
  media_interaction off
  translate  <290.0, 290.0, 500.0>
}


//
// ********  MATERIALS  *******
//

#include "nucleardecay.inc"


//
// ********  REFERENCED OBJECTS  *******
//

#declare Support01 = object {
  box { // Support01
    <-1, -1, -1>, <1, 1, 1>
    material {
      Wood
    }
    scale <3.05, 0.02, 0.02>
    translate  <-1.6, -1.08, 0.0>
  }
}


#declare SubRimCut1 = object {
  box { // SubRimCut1
    <-1, -1, -1>, <1, 1, 1>
    scale <0.14, 0.59, 0.28>
    translate  -4.7*x
  }
}
#declare Tube01 = difference {
  cylinder { // TubeBody01
    <0,0,1>, <0,0,0>, 1 
    scale <0.15, 0.15, 1.0>
    translate  5.0*z
  }
  cylinder { // TubeCut01
    <0,0,1>, <0,0,0>, 1 
    scale <0.12, 0.12, 1.1>
    translate  4.95*z
  }
  scale <0.79, 0.79, 0.52>
  translate  <-6.73, -0.158, -1.61>
}
#declare TubesLeft = union {
  object { Tube01 }
  object { // Tube02 -> Tube01
    Tube01
    rotate 0.0*z
    translate  <0.46, 0.0, 0.0>
  }
  object { // Tube03 -> Tube01
    Tube01
    rotate 0.0*z
    translate  <0.92, 0.0, 0.0>
  }
  object { // Tube04 -> Tube01
    Tube01
    rotate 0.0*z
    translate  <1.38, 0.0, 0.0>
  }
  material {
    Copper
  }
  translate  -0.0*x
}




//
// ********  OBJECTS  *******
//

cylinder { // Clouds
  <0,0,1>, <0,0,0>, 1 
  material {
    Fog
  }
  hollow
  scale <80.0, 400.0, 1800.0>
  rotate <-45.0, -90.0, 0.0>
  translate  <1115.5, -158.44, 0.0>
}


#declare Poles = union {
  cylinder { // Pole01
    <0,0,1>, <0,0,0>, 1 
    material {
      Wood
      translate <0.000000, -0.140000, -1.260000>
    }
    scale <0.05, 0.05, 2.6>
    rotate -2.6*y
    translate  <-4.56, -1.0, -1.4>
  }
  cylinder { // Pole02
    <0,0,1>, <0,0,0>, 1 
    material {
      Wood
      translate <0.000000, 0.000000, 0.720000>
    }
    scale <0.05, 0.05, 2.6>
    rotate -0.5*y
    translate  <-3.4, -1.0, -1.31>
  }
  cylinder { // Pole03
    <0,0,1>, <0,0,0>, 1 
    material {
      Wood
      translate <0.000000, 0.000000, -1.840000>
    }
    scale <0.05, 0.05, 2.6>
    rotate -1.3*y
    translate  <-2.2, -1.0, -1.19>
  }
  cylinder { // Pole04
    <0,0,1>, <0,0,0>, 1 
    material {
      Wood
      translate <0.000000, 0.000000, 0.500000>
    }
    scale <0.05, 0.05, 2.6>
    rotate -1.4*y
    translate  <-1.0, -1.0, -1.22>
  }
  cylinder { // Pole05
    <0,0,1>, <0,0,0>, 1 
    material {
      Wood
      translate <0.000000, 0.000000, -0.780000>
    }
    scale <0.05, 0.05, 2.6>
    rotate -0.6*y
    translate  <0.2, -1.0, -1.28>
  }
  cylinder { // Pole06
    <0,0,1>, <0,0,0>, 1 
    material {
      Wood
      translate <0.000000, 0.000000, 0.530000>
    }
    scale <0.05, 0.05, 2.6>
    rotate -1.0*y
    translate  <1.4, -1.0, -1.28>
  }
  cylinder { // Pole07
    <0,0,1>, <0,0,0>, 1 
    material {
      Wood
      translate <0.000000, 0.000000, 1.050000>
    }
    scale <0.05, 0.05, 2.6>
    rotate 0.8*y
    translate  <-4.6, -1.6, -1.19>
  }
  cylinder { // Pole08
    <0,0,1>, <0,0,0>, 1 
    material {
      Wood
      translate <0.000000, 0.000000, 0.470000>
    }
    scale <0.05, 0.05, 2.6>
    rotate 0.6*y
    translate  <-3.4, -1.6, -1.28>
  }
  cylinder { // Pole09
    <0,0,1>, <0,0,0>, 1 
    material {
      Wood
      translate <0.000000, 0.000000, 0.500000>
    }
    scale <0.05, 0.05, 2.6>
    rotate <0.9, 0.0, -0.0>
    translate  <-2.2, -1.6, -1.22>
  }
  cylinder { // Pole10
    <0,0,1>, <0,0,0>, 1 
    material {
      Wood
      translate <0.000000, 0.000000, -0.310000>
    }
    scale <0.05, 0.05, 2.6>
    rotate 0.6*y
    translate  <-1.0, -1.6, -1.16>
  }
  cylinder { // Pole11
    <0,0,1>, <0,0,0>, 1 
    material {
      Wood
      translate <0.000000, 0.000000, 0.280000>
    }
    scale <0.05, 0.05, 2.6>
    rotate -1.3*y
    translate  <0.2, -1.6, -1.28>
  }
  cylinder { // Pole12
    <0,0,1>, <0,0,0>, 1 
    material {
      Wood
      translate <0.000000, 0.000000, 0.220000>
    }
    scale <0.05, 0.05, 2.6>
    rotate <-0.0, -0.8, 0.0>
    translate  <1.4, -1.6, -1.22>
  }
  cylinder { // Pole13
    <0,0,1>, <0,0,0>, 1 
    material {
      Wood
      translate <0.000000, 0.000000, 1.010000>
    }
    scale <0.05, 0.05, 2.6>
    rotate 1.7*x
    translate  <-1.9, -2.0, -1.19>
  }
  cylinder { // Pole14
    <0,0,1>, <0,0,0>, 1 
    material {
      Wood
      translate <0.000000, 0.000000, 0.830000>
    }
    scale <0.05, 0.05, 2.6>
    rotate <0.8, 0.0, -0.0>
    translate  <-1.3, -2.0, -1.34>
  }
  cylinder { // Pole15
    <0,0,1>, <0,0,0>, 1 
    material {
      Wood
      translate <0.000000, 0.000000, -0.620000>
    }
    scale <0.05, 0.05, 2.6>
    rotate <-1.699144, -0.065429, 0.000531>
    translate  <-1.9, -3.2, -1.22>
  }
  cylinder { // Pole16
    <0,0,1>, <0,0,0>, 1 
    material {
      Wood
      translate <0.000000, 0.000000, 0.780000>
    }
    scale <0.05, 0.05, 2.6>
    rotate <-0.300171, 0.013087, -0.000122>
    translate  <-1.3, -3.2, -1.22>
  }
}
#declare Supports = union {
  object { Support01 }
  object { // Support02 -> Support01
    Support01
    translate  -0.44*y
  }
  object { // Support03 -> Support01
    Support01
    rotate -90.0*z
    translate  <-0.76, -5.71, 0.0>
  }
  object { // Support04 -> Support01
    Support01
    rotate -90.0*z
    translate  <-0.3, -5.71, 0.0>
  }
  translate  1.2*z
}
#declare Plates = union {
  box { // Plate04
    <-1, -1, -1>, <1, 1, 1>
    material {
      Wood
      rotate -90.0*x
      translate <0.000000, -0.980000, 0.000000>
    }
    scale <0.05, 0.24, 0.04>
    rotate 2.5*z
    translate  <-4.26, -1.3, 1.22>
  }
  box { // Plate05
    <-1, -1, -1>, <1, 1, 1>
    material {
      Wood
      rotate -90.0*x
      translate <0.000000, 1.760000, 0.000000>
    }
    scale <0.05, 0.24, 0.04>
    rotate 1.3*z
    translate  <-4.1, -1.3, 1.22>
  }
  box { // Plate06
    <-1, -1, -1>, <1, 1, 1>
    material {
      Wood
      rotate -90.0*x
      translate <0.000000, 1.080000, 0.000000>
    }
    scale <0.05, 0.24, 0.04>
    rotate -1.3*z
    translate  <-3.975, -1.3, 1.22>
  }
  box { // Plate08
    <-1, -1, -1>, <1, 1, 1>
    material {
      Wood
      rotate -90.0*x
      translate <0.000000, 2.450000, 0.000000>
    }
    scale <0.05, 0.24, 0.04>
    rotate 1.5*z
    translate  <-3.725, -1.3, 1.22>
  }
  box { // Plate09
    <-1, -1, -1>, <1, 1, 1>
    material {
      Wood
      rotate -90.0*x
      translate <0.000000, 1.430000, 0.000000>
    }
    scale <0.05, 0.24, 0.04>
    rotate 0.8*z
    translate  <-3.59, -1.3, 1.22>
  }
  box { // Plate10
    <-1, -1, -1>, <1, 1, 1>
    material {
      Wood
      rotate -90.0*x
      translate <0.000000, 0.490000, 0.000000>
    }
    scale <0.05, 0.24, 0.04>
    rotate -0.6*z
    translate  <-3.475, -1.3, 1.22>
  }
  box { // Plate11
    <-1, -1, -1>, <1, 1, 1>
    material {
      Wood
      rotate -90.0*x
      translate <0.000000, -0.880000, 0.000000>
    }
    scale <0.05, 0.24, 0.04>
    rotate 1.3*z
    translate  <-3.35, -1.3, 1.22>
  }
  box { // Plate12
    <-1, -1, -1>, <1, 1, 1>
    material {
      Wood
      rotate -90.0*x
      translate <0.000000, 2.120000, 0.000000>
    }
    scale <0.05, 0.24, 0.04>
    rotate -1.0*z
    translate  <-3.23, -1.3, 1.22>
  }
  box { // Plate13
    <-1, -1, -1>, <1, 1, 1>
    material {
      Wood
      rotate -90.0*x
      translate <0.000000, -0.620000, 0.000000>
    }
    scale <0.05, 0.24, 0.04>
    rotate 1.5*z
    translate  <-3.1, -1.3, 1.22>
  }
  box { // Plate14
    <-1, -1, -1>, <1, 1, 1>
    material {
      Wood
      rotate -90.0*x
      translate <0.000000, 0.920000, 0.000000>
    }
    scale <0.05, 0.24, 0.04>
    rotate 0.8*z
    translate  <-2.975, -1.3, 1.22>
  }
  box { // Plate15
    <-1, -1, -1>, <1, 1, 1>
    material {
      Wood
      rotate -90.0*x
      translate <0.000000, 3.570000, 0.000000>
    }
    scale <0.05, 0.24, 0.04>
    rotate 0.8*z
    translate  <-2.87, -1.3, 1.22>
  }
  box { // Plate16
    <-1, -1, -1>, <1, 1, 1>
    material {
      Wood
      rotate -90.0*x
      translate <0.000000, -0.880000, 0.000000>
    }
    scale <0.05, 0.24, 0.04>
    rotate -0.7*z
    translate  <-2.725, -1.3, 1.22>
  }
  box { // Plate17
    <-1, -1, -1>, <1, 1, 1>
    material {
      Wood
      rotate -90.0*x
      translate <0.000000, 1.600000, 0.000000>
    }
    scale <0.05, 0.24, 0.04>
    rotate 1.9*z
    translate  <-2.59, -1.3, 1.22>
  }
  box { // Plate18
    <-1, -1, -1>, <1, 1, 1>
    material {
      Wood
      rotate -90.0*x
      translate <0.000000, 3.570000, 0.000000>
    }
    scale <0.05, 0.24, 0.04>
    rotate 2.599998*z
    translate  <-2.475, -1.3, 1.22>
  }
  box { // Plate19
    <-1, -1, -1>, <1, 1, 1>
    material {
      Wood
      rotate -90.0*x
      translate <0.000000, 1.090000, 0.000000>
    }
    scale <0.05, 0.24, 0.04>
    rotate 2.7*z
    translate  <-2.34, -1.3, 1.22>
  }
  box { // Plate20
    <-1, -1, -1>, <1, 1, 1>
    material {
      Wood
      rotate -90.0*x
      translate <0.000000, 2.030000, 0.000000>
    }
    scale <0.05, 0.24, 0.04>
    rotate 0.6*z
    translate  <-2.225, -1.3, 1.22>
  }
  box { // Plate21
    <-1, -1, -1>, <1, 1, 1>
    material {
      Wood
      rotate -90.0*x
      translate <0.000000, -2.420000, 0.000000>
    }
    scale <0.05, 0.24, 0.04>
    rotate 1.1*z
    translate  <-2.11, -1.3, 1.22>
  }
  box { // Plate22
    <-1, -1, -1>, <1, 1, 1>
    material {
      Wood
      rotate -90.0*x
      translate <0.000000, -0.970000, 0.000000>
    }
    scale <0.05, 0.24, 0.04>
    rotate -0.199999*z
    translate  <-1.98, -1.3, 1.22>
  }
  box { // Plate23
    <-1, -1, -1>, <1, 1, 1>
    material {
      Wood
      rotate -90.0*x
      translate <0.000000, 0.490000, 0.000000>
    }
    scale <0.05, 0.24, 0.04>
    rotate 1.6*z
    translate  <-1.85, -1.3, 1.22>
  }
  box { // Plate24
    <-1, -1, -1>, <1, 1, 1>
    material {
      Wood
      rotate -90.0*x
      translate <0.000000, 2.800000, 0.000000>
    }
    scale <0.05, 0.24, 0.04>
    rotate 2.0*z
    translate  <-1.72, -1.3, 1.22>
  }
  box { // Plate25
    <-1, -1, -1>, <1, 1, 1>
    material {
      Wood
      rotate -90.0*x
      translate <0.000000, 1.430000, 0.000000>
    }
    scale <0.05, 0.24, 0.04>
    rotate -1.1*z
    translate  <-1.6, -1.3, 1.22>
  }
  box { // Plate26
    <-1, -1, -1>, <1, 1, 1>
    material {
      Wood
      rotate -90.0*x
      translate <0.000000, 4.000000, 0.000000>
    }
    scale <0.05, 0.24, 0.04>
    rotate <0.0, 0.0, 0.4>
    translate  <-1.475, -1.3, 1.22>
  }
  box { // Plate27
    <-1, -1, -1>, <1, 1, 1>
    material {
      Wood
      rotate -90.0*x
      translate <0.000000, -0.370000, 0.000000>
    }
    scale <0.05, 0.24, 0.04>
    translate  <-1.35, -1.3, 1.22>
  }
  box { // Plate28
    <-1, -1, -1>, <1, 1, 1>
    material {
      Wood
      rotate -90.0*x
      translate <0.000000, 1.860000, 0.000000>
    }
    scale <0.05, 0.24, 0.04>
    rotate 2.4*z
    translate  <-1.225, -1.3, 1.22>
  }
  box { // Plate29
    <-1, -1, -1>, <1, 1, 1>
    material {
      Wood
      rotate -90.0*x
      translate <0.000000, 3.830000, 0.000000>
    }
    scale <0.05, 0.24, 0.04>
    rotate <0.0, 0.0, 2.2>
    translate  <-1.09, -1.3, 1.22>
  }
  box { // Plate30
    <-1, -1, -1>, <1, 1, 1>
    material {
      Wood
      rotate -90.0*x
      translate <0.000000, 2.630000, 0.000000>
    }
    scale <0.05, 0.24, 0.04>
    rotate <0.0, -0.0, 3.3>
    translate  <-0.975, -1.3, 1.22>
  }
  box { // Plate32
    <-1, -1, -1>, <1, 1, 1>
    material {
      Wood
      rotate -90.0*x
      translate <0.000000, 1.600000, 0.000000>
    }
    scale <0.05, 0.24, 0.04>
    rotate <-0.0, -0.0, -2.9>
    translate  <-0.75, -1.3, 1.22>
  }
  box { // Plate33
    <-1, -1, -1>, <1, 1, 1>
    material {
      Wood
      rotate -90.0*x
      translate <0.000000, -1.480000, 0.000000>
    }
    scale <0.05, 0.24, 0.04>
    rotate 1.8*z
    translate  <-0.61, -1.3, 1.22>
  }
  box { // Plate34
    <-1, -1, -1>, <1, 1, 1>
    material {
      Wood
      rotate -90.0*x
      translate <0.000000, -2.680000, 0.000000>
    }
    scale <0.05, 0.24, 0.04>
    rotate <-0.0, -0.0, -0.7>
    translate  <-0.475, -1.3, 1.22>
  }
  box { // Plate35
    <-1, -1, -1>, <1, 1, 1>
    material {
      Wood
      rotate -90.0*x
      translate <0.000000, 2.030000, 0.000000>
    }
    scale <0.05, 0.24, 0.04>
    rotate 1.6*z
    translate  <-0.35, -1.3, 1.22>
  }
  box { // Plate36
    <-1, -1, -1>, <1, 1, 1>
    material {
      Wood
      rotate -90.0*x
      translate <0.000000, 3.060000, 0.000000>
    }
    scale <0.05, 0.24, 0.04>
    rotate <-0.0, 0.0, 2.1>
    translate  <-0.24, -1.3, 1.22>
  }
  box { // Plate37
    <-1, -1, -1>, <1, 1, 1>
    material {
      Wood
      rotate -90.0*x
      translate <0.000000, 1.350000, 0.000000>
    }
    scale <0.05, 0.24, 0.04>
    rotate <0.0, 0.0, 1.9>
    translate  <-0.1, -1.3, 1.22>
  }
  box { // Plate38
    <-1, -1, -1>, <1, 1, 1>
    material {
      Wood
      rotate -90.0*x
      translate <0.000000, -0.370000, 0.000000>
    }
    scale <0.05, 0.24, 0.04>
    rotate <0.0, 0.0, -2.0>
    translate  <0.03, -1.3, 1.22>
  }
  box { // Plate39
    <-1, -1, -1>, <1, 1, 1>
    material {
      Wood
      rotate -90.0*x
      translate <0.000000, 2.890000, 0.000000>
    }
    scale <0.05, 0.24, 0.04>
    rotate 1.8*z
    translate  <0.15, -1.3, 1.22>
  }
  box { // Plate40
    <-1, -1, -1>, <1, 1, 1>
    material {
      Wood
      rotate -90.0*x
      translate <0.000000, 1.520000, 0.000000>
    }
    scale <0.05, 0.24, 0.04>
    rotate <-0.0, 0.0, 0.8>
    translate  <0.29, -1.3, 1.22>
  }
  box { // Plate41
    <-1, -1, -1>, <1, 1, 1>
    material {
      Wood
      rotate -90.0*x
      translate <0.000000, -0.970000, 0.000000>
    }
    scale <0.05, 0.24, 0.04>
    translate  <0.4, -1.3, 1.22>
  }
  box { // Plate43
    <-1, -1, -1>, <1, 1, 1>
    material {
      Wood
      rotate -90.0*x
      translate <0.000000, 2.290000, 0.000000>
    }
    scale <0.05, 0.24, 0.04>
    rotate <0.0, -0.0, -1.6>
    translate  <0.63, -1.3, 1.22>
  }
  box { // Plate44
    <-1, -1, -1>, <1, 1, 1>
    material {
      Wood
      rotate -90.0*x
      translate <0.000000, -0.450000, 0.000000>
    }
    scale <0.05, 0.24, 0.04>
    rotate <0.0, 0.0, 0.9>
    translate  <0.775, -1.3, 1.22>
  }
  box { // Plate45
    <-1, -1, -1>, <1, 1, 1>
    material {
      Wood
      rotate -90.0*x
      translate <0.000000, -1.140000, 0.000000>
    }
    scale <0.05, 0.24, 0.04>
    rotate 1.4*z
    translate  <0.89, -1.3, 1.22>
  }
  box { // Plate47
    <-1, -1, -1>, <1, 1, 1>
    material {
      Wood
      rotate -90.0*x
      translate <0.000000, 0.490000, 0.000000>
    }
    scale <0.05, 0.24, 0.04>
    rotate <-0.0, 0.0, 0.8>
    translate  <1.15, -1.3, 1.22>
  }
  box { // Plate48
    <-1, -1, -1>, <1, 1, 1>
    material {
      Wood
      rotate -90.0*x
      translate <0.000000, 2.290000, 0.000000>
    }
    scale <0.05, 0.24, 0.04>
    rotate <0.0, -0.0, -0.7>
    translate  <1.275, -1.3, 1.22>
  }
  box { // Plate49
    <-1, -1, -1>, <1, 1, 1>
    material {
      Wood
      rotate -90.0*x
      translate <0.000000, -0.620000, 0.000000>
    }
    scale <0.05, 0.24, 0.04>
    rotate -2.9*z
    translate  <1.39, -1.3, 1.22>
  }
  box { // Plate50
    <-1, -1, -1>, <1, 1, 1>
    material {
      Wood
      rotate -90.0*x
      translate <0.000000, 0.890000, 0.000000>
    }
    scale <0.05, 0.24, 0.04>
    rotate -88.800003*z
    translate  <-1.61, -1.6, 1.22>
  }
  box { // Plate51
    <-1, -1, -1>, <1, 1, 1>
    material {
      Wood
      rotate -90.0*x
      translate <0.000000, -1.180000, 0.000000>
    }
    scale <0.05, 0.24, 0.04>
    rotate -91.599998*z
    translate  <-1.61, -1.735, 1.22>
  }
  box { // Plate53
    <-1, -1, -1>, <1, 1, 1>
    material {
      Wood
      rotate -90.0*x
      translate <0.000000, 0.540000, 0.000000>
    }
    scale <0.05, 0.24, 0.04>
    rotate -91.599998*z
    translate  <-1.61, -1.97, 1.22>
  }
  box { // Plate54
    <-1, -1, -1>, <1, 1, 1>
    material {
      Wood
      rotate -90.0*x
      translate <0.000000, -3.160000, 0.000000>
    }
    scale <0.05, 0.24, 0.04>
    rotate -92.399994*z
    translate  <-1.61, -2.11, 1.22>
  }
  box { // Plate55
    <-1, -1, -1>, <1, 1, 1>
    material {
      Wood
      rotate -90.0*x
      translate <0.000000, 0.990000, 0.000000>
    }
    scale <0.05, 0.24, 0.04>
    rotate -91.699997*z
    translate  <-1.61, -2.22, 1.22>
  }
  box { // Plate56
    <-1, -1, -1>, <1, 1, 1>
    material {
      Wood
      rotate -90.0*x
      translate <0.000000, 1.920000, 0.000000>
    }
    scale <0.05, 0.24, 0.04>
    rotate -91.599998*z
    translate  <-1.61, -2.35, 1.22>
  }
  box { // Plate57
    <-1, -1, -1>, <1, 1, 1>
    material {
      Wood
      rotate -90.0*x
      translate <0.000000, -2.220000, 0.000000>
    }
    scale <0.05, 0.24, 0.04>
    rotate -91.199997*z
    translate  <-1.61, -2.485, 1.22>
  }
  box { // Plate58
    <-1, -1, -1>, <1, 1, 1>
    material {
      Wood
      rotate -90.0*x
      translate <0.000000, -0.740000, 0.000000>
    }
    scale <0.05, 0.24, 0.04>
    rotate -92.600006*z
    translate  <-1.61, -2.62, 1.22>
  }
  box { // Plate59
    <-1, -1, -1>, <1, 1, 1>
    material {
      Wood
      rotate -90.0*x
      translate <0.000000, -1.730000, 0.000000>
    }
    scale <0.05, 0.24, 0.04>
    rotate -88.199997*z
    translate  <-1.61, -2.76, 1.22>
  }
  box { // Plate61
    <-1, -1, -1>, <1, 1, 1>
    material {
      Wood
      rotate -90.0*x
      translate <0.000000, 2.170000, 0.000000>
    }
    scale <0.05, 0.24, 0.04>
    rotate -90.300003*z
    translate  <-1.61, -2.985, 1.22>
  }
  box { // Plate62
    <-1, -1, -1>, <1, 1, 1>
    material {
      Wood
      rotate -90.0*x
      translate <0.000000, -0.540000, 0.000000>
    }
    scale <0.05, 0.24, 0.04>
    rotate -90.800003*z
    translate  <-1.61, -3.1, 1.22>
  }
  box { // Plate63
    <-1, -1, -1>, <1, 1, 1>
    material {
      Wood
      rotate -90.0*x
      translate <0.000000, 0.790000, 0.000000>
    }
    scale <0.05, 0.24, 0.04>
    rotate -91.5*z
    translate  <-1.61, -3.235, 1.22>
  }
  box { // Plate64
    <-1, -1, -1>, <1, 1, 1>
    material {
      Wood
      rotate -90.0*x
      translate <0.000000, -1.330000, 0.000000>
    }
    scale <0.05, 0.24, 0.04>
    rotate -91.5*z
    translate  <-1.61, -3.35, 1.22>
  }
  box { // Plate65
    <-1, -1, -1>, <1, 1, 1>
    material {
      Wood
      rotate -90.0*x
      translate <0.000000, -0.640000, 0.000000>
    }
    scale <0.05, 0.24, 0.04>
    rotate -95.200005*z
    translate  <-1.61, -3.47, 1.22>
  }
  box { // Plate66
    <-1, -1, -1>, <1, 1, 1>
    material {
      Wood
      rotate -90.0*x
      translate <0.000000, -2.020000, 0.000000>
    }
    scale <0.05, 0.24, 0.04>
    rotate -91.199997*z
    translate  <-1.61, -3.61, 1.22>
  }
  box { // Plate67
    <-1, -1, -1>, <1, 1, 1>
    material {
      Wood
      rotate -90.0*x
      translate <0.000000, -1.870000, 0.000000>
    }
    scale <0.05, 0.24, 0.04>
    rotate -91.900002*z
    translate  <-1.61, -3.74, 1.22>
  }
  box { // Plate68
    <-1, -1, -1>, <1, 1, 1>
    material {
      Wood
      rotate -90.0*x
    }
    scale <0.05, 0.24, 0.04>
    rotate -90.900002*z
    translate  <-1.61, -3.86, 1.22>
  }
  box { // Plate69
    <-1, -1, -1>, <1, 1, 1>
    material {
      Wood
      rotate -90.0*x
      translate <0.000000, -1.180000, 0.000000>
    }
    scale <0.05, 0.24, 0.04>
    rotate -91.599998*z
    translate  <-1.61, -3.98, 1.22>
  }
  box { // Plate70
    <-1, -1, -1>, <1, 1, 1>
    material {
      Wood
      rotate -90.0*x
      translate <0.000000, 1.820000, 0.000000>
    }
    scale <0.05, 0.24, 0.04>
    rotate -94.0*z
    translate  <-1.61, -4.11, 1.22>
  }
  box { // Plate71
    <-1, -1, -1>, <1, 1, 1>
    material {
      Wood
      rotate -90.0*x
      translate <0.000000, 0.490000, 0.000000>
    }
    scale <0.05, 0.24, 0.04>
    rotate -92.899994*z
    translate  <-1.61, -4.22, 1.22>
  }
  box { // Plate72
    <-1, -1, -1>, <1, 1, 1>
    material {
      Wood
      rotate -90.0*x
      translate <0.000000, -1.380000, 0.000000>
    }
    scale <0.05, 0.24, 0.04>
    rotate -92.300003*z
    translate  <-1.61, -4.36, 1.22>
  }
  box { // Plate73
    <-1, -1, -1>, <1, 1, 1>
    material {
      Wood
      rotate -90.0*x
      translate <0.000000, -1.330000, 0.000000>
    }
    scale <0.05, 0.24, 0.04>
    rotate -91.400002*z
    translate  <-1.61, -4.485, 1.22>
  }
  box { // Plate74
    <-1, -1, -1>, <1, 1, 1>
    material {
      Wood
      rotate -90.0*x
      translate <0.000000, 0.840000, 0.000000>
    }
    scale <0.05, 0.24, 0.04>
    rotate -87.199997*z
    translate  <-1.61, -4.63, 1.22>
  }
  box { // Plate75
    <-1, -1, -1>, <1, 1, 1>
    material {
      Wood
      rotate -90.0*x
      translate <0.000000, 0.300000, 0.000000>
    }
    scale <0.05, 0.24, 0.04>
    rotate -88.400002*z
    translate  <-1.61, -4.735, 1.22>
  }
  box { // Plate76
    <-1, -1, -1>, <1, 1, 1>
    material {
      Wood
      rotate -90.0*x
      translate <0.000000, 1.630000, 0.000000>
    }
    scale <0.05, 0.24, 0.04>
    rotate -87.800003*z
    translate  <-1.61, -4.86, 1.22>
  }
  box { // Plate77
    <-1, -1, -1>, <1, 1, 1>
    material {
      Wood
      rotate -90.0*x
      translate <0.000000, -1.920000, 0.000000>
    }
    scale <0.05, 0.24, 0.04>
    rotate -91.099998*z
    translate  <-1.61, -4.98, 1.22>
  }
  box { // Plate78
    <-1, -1, -1>, <1, 1, 1>
    material {
      Wood
      rotate -90.0*x
      translate <0.000000, -0.390000, 0.000000>
    }
    scale <0.05, 0.24, 0.04>
    rotate -91.099998*z
    translate  <-1.61, -5.09, 1.22>
  }
  box { // Plate79
    <-1, -1, -1>, <1, 1, 1>
    material {
      Wood
      rotate -90.0*x
      translate <0.000000, 0.300000, 0.000000>
    }
    scale <0.05, 0.24, 0.04>
    rotate -92.599998*z
    translate  <-1.61, -5.235, 1.22>
  }
  box { // Plate80
    <-1, -1, -1>, <1, 1, 1>
    material {
      Wood
      rotate -90.0*x
      translate <0.000000, -1.630000, 0.000000>
    }
    scale <0.05, 0.24, 0.04>
    rotate -91.699997*z
    translate  <-1.61, -5.36, 1.22>
  }
  box { // Plate81
    <-1, -1, -1>, <1, 1, 1>
    material {
      Wood
      rotate -90.0*x
      translate <0.000000, 0.540000, 0.000000>
    }
    scale <0.05, 0.24, 0.04>
    rotate -91.599998*z
    translate  <-1.61, -5.5, 1.22>
  }
  box { // Plate82
    <-1, -1, -1>, <1, 1, 1>
    material {
      Wood
      rotate -90.0*x
      translate <0.000000, -3.600000, 0.000000>
    }
    scale <0.05, 0.24, 0.04>
    rotate -92.199997*z
    translate  <-1.61, -5.61, 1.22>
  }
  box { // Plate83
    <-1, -1, -1>, <1, 1, 1>
    material {
      Wood
      rotate -90.0*x
    }
    scale <0.05, 0.24, 0.04>
    rotate -90.400002*z
    translate  <-1.61, -5.735, 1.22>
  }
  box { // Plate84
    <-1, -1, -1>, <1, 1, 1>
    material {
      Wood
      rotate -90.0*x
      translate <0.000000, 0.840000, 0.000000>
    }
    scale <0.05, 0.24, 0.04>
    rotate -91.199997*z
    translate  <-1.61, -5.85, 1.22>
  }
  box { // Plate85
    <-1, -1, -1>, <1, 1, 1>
    material {
      Wood
      rotate -90.0*x
      translate <0.000000, 2.320000, 0.000000>
    }
    scale <0.05, 0.24, 0.04>
    rotate -90.900002*z
    translate  <-1.61, -5.985, 1.22>
  }
  box { // Plate86
    <-1, -1, -1>, <1, 1, 1>
    material {
      Wood
      rotate -90.0*x
      translate <0.000000, -0.390000, 0.000000>
    }
    scale <0.05, 0.24, 0.04>
    rotate -91.099998*z
    translate  <-1.61, -6.1, 1.22>
  }
  box { // Plate87
    <-1, -1, -1>, <1, 1, 1>
    material {
      Wood
      rotate -90.0*x
      translate <0.000000, 1.820000, 0.000000>
    }
    scale <0.05, 0.24, 0.04>
    rotate -91.199997*z
    translate  <-1.61, -6.24, 1.22>
  }
  box { // Plate88
    <-1, -1, -1>, <1, 1, 1>
    material {
      Wood
      rotate -90.0*x
      translate <0.000000, -0.990000, 0.000000>
    }
    scale <0.05, 0.24, 0.04>
    rotate -91.799995*z
    translate  <-1.61, -6.36, 1.22>
  }
  box { // Plate89
    <-1, -1, -1>, <1, 1, 1>
    material {
      Wood
      rotate -90.0*x
      translate <0.000000, 1.130000, 0.000000>
    }
    scale <0.05, 0.24, 0.04>
    rotate -92.800003*z
    translate  <-1.61, -6.485, 1.22>
  }
  box { // Plate90
    <-1, -1, -1>, <1, 1, 1>
    material {
      Wood
      rotate -90.0*x
      translate <0.000000, 0.640000, 0.000000>
    }
    scale <0.05, 0.24, 0.04>
    rotate -91.599998*z
    translate  <-1.61, -6.61, 1.22>
  }
  box { // Plate91
    <-1, -1, -1>, <1, 1, 1>
    material {
      Wood
      rotate -90.0*x
      translate <0.000000, -2.020000, 0.000000>
    }
    scale <0.05, 0.24, 0.04>
    rotate -92.199997*z
    translate  <-1.61, -6.72, 1.22>
  }
  box { // Plate92
    <-1, -1, -1>, <1, 1, 1>
    material {
      Wood
      rotate -90.0*x
      translate <0.000000, -0.740000, 0.000000>
    }
    scale <0.05, 0.24, 0.04>
    rotate -87.699997*z
    translate  <-1.61, -6.86, 1.22>
  }
  box { // Plate93
    <-1, -1, -1>, <1, 1, 1>
    material {
      Wood
      rotate -90.0*x
      translate <0.000000, 0.940000, 0.000000>
    }
    scale <0.05, 0.24, 0.04>
    rotate -91.099998*z
    translate  <-1.61, -6.985, 1.22>
  }
  box { // Plate94
    <-1, -1, -1>, <1, 1, 1>
    material {
      Wood
      rotate -90.0*x
      translate <0.000000, -0.200000, 0.000000>
    }
    scale <0.05, 0.24, 0.04>
    rotate -91.5*z
    translate  <-1.61, -7.1, 1.22>
  }
}
#declare Lamp01 = union {
  object { LampLight01 }
  cylinder { // LampBulb01
    <0,0,1>, <0,0,0>, 1 
    material {
      Glass
    }
    scale <0.018, 0.018, 0.04>
    translate  -0.02*z
  }
  cylinder { // LampTop01
    <0,0,1>, <0,0,0>, 1 
    material {
      DarkMetal
    }
    scale 0.02
    translate  0.02*z
  }
  cylinder { // LampBottom01
    <0,0,1>, <0,0,0>, 1 
    material {
      DarkMetal
    }
    scale 0.02
    translate  -0.04*z
  }
  cylinder { // LampPost01
    <0,0,1>, <0,0,0>, 1 
    material {
      DarkMetal
    }
    scale <0.005, 0.005, 0.1>
    translate  -0.13*z
  }
  sphere { // LampHaze01
    <0,0,0>,1
    material {
      Haze
    }
    hollow
    scale 0.4
  }
  translate  <-3.42, -1.51, 1.44>
}
#declare Lamp02 = union {
  object { LampLight02 }
  cylinder { // LampBulb02
    <0,0,1>, <0,0,0>, 1 
    material {
      Glass
    }
    scale <0.018, 0.018, 0.04>
    translate  -0.02*z
  }
  cylinder { // LampTop02
    <0,0,1>, <0,0,0>, 1 
    material {
      DarkMetal
    }
    scale 0.02
    translate  0.02*z
  }
  cylinder { // LampBottom02
    <0,0,1>, <0,0,0>, 1 
    material {
      DarkMetal
    }
    scale 0.02
    translate  -0.04*z
  }
  cylinder { // LampPost02
    <0,0,1>, <0,0,0>, 1 
    material {
      DarkMetal
    }
    scale <0.005, 0.005, 0.1>
    translate  -0.13*z
  }
  sphere { // LampHaze02
    <0,0,0>,1
    material {
      Haze
    }
    hollow
    scale 0.4
  }
  translate  <0.16, -1.6, 1.44>
}
#declare Lamp03 = union {
  object { LampLight03 }
  cylinder { // LampBulb03
    <0,0,1>, <0,0,0>, 1 
    material {
      Glass
    }
    scale <0.018, 0.018, 0.04>
    translate  -0.02*z
  }
  cylinder { // LampTop03
    <0,0,1>, <0,0,0>, 1 
    material {
      DarkMetal
    }
    scale 0.02
    translate  0.02*z
  }
  cylinder { // LampBottom03
    <0,0,1>, <0,0,0>, 1 
    material {
      DarkMetal
    }
    scale 0.02
    translate  -0.04*z
  }
  cylinder { // LampPost03
    <0,0,1>, <0,0,0>, 1 
    material {
      DarkMetal
    }
    scale <0.005, 0.005, 0.1>
    translate  -0.13*z
  }
  sphere { // LampHaze03
    <0,0,0>,1
    material {
      Haze
    }
    hollow
    scale 0.4
  }
  translate  <-1.98, -3.07, 1.5>
}
#declare Lamp04 = union {
  cylinder { // LampBottom04
    <0,0,1>, <0,0,0>, 1 
    material {
      DarkMetal
    }
    scale 0.02
    translate  -0.04*z
  }
  cylinder { // LampPost04
    <0,0,1>, <0,0,0>, 1 
    material {
      DarkMetal
    }
    scale <0.005, 0.005, 0.1>
    translate  -0.13*z
  }
  translate  <-1.38, -3.15, 1.5>
}
#declare Lamps = union {
  object { Lamp01 }
  object { Lamp02 }
  object { Lamp03 }
  object { Lamp04 }
  rotate 1.5*z
}
union { // Landing
  object { Poles }
  object { Supports }
  object { Plates }
  object { Lamps }
  rotate -1.5*z
}


object {   // Reef
  height_field {
    sys /*unknown extension [BMP]*/ "D:\Program Files\Moray For Windows\PovScn\nuclearfield.bmp"
    water_level 0.0
  }
  rotate    <-90, 0, 0> // Turn onto XY plane. Now points along -Z
  scale     <  2, 2,-2> // Scale to Cube size. Now points along +Z
  translate < -1,-1,-1> // Center around origin
  material {
    Rock
  }
  scale <30.0, 30.0, 8.0>
  rotate -82.0*z
  translate  6.2*z
}


#declare SubMainCut = union {
  cylinder { // SubMainCutLeft
    <0,0,1>, <0,0,0>, 1 
    scale <0.6, 0.6, 24.0>
    rotate <-3.0, -90.0, 0.0>
    translate  <-2.84, -1.76, -0.41>
  }
  cylinder { // SubMainCutRight
    <0,0,1>, <0,0,0>, 1 
    scale <0.6, 0.6, 24.0>
    rotate <3.0, -90.0, 0.0>
    translate  <-2.84, 1.75, -0.41>
  }
  rotate 0.5*y
  translate  <17.2, 0.0, -0.52>
}
#declare SubMain = difference {
  superellipsoid { // SubMainBody
    <1.0, 0.632>
    hollow
    scale <1.0, 1.0, 8.0>
    rotate <-90.0, 0.0, -90.0>
  }
  object { SubMainCut }
  scale <1.0, 0.8, 1.0>
}
#declare SubTower = difference {
  superellipsoid { // SubTowerBody
    <1.0, 0.301>
    scale <1.0, 0.3, 1.0>
  }
  cylinder { // SubTowerCut
    <0,0,1>, <0,0,0>, 1 
    scale <0.51, 0.18, 1.1>
    translate  0.2*x
  }
  translate  <-2.27, 0.0, 1.17>
}
#declare SubRimCut = union {
  object { SubRimCut1 }
  object { // SubRimCut2 -> SubRimCut1
    SubRimCut1
    translate  0.4*x
  }
  object { // SubRimCut3 -> SubRimCut1
    SubRimCut1
    translate  0.8*x
  }
  object { // SubRimCut7 -> SubRimCut1
    SubRimCut1
    translate  2.4*x
  }
  object { // SubRimCut8 -> SubRimCut1
    SubRimCut1
    translate  2.8*x
  }
  object { // SubRimCut9 -> SubRimCut1
    SubRimCut1
    translate  3.2*x
  }
  object { // SubRimCut10 -> SubRimCut1
    SubRimCut1
    translate  3.6*x
  }
  object { // SubRimCut11 -> SubRimCut1
    SubRimCut1
    translate  4.0*x
  }
  object { // SubRimCut12 -> SubRimCut1
    SubRimCut1
    translate  4.4*x
  }
  object { // SubRimCut13 -> SubRimCut1
    SubRimCut1
    translate  4.8*x
  }
  object { // SubRimCut14 -> SubRimCut1
    SubRimCut1
    translate  5.2*x
  }
  object { // SubRimCut15 -> SubRimCut1
    SubRimCut1
    translate  5.6*x
  }
  object { // SubRimCut16 -> SubRimCut1
    SubRimCut1
    translate  6.0*x
  }
  object { // SubRimCut17 -> SubRimCut1
    SubRimCut1
    translate  6.4*x
  }
  object { // SubRimCut18 -> SubRimCut1
    SubRimCut1
    translate  6.8*x
  }
  object { // SubRimCut19 -> SubRimCut1
    SubRimCut1
    translate  7.2*x
  }
  object { // SubRimCut20 -> SubRimCut1
    SubRimCut1
    translate  7.6*x
  }
  object { // SubRimCut21 -> SubRimCut1
    SubRimCut1
    translate  8.0*x
  }
}
#declare SubRim = difference {
  superellipsoid { // SubRimBody
    <0.698, 0.16>
    scale <4.72, 0.34, 0.41>
    translate  -0.69*x
  }
  object { SubRimCut }
  translate  <0.74, 0.0, 0.79>
}
#declare SubBody = merge {
  object { SubMain }
  cone { // SubTail
    <0,0,0>, 0.1, <0,0,1>, 1.0
    scale <0.54, 0.43, 1.53>
    rotate -90.0*y
    translate  9.14*x
  }
  object { SubTower }
  superellipsoid { // SubBodyFinLeft
    <0.1, 1.0>
    scale <0.4, 1.18, 0.05>
    rotate 15.0*x
    translate  <-3.98, -0.75, -0.1>
  }
  superellipsoid { // SubBodyFinRight
    <0.1, 1.0>
    scale <0.4, 1.18, 0.05>
    rotate -15.0*x
    translate  <-3.98, 0.75, -0.1>
  }
  superellipsoid { // SubTailFinVert
    <0.1, 1.0>
    scale <0.4, 1.18, 0.05>
    rotate -90.0*x
    translate  8.65*x
  }
  superellipsoid { // SubTailFinHor
    <0.1, 1.0>
    scale <0.4, 1.18, 0.05>
    rotate 180.0*x
    translate  8.65*x
  }
  object { SubRim }
  material {
    Ripped
  }
  scale <1.0, 0.8, 1.0>
  translate  0.97*z
}
#declare TubesCasing = union {
  box { // TubesBase
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0428, 0.4029, 0.1144>
    translate  <-6.0269, 0.0, 0.9276>
  }
  box { // TubesRim
    <-1, -1, -1>, <1, 1, 1>
    scale <0.9875, 0.3792, 0.1144>
    translate  <-6.0269, 0.0, 0.964>
  }
  box { // TubesFixture
    <-1, -1, -1>, <1, 1, 1>
    scale <0.9875, 0.3792, 0.0416>
    translate  <-6.0269, 0.0, 1.2708>
  }
  material {
    DarkMetal
  }
}
#declare SubTubes = union {
  object { TubesCasing }
  object { TubesLeft }
  object { // TubesRight -> TubesLeft
    TubesLeft
    translate  0.3*y
  }
}
#declare PropulsionCasing = union {
  box { // ReactorPump
    <-1, -1, -1>, <1, 1, 1>
    scale <1.04, 0.83, 0.55>
    translate  <-2.12, 0.0, 3.71>
  }
  box { // ReactorBase
    <-1, -1, -1>, <1, 1, 1>
    scale <1.1, 1.1, 0.4>
    translate  3.59*z
  }
  box { // GeneratorBase
    <-1, -1, -1>, <1, 1, 1>
    scale <1.02, 1.0, 0.22>
    translate  <2.87, 0.0, 3.4>
  }
  box { // GeneratorFront
    <-1, -1, -1>, <1, 1, 1>
    scale <0.38, 0.89, 0.7>
    translate  <1.47, 0.0, 3.88>
  }
  box { // GeneratorBack
    <-1, -1, -1>, <1, 1, 1>
    scale <0.38, 0.91, 0.73>
    translate  <4.27, 0.0, 3.91>
  }
  box { // Engine
    <-1, -1, -1>, <1, 1, 1>
    scale <1.44, 0.83, 0.71>
    translate  <6.07, 0.0, 3.87>
  }
  material {
    DarkMetal
  }
}
#declare Pipes = union {
  cylinder { // PipesTopLeft
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 9.0>
    rotate -90.0*y
    translate  <6.99, -0.6, 4.84>
  }
  cylinder { // PipesTopRight
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 9.0>
    rotate -90.0*y
    translate  <6.99, 0.6, 4.83>
  }
  cylinder { // PipesFrontLeft
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 1.0>
    rotate 30.0*y
    translate  <-2.47, -0.6, 4.0>
  }
  cylinder { // PipesFrontRight
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 1.0>
    rotate 30.0*y
    translate  <-2.47, 0.6, 4.0>
  }
  cylinder { // PipesBack1Left
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 1.0>
    rotate -10.0*y
    translate  <6.12, -0.6, 3.88>
  }
  cylinder { // PipesBack1Right
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 1.0>
    rotate -10.0*y
    translate  <6.12, 0.6, 3.88>
  }
  cylinder { // PipesBack2Left
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 1.0>
    rotate -10.0*y
    translate  <6.63, -0.6, 3.89>
  }
  cylinder { // PipesBack2Right
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 1.0>
    rotate -10.0*y
    translate  <6.63, 0.6, 3.89>
  }
  cylinder { // PipesBack3Left
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 1.0>
    rotate -10.0*y
    translate  <7.12, -0.6, 3.89>
  }
  cylinder { // PipesBack3Right
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 1.0>
    rotate -10.0*y
    translate  <7.12, 0.6, 3.89>
  }
  material {
    Copper
  }
  translate  <0.0, 0.0, 0.0>
}
#declare SubPropulsion = union {
  object { PropulsionCasing }
  cylinder { // GeneratorCasing
    <0,0,1>, <0,0,0>, 1 
    material {
      Copper
    }
    scale <0.73, 0.9, 2.04>
    rotate -90.0*y
    translate  <3.89, 0.0, 3.89>
  }
  object { Reaction }
  superellipsoid { // ReactorVessel
    <0.2, 0.2>
    material {
      Glass
    }
    scale 0.469697
    translate  <-0.006212, 0.0, 4.463484>
  }
  object { Pipes }
  scale <0.66, 0.5, 0.66>
  translate  <-0.42, 0.0, -1.52>
}
union { // Submarine
  object { SubBody }
  cylinder { // SubPeriscope
    <0,0,1>, <0,0,0>, 1 
    material {
      Skeleton
    }
    scale <0.06, 0.04, 1.99>
    rotate -0.0*y
    translate  <-2.67, 0.0, 1.94>
  }
  cylinder { // SubAntenna
    <0,0,1>, <0,0,0>, 1 
    material {
      Skeleton
    }
    scale <0.05, 0.032, 1.7>
    rotate -0.0*y
    translate  <-2.93, 0.0, 1.94>
  }
  object { SubTubes }
  object { SubPropulsion }
  rotate <-7.30158, -1.27, -0.1525>
}


box { // Ocean
  <-1, -1, -1>, <1, 1, 1>
  scale <1000.0, 1000.0, 1.0>
  translate  -10.56*x
  material {
    Water
    // Transform to world space
  }
}


plane { // Bottom
  z,0
  material {
    Sand
  }
}


sphere { // Sky
  <0,0,0>,1
  material {
    DeepBlue
  }
  hollow
  scale 1000.0
}




