// Persistence of Vision Ray Tracer Scene Description File
// File: tank.inc
// Vers: 3.5
// Desc: Contains Tank object for remembrance.pov
// Date: October 19, 2003
// Auth: Philip Chan

#include "colors.inc"
#include "glass.inc"

// parameters for fading out colours
#declare Camo_grey = 1;  // weight of the colours grey value to be added
#declare Camo_fade = 1.5;  // factor to divide by after addition

#declare Camo = pigment {
	bozo
	colour_map {
		[0.00 colour rgb (Brass + Camo_grey*<Brass.gray, Brass.gray, Brass.gray>) / Camo_fade]
		[0.25 colour rgb (Brass + Camo_grey*<Brass.gray, Brass.gray, Brass.gray>) / Camo_fade]
		[0.25 colour rgb (ForestGreen + Camo_grey*<ForestGreen.gray, ForestGreen.gray, ForestGreen.gray>) / Camo_fade]
		[0.50 colour rgb (ForestGreen + Camo_grey*<ForestGreen.gray, ForestGreen.gray, ForestGreen.gray>) / Camo_fade]
		[0.50 colour rgb (MediumForestGreen + Camo_grey*<MediumForestGreen.gray, MediumForestGreen.gray, MediumForestGreen.gray>) / Camo_fade]
		[0.75 colour rgb (MediumForestGreen + Camo_grey*<MediumForestGreen.gray, MediumForestGreen.gray, MediumForestGreen.gray>) / Camo_fade]
		[0.75 colour rgb (Brass + Camo_grey*<Brass.gray, Brass.gray, Brass.gray>) / Camo_fade]
		[1.00 colour rgb (Brass + Camo_grey*<Brass.gray, Brass.gray, Brass.gray>) / Camo_fade]
	}
	scale 3
}

// texture to fade out patches
#declare Fade = pigment {
	bozo
	turbulence 0.3
	colour_map {
		[0.00 color rgbf<1.000, 1.000, 1.000, 1.000>]
		[0.50 color rgbf<0.632, 0.612, 0.688, 0.698>]
		[1.00 color rgbf<0.546, 0.597, 0.676, 0.953>]
	}
}

// Single rust spot
#declare Rust_Spot = pigment {
	cylindrical
	octaves 7
	lambda 3
	omega 1
	turbulence 0.1
	colour_map {
		[0.00 colour rgbt <0.455, 0.149, 0.071, 1>]
		[0.60 colour rgbt <0.455, 0.149, 0.071, 1>]
		[0.70 colour rgbt <0.455, 0.149, 0.071, 0.5>]
		[0.75 colour rgbt <0.341, 0.112, 0.053, 0>]
		[0.85 colour rgbt <0.341, 0.112, 0.053, 0>]
		[0.90 colour rgbt <0.228, 0.075, 0.036, 0>]
		[1.00 colour rgbt <0.228, 0.075, 0.036, 0>]
	}
}

// fairly heavy rust
#declare Rust = pigment {
	bozo
	octaves 7
	lambda 3
	omega 0.8
	turbulence 0.2
	colour_map {
		[0.00 colour rgbt <0.455, 0.149, 0.071, 1>]
		[0.40 colour rgbt <0.455, 0.149, 0.071, 1>]
		[0.50 colour rgbt <0.455, 0.149, 0.071, 0.5>]
		[0.60 colour rgbt <0.341, 0.112, 0.053, 0>]
		[0.75 colour rgbt <0.341, 0.112, 0.053, 0>]
		[0.85 colour rgbt <0.228, 0.075, 0.036, 0>]
		[1.00 colour rgbt <0.228, 0.075, 0.036, 0>]
	}
}

// lighter rust
#declare Light_Rust = pigment {
	bozo
	octaves 7
	lambda 3
	omega 0.8
	turbulence 0.2
	colour_map {
		[0.00 colour rgbt <0.455, 0.149, 0.071, 1>]
		[0.60 colour rgbt <0.455, 0.149, 0.071, 1>]
		[0.70 colour rgbt <0.455, 0.149, 0.071, 0.5>]
		[0.80 colour rgbt <0.341, 0.112, 0.053, 0>]
		[0.85 colour rgbt <0.341, 0.112, 0.053, 0>]
		[0.90 colour rgbt <0.228, 0.075, 0.036, 0>]
		[1.00 colour rgbt <0.228, 0.075, 0.036, 0>]
	}
}

// tank wheel
#declare Wheel = union {
	difference {
		cylinder { <-1, 0, 0>, <1, 0, 0>, 1.5 }
		cylinder { <-2, 0, 0>, <0, 0, 0>, 1.2 }
	}
	sphere { <0, 0, 0>, 1
		scale <0.75, 0.4, 0.4>
	}
}

// tank track
#declare Track = union {
	// wheels (6 big)
	#declare i = -8;
	#while ( i <= 8 )
		object { Wheel
			translate <0, 0, i>
		}
		#declare i = i + 3.2;
	#end
	// wheels (2 little)
	object { Wheel
		scale <0.75, 0.5, 0.5>
		translate <0, 0.75, -8 - ( 2.25 - 0.75*cos( radians(30) ) )/tan( radians(30) )>
	}
	object { Wheel
		scale <0.75, 0.5, 0.5>
		translate <0, 0.75, 8 + ( 2.25 - 0.75*cos( radians(30) ) )/tan( radians(30) )>
	}
	// track
	union {
		box { <-1.1, 1.5, -10.5>, <1.1, 1.7, 10.5> }  // top section, flat
		box { <-1.1, -1.7, -8 - 1.5*tan( radians(15) )>, <1.1, -1.5, 8 + 1.5*tan( radians(15) )> } // bottom section, flat
		// bottom section slants
		box { <-1.1, -0.2, -( 2.25 - 0.75*cos( radians(30) ) )/sin( radians(30) ) - 0.75*( 1 - sin( radians(30) ) )/cos( radians(30) )>, <1.1, 0, 0>
			rotate x*30
			translate <0, -1.5, -8 - 1.5*tan( radians(15) )>
		}
		box { <-1.1, -0.2, ( 2.25 - 0.75*cos( radians(30) ) )/sin( radians(30) ) + 0.75*( 1 - sin( radians(30) ) )/cos( radians(30) )>, <1.1, 0, 0>
			rotate -x*30
			translate <0, -1.5, 8 + 1.5*tan( radians(15) )>
		}
		// up
		box { <-1.1, 0.15, -8.75 - ( 2.25 - 0.75*cos( radians(30) ) )/tan( radians(30) )>, <1.1, 1.7, -8.95 - ( 2.25 - 0.75*cos( radians(30) ) )/tan( radians(30) )> }
	}
	texture { pigment { colour rgb <0.7, 0.7, 0.7> } }
	texture {
		pigment { Rust }
		scale 0.5
	}
}

// Dirty Glass for lights
#declare Dirty_Glass = material {
	texture {
		pigment { colour rgbft <1.25, 1.15, 0.56, 0.5, 0.3> }
		finish { reflection 0.3 }
	}
	interior { ior 1.4 }
}

// More yellowish dirty glass for light cover
#declare Dirty_Glass2 = material {
	texture {
		pigment { colour rgbft <1.5, 1.5, 0.30, 0.3, 0.2> }
		finish {
			reflection 0.1
		}
	}
	interior { ior 1.4 }
}

// Light object for tank, without cover
#declare Light = union {
	difference {
		sphere { <0, 0, 0>, 1 }
		box { <-1.1, -1.1, -1.1>, <1.1, 1.1, 0> }
		box { <-1.1, -1.1, -1.1>, <1.1, 0, 1.1> }
		sphere { <0, 0, 0>, 0.9
			scale <1, 1, 0.5>
			pigment { Light_Rust
				scale 0.1
			}
		}
	}
	difference {
		sphere { <0, 0, 0>, 1
			scale <0.35, 0.35, 0.5>
			translate <0, 0.4, 0.7>
		}
		sphere { <0, 0, 0>, 1
			scale <0.325, 0.325, 0.475>
			translate <0, 0.4, 0.7>
		}
		box { <-0.5, -0.1, 0.7>, <0.5, 0.9, 1.7> }
		material { Dirty_Glass }
	}
}

// light object for tank, with cover
#declare Left_Light = union {
	object { Light }
	difference {
		sphere { <0, 0, 0>, 1
			scale <1, 1, 0.025>
		}
		box { <-1.1, -1.1, -0.1>, <1.1, 0, 0.1> }
		box { <-1.1, -1.1, 0>, <1.1, 1.1, 0.1> }
		material { Dirty_Glass2 }
	}
}

// side guns
#declare Gun = union {
	// mount to turret
	cylinder { <-1, 0, 0>, <0.2, 0, 0>, 0.8 }
	difference {
		cone { <0.2, 0, 0>, 0.8, <0.5, 0, 0>, 0.7 }
		cylinder { <0.2, 0, 0>, <0.6, 0, 0>, 0.6 }
		box { <0.2, -0.1, -1>, <0.6, 0.1, 1> }
	}
	box { <0.5, -0.35, -0.35>, <1, 0.35, 0.35>
		rotate x*45
	}
	// mount to gun
	cylinder { <1.3, 0, -1>, <1.3, 0, 0.75>, 0.6 }
	// barrels
	union {
		#declare i = 0;
		#while ( i < 2*pi )
			difference {
				cylinder { <1.3, 0, -8>, <1.3, 0, -1>, 0.15 }
				cylinder { <1.3, 0, -9>, <1.3, 0, -1>, 0.1 }
				translate <0.35*sin(i), 0.35*cos(i), 0>
			}
			#declare i = i + pi/3;
		#end
		cylinder { <1.3, 0, -6.7>, <1.3, 0, -6.5>, 0.6 }
		cylinder { <1.3, 0, -2.7>, <1.3, 0, -2.5>, 0.6 }
		texture { pigment { colour rgb <0.7, 0.7, 0.7> } }
		texture { Rust
			scale 0.5
		}
	}
}

// front camera mount
#declare Camera = union {
	cylinder { <0, 0, 0>, <0, 1, 0>, 3
		pigment { colour rgb <0.2, 0.2, 0.2> }
	}
	cylinder { <0, 1, 0>, <0, 1.2, 0>, 3.1 }
	difference {
		cylinder { <0, 0.8, 0>, <0, 0.8, -3.1>, 0.2
			pigment { colour rgb <0.7, 0.7, 0.7> }
		}
		cylinder { <0, 0.8, 0>, <0, 0.8, -3.2>, 0.18}
	}
	cylinder { <0, 0.8, -3>, <0, 0.8, -2.95>, 0.18
		material {
			texture { T_Beerbottle_Glass }
			interior { ior 1.6 }
		}
	}
}	

// tank object
#declare Tank = union {
	object { Track
		translate <-7, 1.7, 0>
	}
	object { Track
		rotate y*180
		translate <7, 1.7, 0>
	}
	// front panel
	box { <-5.8, -3, -0.5>, <5.8, 0, 0.5>
		rotate -x*35
		translate <0, 3.5, -11.5>
	}
	cylinder { <-5.8, 3.5, -11.5>, <5.8, 3.5, -11.5>, 0.5 }
	// middle panel
	box { <-8.35, 3.5, -11.5>, <8.35, 4, 11.5> }
	// side panels
	box { <-8.35, 2, -11.5>, <-8.15, 4, 11.5> }
	box { <8.15, 2, -11.5>, <8.35, 4, 11.5> }
	// slanted pieces
	// left outer
	intersection {
		box { <-8.35, -4, 0>, <-8.15, 0, 3>
			rotate -x*20
			translate <0, 4, -12.5>
		}
		box { <-8.351, 2, -12.5>, <-8.15, 4, -10.5> }
	}
	// left inner
	intersection {
		box { <-5.85, -4, 0>, <-5.65, 0, 3>
			rotate -x*20
			translate <0, 4, -12.5>
		}
		box { <-5.851, 2, -12.5>, <-5.64, 4, -10.5> }
	}
	// left front
	intersection {
		box { <-8.35, -4, 0>, <-5.65, 0, 0.5>
			rotate -x*20
			translate <0, 4, -12.5>
		}
		box { <-8.351, 2, -12.5>, <-5.64, 4, -10.5> }
	}
	// left top
	box { <-8.35, 3.5, -12.1>, <-5.65, 4, -11.5> }
	// left light
	object { Left_Light
		scale <0.75, 0.75, 1.5>
		translate <-7, 3.95, -12>
	}
	// right outer
	intersection {
		box { <8.15, -4, 0>, <8.35, 0, 3>
			rotate -x*20
			translate <0, 4, -12.5>
		}
		box { <8.15, 2, -12.5>, <8.351, 4, -10.5> }
	}
	// right inner
	intersection {
		box { <5.64, -4, 0>, <5.85, 0, 3>
			rotate -x*20
			translate <0, 4, -12.5>
		}
		box { <5.64, 2, -12.5>, <5.85, 4, -10.5> }
	}
	// right front
	intersection {
		box { <5.65, -4, 0>, <8.35, 0, 0.5>
			rotate -x*20
			translate <0, 4, -12.5>
		}
		box { <5.64, 2, -12.5>, <8.351, 4, -10.5> }
	}
	// right top
	box { <8.35, 3.5, -12.1>, <5.65, 4, -11.5> }
	// right light
	object { Light
		scale <0.75, 0.75, 1.5>
		translate <7, 3.95, -12>
	}
	// slant up
	box { <-5.8, -0.25, 0>, <5.8, 0.25, 2.55/2/sin( radians(10) )>
		rotate -x*10
		translate <0, 3.75, -11.5>
	}
	// front camera
	union {
		difference {
			cylinder { <0, 4, -9.5>, <0, 4.5, -9.5>, 2 }
			cylinder { <0, 4.05, -9.5>, <0, 4.45, -9.5>, 2.2 }
		}
		box { <-2, 4, -9.5>, <2, 4.5, -8> }
		cylinder { <0, 4.05, -9.5>, <0, 4.45, -9.5>, 1.95
			pigment { colour rgb <0.2, 0.2, 0.2> }
		}
		union {
			difference {
				cylinder { <0, 4.25, -9.5>, <0, 4.25, -11.5>, 0.2 }
				cylinder { <0, 4.25, -9.5>, <0, 4.25, -11.6>, 0.18 }
				pigment { colour rgb <0.7, 0.7, 0.7> }
			}
			cylinder { <0, 4.25, -11.4>, <0, 4.25, -11.3>, 0.18
				material {
					texture { T_Beerbottle_Glass }
					interior { ior 1.6 }
				}
			}
		}
	}
	// left slant cone
	cone { <0, 4, -11.5>, 0, <0, 4, -11.5+2.55/2/tan( radians(10) )>, 2.55/2
		scale <2, 1, 1>
		translate <-5.8, 0, 0>
	}
	// right slant cone
	cone { <0, 4, -11.5>, 0, <0, 4, -11.5+2.55/2/tan( radians(10) )>, 2.55/2
		scale <2, 1, 1>
		translate <5.8, 0, 0>
	}
	// back section
	difference {
		union {
			// back box
			box { <-5.8, 4, -11.5+2.55/2/tan( radians(10) )>, <5.8, 4 + 2.55/2, 11.5> }
			// left back cylinder
			cylinder { <0, 4, -11.5+2.55/2/tan( radians(10) )>, <0, 4, 11.5>, 2.55/2
				scale <2, 1, 1>
				translate <-5.8, 0, 0>
			}
			// right back cylinder
			cylinder { <0, 4, -11.5+2.55/2/tan( radians(10) )>, <0, 4, 11.5>, 2.55/2
				scale <2, 1, 1>
				translate <5.8, 0, 0>
			}
		}
		// cut out section for turret
		cylinder { <0, 5, 4>, <0, 5.3, 4>, 5.8 }
	}
	torus { 5.8, 0.275
		translate <0, 5, 4>
	}
	// turret
	union {
		// body
		box { <-2.75, 5.3, 0>, <2.75, 7, 8> }
		// front smoothing
		cylinder { <-2.75, 6.15, 0>, <2.75, 6.15, 0>, 0.85
			scale <1, 1, 0.75>
		}
		sphere { <0, 0, 0>, 0.85
			scale <0.75, 1, 0.75>
			translate <-2.75, 6.15, 0>
		} 
		sphere { <0, 0, 0>, 0.85
			scale <0.75, 1, 0.75>
			translate <2.75, 6.15, 0>
		} 
		// back smoothing
		cylinder { <-2.75, 6.15, 0>, <2.75, 6.15, 0>, 0.85
			scale <1, 1, 0.75>
			translate z*8
		}
		sphere { <0, 0, 0>, 0.85
			scale <0.75, 1, 0.75>
			translate <-2.75, 6.15, 8>
		} 
		sphere { <0, 0, 0>, 0.85
			scale <0.75, 1, 0.75>
			translate <2.75, 6.15, 8>
		} 
		// left smoothing
		cylinder { <0, 6.15, 0>, <0, 6.15, 8>, 0.85
			scale <0.75, 1, 1>
			translate -x*2.75
		}
		// right smoothing
		cylinder { <0, 6.15, 0>, <0, 6.15, 8>, 0.85
			scale <0.75, 1, 1>
			translate x*2.75
		}
		// main gun
		sphere { <0, 0, 0>, 1
			scale <0.8, 0.8, 1.5>
			translate <0, 6.5, 0>
		}
		difference{
			union {
				cylinder { <0, 6.5, -7>, <0, 6.5, 0>, 0.8 }
				union {
					torus { 0.7, 0.3
						rotate x*90
						scale <1, 1, 2>
						translate <0, 6.5, -7>
					}
					cylinder { <0, 6.5, -7>, <0, 6.5, -5.5>, 1.0 }
					cone { <0, 6.5, -5.5>, 1.0, <0, 6.5, -5.0>, 0.7 }
					texture { pigment { colour rgb <0.7, 0.7, 0.7> } }
					texture { Rust
						scale 0.5
					}
				}
			}
			cylinder { <0, 6.5, -7.5>, <0, 6.5, 0>, 0.7
				pigment { colour rgb <0, 0, 0> }
			}
		}
		// side guns
		object { Gun
			rotate z*180
			translate <-3.5, 6.15, 4>
		}
		object { Gun
			translate <3.5, 6.15, 4>
		}
		// main camera
		union {
			// base
			difference {
				cylinder { <0, 7, 5>, <0, 7.3, 5>, 1.3 }
				cylinder { <0, 7.1, 5>, <0, 7.4, 5>, 1.1 }
				texture { pigment { Camo } }
				texture { pigment { Fade } }
			}
			// glass
			difference {
				// hollow cylinder
				cylinder { <0, 7.3, 5>, <0, 7.7, 5>, 1.15 }
				cylinder { <0, 7.2, 5>, <0, 7.8, 5>, 1.1 }
				// cut out boxes
				#declare CGrand = seed(64925);
				#declare i = 0;
				#while ( i < 360 )
					box { <-0.1 - 0.2*rand(CGrand), -0.1 - 0.2*rand(CGrand), -2>, <0.1 + 0.2*rand(CGrand), 0.2, 2>
						rotate z*180*( rand(CGrand) - 0.5 )
						rotate y*i
						translate <0, 7.75, 5>
					}
					#declare i = i + 10 + 20*rand(CGrand);
				#end
				texture { T_Beerbottle_Glass }
				interior { ior 1.2 }
				translate -y*7.3
				scale <1, 1.5, 1>
				translate y*7.3
			}
			// dome
			union {
				cylinder { <0, 7.1, 5>, <0, 7.3, 5>, 1 }
				difference {
					sphere { <0, 7.3, 5>, 0.9 }
					box { <-0.25, 6, 3.9>, <0.25, 8.4, 6.1> }
					texture { pigment { colour rgb <0.7, 0.7, 0.7> } }
					texture { pigment { Rust } translate <10, 35, 13> }
				}
				// camera and track
				sphere { <0, 7.3, 5>, 0.7
					pigment { colour rgb <0.2, 0.2, 0.2> }
				}
				union {
					difference {
						cylinder { <0, 0, -1>, <0, 0, 0>, 0.2 }
						cylinder { <0, 0, -0.8>, <0, 0, -1>, 0.25 }
						cylinder { <0, 0, -1.1>, <0, 0, 0>, 0.15
							pigment { colour rgb <0, 0, 0> }
						}
					}
					cylinder { <0, 0, -0.9>, <0, 0, -0.85>, 0.15
						material {
							texture { T_Beerbottle_Glass }
							interior { ior 1.6 }
						}
					}
					rotate x*35
					translate <0, 7.1, 5>
				}
				pigment { colour rgb <0.7, 0.7, 0.7> }
			}
			translate -z*5
			rotate -y*30
			translate z*5
		}
		rotate y*20
	}
	texture { pigment { Camo } }
	texture { pigment { Fade } }
	// rust spots
	#declare Rrand = seed(57842);	
	// top rust spots
	#declare i = 0;
	#while ( i < 30 )
		texture {
			pigment {
				Rust_Spot
				scale 1 + rand(Rrand)
				translate <16*(rand(Rrand) - 0.5), 0, 20*(rand(Rrand) - 0.5)>
			}
		}
		#declare i = i + 1;
	#end
	// side rust spots
	#declare i = 0;
	#while ( i < 10 )
		texture {
			pigment {
				Rust_Spot
				scale 1 + 0.75*rand(Rrand)
				rotate z*90
				translate <0, 2 + 1.8*rand(Rrand), 20*(rand(Rrand) - 0.5)>
			}
		}
		#declare i = i + 1;
	#end
	// front rust spots
	#declare i = 0;
	#while ( i < 8 )
		texture {
			pigment {
				Rust_Spot
				scale 1 + 0.75*rand(Rrand)
				rotate x*90
				translate <16*(rand(Rrand) - 0.5), 1 + 2*rand(Rrand), 0>
			}
		}
		#declare i = i + 1;
	#end
}