//	Persistence of Vision Ray Tracer Scene Description File
//	File: Spider.pov
//	Date: October 2003
//	Author:  Katherine Donaldson

#ifndef (Master)
	#declare Master = 1;
	#declare view_distance = 10;
	//camera {
	//	perspective 
	//	location <0.0, 16/25,-9/25>*view_distance
	//	up y*image_height right x*image_width
	//	angle 90
	//	look_at <0.0, 0.0, 0.0>
	//}
	camera {
		orthographic 
		location vnormalize(<0.0, 9/25,-16/25>)*view_distance*0.9
		up y*image_height/45 right x*image_width/45
		look_at <0.0, 0, 0.0>
	}
	
	light_source {
		//<-10, 10, 10>
		<0.0, 9/25,-16/25>*view_distance+<1,0,-1>
		rgb 0.1
	//	area_light <0.0, 5.0, 5.0>,   < 5.0,  0.0, 0.0 >,  5,  5
	}
	light_source {
		//<-10, 10, 10>
		<1.0, 1,-9/25>*view_distance
		rgb <1.0, 1.0, 1.0>
	//	area_light <0.0, 5.0, 5.0>,   < 5.0,  0.0, 0.0 >,  5,  5
	}
	
	light_source {
		//<-10, 10, 10>
		<-2,-3,-0.5>*view_distance
		rgb <1.0, 1.0, 1.0>
	//	area_light <0.0, 5.0, 5.0>,   < 5.0,  0.0, 0.0 >,  5,  5
	}
#else
	#local Master = 0;
#end

#include "web-sack.pov"

#local web_mean_rad = view_distance*1.2;
#local rWeb = seed(0);
#local i = 0;
#while (i < 500)
	torus {
		web_mean_rad,0.05
		material {web_material scale 4}
		scale <1,1,1.2>
		//pigment {rgb <0.8,0.8,0.8>}
		rotate <rand(rWeb),rand(rWeb),rand(rWeb)>*360
		translate (<rand(rWeb),rand(rWeb),rand(rWeb)>-0.5)*view_distance/3
	}
	#local i = i + 1;
#end

sphere {
<0,0,0>,web_mean_rad*8
pigment {rgb 0}
hollow
}

#declare rAmb = seed(0);

#declare Amber_M = material {
		texture {
			pigment {rgbf <0.9882, 0.6941, 0.0431, 0.8>+<(rand(rAmb)-0.5)*0.1,(rand(rAmb)-0.5)*0.05,(rand(rAmb)-0.5)*0.05>}
			//#declare F_Glass3 =
			finish  {
			    ambient 0.1
			    diffuse 0.1
			    reflection 0.01
			    specular 0.8
			    roughness 0.003
			    phong 1
			    phong_size 400
			}
		}
	//#declare I_Glass_Caustics2=
		interior {
			ior 1.5
			caustics 1.0
			fade_distance 1
			fade_power 1001
		}
}

#declare i = 0;
#while (i < 300)
	sphere {<0,0,web_mean_rad+(rand(rAmb)-0.5)>,(rand(rAmb)*0.2+0.1)
		rotate (rand(rAmb)-0.5)*y*180
		rotate (rand(rAmb)-0.5)*x*180+30
		material {Amber_M}		
	}
	#declare i = i + 1;
#end

#declare amber_drip =  union {
	cylinder {<0,0,0>,<0,100,0>,0.05 }
	lathe {
		bezier_spline
		12, 
		<0.00000, 0.00000>,
		<0.12987, -0.00000>,
		<0.25126, 0.05242>,
		<0.25974, 0.16340>,
		<0.25974, 0.16340>,
		<0.26623, 0.24837>,
		<0.25325, 0.37908>,
		<0.13636, 0.52941>,
		<0.13636, 0.52941>,
		<0.10243, 0.57305>,
		<0.05844, 0.69935>,
		<0.04545, 1.00000>
		sturm
	}
	scale <0.6,1,0.6>
	material {Amber_M}
}

union {
	object {amber_drip translate <-3,2,3>}
	object {amber_drip translate <-3.1,2.7,3.5>}
	object {amber_drip translate <-2,2.2,2.7>}
	object {amber_drip translate <-2.5,1.5,2>}
}

union {
	object {amber_drip translate <4,2,-3>}
	object {amber_drip translate <4.1,2.7,-3.5>}
	object {amber_drip translate <3,2.2,-2.7>}
	object {amber_drip translate <3.5,1.5,-2>}
}

object {web_sack_with_spiders scale 2}
object {web_sack_with_spiders scale 2 rotate 90*y translate <3,1,2>}
object {web_sack_with_spiders scale 2 rotate 120*y translate <-3,1,-3>}

media {
	scattering {2 rgb <0.986938, 1.000000, 0.679728>/40}
	samples 1,3
}
