// WOODROT.POV                                  15 Oct  2003       800 x 600 AA 0.3                   Ian MacKay

#include "colors.inc"

background { color rgb < 0.8, 0.9, 1 > } 

camera { 
        location < 0, 0.5, -4 >
        look_at < 0.25, 0.25, 0 > 
        angle 40                      
       }
       
light_source { < 50, 100, -75 > color White   // spotlight on fungi
                 area_light 22*x, 22*z, 5, 5
                 adaptive 5 
                 spotlight
                 point_at < 0.6, 0, 2.3 >
                 falloff 2
                 radius 1
                 tightness 30
             }                                          
light_source { < 50, 100, -75 > color Gray40    // spotlight on grass
                 area_light 22*x, 22*z, 5, 5
                 adaptive 5 
                 spotlight
                 point_at < 2, 0, 6.75 >
                 falloff 2
                 radius 1
                 tightness 30
             }              
            

plane { y, 7                          // some dappling of light
            pigment {
                     bozo
                     color_map {
                                [ 0 color rgbt < 0.6, 0.7, 0.4, 0.4 > ]
                                [ 0.3 color rgbt < 0.5, 0.8, 0.5, 0.5 > ]
                                [ 0.4 color Clear ]
                                [ 0.6 color Clear ]
                                [ 0.75 color rgbt < 0.6, 0.7, 0.8, 0.5 > ]
                                [ 1 color rgbt < 0.6, 0.7, 0.4, 0.4 > ]
                                } 
                      scale 1.5          
                    }
             finish { ambient 0.2 } 
             translate < 2.75, 0, -1.5 >
       }


// FUZZ ************************************************************* ( fuzzy mould }

#declare Pin =
              union {
                      cylinder { < 0, 0, 0 >,< 0, 0.06, 0 >,0.0004 }
                      sphere { < 0, 0.06, 0 >,0.00075 }
                              pigment { color White }
                              finish { ambient 0.3 }
                    }
#declare Number_of_Cycles = 30 ;
#declare Count_per_Cycle = 28 ;
#declare Coefficient = 0.01 ;
#declare Starting_Angle = 0 ; 
#declare Angle = 360 / Count_per_Cycle ;
#declare Count = Number_of_Cycles * Count_per_Cycle -1 ;

#declare SD1 = seed(1) ;
#declare SD2 = seed(2) ;

#declare Fuzz =
                union {
                       #while ( Count >= 0 )
                       object { Pin
                                scale < 1, 1.1*rand(SD1), 1 > 
                                translate < 0.18*rand(SD2), 0, 0 >
                                rotate < 2*rand(SD1), Starting_Angle*rand(SD2), 2*rand(SD1) >
                               }
                       #declare Starting_Angle = Starting_Angle + Angle ;
                       #declare Count = Count - 1 ;
                       #end
                       } 
                                          
                                          
// ROTTING WOOD ***************************************************** 

#declare Fung =
               texture {
                         pigment {
                                  bozo
                                  color_map {
                                             [ 0 color Clear ]
                                             [ 0.35 color Clear ]
                                             [ 0.35 color White ]
                                             [ 0.358 color White ]
                                             [ 0.36 color Clear ]
                                             [ 1 color Clear ]
                                            }
                                       
                                 }
                          finish { ambient 0.3 }
                        }
                        
                        
                                           

#declare Crak =
                 sphere { < 0, 0, 0 >,1
                           scale < 0.06, 1, 1 >
                            texture {        
                          pigment { 
                                   gradient y
                                   color_map {
                                                [ 0 rgb < 0.85, 0.56, 0.65 > ]
                                                [ 0.25 rgb < 0.8, 0.5, 0.6 > ]
                                                [ 0.5 rgb < 0.85, 0.56, 0.65 > ]
                                                [ 0.75 rgb < 0.85, 0.58, 0.7 > ]
                                                [ 1 rgb < 0.9, 0.6, 0.7 > ]
                                              }
                                   scale 0.5
                                   turbulence 0.1
                                   } 
                           normal { bumps 0.15 scale 0.05 }        
                           finish { ambient 0.2 }
                                    } 
                         }           
#declare Cracks =                                                     // cracks in rotting wood
                 union {
                          object { Crak translate < 0, 0.8, 0 > }
                          object { Crak translate < 0.25, 0.75, 0.3 > }    
                          object { Crak translate < -0.2, 0.7, 0.4 > }
                          object { Crak translate < 0.35, 0.6, -0.5 > }
                       }                             
#declare Aseg =                                                            // a segment of rotting wood
                superellipsoid { < 0.15, 0.15 >
                                      texture {        
                                               pigment { 
                                                        gradient y
                                                        color_map {
                                                                    [ 0 rgb < 0.9, 0.56, 0.5 > ]
                                                                    [ 0.25 rgb < 0.85, 0.5, 0.6 > ]
                                                                    [ 0.5 rgb < 0.95, 0.56, 0.5 > ]
                                                                    [ 0.75 rgb < 0.85, 0.58, 0.6 > ]
                                                                    [ 1 rgb < 1, 0.6, 0.5 > ]
                                                                   }
                                                        scale 0.5
                                                        turbulence 0.1
                                               } 
                                                 normal { bumps 0.35 scale < 0.05, 0.05, 0.2 > }        
                                                 finish { ambient 0.2 }
                                              }
                                       texture { Fung rotate y*45 }        
                               scale < 0.5, 1, 1 >        
                               translate y*-1
                                } 
#declare Bseg =                                                            // a segment with cracks
                 difference {
                             object { Aseg }
                             object { Cracks }
                             } 
#declare Arc =                                                             // an arc of rotting segments
               union {                             
                       object { Bseg translate y*3 }   
                       object { Bseg translate < 0, 3, 0.2 >  rotate < 0, 180, 20 > } 
                       object { Bseg translate y*3 rotate z*40 }
                       object { Bseg translate y*3  rotate < 0, 180, 60 > }                 
                       object { Bseg translate < 0, 3, -0.2 >  rotate < 0, 180, -20 > } 
                       object { Bseg translate y*3 rotate z*-40 }
                       object { Bseg translate y*3  rotate < 0, 180, -60 > }
                      } 
#declare Cseg =                                                             // a segment with less rot
                superellipsoid { < 0.15, 0.15 >
                                      texture {        
                                               pigment { 
                                                        gradient y
                                                        color_map {
                                                                    [ 0 rgb < 0.85, 0.6, 0.65 > ]
                                                                    [ 0.25 rgb < 0.85, 0.75, 0.6 > ]
                                                                    [ 0.5 rgb < 0.95, 0.56, 0.65 > ]
                                                                    [ 0.75 rgb < 0.85, 0.58, 0.6 > ]
                                                                    [ 1 rgb < 1, 0.6, 0.5 > ]
                                                                   }
                                                        scale 0.5
                                                        turbulence 0.1
                                               } 
                                                 normal { bumps 0.35 scale < 0.05, 0.05, 0.2 > }        
                                                 finish { ambient 0.2 }
                                              } 
                                         texture {
                                                    pigment {
                                                              bozo
                                                              color_map {
                                                                          [ 0 color Clear ]
                                                                          [ 0.3 color Clear ]
                                                                          [ 0.4 color rgbt < 0.6, 0.8, 0.3, 0.5 > ]
                                                                          [ 0.6 color rgbt < 0.7, 0.6, 0.3, 0.6 > ]
                                                                          [ 0.65 color Clear ]
                                                                          [ 1 color Clear ]
                                                                         } 
                                                              scale 0.5           
                                                             }            
                                                     normal { bumps scale 0.1 }          
                                                     finish { ambient 0.2 } 
                                                   }                                    
                               scale < 0.55, 1, 1 >        
                               translate y*-1
                                }
#declare Dseg =
                 difference {
                              object { Cseg }
                              object { Cracks translate y*0.1 } 
                                scale < 1, 1, 1.25 >
                            }                                  
#declare Barc =                                                             // an arc with less rot
               union {                             
                       object { Dseg translate y*3 }   
                       object { Cseg translate < 0, 3, 0.2 >  rotate < 0, 180, 20 > } 
                       object { Dseg translate y*3 rotate z*40 }
                       object { Dseg translate y*3  rotate < 0, 180, 60 > }             
                       object { Dseg translate < 0, 3, -0.2 >  rotate < 0, 180, -20 > } 
                       object { Dseg translate y*3 rotate z*-40 }
                       object { Dseg translate y*3  rotate < 0, 180, 80 > }
                      } 
#declare Eak =                  
             box { < -0.5, 0, -0.5 >,< 0.5, 4, 0.5 >
                                 rotate y*45
                                 scale < 0.3, 1, 2 >
                                 texture {
                                           pigment { 
                                                     gradient z
                                                     color_map { 
                                                                [ 0 rgb < 0.9, 0.6, 0.6 > ]  
                                                                 [ 1 rgb < 0.9, 0.7, 0.8 > ] 
                                                               }
                                                        scale 6 
                                                    }              
                                           normal { bumps scale < 0.1, 0.1, 1 > }
                                           finish { ambient 0.2 } 
                                         } 
                 } 
#declare Break =                                                             // broken end of log
                 union {
                         object { Eak }
                         object { Eak scale < 0.5, 1, 1.5 > rotate z*15 } 
                         object { Eak scale < 2, 1, 1.5 > rotate z*25 }
                         object { Eak scale < 0.5, 1, 1.5 > rotate z*35 }
                         object { Eak scale < 1.5, 1, 2.5 > rotate z*50 }       
                         object { Eak scale < 0.5, 1, 1.5 > rotate z*55 }
                         object { Eak scale < 1.25, 1, 0.5 > rotate z*70 }    
                         object { Eak scale < 1, 1, 0.35 > rotate z*80 }
                         object { Eak scale < 1.25, 1, 2 > rotate z*95 }  
                       }                                                    
#declare Lcrak =                                                            // rot-free crack
                 object { Crak scale < 2, 1, 4 > }
#declare Lcracks =
                 union {
                         object { Lcrak translate y*3.8 }
                         object { Lcrak translate< 0, 3.8, 1 > rotate z*45 }  
                         object { Lcrak translate y*3.8 rotate z*25 }
                         object { Lcrak translate < 0, 3.8, 0.5 > rotate z*65 }
                       }                                           
#declare Plain =                                                            // relatively rot-free
                difference {                        
                             cylinder { < 0, 0, 0 >,< 0, 0, 6 >,3
                                         texture {
                                                   pigment { 
                                                             gradient z
                                                             color_map { 
                                                                         [ 0 rgb < 0.9, 0.6, 0.6 > ]  
                                                                         [ 1 rgb < 0.9, 0.7, 0.8 > ] 
                                                                       }
                                                                 scale 6 
                                                           }              
                                                   normal { bumps scale < 0.1, 0.1, 1 > }
                                                   finish { ambient 0.2 } 
                                                  }
                                          texture {
                                                    pigment {
                                                              bozo
                                                              color_map {
                                                                          [ 0 color Clear ]
                                                                          [ 0.3 color Clear ]
                                                                          [ 0.4 color rgbt < 0.6, 0.8, 0.3, 0.5 > ]
                                                                          [ 0.6 color rgbt < 0.7, 0.6, 0.3, 0.6 > ]
                                                                          [ 0.65 color Clear ]
                                                                          [ 1 color Clear ]
                                                                         } 
                                                              scale 0.5           
                                                             }            
                                                     normal { bumps scale 0.1 }          
                                                     finish { ambient 0.2 } 
                                                   }                                
                                      }
                            union {
                                    object { Barc translate z*-1 }
                                    object { Lcracks } 
                                    object { Break translate z*6 }
                                  }  
                           }                                                                                                       
#declare Log =                                                               // the tree branch with rot
                union { 
                        object { Plain translate z*5.23 } 
                        object { Dseg translate y*3  rotate < 0, 180, 80 > translate z*5.5 }
                        object { Barc rotate z*-5 translate z*4 } 
                        object { Fuzz scale 7 translate y*2.8 rotate z*50 translate z*-3.5 }     
                        object { Fuzz scale 6 translate y*3 rotate z*60 translate z*1.5 }  
                        object { Fuzz scale 6 translate y*3 rotate z*70 translate z*4.5 }                  
                        object { Arc translate z*1.9 }                      
                        object { Arc }
                        object { Arc scale 0.9 rotate z*3 translate < 0, 0.2, -1.9 > }   
                        object { Arc scale 0.8 rotate < -4, 0, -3 > translate < 0, 0.32, -3.6 > }    
                        object { Arc scale 0.6 rotate < 8, 180, -3 > translate < 0, 0.6, -4.76 > }
                                   translate y*-3
                                  
                      }
object { Log scale 0.25 rotate < -4, -45, 0 > translate < 0.6, 0.5, 2.25 > }                                                                                                                                                                        

// FUNGI  ************************************************************  

#declare Stem =
                torus { 2.5, 0.1
                           rotate x*90 
                           scale < 1, 2, 1 >
                           clipped_by {
                                        box { < -3, -6, -1 >,< 0, 0.5, 1 > }
                                      }
                           pigment { color White }
                           finish { ambient 0.4  phong 1 }
                      }                   

#declare Fin =
              disc { < 0, 0, 0 >,< 0, 0, 1 >,0.99
                        scale < 0.7, 0.7, 1 > 
                          clipped_by {
                                     box { < -1, -0.49, -1 >,< 1, 1.5, 1 > }
                                   }
                        pigment { color rgb < 1, 0.9, 0.9 > }
                        finish { ambient 0.3 }
                   } 
#declare Fins =
               union {
                       object { Fin rotate y*20 } 
                       object { Fin rotate y*40 }
                       object { Fin rotate y*60 }
                       object { Fin rotate y*80 }
                       object { Fin rotate y*100 }
                       object { Fin rotate y*120 }
                       object { Fin rotate y*140 }
                       object { Fin rotate y*160 } 
                     }                       
#declare Top =
              union {
                     sphere { < 0, 0, 0 >,1
                                scale < 0.7, 1, 0.7 >
                                clipped_by {
                                             box { < -1, -0.5, -1 >,< 1, 1.5, 1 > }
                                           }
                                pigment {
                                         gradient y
                                         color_map {
                                                     [ 0 color White ]
                                                     [ 1 color rgb < 0.9, 0.5, 0 > ]
                                                   }
                                            scale 1.5
                                            translate y*-0.5       
                                        }
                                 finish { ambient 0.35 reflection 0.1 phong 1 phong_size 100 }
                             } 
                      torus { 0.552, 0.06
                                  clipped_by {
                                               box { < -1, 0, -1 >,< 1, -1, 1 > }
                                             } 
                                  scale < 1, 1.5, 1 >           
                                  translate y*-0.46
                                  pigment { color White }
                                  finish { ambient 0.35 reflection 0.1 phong 1 phong_size 100 }
                             }                         
                      object { Fins }
                      object { Stem translate x*2.5 } 
                                   translate < -2.5, 5, 0 >
                     }
object { Top rotate y*-45 rotate z*7 scale 0.1 translate < -0.37, 0, 2.3 > }   
object { Top rotate y*-85 rotate x*20 scale 0.11 translate < -0.37, 0, 2.3 > }   
object { Top rotate y*-45 rotate x*25 scale < 0.11, 0.13, 0.11 > translate < -0.37, 0, 2.35 > } 
object { Top rotate y*-45 scale 0.1 translate < 0.37, 0, 1.7 > }
                                                              
                                                                     

// FIRST GUMLEAF   **************************************************

#declare Ded =
               texture {
                         pigment { color rgb < 1, 0.8, 0.75 > }
                         finish { ambient 0.3 }
                       }  

#declare Clip =
               union {
                       cylinder { < 0, -0.1, 0 >,< 0, 0.1, 0 >,1.1 
                                         translate z*-0.3
                                }
                       box { < 0, -0.1, -1.5 >,< 1.5, 0.1, 1.5 >
                               rotate y*-45
                           }
                             texture { Ded }
                     }
#declare Tip =
               difference {
                            cylinder { < 0, -0.001, 0 >,< 0, 0.001, 0 >,1 }
                            object { Clip }
                                   texture { Ded }
                          } 
#declare Main =
                cylinder { < 0, -0.001, 0 >,< 0, 0.001, 0 >,0.1
                               scale < 3, 1, 1 >
                               texture { Ded }
                         }
#declare Rib =
                torus { 1, 0.002
                          scale < 1, 1.5, 1 > 
                          translate < -0.02, 0, -0.075 >
                          clipped_by {
                                      box { < -1, -0.1, 0.3 >,< 0, 0.1, 1.2 > }
                                     } 
                          texture { Ded }
                      }                             
#declare Aleaf =
                 union {
                         object { Tip }
                         object { Rib }
                         object { Main
                                  translate z*0.91 
                                  rotate y*-32
                                 }
                            scale < 0.8, 1, 1 >     
                       }


 // SECOND GUMLEAF  ***********************************************                                                                                                  
                                     
#declare Btip =
               difference {
                            cylinder { < 0, -0.001, 0 >,< 0, 0.001, 0 >,1 }
                            object { Clip 
                                   rotate y*25 
                                   translate z*-0.1 
                                   }                                    
                                   texture { Ded }
                          }
#declare Bleaf =
                 union {
                         object { Btip }
                         object { Rib rotate y*10 }
                         object { Main
                                  scale < 0.85, 1, 1.25 >
                                  translate z*0.89 
                                  rotate y*-16
                                 } 
                              translate z*-0.9   
                              scale < 1.2, 1, 0.8 >   
                       } 


// THIRD GUMLEAF **************************************************

#declare Cleaf =
                 union {
                           difference {
                                        cylinder { < 0, -0.001, 0 >,< 0, 0.001, 0 >,1 }
                                        cylinder { < 0.67, -0.1, -0.67 >,< 0.67, 0.1, -0.67 >,1.8 }
                                                       texture { Ded }
                                      }
                           torus { 1.35, 0.002
                                    scale < 1, 1.5, 1 >
                                    translate < 0.3, 0, -0.31 >
                                    clipped_by {
                                                 box { < -1, -0.1, 0 >,< 0.1, 0.1, 1.1 > }
                                               }
                                     texture { Ded }           
                                 } 
                                       translate z*-1
                                       scale 0.8 
                                      
                       } 


           

// LAYER of LEAVES *************************************************

#declare Hole =
                 cylinder { < 0, -1, 0 >,< 0, 1, 0 >,0.05
                                 texture { Ded }
                          }
                          
#declare Holes =
                union {
                        object { Hole translate < -0.9, 0, 0 > } 
                        object { Hole translate < -1.4, 0, -0.3 > } 
                        object { Hole translate < -0.5, 0, -0.95 > } 
                        object { Hole scale 0.6 translate < -0.2, 0, -0.75 > }
                        object { Hole translate < 1.3, 0, 0 > }     
                        object { Hole scale 0.5 translate < 1.2, 0,-0.5 > }  
                        object { Hole scale 0.75 translate < 0.5, 0,-0.1 > } 
                       }                         
                                 
#declare Set =
              difference {               
               union {
                      object { Aleaf rotate y*-80 translate x*0.8 }   
                      object { Aleaf rotate x*180 translate < -0.8, 0, 0.8 > }
                      object { Aleaf rotate y*-45 translate < 0.6, 0, -1 > }         
                      object { Aleaf rotate x*180 translate < 0.6, 0, 0 > } 
                      object { Aleaf  }
                      object { Bleaf translate < 0.5, 0, 0.5 > }   
                      object { Bleaf rotate z*180 translate x*0.2 }  
                      object { Bleaf rotate < 180, -55, 0 > translate < -0.5, 0, -0.5 > }
                      object { Cleaf translate < -0.5, 0, -0.3 > }
                      } 
               object { Holes }       
                          }
#declare Layer =                                                   // layer of leaves
                 union {              
                         object { Set }
                         object { Set rotate y*120 translate < 1, -0.005, 0 > }  
                         object { Set rotate y*-120 translate < -1, -0.005, 0 > } 
                       }

#declare Matt =
                union{                       
                       object { Layer }
                       object { Layer rotate y*100 translate < -0.5, 0.015, -0.25 > }    
                       object { Layer rotate y*-180 translate < 0.5, -0.015, -0.5 > }                         
                       object { Layer translate < -1.5, 0, 3 > }   
                       object { Layer translate < 1.5, 0, 3 > }   
                       object { Layer translate < 0.5, 0, -2.4 > } 
                     } 
object { Matt }                     
object { Matt translate < 0, -0.05, -1 > } 

plane { y, -0.06                                                    // underlay
                pigment {  color rgb < 0.2, 0.3, 0.1 > }
                finish { ambient 0.3 }
      }                                                                    
#declare Omatt =
                plane { y, -0.016                                                      // filtering layer
                            pigment {
                                      bozo 
                                      color_map {
                                                 [ 0 color rgbt < 0.1, 0.3, 0.1, 0.6 > ]  
                                                 [ 0.3 color rgbt < 0.8, 0.5, 0.3, 0.5 > ] 
                                                 [ 0.6 color rgbt < 0.1, 0.3, 0.1, 0.6 > ] 
                                                 [ 1 color rgbt < 0.8, 0.5, 0.3, 0.5 > ]  
                                                } 
                                        scale 0.5    
                                    }              
                             finish { ambient 0.2 }
                         }  
object { Omatt }                         

plane { y, 0.012                                                      // filtering layer ( water surface )
                pigment {
                          bozo 
                          color_map {
                                      [ 0 color rgbt < 0.1, 0.3, 0.1, 0.8 > ]  
                                      [ 0.3 color Clear ] 
                                      [ 0.6 color rgbt < 0.1, 0.3, 0.1, 0.8 > ] 
                                      [ 1 color Clear ] 
                                     } 
                                 scale 0.5    
                        }
                normal { ripples 0.15 scale 0.15 }                      
                finish { ambient 0.2 reflection 0.2 phong 1 phong_size 80 }
      }  

// CURLY LEAF ************************************************


              
#declare Start =
                union {
                         cylinder { < 0, 0, -2 >,< 0, 0, 2 >,1 open } 
                         torus { 1, 0.01
                                       scale < 1.6, 1, 1 > 
                                       rotate < 90, -50, 0 > 
                                      
                               }                       
                                  texture {
                                      pigment { 
                                                bozo
                                                color_map {
                                                           [ 0 color rgb < 0.8, 0.7, 0.6 > ]
                                                           [ 0.1 color rgb < 0.8, 0.7, 0.6 > ]
                                                           [ 0.3 color rgb < 0.9, 0.7, 0.6 > ]
                                                           [ 1 color rgb < 0.7, 0.8, 0.6 > ]
                                                          
                                                          } 
                                                   scale 0.1       
                                               }
                                      finish { ambient 0.2 }
                                          }
                          } 
                        
#declare Curly =
                  object { Start rotate y*50 
                             clipped_by {
                                           cylinder { < 0, 0, 0 >,< 0, -1, 0 >,1
                                                         scale < 1, 1, 0.2 >
                                                    } 
                                        }
                             translate y*1           
                             scale 0.5            
                          }              
object { Curly translate y*0.02 }
object { Curly rotate y*90 translate < 0.5, 0.02, -1.5 > }    
object { Curly scale 0.75 rotate y*130 translate < 0, 0.02, -1.75 > } 

// DISTANCE ****************************************************                                        
cylinder { < 0, -1, 0 >,< 0, 20, 0 >,20 open        // darkness beyond grass
             clipped_by {
                           box { < -21, -2, 21 >,< 21, 21, 0 > }
                        }   
             pigment {
                       bozo 
                       color_map {
                                  [ 0 color rgb < 0.7, 0.7, 0.5 > ]                                 
                                  [ 0.3 color rgb < 0.8, 0.6, 0.5 > ] 
                                  [ 0.6 color rgb < 0.8, 0.5, 0.4 > ]
                                  [ 1 color rgb < 0.6, 0.5, 0.4 > ]
                                  } 
                           scale < 3, 6, 3 >     
                      }
              finish { ambient 0.2 }
         }                                                                                   
cylinder { < 0, -1, 0 >,< 0, 10, 0 >,10 open         // for reflection in fungi
             clipped_by {
                           box { < -11, -2, -11 >,< 11, 11, 5 > }
                        }   
             pigment {  color White }          
                       
              finish { ambient 0.5 }
         }                                         
 
// GRASS  *************************************************    


#declare Oblade =
                 torus { 1.475, 0.025
                             rotate x*90
                             clipped_by {
                                         cylinder { < 0, -0.025, -0.1 >,< 0, -0.025, 0.1 >,1.475 }
                                        } 
                             pigment { 
                                      gradient y
                                      color_map {
                                                 [ 0 color rgb < 1, 1, 0.5 > ]   
                                                 [ 0.5 color rgb < 0.7, 0.9, 0.1 > ]
                                                 [ 1 color rgb < 0.1, 0.7, 0.1 > ]
                                                 }
                                       scale 1.6 
                                       
                                      }           
                             finish { ambient 0.2 }
                       }

#declare Ablade =
                 object { Oblade clipped_by {
                                             box { < -1.6, 0, -0.1 >,< 0, 1.6, 0.1 > }
                                            }
                                 translate x*1.475           
                        }
#declare Bblade =
                 union {                         
                        object { Ablade scale < 0.5, 1.25, 1 > rotate y*-30 }                          
                        object { Ablade }
                        object { Ablade scale < 1.15, 0.5, 1 > rotate y*15 }  
                        object { Ablade scale < 0.5, 0.5, 1 > rotate y*25 } 
                       }
#declare Cblade =
                 object { Bblade rotate z*20 }

#declare Tussok =
                  union {
                          object { Bblade translate x*0.1 }         
                          object { Bblade translate x*0.1 rotate y*60 } 
                          object { Bblade translate x*0.1 rotate y*-80 }
                          object { Bblade translate x*0.1 rotate y*160 } 
                          object { Cblade rotate y*30 }  
                          object { Cblade rotate y*130 }
                          object { Cblade rotate y*-130 } 
                          scale 2
                        }
object { Tussok rotate y*60 translate z*7.25 }    
object { Tussok rotate y*-60 translate < 0.75, 0, 7 > }     
object { Tussok rotate < 0, 180, 15 > translate < -0.75, 0, 7.25 > }       
object { Tussok rotate < -5, 30, 5 > translate < -1.75, 0, 7 > }                   
                                                                       
object { Tussok rotate < 0, 45, 10 > translate < 2, 0, 7.25 > }       
object { Tussok rotate < -5, 3-0, -5 > translate < 3, 0, 6.5 > }          
object { Tussok rotate < 0, 145, 10 > translate < 3.8, 0, 7.25 > }       
object { Tussok rotate < -5, 3-0, -5 > translate < -3, 0, 6.5 > }                  
                                                                       

                                                                                                                                                                                                                                                                                                                                            