// Classical photographic three-points light
#macro Photo_3Lights (Cam_Pos, Subject_Pos, Key_Angle, Fill_Angle, Back_Angle, Color, Altitude, Distance, Q)

#declare With_Main_Light=on;
#declare With_Fill_Light=off;
#declare With_Back_Light=off;

#declare Fading=off;

#local Tmp_Pos=vrotate (Cam_Pos - Subject_Pos, <0,Key_Angle,0>) + Subject_Pos;
#declare Key_Light_Pos=<Distance*Tmp_Pos.x, Altitude*Tmp_Pos.y, Distance*Tmp_Pos.z>;
#local Tmp_Pos=vrotate (Cam_Pos - Subject_Pos, <0,Fill_Angle,0>) + Subject_Pos;
#declare Fill_Light_Pos=<Distance*Tmp_Pos.x, Altitude*Tmp_Pos.y/2, Distance*Tmp_Pos.z>;
#local Tmp_Pos=vrotate (Cam_Pos - Subject_Pos, <0,Back_Angle,0>) + Subject_Pos;
#declare Back_Light_Pos=<Distance*Tmp_Pos.x, Altitude*Tmp_Pos.y/4, Distance*Tmp_Pos.z>;

// Quality settings
#switch (Q)
  #case (0)
    #local area_lights=1;
  #break
  #case (1)
    #declare With_Fill_Light=on;
    #local area_lights=1;
    #local area_other_lights=1;
  #break
  #case (2)
    #declare With_Fill_Light=on;
    #declare With_Back_Light=on;
    #local area_lights=1;
    #local area_other_lights=1;
  #break
  #case (3)
    #declare With_Fill_Light=on;
    #declare With_Back_Light=on;
    #local area_lights=1;
    #local area_other_lights=2;
  #break
  #case (4)
    #declare With_Fill_Light=on;
    #declare With_Back_Light=on;
    #local area_lights=1;
    #local area_other_lights=2;
  #break
  #case (5)
    #declare With_Fill_Light=on;
    #declare With_Back_Light=on;
    #local area_lights=3;
    #local area_other_lights=2;
    #declare Fading=on;
  #break
  #case (6)
    #declare With_Fill_Light=on;
    #declare With_Back_Light=on;
    #local area_lights=4;
    #local area_other_lights=3;
    #declare Fading=on;
  #break
#end

#if (With_Main_Light)
light_source {
  Key_Light_Pos
  color rgb Color
  #if (area_lights>1)
    area_light
    <2, 0, 0> <0, 0, 2>
    area_lights, area_lights
    adaptive 0
    jitter
    circular
    orient
  #end
  fade_distance Distance*vlength (Cam_Pos - Subject_Pos)
  fade_power 2
}
#end

#if (With_Fill_Light)
light_source {
  Fill_Light_Pos
  color rgb Color/4
  #if (area_other_lights>1)
    area_light
    <8, 0, 0> <0, 0, 8>
    area_other_lights, area_other_lights
    adaptive 0
    jitter
    circular
    orient
  #end
}
#end

#if (With_Back_Light)
light_source {
  Back_Light_Pos
  color rgb Color
  #if (area_other_lights>1)
    area_light
    <8, 0, 0> <0, 0, 8>
    area_other_lights, area_other_lights
    adaptive 0
    jitter
    circular
    orient
  #end
}
#end

#end
