#include "colors.inc"
#include "stones.inc"
#include "metals.inc"
#include "woods.inc"
#include "textures.inc"
#include "math.inc"
#include "functions.inc"
#include "glass.inc"
#include "logo.inc"

#include "bmh.inc"
#declare detail=0;

#include "sail.pov"
#include "figure.pov"
#include "wheel.pov"
#include "cart.pov"
#include "light.pov"
#include "bollard.pov"
#include "grass.pov"
#include "bottle.pov"
#include "door.pov"
#include "sign.pov"
#include "poster.pov"
#include "building.pov"
#include "coke_can.pov"
#include "coke_cup.pov"
#include "crack.pov"
#include "kerb.pov"
#include "ramp.pov"
#include "pavement.pov"
#include "pump.pov"
#include "road.pov"
#include "sky3.pov"
#include "wind_turbine.pov"
#include "forecourt.pov"
#include "hills.pov"



light_source { <-1500,900,-400> color rgb <0.9,0.85,0.8> }
light_source { <-15,2,5> color rgb 0.2 shadowless }
global_settings {
	ambient_light rgb <3,3,3>
#if(detail<1)
	max_trace_level 15
	photons
	{
		count 200000
		autostop 0
		jitter .4
		max_trace_level 4
	}
#end
}


plane
{ <0, 1, 0>, -1
	pigment
	{
#if (detail>0)
		checker color White, color Blue
#else
		color Black
#end
	}
	clipped_by { sphere { <0,0,0>, 20 } }
}

//plane
//{ <0, 1, 0>, -1.01 pigment {Green}}

camera
{
	right<image_width/image_height,0,0>
	angle 49
	location <-14,1.6,-7.5>
	look_at<0,2.8,3.5>

//	location <-7,1,4>
//	location <0,100,0>
//	look_at<0,0,0>

}

#if(detail>0)
cone {0,0.25,<0,1,0> 0.1 pigment {rgbf <1,0,0,0.8>}}
#end

#declare road_scale=<1.5,1,1.5>;
#declare road_vec=<0,-0.14,-4>;

#declare road_placed=
object {road scale road_scale translate road_vec}

object{road_placed}

#declare cart_ang=100;
#declare cart_vec=<-3.75,0.6,-3>;

#declare cart_fl=vrotate(wheel_l,<0,cart_ang,0>)+cart_vec;
#declare cart_fr=vrotate(wheel_r,<0,cart_ang,0>)+cart_vec;
#declare cart_b=vrotate(wheel_b,<0,cart_ang,0>)+cart_vec;
#declare cart_f=(cart_fl+cart_fr)/2;

#declare gr_fl=trace(road_placed,cart_fl+2*y,-y);
#declare gr_fr=trace(road_placed,cart_fr+2*y,-y);
#declare gr_b=trace(road_placed,cart_b+2*y,-y);
#declare gr_f=(gr_fl+gr_fr)/2;

//object{thing translate gr_fl}
//object{thing translate gr_fr}
//object{thing translate gr_b}

#declare fb_ang=atan2d(gr_f.y-gr_b.y,vlength(cart_f-cart_b));
#declare lr_ang=atan2d(gr_fl.y-gr_fr.y,vlength(cart_fl-cart_fr));
#declare cart_vec=cart_vec*<1,0,1>+<0,(gr_b.y+gr_f.y)+0.12,0>;

object {cart(0) rotate <0,cart_ang,0> rotate <-lr_ang,0,-fb_ang>translate cart_vec}

object {building rotate <0,2,0> translate <-0.75,0.28,10>}

	// not seen, just for reflections ... 
object {plain_building  translate <-45,0.28,-12>}
object {plain_building  translate <-28,0.28,-12>}
object {plain_building  translate <-16,0.28,-12>}
object {plain_building  translate <-3,0.28,-12>}
object {plain_building  translate <8,0.28,-12>}

object {pavement}

object {forecourt}

object {hills}

text
{
	ttf "timrom.ttf"  "Copyright (c) 2003 Bernard Hatt",0.01,0
	scale 0.33
	rotate <0,51,0>
	translate <-5.1,8.07,10>
	pigment {rgbf <1,1,1.05,1>}
	no_shadow
}


