
// detail level
#declare detail=2;
#declare hills_detail=1;

// handy constants
#declare c60 = cos(pi/3);
#declare s60 = sin(pi/3);


// p=array of points (1st point duplicated as last)
// num= number of points (including duplication)
// r=rounding radius
// d=depth

#macro rounded_prism ( p,num,r,d )
merge
{
#local dv= <0,0,d>;
#local i =0 ;
#while (i<(num-1))
	cylinder {p[i],p[i+1],r}
	sphere {p[i],r}
	cylinder {p[i]+dv,p[i+1]+dv,r}
	sphere {p[i]+dv,r}
	cylinder {p[i],p[i]+dv,r}
	box{<0,0,-r>,<vlength(p[i]-p[i+1]),vlength(dv),r> rotate <90,0,VRotationD(<1,0,0>,p[i+1]-p[i],z)> translate p[i] }

#local i=i+1;
#end

	prism
	{
		-r,r,num
#local i=0;
#while(i<num)
		,p[i]
#local i=i+1;
#end
		rotate <-90,0,0>
	}
	prism
	{
		-r,r,num
#local i=0;
#while(i<num)
		,p[i]
#local i=i+1;
#end
		rotate <-90,0,0>
		translate dv
	}
}
#end


#macro rope(rstart,rend,rdrop,rad)
sphere_sweep
{
	cubic_spline,
	5,
	(rstart*2-rend)+<0,rdrop*4,0>, rad
	rstart, rad
	(rstart+rend)/2-<0,rdrop,0>, rad
	rend, rad
	(rend*2-rstart)+<0,rdrop*4,0>, rad
}
#end


#declare thing=
union
{
#local r1=0.005;
#local i=-0.5;
#while (i<0.45)
	cylinder{ <i,0,0> <i+0.1,0,0> r1 pigment {Red}}
	cylinder{ <i+0.2,0,0> <i+0.1,0,0> r1 pigment {White}}
	cylinder{ <0,i,0> <0,i+0.1,0> r1 pigment {rgb <0.0,0.8,0.0>}}
	cylinder{ <0,i+0.2,0> <0,i+0.1,0> r1 pigment {White}}
	cylinder{ <0,0,i> <0,0,i+0.1> r1 pigment {Blue}}
	cylinder{ <0,0,i+0.2> <0,0,i+0.1> r1 pigment {White}}
#local i=i+0.2;
#end
}
