
#declare bollard=
difference
{
	union
	{
		cone{<0,-0.1,0> 0.1 ,<0,0.8,0> 0.07}
		sphere {<0,0.8,0> 0.07}
	}
	union
	{
		cylinder{<0,0,0.04> <0,0.7,0.04> 0.003}
		cylinder{<0,0,0.04> <0,0.7,0.04> 0.003 rotate <0,90,0>}
		cylinder{<0,0,0.04> <0,0.7,0.04> 0.003 rotate <0,180,0>}
		cylinder{<0,0,0.04> <0,0.7,0.04> 0.003 rotate <0,270,0>}
		pigment {rgb <0.7,0.5,0.2>}
	}
}

#macro concrete_break(sign,pat)
isosurface
{
	function{sign*(y-(z+x)/4+(f_bozo(x*4,pat,z*4)-0.5)/2+(f_bozo(x*20,pat,z*20)-0.5)/10)}
//	function{sign*(y-(z+x)/4)}
	max_gradient 3.5
	max_trace 3
	contained_by{box{<-1,-4,-1> <1,4,1>}}	
}
#end

#declare bollard_complete=
object {
	bollard
	normal{function{clip(f_bozo(x*50,y*50,z*50)*2,0,0.5)+f_bozo(x*200,y*200,z*200)/10}}
	pigment
	{
		bozo scale 0.05
		pigment_map
		{
			[0.0 Gray80]
			[1.0 rgb <0.7,0.8,0.7>]
		}
	}
}

#macro bollard_bottom(h,pat)
intersection
{
	object {bollard}
	object {concrete_break(1,pat) scale 0.25 translate <0,h,0>}
	pigment
	{
		function{clip(
			min(
				min(f_r((x-0.04)*40,0,z*40),f_r(x*40,0,(z-0.04)*40)),
				min(f_r((x+0.04)*40,0,z*40),f_r(x*40,0,(z+0.04)*40))
				)+(f_bozo(x*60,0,y*60)-0.5)
				,0,1)}
		color_map
		{
			[0.0 rgb <0.6,0.3,0.1>]
			[1.0 rgb 0.8]
		}
	}
	normal{function{clip(f_bozo(x*50,y*50,z*50)*2,0,0.5)+f_bozo(x*200,y*200,z*200)/10}}
}
#end

#macro bollard_top(h,pat)
intersection
{
	object {bollard}
	object {concrete_break(-1,pat) scale 0.25 translate <0,h,0>}
	normal{function{clip(f_bozo(x*50,y*50,z*50)*2,0,0.5)+f_bozo(x*200,y*200,z*200)/10}}
	translate <0,-h/2,0>
	pigment {Gray80}
}
#end

#declare rnd8=seed(9140);

#macro bollard_broken(h,pat)
union
{
	object{bollard_bottom(h,pat)}
	object{bollard_top(h,pat) rotate <0,180*rand(rnd8),90> translate <0,0.07,0> rotate <0,270*rand(rnd8),0>}
}
#end
