 
#macro Strut(s,e,r,sc)
union
{
	cylinder { s/sc, e/sc r scale sc}
	sphere {0,r scale sc translate s}
	sphere {0,r scale sc translate e}
}
#end  

#declare rope_texture=
texture
{
    normal{function{(sin(x*100)*sin(y*100)*sin(z*100)+1)/8}}
    pigment {leopard scale 0.001 color_map{[0.25 Red][0.33 Blue]}}
}


#declare fl=<-1.5,0,-2>;
#declare fr=<1.5,0,-2>;
#declare bc=<0,0,2>;

#declare wheel_l=fl+<-0.25,0,0>;
#declare wheel_r=fr+<0.25,0,0>;
#declare wheel_b=bc+<0,0,0.6>;

#macro cart(pat)

#declare mb=(3*fl+3*fr+2*bc)/8;
#declare mt=mb+<0,4.5,0>;

union
{
	object {Strut(fl,fr,0.1,<1,1.5,1>)}
	object {Strut(bc,fr,0.1,<1,1.5,1>)}
	object {Strut(fl,bc,0.1,<1,1.5,1>)}
	sphere {0 .1 scale <1,2,1> translate bc}
	sphere {0 .1 scale <1,2,1> translate fl}
	sphere {0 .1 scale <1,2,1> translate fr}

	object {Strut((fl+fr)/2,(bc+fr)/2,0.1,<1,0.5,1>)}
	object {Strut((bc+fr)/2,(bc+fl)/2,0.1,<1,0.5,1>)}
	object {Strut((fl+bc)/2,(fl+fr)/2,0.1,<1,0.5,1>)}


#declare p1=(fl/4+fr/2+bc/4);
#declare p2=(fl/2+fr/4+bc/4);
#declare p3=(fl/4+fr/4+bc/2);

	object {Strut(p1,p2,0.1,<1,0.5,1>)}
	object {Strut(p3,p2,0.1,<1,0.5,1>)}
	object {Strut(p1,p3,0.1,<1,0.5,1>)}

	object {Strut(p1,fr,0.1,<1,0.5,1>)}
	object {Strut(p2,fl,0.1,<1,0.5,1>)}
#declare sb=bc*0.3+p3*0.7-<0,0.25,0>;
	object {Strut(p3,sb,0.1,<1,0.5,1>)pigment {Red}}
	object {Strut(sb,bc,0.1,<1,0.5,1>)pigment {Red}}
	object {Strut(sb+<0,0.05,0>,bc+<0,0.3,-0.5>,0.1,<3,0.5,1>) pigment {Yellow}}
	object {Strut(sb+<0,0.05,0>,p3+<0,0.05,0>,0.1,<3,0.5,1>) pigment {Yellow}}
	object {Strut(sb,bc*0.6+fr*0.4,0.1,<1,0.5,1>)pigment {Red}}
	object {Strut(sb,bc*0.6+fl*0.4,0.1,<1,0.5,1>)pigment {Red}}

#declare mp=(mb+<0,0.5,0>);
	object {Strut(p1,mp,0.1,<0.5,0.5,1>)}
	object {Strut(p2,mp,0.1,<0.5,0.5,1>)}
	object {Strut(p3,mp,0.1,<0.5,1,0.5>)}
	object {Strut((fl+fr)/2,mp,0.1,<0.5,1,0.5>)}

	object {Strut(mb,mt,0.1,<0.5,0.5,1>)}


	object{sail(0.0) translate <0,0,6> scale <1,1.1,3> rotate <0,20,0> translate mp+<-0.5,1.45,-1.5>}

#declare sail_l=<1.7,0.75,-2.0>;
#declare sail_r=<-1.83,0.72,-0.68>;
#declare sail_t= <-0.01,4.52,-1.17>;

#declare hand_r=<-0.28,0.34,0.70>;
#declare hand_l=<0.32,0.35,0.53>;

	
object {Strut(mp+<-1.5,0,0>,mp+<2.4,0,0>,0.1,<0.5,0.5,0.5>) rotate <0,20,0> translate <0,0.3,0.25>}
#declare r_strut=vrotate(mp+<-1.5,0,0>,<0,20,0>)+<0,0.3,0.25>;
#declare l_strut=vrotate(mp+<2.4,0,0>,<0,20,0>)+<0,0.3,0.25>;

#declare t_cart1=
texture
{
	pigment {Gray50}
	finish {phong 0.1 phong_size 25}
	normal
	{
		function{(sin(x*(f_bozo(x*3,y*3+20,z*3)*20+240))*sin(y*(f_bozo(x*3,y*3,z*3)*20+240))*sin(z*(f_bozo(x*3,y*3,z*3+10)*20+240))+1)/2} 0.1
		rotate <60,30,0>
	}

}

#declare t_cart2=
texture
{
	pigment {White}
	finish {phong 0.8 phong_size 25}
	normal
	{
		function{(sin(x*(f_bozo(x*3,y*3+20,z*3)*20+240))*sin(y*(f_bozo(x*3,y*3,z*3)*20+240))*sin(z*(f_bozo(x*3,y*3,z*3+10)*20+240))+1)/2} 0.1
		rotate <60,30,0>
	}

}

union
{
	torus{0.06,0.01 rotate<0,0,90> rotate<0,20,0> translate (l_strut*98+r_strut*2)/100 }
	torus{0.06,0.01 rotate<0,0,90> rotate<0,20,0> translate (l_strut*98.5+r_strut*1.5)/100 }
	torus{0.06,0.01 rotate<0,0,90> rotate<0,20,0> translate (l_strut*99+r_strut*1)/100 }
	torus{0.025,0.01 rotate <0,0,60> translate sail_l +<0,0.00,0.02>}
	torus{0.04,0.01 rotate<0,0,-90> translate sail_l +<-0.02,-0.05,0.03>}
	cylinder{sail_l,l_strut+<-0.06,-0.05,0> 0.01}

	torus{0.06,0.01 rotate<0,0,90> rotate<0,20,0> translate (r_strut*98+l_strut*2)/100 }
	torus{0.06,0.01 rotate<0,0,90> rotate<0,20,0> translate (r_strut*98.5+l_strut*1.5)/100 }
	torus{0.06,0.01 rotate<0,0,90> rotate<0,20,0> translate (r_strut*99+l_strut*1)/100 }
	torus{0.03,0.01 translate sail_r +<0,0,0.03>}
	torus{0.03,0.01 translate sail_r +<0,-0.03,0.03>}
	cylinder{sail_r,r_strut-<-0.03,0.06,0> 0.01}

	torus{0.03,0.01 rotate<0,0,90>translate sail_t +<-0.01,0,-0.0>}
	torus{0.03,0.01 rotate<0,0,90>translate sail_t +<0.01,0,0.0>}
	torus{0.11,0.01 scale<0.5,0.5,1> translate mt}
	torus{0.11,0.01 scale<0.5,0.5,1> translate mt-<0,0.02,0>}
	cylinder{mt-<0.06,0,0>,sail_t 0.01}
	cylinder{mt+<0.06,-0.02,0>,sail_t 0.01}

	rope(hand_r,r_strut-<-0.03,0.06,0>,0.05, 0.01)
	rope(hand_r,l_strut+<-0.06,-0.05,0>,0.1, 0.01)

	torus{0.06,0.01 rotate<0,0,90> rotate<0,20,0> translate (l_strut*48.5+r_strut*51.5)/100 }
	torus{0.06,0.01 rotate<0,0,90> rotate<0,20,0> translate (l_strut*49+r_strut*51)/100 }
	torus{0.06,0.01 rotate<0,0,90> rotate<0,20,0> translate (l_strut*51+r_strut*49)/100 }
	torus{0.06,0.01 rotate<0,0,90> rotate<0,20,0> translate (l_strut*51.5+r_strut*48.5)/100 }

	torus{0.12,0.02 scale<0.5,0.5,1> translate mp+<0,0.38,0>}
	torus{0.12,0.02 scale<0.5,0.5,1> translate mp+<0,0.35,0>}
	torus{0.12,0.02 scale<0.5,0.5,1> translate mp+<0,0.25,0>}
	torus{0.12,0.02 scale<0.5,0.5,1> translate mp+<0,0.22,0>}


	texture{rope_texture}
}

//	object {thing translate hand_r}
//	object {thing translate hand_l}

	object{figure(0) scale 0.09 rotate <0,-90,0> rotate <5,0,0>  translate <0,-0.05,0.5>}

	object{wheel(1) scale 0.5 rotate <0,0,90> translate wheel_l}
	object{wheel(1) scale 0.5 rotate <0,0,90> translate wheel_r}
	object{wheel(1) scale 0.5 rotate <0,0,90> translate wheel_b}

	union
	{
		cylinder{wheel_l,fl+<0,0.15,0>,0.04}
		cylinder{wheel_l,fl-<0,0.15,0>,0.04}
		cylinder{wheel_l,fl+<0,0,0.15>,0.04}
		cylinder{wheel_r,fr+<0,0.15,0>,0.04}
		cylinder{wheel_r,fr-<0,0.15,0>,0.04}
		cylinder{wheel_r,fr+<0,0,0.15>,0.04}

		torus{0.32,0.05 scale <0.5,1,1> rotate <-22,0,0> translate bc+<0,-0.12,0.3>}
		torus{0.32,0.05 scale <0.5,1,1> rotate <22,0,0> translate bc+<0,0.12,0.3>}
		cylinder{bc-<0,0.22,0>, bc+<0,0.28,0> 0.05}
		sphere{bc-<0,0.22,0> 0.05}
		sphere{bc+<0,0.28,0> 0.05}
#declare bct=bc+<0,0.24,0>;
#declare handle_r=0.03;
		sphere_sweep
		{
			cubic_spline
			7,
			hand_l+<-0.4,0,0.02>, handle_r,
			hand_l+<-0.3,0,0.02>, handle_r,
			hand_l,handle_r,
			(bct+hand_l*7)/8+<1.1,0,0>,handle_r,
			(bct*3+hand_l)/4+<0.8,0,0>,handle_r,
			bct,handle_r,
			bct+<-0.1,0,0>,handle_r
		}
		pigment{P_Chrome3}
		texture{T_Chrome_1A}
		finish{F_MetalB}
	}

	texture
	{
		function{clip((y*4+0.5)+(f_bozo(x*25,y*15,z*25)-0.5)/2,0,1)}
		texture_map
		{
			[0.0 t_cart1]
			[1.0 t_cart2]
		}
	}
}

#end

