
#declare t_grass=
texture
{
	pigment
	{
		bozo scale 0.01
		color_map
		{
			[0.0 rgb <0.1,0.95,0>]
			[1.0 rgb <0.1,0.65,0>]
		}

	}
	normal
	{
		bozo scale 0.01
		normal_map
		{
			[0.0 granite scale 0.001]
			[1.0 bozo scale 0.001]
		}
	}
}

#declare t_hedge=
texture
{
	pigment
	{
		bozo scale 0.001
		color_map
		{
			[0.0 rgb <0,0.6,0>]
			[0.6 rgb <0,0.4,0>]
			[1.0 rgb <0.2,0.3,0.1>]
		}
	}
	normal{bozo 3 scale <0.0006,0.0003,0.0006>}
}

#declare f_hedge=function{clip(f_crackle(x*5-0.24,0,z*5-0.25),0.0035,0.011)}

#declare hills1=
isosurface
{
//	function {(y-sin(x*2)*sin(z*2)/5)-f_bozo(x*10,0,z*10)*(y+0.1)/10-f_bozo(x*3,0,z*3)*(y+0.25)/3-f_bozo(x*250,0,z*250)*f_bozo(x*500,0,z*500)/330+clip(f_crackle(x*5,0,z*5),0.0025,0.01)}
	function {(y-sin(x*2)*sin(z*2)/5)-f_bozo(x*10,0,z*10)*(y+0.1)/10-f_bozo(x*3,0,z*3)*(y+0.25)/3-f_bozo(x*250,0,z*250)*f_bozo(x*500,0,z*500)/330+f_hedge(x,y,z)}
	contained_by{box{0,<1.2,0.5,1.2>}}
	max_gradient 11
	texture
	{
		function{f_hedge(x,y,z)}
		texture_map
		{
			[0.009 t_hedge]
			[0.011 t_grass]
		}
	}
//	pigment {Green}
	scale <800,300,800>
	translate <-15,-25,-27>
}

#declare rnd1=seed(153);

#declare wind_farm=
union
{
#declare i=10;
#while(i<700)
#declare j=10;
#declare i2=i+(f_bozo(i,j,10)-0.5)*100;
#while(j<700)
#declare j2=j+(f_bozo(i,j,1)-0.5)*100;
#declare vec=<i2,500,j2>;
#declare vb=trace(hills1,vec,<0,-1,0>);
#if (vb.y<0)
#declare vb=vb*<1,0,1>;
#end
	object {wind_turbine(30+rand(rnd1)*120) rotate <0,180+(f_bozo(i2,j2,3)-0.5)*20,0> translate vb}
#declare j=j+100;
#end
#declare i=i+100;
#end

}

#declare plain=
plane
{
<0, 1, 0>, -1.01
	texture{t_grass scale 800}
	pigment {Red}
}


#declare wool_p=
pigment
{
	bozo scale 0.1
	color_map
	{
		[0.0 Gray60]
		[0.2 Gray90]
		[0.8 Gray90]
		[1.0 rgb <0.9,0.9,0.7>]
	}
}

#declare sheep=
union
{
	sphere
	{
		0,0.9
		pigment	{wool_p}
		normal {bozo 2 scale 0.1}
	}
	sphere
	{
		<-0.9,0.2,0>,0.2
		pigment	{wool_p}
		normal {bozo 2 scale 0.1}
	}
	sphere
	{
		<1,0,0>
		0.5
		normal {granite scale 0.1}
		pigment {Gray40}
	}
	union
	{
		cylinder {<0.25,0,0.15><0.5,-1.25,0.3> 0.05}
		cylinder {<0.25,0,-0.15><0.5,-1.25,-0.3> 0.05}
		cylinder {<-0.25,0,0.15><-0.5,-1.25,0.3> 0.05}
		cylinder {<-0.25,0,-0.15><-0.5,-1.25,-0.3> 0.05}
		pigment {Gray70}
	}
	scale <1.25,1,1>
	translate <0,1,0>
}

#declare rnd5=seed(8765);

#declare flock=
union
{
#declare i=0;
#while(i<100)
#declare i2=350+rand(rnd5)*250;
#declare j2=350+rand(rnd5)*250;
#declare vec=<i2,500,j2>;
#declare vb=trace(hills1,vec,<0,-1,0>);
#if (vb.y<0)
#declare vb=vb*<1,0,1>;
#end
	object {sheep rotate <0,360*rand(rnd5),0> translate vb}
#declare i=i+1;
#end
}


#declare hills=
union
{
	object{hills1}
	object{wind_farm}
	object{flock}
}



