#declare kerb_texture=
texture
{
	pigment {Gray70}
	normal {function{ (f_bumps(x*200,y*200,z*200)+f_bozo(x*40,y*40,z*40))/2} 0.33}
}

#declare rndp=seed(4134);

#macro kerb(len)
#local z1=0.06;
#local y1=0.2;
#local z2=0.1;
#local y2=0.15;
union
{
	box{<0,0,0><len,y1,z1>}
	box{<0,0,0><len,y2,z2>}
	cylinder {<0,0,0><len,0,0> 1 scale <1,y1-y2,z2-z1> translate <0,y2,z1>}
	translate<0,-y1/2,-z2/2>
	rotate<0,180,0>
	translate<len,0,0>
	texture{kerb_texture translate <rand(rndp)*12,0,0>}
}
#end

#macro rkerb(r1)
#local z1=0.06;
#local y1=0.2;
#local z2=0.1;
#local y2=0.15;
#local r2=r1-(z2/2);
union
{
	difference
	{
		union
		{
			cylinder{<0,0,0> <0,y2,0> r2+z2}
			cylinder{<0,0,0> <0,y1,0> r2+z1}
		}
		cylinder{<0,-0.01,0> <0,y1+0.01,0> r2}
	}
	torus { r2+z1, (z2-z1) scale <1,(y1-y2)/(z2-z1),1> translate <0,y2,0> }
	translate<0,-y1/2,0>
	texture{kerb_texture}
}
#end

#declare k_func =
function{(f_bozo(x/2,y/2,z)-0.5)/16}

#macro kerb_run(stx,endx,len,gap,uneven)
union
{
#local tx=stx;
#while((tx+len)<endx)
	object {kerb(len) rotate <(f_bozo(tx,8,0)-0.5)*uneven,0,atan2d(k_func(tx,0,0)-k_func(tx+len,0,0),len)> translate <tx,(f_bozo(tx,0,0)-0.5)/50,(f_bozo(tx,1,0)-0.5)/50>}
#local tx=tx+len+gap;
#end
	object {kerb(endx-tx-gap) translate <tx,0,0>}
}
#end

