#declare road_texture=
texture
{
	crackle scale 0.01
	texture_map
	{
		[0.5 pigment {bozo scale 0.2 color_map {[0.0 Gray40] [1.0 Gray60]}} normal {granite scale 0.025}]
		[0.6 pigment {bozo scale 0.1 color_map {[0.25 rgb <0.94,0.77,0.25>][0.25 rgb <0.9,0.8,0.7>]}}]
	}
}


#declare road_surface =
isosurface
{
	function{y-cos(z/3)/4+f_bozo(x/8,y/8,z/8)/6+(f_bozo(6.5+x,y/2+2,z)-0.5)/10+f_bozo(1+x*30,y*30,z*30)/100}
	max_gradient 1.5
#if(detail=0)
	max_trace 2
#end
	contained_by { box {<-30,-0.21,-4.1> <30,0.235,4.1>}}
	texture{road_texture}
	translate <0,0.25,0>
}

#declare road_dirt=
isosurface
{
	function{y-cos(z/3.1)/4+f_bozo(x/8,y/8,z/8)/6+f_bozo(x/3,y/2+5,z/2)/35}
	contained_by { box {<-30,-0.01,-4.1> <30,0.25,4.1>}}
	pigment
	{
		bozo scale 0.01
		color_map
		{
			[0.0 Gray70]
			[1.0 Gray60]
		}
	}
	normal {bumps 0.01 scale 0.001}
	translate <0,0.21,0>
}

#declare markings =
blob
{
	threshold 0.5
#declare i=0 ;
#while(i<50)
#local vec=<i/10,3,(f_bozo(i,1,2)-0.5)*2>;
//#debug concat(str(vec.x,5,4)," ",str(vec.y,5,4)," ",str(vec.z,5,4),"\n")
#local vi=trace(road_surface,vec,<0,-1,0>);
//#debug concat("=",str(vi.x,5,4)," ",str(vi.y,5,4)," ",str(vi.z,5,4),"\n")
	sphere{ vi 1 0.05}
#declare i=i+1;
#end
	pigment {White}
}

#declare cracks=
union
{
#declare crackh=0;
	object {crack(10,0.2,0.04,0.5, 0.5,5,0.05, 0.1,60,0.0, 7.35,3) rotate<0,5,0> translate <6,crackh,-5>}
	object {crack(10,0.01,0.02,0.5, 0.5,5,0.0, 0.1,60,0.0, 7.36,4.1) rotate<0,5,0> translate <6,crackh,-5>}

	object {crack(10,0.2,0.04,0.5, 0.5,5,0.05, 0.1,60,0.0, 7.35,3) rotate<0,2,0> translate <4,crackh,-5>}
	object {crack(10,0.01,0.02,0.5, 0.5,5,0.0, 0.1,60,0.0, 7.36,4.1) rotate<0,4,0> translate <4.1,crackh,-5>}

	object {crack(10,0.2,0.02,0.5, 0.5,5,0.05, 0.1,60,0.0, 7.75,20) rotate<0,2,0> translate <2,crackh,-5>}
	object {crack(10,0.01,0.01,0.5, 0.5,5,0.0, 0.1,60,0.0, 7.76,23) rotate<0,3,0> translate <2.1,crackh,-5>}

	object {crack(10,0.0,0.05,0.5, 0.5,5,0.05, 0.1,60,0.0, 7.55,8) rotate<0,-10,0> translate <0,crackh,-5>}
	object {crack(10,0.01,0.01,0.5, 0.5,5,0.0, 0.1,60,0.0, 7.56,11) rotate<0,-11,0> translate <0.1,crackh,-5>}

	object {crack(10,0.0,0.05,0.5, 0.5,5,0.05, 0.1,60,0.0, 7.45,2) rotate<0,10,0> translate <-2,crackh,-5>}
	object {crack(10,0.01,0.01,0.5, 0.5,5,0.0, 0.1,60,0.0, 7.46,3) rotate<0,11,0> translate <-2,crackh,-5>}

	object {crack(10,0.05,0.00,0.5, 0.25,5,0.05, 0.1,70,0.0, 7.47,3) rotate<0,-10,0> translate <-4,crackh,-5>}
	object {crack(10,0.01,0.01,0.5, 0.25,5,0.0, 0.1,70,0.0, 7.48,4) rotate<0,-10,0> translate <-4.05,crackh,-5>}

	object {crack(10,0.0,0.05,0.5, 1,5,0.05, 0.1,50,0.0, 8.71,1) translate <0,crackh,-5>}
	object {crack(10,0.02,0.02,0.5, 1,5,0.0, 0.1,50,0.0, 8.721,3) translate <0.1,crackh,-5>}
	
	object {crack(10,0.0,0.05,0.5, 0.75,4,0.05, 0.1,50,0.0, 6.1,4) rotate<0,30,0> translate <-6,crackh,-5>}
	object {crack(10,0.01,0.01,0.5, 0.75,4,0.0, 0.1,50,0.0, 6.11,6) rotate<0,30,0> translate <-6,crackh,-5>}
	
	object {crack(10,0.02,0.02,0.5, 1.2,3,0.0, 0.1,60,0.0, 6.51,6) rotate<0,-10,0> translate <-8,crackh,-5>}
	object {crack(10,0.05,0.01,0.5, 1,5,0.0, 0.1,70,0.0, 6.5,8) rotate<0,2,0> translate <-7.5,crackh,-5>}
	translate<-5,0,0>
	texture{road_texture}
//	pigment {Green}
}

#declare more_grass=
union
{
#declare i=0;
#while(i<20)
#declare gx=(f_bozo(i*4,0,0)-0.5)*40;
#declare vec=trace(road_surface,<gx,2,3.15>,<0,-1,0>);
#if(vec.z>0)
	object{grass(f_bozo(i,gx,1)*30+30,i) scale 0.05+f_bozo(i,0,4)*0.1 translate vec}
#end
#declare i=i+1;
#end

#declare rand1=seed(153);
#declare rand2=seed(531);

#declare i=0;
#while(i<40)
#declare vec=<-10,0.28,rand(rand1)*4-1>;
#while(vec.y!=0)
#declare vec=trace(cracks,vec,<1,0,0>);
//#debug concat(str(vec.x,5,4)," ",str(vec.y,5,4)," ",str(vec.z,5,4),"\n")
#if(vec.y!=0)
#if(rand(rand2)>0.9)
#declare vec2=trace(road_surface,vec+<-0.02,1,0>,<0,-1,0>);
	object{grass(rand(rand2)*30+30,i) scale 0.06+rand(rand2)*0.08 translate (vec*<1,0,1>+vec2*<0,1,0>)}
#declare vec=vec+<1,0,0>;
//	cylinder{vec,vec+<0,1,0>, 0.025 pigment {White}}
//
#end
#declare vec=vec+<0.1,0,0>;
#end
#end
#declare i=i+1;
#end
}

#declare road =
difference
{
	union
	{
		object {road_surface}
//		object {road_dirt}
//		cylinder {<-1.1,0,3.0>,<-1.10,2,3.0> 0.02 pigment {Cyan}}
//		cylinder {<-1.20,0,3.05>,<-1.20,2,3.05> 0.02 pigment {Red}}
//		cylinder {<-1.30,0,3.1>,<-1.30,2,3.1> 0.02 pigment {Yellow}}
//		cylinder {<-1.40,0,3.15>,<-1.40,2,3.15> 0.02 pigment {Green}}
//		cylinder {<-1.50,0,3.2>,<-1.50,2,3.2> 0.02 pigment {Blue}}
//		cylinder {<-1.60,0,3.25>,<-1.60,2,3.25> 0.02 pigment {White}}
		object {more_grass}
	}
	object {cracks}	
}

