
#declare sail_edge =
texture
{
	pigment {White}
	normal {bumps 0.25 scale <0.002,0.01,0.002>}
}

#macro sail(pat)
union
{
#local minx=-2;
#local maxx=2;
#local miny=-1.2;
#local maxy=2.5;
#local minz=-5;
#local maxz=-6;

#declare fn_sail =
function
{
	(cos(atan2(y,x)*24+f_bozo(x*3,y*3,0)*4))*clip(cos(atan2(x,y)*3)+0.5,0,1)*
	clip(sin(f_r(x,y,0)*2.5*(sin(atan2(x,y)*3-pi/2)*0.33+1.0))-pi/8,0,1)/100
	+f_bozo(x*4,y*4,2)/f_r(x*100,y*100,100)
}

#local r_edge = 0.01;
difference
{
	union
	{
#if(detail<1)
		isosurface
		{
			function{max(f_r(x,y,z)-(6.0+fn_sail(x,y,z)),(5.99+fn_sail(x,y,z))-f_r(x,y,z))}
			contained_by{box {<minx,miny,minz> <maxx,maxy,maxz-0.1>}}
		}
#else
		difference
		{
			sphere {0,6}
			sphere {0,5.99}
			clipped_by{box {<minx,miny,minz> <maxx,maxy,maxz-0.1>}}
		}
#end
		union
		{
			torus {5.995,r_edge texture {sail_edge} scale <1,2,1> rotate <-atan2d(miny,maxz),0,0>}
			torus {5.995,r_edge texture {sail_edge} scale <1,2,1> rotate <atan2d(miny,maxz),0,atan2d(maxy-miny,maxx)>}
			torus {5.995,r_edge texture {sail_edge} scale <1,2,1> rotate <-atan2d(miny,maxz),0,atan2d(maxy-miny,minx)>}
			clipped_by{box {<minx-1,miny-1,minz> <maxx+1,maxy+1,maxz>}}
//			pigment {White}	
		}
	}
	union
	{
		box{<minx-1,-2,-7>, <maxx+1,0,0> rotate <180-atan2d(miny-r_edge*2,maxz),0,0> }
		box{<minx-1,-2,0>, <maxx+1,0,7> rotate <atan2d(miny-r_edge*2,maxz),0,atan2d(maxy-miny,maxx)>}
		box{<minx-1,2,0>, <maxx+1,0,7> rotate <-atan2d(miny-r_edge*2,maxz),0,atan2d(maxy-miny,minx)>}
		texture {sail_edge}
	}
#if (detail = 0)
	pigment {rgbft <0.7,0.8,0.9,0.45,0.35>}
	finish
	{
//		specular 0.2
//		phong .75
//	    phong_size 25
//		conserve_energy
//		ambient 0.0
		diffuse 0.6
	}
	normal {crackle 0.05 form <1,-1,1> scale 0.15}
	interior {ior 1.3 fade_distance 1.0 fade_power 2}
	photons
	{
		target
		reflection on
		refraction on
	}
#else
	normal {crackle 0.05 form <1,-1,1> scale 0.15}
	pigment {rgbt 0.5}
//	pigment {Green}
#end
}

union
{
	sphere { 0 r_edge scale <4,4,1.2> translate <0,0,maxz> rotate<atan2d(maxy,-maxz),0,0>}
	sphere { 0 r_edge scale <4,4,1.2> translate <0,0,maxz> rotate<atan2d(miny,-maxz)+0.5,atan2d(maxx,-maxz),0>}
	sphere { 0 r_edge scale <4,4,1.2> translate <0,0,maxz> rotate<atan2d(miny,-maxz)+0.5,atan2d(minx,-maxz),0>}
	pigment {White}
}
}
#end
