 
#declare sh=0.7;
#declare sw=6;
#declare sd=0.2;
#declare st=0.01;
#declare td=0.025;

#declare tube=
union
{
	union
	{
		cylinder{ <-0.5,0,0> <0.5,0,0> 0.025 }
		sphere { <-0.5,0,0> 0.025}
		sphere { <0.5,0,0> 0.025 }
		pigment
		{
			bozo scale 0.25
			color_map{[0.0 White][1.0 Gray70]}
		}
		finish
		{
			phong 0.8 phong_size 250
		}
	}
	cylinder {<-0.575,0,0>, <-0.5,0,0> 0.02 pigment {Gray60}}
	cylinder {<0.575,0,0>, <0.5,0,0> 0.02 pigment {Gray60}}
}

#declare logo_box=
union
{
	difference
	{
		box{ <-sw/2,0,0> <sw/2,sh,sd>}
		box
		{
			<-sw/2+st,st,-st> <sw/2-st,sh-st,sd-st>
			pigment {Gray80}
			normal {dents scale 0.05}
			finish
			{
				ambient 0.1
				diffuse 0.1
				reflection {0.3}
			}
		}
	}
#declare j=sh/5;
#while(j<(4*sh/5))
	object {tube translate <2.1,j,(sd*3/4)>}
	object {tube translate <0.7,j,(sd*3/4)>}
	object {tube translate <-0.7,j,(sd*3/4)>}
	object {tube translate <-2.1,j,(sd*3/4)>}
	object {rope (<1.6,j,sd*3/4> <1.2,j,sd*3/4> f_bozo(0,j,1)/10,0.0075) pigment {Red}}
	object {rope (<-0.2,j,sd*3/4> <0.2,j,sd*3/4> f_bozo(0,j,2)/10,0.0075) pigment {Red}}
	object {rope (<-1.6,j,sd*3/4> <-1.2,j,sd*3/4> f_bozo(0,j,3)/10,0.0075) pigment {Red}}

	object {rope (<1.62,j,sd*3/4> <1.18,j,sd*3/4> f_bozo(0,j,4)/10,0.0075) pigment {Gray10}}
	object {rope (<-0.18,j,sd*3/4> <0.15,j,sd*3/4> f_bozo(0,j,5)/10,0.0075) pigment {Gray10}}
	object {rope (<-1.62,j,sd*3/4> <-1.25,j,sd*3/4> f_bozo(0,j,6)/10,0.0075) pigment {Gray10}}

	object {rope (<1.63,j,sd*3/4> <1.22,j,sd*3/4> f_bozo(0,j,7)/10,0.0075) pigment {Green}}
	object {rope (<-0.23,j,sd*3/4> <0.18,j,sd*3/4> f_bozo(0,j,8)/10,0.0075) pigment {Green}}
	object {rope (<-1.61,j,sd*3/4> <-1.12,j,sd*3/4> f_bozo(0,j,9)/10,0.0075) pigment {Green}}
#declare j=j+sh/4;
#end

	pigment {Gray50}
}


#declare logo=
intersection
{
	union
	{
		cone{ <-0.5,0,0> 0.175 <0.35,0,0> 0.1}
		box{ <0.4,-0.1,-0.1> <0.6,0.1,0.1>}
		cone{ <0.5,-0.15,0> 0.08 <0.5,-0.4,0> 0.12}
		intersection
		{
			box{ <0.2,0.15,-0.1> <0.8,0.5,0.1>}
			cone{ <0.5,0.1,0> 0.1 <0.2,0.5,0> 0}
		}
	}
	box{<-1,-1,0> <1,1,td>}
}

#declare logo_text =
difference
{
	union
	{
		box{ <-sw/2+st,st,0> <sw/2-st,sh-st,st> pigment {rgbf <0.9,0.9,0.9,0.2>}}
		union
		{
			text
			{
				ttf "cyrvetic.ttf" "Red Hammer Oil" td, 0
				scale <0.6,0.4,1>
				translate <-2.6,0.3,-td>
			}
			text
			{
				ttf "cyrvetic.ttf" "Newsagent" td, 0
				scale <0.2,0.15,1>
				translate <-2.6,0.1,-td>
			}
			text
			{
				ttf "cyrvetic.ttf" "Petrol" td, 0
				scale <0.2,0.15,1>
				translate <-1.2,0.1,-td>
			}
			text
			{
				ttf "cyrvetic.ttf" "Diesel" td, 0
				scale <0.2,0.15,1>
				translate <-0.1,0.1,-td>
			}
			text
			{
				ttf "cyrvetic.ttf" "24 Hours" td, 0
				scale <0.2,0.15,1>
				translate <0.9,0.1,-td>
			}
			object {logo scale 0.6 rotate <0,0,25> translate <2.25,0.3,-td>}
			pigment {rgbf <1,0,0,0.2>}
		}
	}
	object {window_break(8,9) scale 0.5 translate <-2.7,0.5,-0.01>}
	object {window_break(5,1) scale 0.5 translate <-2,0.1,-0.01>}
	object {window_break(8,6) scale 0.3 translate <-1.3,0.4,-0.01>}
	object {window_break(6,2) scale 0.33 translate <0,0.2,-0.01>}
	object {window_break(4,3) scale 0.7 translate <0.7,0.5,-0.01>}
	object {window_break(8,2) scale 0.5 translate <1.9,0.3,-0.01>}
	cutaway_textures
}


#declare sign=
union
{
	object{logo_box}
	object{logo_text}
}
