
#declare blade =
union
{
	union
	{
		cone {<0.5,0,0>,1,<8,0,0> 0.75}
		sphere {0,1 scale <0.25,1,1> translate <0.5,0,0>}
		sphere {0,0.75 translate <8,0,0>}
		scale <1.75,0.2,1>
		translate <0,0,0.25>
	}
	cone {<-0.5,0,0> 0.35 ,<2.0,0.0>,0.15}
}

#macro wind_turbine(ang)
union
{
#local wth=27;
	union
	{
		cylinder { 0,<0,wth-1,0> 0.5}
		cone {<0,-1,0>,1.5,<0,1,0>,0.5}
		cone {<0,wth-1,0>,1,<0,wth-2,0>,0.5}
		scale <2,1,1>
	}
	difference
	{
		sphere {0,1.5 scale <3,1,1> translate <0,wth,0>}
		box {<-0.1,-2,-2> <0.1,2,2> translate <-2,wth,0>}
	}
	object{blade translate <1,0,0> rotate <30,ang,90> translate <-3,wth,0>}
	object{blade translate <1,0,0> rotate <30,ang+120,90> translate <-3,wth,0>}
	object{blade translate <1,0,0> rotate <30,ang+240,90> translate <-3,wth,0>}
	finish {phong 0.6 phong_size 150}
	pigment {White}
}
#end
