// File: b_wishes.pov
// Desc: Best wishes for a merry future!
// Date: 15/12/2003
// Auth: Paolo Gibellini
// Oss.: Suggested proportions with camera b: multiples of 320x200
// Ref.: My room was totally modified after reading a news posted by Bob R. POVrookie
/*
 Note:
 Purpose of this file was sending my wishes, therefore comments and variables names 
 are in italian. Here is a partial translation of the terms:
     pavimento = floor
     fiocco = bow
     pacco = parcel
     stanza = room
     albero = tree
     festone = festoon
     renna = reindeer 
 In original version the shape of the reindeer watching at the window was a polygon 
 obtained transforming an old coreldraw shape, but it was heavy to post (1.5 Mb) and
 not significant for overall scene.
*/
//
#version 3.5;

#include "colors.inc"
#include "textures.inc"
#include "woods.inc"


// Impostazioni globali -------------------------------------
global_settings {
  assumed_gamma 1.0
}

media {
    scattering{1, .1 extinction .1}
    //samples 30, 100
    samples 3, 20
    intervals 10
    ratio .999
    confidence .9
    variance 1/10000
}
 
// ----------------------------------------------------------

// Luci -----------------------------------------------------
light_source{ <0, 19, 0> color rgb 0.5 media_interaction off }
light_source{<40, 25, 0> color rgb <1, 1, 1>
     spotlight
     point_at <0, 5, 0>
     radius 20     
     falloff 20
     media_attenuation on
}
// ----------------------------------------------------------

// Camera ---------------------------------------------------
//a
/*
camera {
  location  <14, 4, -8>
  look_at   <8, 1,  2>
  angle 45
} 
*/

//b
camera { 
    location <-3, 5, -8> 
    look_at <4.5, 2, 0> 
    angle 45 
} 
/*  
//c
camera { 
    location <-15, 10, -20> 
    look_at <4.5, 2, 0> 
    angle 45 
}
*/
// ----------------------------------------------------------

// Textures -------------------------------------------------
#declare T_pavimento = texture { 
    T_Wood19 
    finish { specular 0.50 roughness 0.1 ambient 0.25 }
    rotate  <0, 88, 0>
    scale <10,10,10> 
}

#declare T_pavimento_ = texture {
    pigment {
        checker
        color rgb 1
        color blue 1
        scale <5,1,1>
        rotate <0,-20,0>
    }
    finish{
        diffuse 0.8
        ambient 0.1
    }
}

#declare T_pacco = texture {
    //Orange_Glass
    pigment {
        //color rgb <1, 0.84, 0>
        color rgb <1, 0.2, 0>

    }
    normal {
         crackle 0.5
         scale <.3,.3,.3>
    }

}

#declare T_pacco_stelle = texture {
      pigment {
         color rgb <0.752941, 0.752941, 0.752941>
      }   
      finish  {
         ambient 0.1
         diffuse 0.65
         brilliance 1.5
         specular 0.85
         roughness 0.01
         reflection 0.45
      }
}
texture {   
      pigment {
         leopard
         color_map {
            [ 0.0     rgbft <0.501961, 0.25098, 0.25098, 0.0, 0.0> ]
            [ 0.512456  rgbft <0.501961, 0.25098, 0.25098, 0.0, 0.0> ]
            [ 1.0     rgbft <1.0, 1.0, 1.0, 0.0, 1.0> ]
         }
      }   
      scale  <0.1,0.1,0.1>
      translate <0.5,0.5,0.9>
}

#declare T_fiocco = texture {      
         pigment {
            color rgb <1.0, 1.0, 0.501961>
         }      
         finish {
            ambient 0.15
            specular 0.7266
            roughness 0.006139
         }
}

#declare T_pallina = texture {      
     pigment {
        color rgb <1.0, 0, 0>
     }      
     finish {
         ambient 0.1
         diffuse 0.65
         brilliance 1.5
         specular 0.85
         roughness 0.01
         reflection 0.45
     }
}

#declare T_pallina_gialla = texture {      
     pigment {
        color rgb <1.0, 1.0, 0>
     }      
     finish {
         ambient 0.1
         diffuse 0.65
         brilliance 1.5
         specular 0.85
         roughness 0.01
         reflection 0.45
     }
}

#declare T_festone = texture {      
     pigment {
        color White
     }      
}

#declare T_Parati = texture {      
    pigment {
        agate
        agate_turb 0.0
        color_map {
           [ 0.0     rgbft <0, 0.6, 0.9, 0, 0> ]
           [ 0.918149  rgbft <0, 0.6, 0.9, 0, 0> ]
           [ 1.0     rgbft <1, 1, 1, 0, 0> ]
        }
    }      
    rotate -90.0 * y
}

#declare T_tronco = texture {      
     pigment {
        granite
        color_map
        {
           [ 0.0     rgbft <0.780392, 0.607843, 0.211765, 0.0, 0.0> ]
           [ 0.6     rgbft <0.968627, 0.733333, 0.45098, 0.0, 0.0> ]
           [ 0.6     rgbft <0.5, 0.3, 0.2, 0.0, 0.0> ]
           [ 0.65    rgbft <0.5, 0.3, 0.2, 0.0, 0.0> ]
           [ 0.65    rgbft <0.788235, 0.619608, 0.470588, 0.0, 0.0> ]
           [ 1.0     rgbft <0.85, 0.75, 0.35, 0.0, 0.0> ]
        }
     }      
     finish
     {
        ambient 0.1
        specular 0.1
        roughness 0.5
     }
}

#declare T_foglie = texture {      
     pigment {
        leopard
        color_map
        {
           [ 0.0     rgbft <0.3663, 0.5682, 0.0687, 0.82, 0.0> ]
           [ 0.31    rgbft <0.0887, 0.9886, 0.4438, 0.01, 0.0> ]
           [ 0.39    rgbft <0.1308, 0.9083, 0.5524, 0.2, 0.0> ]
           [ 1.0     rgbft <0.1755, 0.5095, 0.448, 0.43, 0.0> ]
        }
        turbulence 0.6
        ramp_wave
     }      
     finish {
        ambient 0.1
        diffuse 0.5
        phong_size 81.0
        //roughness 0.0
     }
}
// ----------------------------------------------------------

// Oggetti --------------------------------------------------
// Pavimento
#declare Pavimento = plane {
  y, -1
  texture {T_pavimento}
}

// Fiocco
#declare Fiocco = union {
    box {<0.8,-1,-2.1> <1.2,2,-2> }
    box {<0.8,-1,0.1> <1.2,2,0> }
    box {<2,-1,-1.2> <2.1,2,-0.8> }
    box {<-0.1,-1,-1.2> <0,2,-0.8> }
    box {<-0.1,2,-1.2> <2.1,2.1,-0.8> }
    box {<0.8,2,-0.1> <1.2,2.1,-2.1> }
    // Riccioli
    sphere_sweep {
      linear_spline                 
      4,                            
      <1, 2, -1>, 0.1               
      <0.4, 2.2, -1.1>, 0.1         
      < 0.6, 2.4, -1.2>, 0.1
      < 1, 2.2, -1>, 0.1
    }
    sphere_sweep {
      linear_spline                 
      4,                            
      <1, 2, -1>, 0.1               
      <1.6, 2.3, -0.8>, 0.1         
      < 1.4, 2.6, -0.9>, 0.1
      < 1, 2.2, -1>, 0.1
    }
    texture { T_fiocco}
}

// Pacco dono 
#declare Pacco = box { 
    <0, -1, -2>, <2, 2,  0>
    texture {T_pacco_stelle} 
}
           
// Stanza
#declare Stanza=union{
    difference{
        box{ <-21, -1, -21>, <21, 21, 21> }
        box{ <-20, 0, -20>, <20, 20, 20> }
        box{ <19.9, 5, -3>, <21.1, 15, 3> }
    }
    box{ <20, 5, -0.25>, <21, 15, 0.25> }
    box{ <20, 9.775, -3>, <21, 10.25, 3> }
    texture {T_Parati}
}

// Albero
#declare Albero = union {
    // Variabili per macrizzare il tutto se serve
    #local basey=8;       
    #local basex=2.5;
    #local teta=atan(basey/basex); // Angolo del cono
    #local py=0.25;
    #local palfa=45*pi/180;
    // Cono
    cone {
        <0,0,0>, 2, <0,basey,0>, 0
        texture {T_foglie}
        translate <0,2,0>
    }
    // Base
    cylinder {
        <0,0,0>,<0,2,0>,0.5
        texture {T_tronco}
    }
    // Festone
    sphere_sweep {           
        #declare nodi=30;
        linear_spline                 
        nodi,
        // aggiunge i nodi alla spline
        #local n=1; // step
        #declare h=basey;
        //#while (h>0) 
        #while (nodi>0) 
            #declare h=basey-n*py;
            #local ro=h/tan(teta);
            #local alfa=n*palfa;
            #local x1=ro*cos(alfa);
            #local y1=n*py;
            #local z1=ro*sin(alfa);
            #local n=n+1;        
            #declare nodi=nodi-1;
            #if (h<=0) 
                #declare nodi=0;
            #end
            <x1,y1,z1>, 0.2
        #end
        // fine aggiunta nodi
        texture {T_festone}                     
        translate <0,2,0>
    }
    // Palline
    #local n=1; // step
    #declare h=basey;
    #while (h>0) 
        #declare h=basey-n*py;
        #local ro=h/tan(teta)-0.5;
        #local alfa=n*palfa+pi;
        #local x1=ro*cos(alfa);
        #local y1=n*py;
        #local z1=ro*sin(alfa);
        #local n=n+2;        
        sphere { <x1, y1, z1> 0.5 texture {T_pallina} translate <0,2,0>}
    #end
    superellipsoid {
        <0.1, 1.0>
        texture {T_pallina_gialla}
        rotate <0,0,45> 
        translate <0,basey+1.5,0>
    }    
}

// Renna di Babbo Natale che spia alla finestra
//#include "renna.inc"
#declare Renna = polygon {
    12, 
    <0, 0>, <0, 6>, <4, 6>, <4, 3>, <1, 3>, <1, 0>, <0, 0>, <1, 4>, <1, 5>, <3, 5>, <3, 4>, <1, 4>
}


// ----------------------------------------------------------

// Assemblaggio scena --------------------------------------- 
object {Pavimento}
object {
    Pacco
    rotate <0,20,0>
    translate <8,0,0>
}
object {
    Fiocco
    rotate <0,20,0>
    translate <8,0,0>
}
object {
    Albero
    translate <8,-2,8>
}
object {
    Stanza
    translate <0,-1.5,0>
}
object {
    Renne             
    rotate <0,90,0>
    translate <42,22,4>
    scale <0.5,0.5,0.5>
}
// ----------------------------------------------------------
