// render as 800x800

#declare DRAFT=0;

//#if (DRAFT)
  #declare small_tree_13_leaf = object { 
    disc { <0,0,0>,<0,0,-1>,0.5 }
    pigment { color rgb <0,0.6,0> }
    translate 0.5*y scale <0.1,0.15,0.1>
  }
//#else
  #declare small_tree_13_leaf = object { 
    disc { <0,0,0>,<0,0,-1>,0.5 }
    texture {
      pigment {
        image_map {
          png "blatt1.png"
          once
          map_type 0
	  filter all 0.2
        }
        translate <-0.5, -0.5, 0>
      }
      finish {
        ambient 0.4 // 0.4
	diffuse 0.5
	// phong 20
	// specular 0.3
	//reflection 0.2        
      }
      normal {
        bumps 0.2 scale 0.02
      }
    }
    translate 0.5*y scale <0.1,0.15,0.1> 
  }
//#end  

#if (DRAFT)
  //#include "quaking_aspen.inc"
  #include "small_tree2.inc"
  //#include "wild_tree.inc"
  #declare ZUNITS=4;
  #declare WASSER=1;
  #declare PFLASTER=0;
#else
  #include "quaking_aspen.inc"
  #include "small_tree2.inc"
  #include "wild_tree.inc"
  #declare ZUNITS=100;
  #declare WASSER=1;
  #declare PFLASTER=1;
#end

#include "functions.inc"
#declare UNIT=13;

background {rgb <0.95,0.95,0.9>}
light_source { <5000,5000,-3000>, rgb 1.2 }
light_source { 0.75*<UNIT*5,UNIT*5,UNIT*(2+1/6)-UNIT*3>, rgb 0.8
  //shadowless 
  spotlight
  radius 0.7
  falloff 1
  point_at <0, small_tree_13_scale*2*0.5, UNIT*(2+1/6)+0.5>
  fade_distance UNIT*0.795*7.5
  fade_power 1000 
}
light_source { <-5000,2000,3000>, rgb 0.5 shadowless }


#declare R = seed(13);
#declare R1 = seed(17);

camera {
  perspective
  location <0.1,2,UNIT+0.9*UNIT>
  up <0,2*UNIT,0>
  right <2*UNIT,0,0>
  direction <0,0,UNIT>
  sky <0.2,UNIT,0>
  look_at <0.1,2.1,UNIT+1*UNIT>
}


#if (DRAFT)
  #declare Beton = texture { pigment { color rgb 0.9 } }
#else
  #declare Beton =   
    texture {
      pigment {
        granite
        color_map {
          [ 0 color rgb <0.81, 0.81, 0.79> ]
          [ 0.3 color rgb <0.75, 0.74, 0.72> ]
          [ 0.7 color rgb <0.81, 0.81, 0.79> ]
          [ 0.8 color rgb <0.09, 0.09, 0.08> ]
        }
        scale 0.4
     }
     normal { bumps 0.4 scale 0.01 }
     finish {
       reflection 0.1
     }
  }
#end

#if (DRAFT)
  #declare Wasser = material { 
    texture { pigment { color rgbf <0.5,0,0,0.8> } } 
  }
#else
/*  #declare Wasser = texture {
    pigment { color rgbf 0.99 }
    normal {
      wood 0.1
      rotate y*90
      translate z*(-1000)
      scale 0.1
   
      warp {
        turbulence <0.05, 0.05, 0.3>
        octaves 4
        lambda 1.5
      }
    }
    finish {
	// ambient .2
        diffuse .2
        brilliance 8
        specular .6
        roughness .001
        reflection .8
    }
  }
*/
  #declare T_Wasser =
    texture {
      pigment{ rgbf <0.6, 0.6, 0.6, 0.9> }
      normal {
        ripples 0.5 // 0.75
        frequency 10
        scale <2,1,2>
    }
    finish {
      reflection {0.3, 1 fresnel}
      conserve_energy
    }
  }
  #declare I_Wasser =
    interior {
      ior 1.33
    }
  #declare Wasser =
    material {
      texture {T_Wasser}
      interior {I_Wasser}
  }

#end

#declare Platte = 
 isosurface {
    function { y+1 - f_noise3d(x/2,0,z/2) -
      f_noise3d(x*100,0,z*100)*0.05 }
#if (DRAFT)
    accuracy 0.01
    max_gradient 2
#else
    accuracy 0.001
    max_gradient 10
#end
    contained_by { 
      box { <0,-2,0>,<UNIT/3-0.05,1,UNIT/3-0.05> } 
    }

    texture { Beton }

    scale <1,0.1,1>
  }
/*
  box { <0,-0.1,0>,<UNIT/3-0.05,0.1,UNIT/3-0.05> 
    pigment { Beton }
  }
*/

#declare Platten =
  function {
    pattern {
      brick 
      brick_size <UNIT/3,1,UNIT/3> 
      mortar 0.05
    }
  }

#declare Pflaster = 
  isosurface {
    function { y + 1 - Platten(x,0,z) - f_noise3d(x/5,0,z/5) }
#if (DRAFT)
    accuracy 0.1
    max_gradient 2
#else
    accuracy 0.001
    max_gradient 10
#end
    contained_by { 
      box { <-ZUNITS*UNIT,-2,0>,<ZUNITS*UNIT,1,ZUNITS*UNIT> } 
    }

    texture { Beton }

    scale <1,0.1,1>
}

#declare Pfuetzen = 
  box { <-ZUNITS*UNIT,-1,0>, <ZUNITS*UNIT,0.04,ZUNITS*UNIT>
    material { Wasser }
    translate UNIT*2*z
  }

#declare Ring = 
  difference {
    union {
      cone { <UNIT/6,0,UNIT/6>, UNIT*0.095, <UNIT/6,0.4,UNIT/6>,
                           UNIT*0.09 }
      cone { <UNIT/6,0.399,UNIT/6>, UNIT*0.09, <UNIT/6,0.42,UNIT/6>,
                           UNIT*0.087 }
    }
    cylinder { <UNIT/6,-0.1,UNIT/6>, <UNIT/6,0.5,UNIT/6>, UNIT*0.07}
    box { <0,-0.1,UNIT/6-0.02>, <UNIT/3,0.5,UNIT/6+0.02> }
 
    translate <UNIT*0.33,0,UNIT*0.33>
    texture { Beton }
  }


// -----  trees ------
#declare M=1;
#while (M < ZUNITS)
  #declare N=0;
  #while (N<2*M)

#if (DRAFT)
    cone {<0,0,0>,0.1,<0,13,0>,0.05 
      translate <UNIT*(-M+0.5+N),0,UNIT*(0.5+M)>
      pigment {color rgb 0.9}
    }
#else
   #if (M>1)
       object { 
         quaking_aspen_13_stems
	 rotate rand(R)*360*y
	 translate <UNIT*(-M+0.5+N),0,UNIT*(0.5+M)>
	 pigment {color rgb 0.9} 
       }
    #end
#end

      object { Ring translate <UNIT*(-M+N),0,UNIT*(M)> }	      
    
     #declare N=N+1;
  #end
  #declare M=M+1;
#end

#if (PFLASTER)
  object { Pflaster texture { Beton } translate UNIT*(2+1/3+1/6)*z }
#end

box { <-ZUNITS*UNIT,-0.3,0>,<ZUNITS*UNIT,-0.2,(ZUNITS+2)*UNIT> 
    pigment { color rgb 0.3 } 
    } 

// hinten links
object { 
  Platte 
  rotate <3,0.3,5> 
  translate <-UNIT/3-0.01,+0.04,UNIT*(2+1/6)> 
}

// hinten ganz links
object { 
  Platte 
  translate <-2*UNIT/3-0.02,0.1,UNIT*(2+1/6)> 
}

// hinten rechts
object { 
  Platte 
  rotate <2,-1,-1>
  translate <0,0.12,UNIT*(2+1/6)-0.03> 
}

// hinten ganz rechts
object { 
  Platte 
  translate <UNIT/3+0.01,0,UNIT*(2+1/6)> 
}

// vorn links
object { 
  Platte 
  rotate <-1,-3,0>
  translate <-UNIT/3+0.22,+0.0,UNIT*(2-1/6)-0.2> 
}

// vorn rechts
object { 
  Platte 
  rotate <-0.5,0,-1>
  translate <0,0.05,UNIT*(2-1/6)-0.03> 
}

#if (WASSER)
  object { Pfuetzen }
  object { small_tree_13_leaf scale 2 
    rotate <89.99,49,0> 
    translate <UNIT/13,0.04,UNIT*(2+1/6)-1.3> 
  }
  object { small_tree_13_leaf scale 2 
    rotate <92,-35,0> 
    translate <-UNIT/39,0.05,UNIT*(2+1/6)-0.8> 
  }
  #declare i=0;
  #while (i<13) 
      #declare X_ = (-UNIT/3+1.4)*rand(R1);
      #declare Y_ = small_tree_13_scale*1.8 + X_*(UNIT/3/6 - 0.3) // -0.1;
        + 0.3*(rand(R1)-0.5);
      #declare Z_ = UNIT*(2+1/6) + 0.3*rand(R1)-0.5 + X_*(UNIT/36 );
      object { small_tree_13_leaf scale 2 
        rotate <rand(R1)*360,rand(R1)*360,rand(R1)*360> 
        translate <X_-0.2,Y_,Z_> 
      }
    #declare i=i+1;
  #end
#end

#declare gr = color rgbf <0.2,0.4,0.6,0.2>; // <0.2,0.8,0.4>

#declare Gruen1 = 
  pigment {
    crackle
    color_map {
      [ 0 color rgb   <0.1, 0.3, 0.1>*0.3 ]
      [ 0.1 color rgb <0.2, 1, 0.1> ]
    }
    scale 0.03
  }

#declare Gruen2 =
  pigment {
    bozo
    color_map {
      [ 0.3 color rgb gr*0.05 ]
      [ 0.4 color rgb gr*0.5 ]
//      [ 0.6 color rgb gr*1.2 ]
      [ 0.62 color rgb gr*1.4 ]
      [ 0.77 color rgb gr*2.4 ]
      [ 0.78 color rgb 2.5 ]
    }
    scale 0.08
  }

/*
cylinder {
	 <0.5,0,0>,<0.5,small_tree_13_scale*3,0>,1
	 translate <-0.05,0,UNIT*(2+1/6)+0.3>
	 pigment { color rgbt 0.4 }
}
*/

// ---- the small tree ----
#declare br = color rgb <0.7,0.6,0.4>; // <0.8,0.6,0.2>;
union { 
  object { 
    small_tree_13_stems
    texture {
     // pigment { color rgb br*0.5 }
      pigment {
        bozo
        color_map {
          [ 0.3  color rgb br*0.2 ]
	  [ 0.4  color rgb br*0.8 ]
          [ 0.8  color rgb br*1.0 ]
          [ 0.82 color rgb br*1.2 ]
         }
        scale <0.01,0.2,0.01>
	translate 0.2*y
      }
      finish { ambient 0.6 } //0.6 }
    }
  }
  object { 
    small_tree_13_leaves
/*    texture { 
      pigment {
        average 
        pigment_map {
          [0.4 Gruen1]
          [0.7 Gruen2]
        }
	translate -0.1*x
      }
      finish {
        ambient 0.2 // 0.4
      }
      normal {
        bumps 0.2 scale 0.02
      }
    }
*/ 
  }
  no_shadow
  rotate -90*y
  scale 2
  translate  <-0.05,0,UNIT*(2+1/6)+0.3>
}

#if (! DRAFT)
// ---- the shadow of the tree ----
union { 
  object { 
    wild_tree_13_stems
  }
  object { 
    wild_tree_13_leaves
  }
  pigment {color rgb 0.8} 

  rotate 40*y
  scale 3
  translate  <-0.35,0,UNIT*(2+1/6)+0.1>
  translate  <UNIT*5,UNIT*5,-UNIT*3>
}
#end













