#include "functions.inc"
                                           
// Sphere as blob component                                           
#macro ball(ballRadius,blobStrength,translationVector,rotationVector)                  
  sphere{
    <0,0,0>,
    ballRadius,
    blobStrength
  	translate translationVector
  	rotate rotationVector
  }
#end

// Quadratic on its side, to get ball shape
#declare f = function(yval) { 0.7*(yval-0.8)*(yval-0.8) - 0.2*(yval-0.8) + 0.8 -x } 
#declare sizeRed = function(ringRadius,totRadius) { ringRadius/totRadius }             
    
// A ring of balls                    
#macro ballring(numberOfBalls,BallSize,radiusOfRing,h)                    
  blob {         
    threshold 0.2
    #local Hr = 0;
    #local EndHr = 12;
    #local hps = 0.12;
    #while (Hr< EndHr) 
      #local Nr = 0;     // start
      #local EndNr = numberOfBalls; // end
      #while (Nr< EndNr) 
        //object{ ball(s) translate<r,s+h,0> rotate<0,Nr * 360/EndNr,0>} 
        //ball(s,0.5,<r,s+hps*Hr,0>,<0,Nr * 360/EndNr,0>)
        #local ballX = f(BallSize+hps*Hr);
        #local ballSize = BallSize*sizeRed(ballX,radiusOfRing);
        #local ballY = ballSize+hps*Hr;
        ball(ballSize,0.5,<ballX,ballY,0>,<0,Nr * 360/EndNr+2*Hr,0>)
        #local Nr = Nr + 1;    // next Nr
      #end // ---------------  end of loop   
      #local Hr = Hr + 1;    // next Nr
    #end  
  } // end of union
#end  

#declare pearlstand =                                
object { 
  ballring(40,0.115,1,0) 
 	texture{
 	  pigment{color rgb<1,1,0.8>}
 	  finish {    
 	    brilliance 1.0
 	    irid { 
 	      0.4
 	      thickness 0.05
 	      turbulence 5
 	    }                  
 	    reflection 0.4
 	    ambient 0.2 
 	    diffuse 0.8 
 	    phong 1 
 	    phong_size 80       
 	  }
	}
  interior { ior 1.5 }
}   


  