#include "rand.inc"

#include "colors.inc"
#include "stones1.inc"

#declare r1 = seed(1999);        
#declare r2 = seed(1);        
#declare r3 = seed(12345);        
#declare r4 = seed(19);        
#declare r5 = seed(1921);        
                
#macro R(strm,a,b)                               
  rand(strm)*(b-a) + a    
#end
                           
  
#macro oneBrick(blockWidth,blockHeight,blockThickness)   
     
#local sphereMinRadius = 11.9;
#local sphereMaxRadius = 12;

#local blockWidthRes = ceil(blockWidth / (sphereMinRadius - 5));     
#local blockHeightRes = ceil(blockHeight / (sphereMinRadius - 5));
#local blockThicknessRes = ceil(blockThickness / (sphereMinRadius - 5));       


blob {
  threshold 1
  #local NrX = 0;    // start x
  #while (NrX < blockWidthRes) 
    
    #local NrY = 0;    // start y 
    #while (NrY < blockHeightRes) 
       
       #local NrZ = 0;     // start z
       #while (NrZ < blockThicknessRes) 
       
       sphere { 
         <0,0,0>
         R(r1,sphereMinRadius,sphereMaxRadius)
         R(r2,5,15)  
         translate<NrX*(blockWidth/(blockWidthRes - 1))+R(r4,-1,1), 
                   NrY*(blockHeight/(blockHeightRes - 1))+R(r4,-1,1), 
                   NrZ*(blockThickness/(blockThicknessRes - 1))+R(r4,-1,1)>
       } 
  
       #local NrZ = NrZ + 1;  // next Nr z
       #end // --------------- end of loop z
       
    #local NrY = NrY + 1;  // next Nr y
    #end // --------------- end of loop y
    
  #local NrX = NrX + 1;  // next Nr x
  #end // --------------- end of loop x
  
  
  pigment { 
    bozo
    color_map { 
      [0.1 color rgb <0.5,0.5,0.5> ]
      [0.3 color rgb <0.7,0.7,0.7> ]
      [0.35 color rgb <0.8,0.8,0.8> ]
      [0.4 color rgb <0.6,0.6,0.6> ]
      [0.9 color rgb <0.7,0.7,0.7> ]
      
    } 
    sine_wave
    scale 0.4           
    turbulence 0.4
  }
  
  normal { 
     bozo 0.3 sine_wave no_bump_scale scale 0.4 turbulence 0.4
  }
 
  translate <-(blockWidth + 2*sphereMaxRadius)/2, -(blockHeight + 2*sphereMaxRadius)/2, -(blockThickness + 2*sphereMaxRadius)/2>
  scale <blockWidth/(blockWidth + sphereMaxRadius), blockHeight/(blockHeight + sphereMaxRadius), blockThickness/(blockThickness + sphereMaxRadius)>
  translate <blockWidth/2, blockHeight/2, blockThickness/2> 

  
} // end of blob                                    
#end
