#include "stonewall\stonebrick.inc"
#include "math.inc"
            
#declare r1 = seed(1999);        
#declare r2 = seed(1);        
#declare r3 = seed(12345);        
#declare r4 = seed(19);        
#declare r5 = seed(1921);        
                



#macro R(strm,a,b)                               
  rand(strm)*(b-a) + a    
#end




#macro wallOfBricks(wallWidth,     wallWidthRes,     wallSpaceWidth, 
                    wallHeight,    wallHeightRes,    wallSpaceHeight,
                    wallThickness, wallThicknessRes, wallSpaceThickness)

   union {

      #local brickWidth     = (wallWidth / wallWidthRes)         - wallSpaceWidth;
      #local brickHeight    = (wallHeight / wallHeightRes)       - wallSpaceHeight;
      #local brickThickness = (wallThickness / wallThicknessRes) - wallSpaceThickness; 
      
      #local currentZ = 0;
      #local nrZ = 0;    // start z loop (thickness)
      #while (nrZ < wallThicknessRes) 
         
         #local currentY = 0;
         #local nrY = 0;    // start y loop (height)    
         #while (nrY <  wallHeightRes)            

            #local currentX = 0;
            
            #if (odd(nrY))
            
               #local nrX = 0;     // start x loop (width)
               #while (nrX < wallWidthRes)               
                  
                  object {          
         
                     oneBrick(brickWidth,brickHeight,brickThickness)
                     translate<currentX, currentY, currentZ>
             
                  }                   
                 
                  #local currentX = currentX + brickWidth + wallSpaceWidth * R(r3, 0.95, 1.05);
                  #local nrX = nrX + 1;  // next NrX
                  
               #end //while nrX              
               
            #else
            
               #local nrX = 0;     // start x loop (width)
               #while (nrX < (wallWidthRes + 1))
                                 
                  #if (nrX = 0)                 
                     object {          
            
                        oneBrick(0.5*brickWidth, brickHeight, brickThickness)
                        translate<currentX, currentY, currentZ>
                
                     }                     
                     
                    #local currentX = currentX + 0.5*brickWidth + wallSpaceWidth * R(r3, 0.95, 1.05);
                    #local nrX = nrX + 1;  // next NrX                    
                  #else                    
                     #if (nrX = wallWidthRes)
                        object {          
               
                           oneBrick(0.5*brickWidth, brickHeight, brickThickness)
                           translate<currentX, currentY, currentZ>
                   
                        }                     
                        
                       #local currentX = currentX + 0.5*brickWidth + wallSpaceWidth * R(r3, 0.95, 1.05);
                       #local nrX = nrX + 1;  // next NrX                                          
                     #else
                        object {          
               
                           oneBrick(brickWidth, brickHeight, brickThickness)
                           translate<currentX, currentY, currentZ>
                   
                        }                     
                        
                       #local currentX = currentX + brickWidth + wallSpaceWidth * R(r3, 0.95, 1.05);
                       #local nrX = nrX + 1;  // next NrX                                         
                     #end //else
                  #end // if                                                   
                                
               #end //while nrX
            #end   //if odd
                                              
            #local currentY = currentY + brickHeight + wallSpaceHeight * R(r3, 0.95, 1.05);
            #local nrY = nrY + 1;  // next NrY
         
         #end //while nrY
         
         #local currentY = currentZ + brickThickness + wallSpaceThickness * R(r3, 0.95, 1.05);
         #local nrZ = nrZ + 1;  // next NrX
      
      #end //while nrZ      

   } // end of union
#end



#macro wallOfBricksWindow(wallWidth,         wallWidthRes,     wallSpaceWidth, 
                          wallHeight,        wallHeightRes,    wallSpaceHeight,
                          wallThickness,     wallThicknessRes, wallSpaceThickness,
                          windowWidthStart,  windowWidthEnd,
                          windowHeightStart, windowHeightEnd)

   union {

      #local brickWidth     = (wallWidth / wallWidthRes)         - wallSpaceWidth;
      #local brickHeight    = (wallHeight / wallHeightRes)       - wallSpaceHeight;
      #local brickThickness = (wallThickness / wallThicknessRes) - wallSpaceThickness; 
      
      #local currentZ = 0;
      #local nrZ = 0;    // start z loop (thickness)
      #while (nrZ < wallThicknessRes) 
         
         #local currentY = 0;
         #local nrY = 0;    // start y loop (height)    
         #while (nrY <  wallHeightRes)            

            //Check if inside window on y axis
            #if (nrY >= windowHeightStart)
               #if (nrY <= windowHeightEnd)
                  #local windowY = 1;
               #else
                  #local windowY = 0;
               #end          
            #else
               #local windowY = 0;
            #end            
            
            #local currentX = 0;
            
            #if (odd(nrY))
            
               #local nrX = 0;     // start x loop (width)
               #while (nrX < wallWidthRes)               
                  

                  //Check if inside window on x axis
                  #if (nrX >= windowWidthStart)
                     #if (nrX <= windowWidthEnd)
                        #local windowX = 1;
                     #else
                        #local windowX = 0;
                     #end          
                  #else
                     #local windowX = 0;
                  #end

                  //Check if inside window               
                  #if (windowX = 1)
                     #if (windowY = 1)
                        #local inWindow = 1;
                     #else
                        #local inWindow = 0;
                     #end
                  #else
                     #local inWindow = 0;
                  #end               

                  #if (inWindow = 0)
                     object {          
            
                        oneBrick(brickWidth,brickHeight,brickThickness)
                        translate<currentX, currentY, currentZ>
                
                     }                   
                  #end
                 
                  #local currentX = currentX + brickWidth + wallSpaceWidth * R(r3, 0.95, 1.05);
                  #local nrX = nrX + 1;  // next NrX
                  
               #end //while nrX              
               
            #else
            
               #local nrX = 0;     // start x loop (width)
               #while (nrX < (wallWidthRes + 1))
                                 
                  //Check if inside window on x axis
                  #if (nrX >= windowWidthStart)
                     #if (nrX <= windowWidthEnd)
                        #local windowX = 1;
                     #else
                        #local windowX = 0;
                     #end          
                  #else
                     #local windowX = 0;
                  #end

                  //Check if inside window               
                  #if (windowX = 1)
                     #if (windowY = 1)
                        #local inWindow = 1;
                     #else
                        #local inWindow = 0;
                     #end
                  #else
                     #local inWindow = 0;
                  #end               

                  #if (nrX = 0) //first brick is a half
                     #if (inWindow = 0)              
                        object {          
               
                           oneBrick(0.5*brickWidth, brickHeight, brickThickness)
                           translate<currentX, currentY, currentZ>
                   
                        }
                     #end                     
                     
                    #local currentX = currentX + 0.5*brickWidth + wallSpaceWidth * R(r3, 0.95, 1.05);
                    #local nrX = nrX + 1;  // next NrX                    
                  #else                    
                     #if (nrX = wallWidthRes) //last brick is a half
                        
                        #if (nrX = (windowWidthEnd + 1))
                           #if (windowY = 1)
                              //Draw nothing
                           #else                       
                              object {          
                     
                                 oneBrick(0.5*brickWidth, brickHeight, brickThickness)
                                 translate<currentX, currentY, currentZ>
                         
                              }
                           #end
                        #else                     
                           object {          
                  
                              oneBrick(0.5*brickWidth, brickHeight, brickThickness)
                              translate<currentX, currentY, currentZ>
                      
                           }                        
                        #end
                        
                       #local currentX = currentX + 0.5*brickWidth + wallSpaceWidth * R(r3, 0.95, 1.05);
                       #local nrX = nrX + 1;  // next NrX                                          
                     #else
                        #if (inWindow = 1)
                           #if (nrX = windowWidthStart)
                              object {          
                     
                                 oneBrick(0.5*brickWidth, brickHeight, brickThickness)
                                 translate<currentX, currentY, currentZ>
                         
                              }
                           #else
                              //Draw nothing
                           #end                     
                        #else
                           #if (nrX = (windowWidthEnd + 1))
                              #if (windowY = 1)
                                 #local currentX = currentX + 0.5*brickWidth;   
                                 
                                 object {          
                        
                                    oneBrick(0.5*brickWidth, brickHeight, brickThickness)
                                    translate<currentX, currentY, currentZ>
                            
                                 }
                                 
                                 #local currentX = currentX - 0.5*brickWidth;
                              #else
                                 object {          
                        
                                    oneBrick(brickWidth, brickHeight, brickThickness)
                                    translate<currentX, currentY, currentZ>
                            
                                 }                                                   
                              #end                              
                           #else
                              object {          
                     
                                 oneBrick(brickWidth, brickHeight, brickThickness)
                                 translate<currentX, currentY, currentZ>
                         
                              }                     
                           #end
                        #end
                       
                        
                        #local currentX = currentX + brickWidth + wallSpaceWidth * R(r3, 0.95, 1.05);
                        #local nrX = nrX + 1;  // next NrX                                         
                     #end //else
                  #end // if                                                   
                                
               #end //while nrX
            #end   //if odd
                                              
            #local currentY = currentY + brickHeight + wallSpaceHeight * R(r3, 0.95, 1.05);
            #local nrY = nrY + 1;  // next NrY
         
         #end //while nrY
         
         #local currentY = currentZ + brickThickness + wallSpaceThickness * R(r3, 0.95, 1.05);
         #local nrZ = nrZ + 1;  // next NrX
      
      #end //while nrZ      

   } // end of union
#end

