#include "rand.inc"

#include "colors.inc"
#include "stones1.inc"

// perspective (default) camera
camera {
  location  <-20.0, 100.0, -300.0>
  look_at   <0.0, 10.0,  10.0>
  right     x*image_width/image_height
}

// create a regular point light source
light_source {
  0*x                  // light's position (translated below)
  color rgb <1,1,1>    // light's color
  translate <-200, 300, -500>
}                          

// create a regular point light source
light_source {
  0*x                  // light's position (translated below)
  color rgb <1,1,1>    // light's color
  translate <-300, 300, -100>
}                          
        
#declare r1 = seed(1999);        
#declare r2 = seed(1);        
#declare r3 = seed(12345);        
#declare r4 = seed(19);        
#declare r5 = seed(1921);        
                
#macro R(strm,a,b)                               
  rand(strm)*(b-a) + a    
/*  #declare midpoint = (b-a)/2;
  #declare ans = Rand_Gauss(midpoint, midpoint/2, strm);
  #if (ans<a)
    #declare ans=a;
  #end
  
  #if (ans>b)
    #declare ans=b;
  #end
 
  #if (ans<midpoint)
    #declare ans = (1- (ans-a)/(midpoint - a))*(midpoint-a)+a;
  #end
  #if (ans>midpoint)
    #declare ans = (1- (ans-midpoint)/(b - midpoint))*(b-midpoint)+midpoint;
  #end
  ans
*/  
#end

#declare blockWidth = 30;
#declare blockHeight = 20;
#declare blockThickness = 20;             
#declare sphereMinRadius = 5.8;
#declare sphereMaxRadius = 6;                            

/*                       
blob {
  threshold 1
  #local counter = 1;
  #while (counter < 100)        
     #local sphereRadius = R(r1,sphereMinRadius, sphereMaxRadius); 
     #declare spherePosX    = R(r2,0+sphereRadius,blockWidth-sphereRadius);
     #declare spherePosY    = R(r3,0+sphereRadius,blockHeight-sphereRadius);
     #declare spherePosZ    = R(r4,0+sphereRadius,blockThickness-sphereRadius);
     #declare strengthValue = R(r1,10,15);
     //#debug concat("sphere { <",str(spherePosX,5,2),",")
     //#debug concat(str(spherePosY,5,2),",",str(spherePosZ,5,2),">,")
     //#debug concat(str(sphereRadius,5,2),",",str(strengthValue,5,2),"}\n")
     sphere { <spherePosX,spherePosY,spherePosZ>, sphereRadius, strengthValue } 
     #local counter = counter+1; 
  #end                                      
  pigment { 
    bozo
    color_map { 
      [0.1 color rgb <0.8,0.8,0.8> ]
      [0.3 color rgb <0.7,0.7,0.7> ]
      [0.35 color rgb <0.5,0.5,0.5> ]
      [0.4 color rgb <0.6,0.6,0.6> ]
      [0.9 color rgb <0.7,0.7,0.7> ]
    }                            
    scale 0.2           
    turbulence 0.4
  }
  normal { bozo 1 scale 0.2 turbulence 0.4 }
}  
*/
 

blob {
  threshold 3
  #declare NrX = 0;    // start x
  #declare EndNrX = 20; // end   x
  #while (NrX< EndNrX) 
    // more inner loop
    #declare NrY = 0;    // start y 
    #declare EndNrY = 20; // end    y
    #while (NrY< EndNrY) 
       // innerst loop
       #declare NrZ = 0;     // start z
       #declare EndNrZ = 32; // end   z
       #while (NrZ< EndNrZ) 
       
       sphere { <0,0,0>,R(r1,2,3),R(r2,5,15)  
         translate<NrX*2 NrY*2 NrZ*2>
       } 
  
       #declare NrZ = NrZ + 1;  // next Nr z
       #end // --------------- end of loop z
       // end innerst loop
    #declare NrY = NrY + 1;  // next Nr y
    #end // --------------- end of loop y
    // end more inner loop
  #declare NrX = NrX + 1;  // next Nr x
  #end // --------------- end of loop x
  // end of outer loop
  /*
  pigment { 
    bozo
    color_map { 
      [0.1 color rgb <0.8,0.8,0.8> ]
      [0.3 color rgb <0.7,0.7,0.7> ]
      [0.35 color rgb <0.65,0.65,0.65> ]
      [0.4 color rgb <0.6,0.6,0.6> ]
      [0.9 color rgb <0.7,0.7,0.7> ]
    }                            
    scale 0.8           
    turbulence 0.4
  }
  normal { bozo 1 scale 0.4 turbulence 0.8 }
  finish { specular 0.1 roughness 0.01 }
  */
  texture {
    T_Stone13
    scale 15
    
    finish { 
      specular 0.1
      roughness 0.1
      phong 0
    }
  }
  rotate<0,-30,0> 
  translate<0,0.2,0>
} // end of union
