// ==== Standard POV-Ray Includes ====
#include "colors.inc"	  // Standard Color definitions
#include "textures.inc"	  // Standard Texture definitions
#include "functions.inc"  // internal functions usable in user defined functions


#include "stonewall.inc"

// perspective (default) camera
camera {
  location  <120.0, 150.0, -300.0>
  look_at   <120.0, 120.0,  0.0>
  right     x*image_width/image_height
}

// create a regular point light source
light_source {
  0*x                  // light's position (translated below)
  color rgb <1,1,1>    // light's color
  translate <-200, 300, -500>
}                          

// create a regular point light source
light_source {
  0*x                  // light's position (translated below)
  color rgb <1,1,1>    // light's color
  translate <-300, 300, -100>
}


// Create an infinite sphere around scene and allow any pigment on it
sky_sphere {
  pigment {
    gradient y
    color_map { [0.0 color rgb <0.7,0.7,1.0>] [1.0 color blue 0.5] }
  }
}
 

object {
  //wallOfBricks(90, 3, 0.0, 90, 3, 0.0, 30, 1, 0.0)
  wallOfBricksWindow(240, 8, 0.0, 240, 8, 0.0, 60, 2, 0.0, 3, 5, 3, 5)
}


/*
plane {
  z, -8
  pigment { color rgb <0.3,0.3,0.32> }  
  normal { bumps 0.75 scale 0.05 }
  finish { ambient 0.1 diffuse 0.8 }
} 

*/