#include "functions.inc"

#macro SateliteDish(Above_Horison, Around_Zenit)
union{
	union{
		
		/* Parabola: x^2 + y^2 - z = 0  vertex=<0,0,0>, focus <0,0,1/4>*/ 
		object{
			quadric {
				<1,  1,  0>,
				<0,  0,  0>,
				<0,  0, -1>, 0
			}
			clipped_by { sphere{<0,0,0.4>, 0.5 } }
			texture{
				pigment { color rgb 1 }     
				finish {                        
					//ambient 0.0               
					diffuse 1
					specular 1
					metallic
					roughness 0.0005
					reflection { 0.05, 0 falloff 16 metallic }
					conserve_energy  
				}
			}
		}
		// bottom of dish.  Should also be alot smarter. 
		sphere{ <0,0,0.4>, 0.5 
			clipped_by{ box{<-1,-1, -0.1+sqrt(0.1)>, <1,1,1> inverse } } 
			texture{
				pigment { color rgbt 0.5 }
			}
		}
		// position on parabol: x^2+y^2-z = 0
	 	// position on sphere:  x^2+y^2+(z-0.4)^2-0.25 = 0
		
		// focus
		sphere { <0,0, 0.4>,0.025 }  
		
		// Dessa borde vara smartare och bttre placerade.
		cylinder{ 
			<0,0,0.4>, <0.4-(0.9-sqrt(0.65)), 0, 0.9-sqrt(0.65)>, 0.002
			translate<0.01,0.01,0.01>
		}
		cylinder{ 
			<0,0,0.4>, <0.4-(0.9-sqrt(0.65)), 0, 0.9-sqrt(0.65)>, 0.002
			translate<-0.01,0.01,-0.01>
		}
		cylinder{ 
			<0,0,0.4>, <0.4-(0.9-sqrt(0.65)), 0, 0.9-sqrt(0.65)>, 0.002
			translate<0.01,-0.01,0.01>
		}
		cylinder{ 
			<0,0,0.4>, <0.4-(0.9-sqrt(0.65)), 0, 0.9-sqrt(0.65)>, 0.002
			translate<-0.01,-0.01,-0.01>
		}
	
		cylinder{ 
			<0,0,0.4>, <-0.4+(0.9-sqrt(0.65)), 0, 0.9-sqrt(0.65)>, 0.002
			translate<0.01,0.01,-0.01>
		}
		cylinder{ 
			<0,0,0.4>, <-0.4+(0.9-sqrt(0.65)), 0, 0.9-sqrt(0.65)>, 0.002
			translate<-0.01,0.01,0.01>
		}
		cylinder{ 
			<0,0,0.4>, <-0.4+(0.9-sqrt(0.65)), 0, 0.9-sqrt(0.65)>, 0.002
			translate<0.01,-0.01,-0.01>
		}
		cylinder{ 
			<0,0,0.4>, <-0.4+(0.9-sqrt(0.65)), 0, 0.9-sqrt(0.65)>, 0.002
			translate<-0.01,-0.01,0.01>
		}
	
		cylinder{ 
			<0,0,0.4>, <0, 0.4-(0.9-sqrt(0.65)), 0.9-sqrt(0.65)>, 0.002
			translate<0.01,0.01,0.01>
		}
		cylinder{ 
			<0,0,0.4>, <0, 0.4-(0.9-sqrt(0.65)), 0.9-sqrt(0.65)>, 0.002
			translate<-0.01,0.01,-0.01>
		}
		cylinder{ 
			<0,0,0.4>, <0, 0.4-(0.9-sqrt(0.65)), 0.9-sqrt(0.65)>, 0.002
			translate<0.01,-0.01,0.01>
		}
		cylinder{ 
			<0,0,0.4>, <0, 0.4-(0.9-sqrt(0.65)), 0.9-sqrt(0.65)>, 0.002
			translate<-0.01,-0.01,-0.01>
		}
	
		cylinder{ 
			<0,0,0.4>, <0, -0.4+(0.9-sqrt(0.65)), 0.9-sqrt(0.65)>, 0.002
			translate<0.01,0.01,-0.01>
		}
		cylinder{ 
			<0,0,0.4>, <0, -0.4+(0.9-sqrt(0.65)), 0.9-sqrt(0.65)>, 0.002
			translate<-0.01,0.01,0.01>
		}
		cylinder{ 
			<0,0,0.4>, <0, -0.4+(0.9-sqrt(0.65)), 0.9-sqrt(0.65)>, 0.002
			translate<0.01,-0.01,-0.01>
		}
		cylinder{ 
			<0,0,0.4>, <0, -0.4+(0.9-sqrt(0.65)), 0.9-sqrt(0.65)>, 0.002
			translate<-0.01,-0.01,0.01>
		}

		texture{
			pigment { color rgb 1 }     
			finish {                        
				//ambient 0.0               
				diffuse 1
				specular 1
				metallic
				roughness 0.0005
				reflection { 0.15, 0 falloff 16 metallic }
				conserve_energy  
			}
		}
	
	 	// translate origin from parabola vertex to rotationpoint 
	    translate <0,0,0.1>
 
		rotate <0,1,0>*(90-Above_Horison) // rotation from straight up
		rotate <0,0,1>*Around_Zenit       // rotation around horizon
	}
	
	// Base
	cone{ 
		<0,0,-0.00>,0.12, 
		<0,0,-0.30>, 0.15
		texture {
			pigment { color rgb <0.6, 0.6, 0.6> }
  			normal { bumps 0.05 }  
  			finish { //F_MetalA
     	 		//ambient 0.0
      			diffuse 0.7
      			specular 0.01
      			roughness 0.15
   			}	
		}
		texture {
  	 		pigment{
  	 			wrinkles 
  	 			noise_generator 3
				scale 0.05
				pigment_map{
					[0 color rgbt 0.2]
					[1 color rgbt 1]
				}
  	 		}
  	 	}
	}
		
	// translate to ground level
	translate<0,0,0.3>
    
    // This will give the dish a radius of 1.0 (box is <-1,-1,0> - <1,1,2>
	scale 1/sqrt(-0.1+sqrt(0.1))
} 
#end

#macro DishArray(Above_Horison, Around_Zenit)
union{
	// All satelite dishes
	object{ SateliteDish(Above_Horison, Around_Zenit) scale 0.10 translate<-0.9, 0.0,0>}
	object{ SateliteDish(Above_Horison, Around_Zenit) scale 0.10 translate< 0.0,-0.9,0>}
	object{ SateliteDish(Above_Horison, Around_Zenit) scale 0.10 translate<-0.6, 0.0,0>}
	object{ SateliteDish(Above_Horison, Around_Zenit) scale 0.10 translate< 0.0,-0.6,0>}
	object{ SateliteDish(Above_Horison, Around_Zenit) scale 0.10 translate<-0.3, 0.0,0>}
	object{ SateliteDish(Above_Horison, Around_Zenit) scale 0.10 translate< 0.0,-0.3,0>}
	object{ SateliteDish(Above_Horison, Around_Zenit) scale 0.10 translate< 0.0, 0.0,0>}
	object{ SateliteDish(Above_Horison, Around_Zenit) scale 0.10 translate< 0.3, 0.0,0>}
	object{ SateliteDish(Above_Horison, Around_Zenit) scale 0.10 translate< 0.0, 0.3,0>}
	object{ SateliteDish(Above_Horison, Around_Zenit) scale 0.10 translate< 0.6, 0.0,0>}
	object{ SateliteDish(Above_Horison, Around_Zenit) scale 0.10 translate< 0.0, 0.6,0>}
	object{ SateliteDish(Above_Horison, Around_Zenit) scale 0.10 translate< 0.9, 0.0,0>}
	object{ SateliteDish(Above_Horison, Around_Zenit) scale 0.10 translate< 0.0, 0.9,0>}
	
	// control building
	box{ <-0.95,-0.95,0>,<-0.8,-0.8,0.04>
   		texture{
 			function{ (x*100+y*100) * select(z*100-int(z*100)-0.6777,0,1 )}
			texture_map{
				[0.25 concrete_texture ]
				[0.25 window_texture]
			}
		}
	}
	box{ <-0.95,-0.95,0.04>,<-0.8,-0.8,0.05>
   		texture{ dirtyconcrete_texture }
   	}
}
#end 
