
#include "consts.inc"
#include "functions.inc"
#include "Textures.inc"

#declare greenhouse_dome=
union{
	// plexiglas dome
	merge{
		cylinder{<0, -0.801, 0.10>, <0, 0.801, 0.10>, 0.150 }
		box{ <-0.150, -0.801, 0.00>, <0.150, 0.801, 0.10> }
		
		texture{ glass_texture }
	}

	// dome frame
	#local ypos= -0.800;
	#while( ypos <= 0.800)
		difference{
			torus {
				0.149,0.004
				translate <0, ypos, 0.10>
			}
			box{<0.155, ypos+0.004, 0.100>,<-0.155, ypos-0.004, -0.055> }

			texture{ steel_texture }
		}
		cylinder{
			<0.149, ypos, 0.100>, <0.149, ypos, 0.00>, 0.004
			texture{ steel_texture }
		}
		cylinder{
			<-0.149, ypos, 0.100>, <-0.149, ypos, 0.00>, 0.004
			texture{ steel_texture }
		}
		#declare ypos = ypos+0.400;
	#end
		
	#local degree=0;
	#while(degree <= 180)
		#local xpos=cos(radians(degree))*0.149;
		#local zpos=sin(radians(degree))*0.149;
		
		cylinder{
			< xpos, -0.800, zpos+0.10>,
			< xpos, 0.800, zpos+0.10>,
			0.004
			
			texture{ steel_texture }
		}
		cylinder{
			< xpos, -0.800, zpos+0.10>,
			< 0, -0.800, 0.10>,
			0.004
			
			texture{ steel_texture }
		}
		cylinder{
			< xpos, 0.800, zpos+0.10>,
			< 0, 0.800, 0.10>,
			0.004
			
			texture{ steel_texture }
		}
		#declare degree = degree + 60;
	#end
	
	// foundation
	union{
		box{ <0.154, 0.803, 0.01>,<0.144, -0.803, 0.00> }
		box{ <-0.154, 0.803, 0.01>,<-0.144, -0.803, 0.00> }
		box{ <0.154, 0.803, 0.01>,<-0.154, 0.793, 0.00> }
		box{ <0.154, -0.803, 0.01>,<-0.154, -0.793, 0.00> }
				
		texture{ concrete_texture }
	}

	// Crop
	isosurface{
		function{ 
			z-f_spikes_2d(x,0,y, 1, 1000,1000, 0)
			//z-0.015*f_bozo(x*1000,y*1000,0)
			//z-0.015*f_snoise3d(x*1000,y*1000,0)
		}
		
		//max_gradient 29.7
		max_gradient 732.47
		contained_by{ box{ <0.144, 0.803, 0.02>,<-0.144, -0.803, 0> } }

		texture{
			pigment { color rgb <1, 1, 0> }
			finish {
      			diffuse 0.9
   			}
		}
	} 

	rotate<0,0,90>
}

#declare GreenHouse=
union{
	object{ greenhouse_dome translate<0, -0.70,0> }
	object{ greenhouse_dome translate<0, -0.35,0> }
	object{ greenhouse_dome translate<0, +0.00,0> }
	object{ greenhouse_dome translate<0, +0.35,0> }
	object{ greenhouse_dome translate<0, +0.70,0> }
	
	// Control building
	box{ 
		<1,0.90,0.08>,<0.800, -0.9,0>
   		texture{
 			function{ (x*100+y*100) * select(z*100-int(z*100)-0.6777,0,1 )}
			texture_map{
				[0.25 concrete_texture ]
				[0.25 window_texture]
			}
		}
	}
	box{ 
		<1,0.90,0.08>,<0.800, -0.9,0.09>
   		texture{ dirtyconcrete_texture }
 	}

}
