#version 3.5;

                                            
// +AA.03  1d  4hr  24m                       
 

#include "colors.inc"
#include "stones.inc"
#include "woods.inc" 
#include "metals.inc"
#include "functions.inc" 
#include "transforms.inc"
#include "mgrass.pov"
#include "fgrass3.inc"
#include "Biopred.inc"
                                               
#declare R1 = seed(4456);
#declare PreTrace = 1;  //0 = compute radiosity only  1 = final render
#declare Rad_Quality = 5; //use 3 for final
#declare High_MSamples = 0; //0 = few media samples (faster), 1 = many media samples (slower)

#declare Surface       = 1; //1 = turn on texture
#declare Ground        = 1;
#declare Bubbles       = 1;
#declare SlowLight     = 1;
#declare CameraProbe   = 1;
#declare DeliveryProbe = 1;
#declare Grasses       = 1;
#declare Creatures     = 1;

#if (Rad_Quality < 4) 
   #default {finish{ambient .2 diffuse .8}  //.5->/8
            } 
#end 

global_settings{ assumed_gamma 1
                 max_trace_level 20
                 ambient_light 2  //2
                                                   
#switch (Rad_Quality)
 #case (1)
  radiosity {             // --- Settings 1 (fast) ---
     #if (PreTrace = 0)
        pretrace_start 0.08
        pretrace_end   0.02
        count 50
        error_bound 0.5
        recursion_limit 1
        nearest_count 1
        gray_threshold 0
        brightness 1.0
        media on
        normal on 
        always_sample off
        save_file "AlienRad1"
     #else 
        load_file "AlienRad1A"
        always_sample off
        pretrace_start 1 
        pretrace_end 1
     #end 
  }
 #break
 #case (2)
  radiosity {             // --- Settings 2 (medium quality) ---
     #if (PreTrace = 0)
        pretrace_start 0.08
        pretrace_end   0.001   //A=.01  B=.007
        count 100              //A=200  B=100
        error_bound 0.3       //A=.25  B=.15  .12
        recursion_limit 3      //A=1    B=3
        brightness 1.0
        nearest_count 5
        media on
        normal on 
        always_sample off
        save_file "AlienRad2"
     #else 
        load_file "AlienRad2A"
        always_sample off
        pretrace_start 1 
        pretrace_end 1
     #end 
  }
 #break
 #case (3)
  radiosity {             // --- Settings 3 (high quality) ---
     #if (PreTrace = 0)
        pretrace_start 0.08
        pretrace_end   0.008
        count 300   
        error_bound 0.08
        recursion_limit 4 
        brightness 1
        nearest_count 8
        media on
        normal on
        always_sample off
        save_file "AlienRad3"
     #else 
        load_file "AlienRad3"
        always_sample off
        pretrace_start 1 
        pretrace_end 1
     #end 
  }
 #break
 #end

}

#declare Media1 = 
     media{
	scattering {3, rgb<.8,.8,1> extinction .7}    
	method 3
	intervals 1
        #if (High_MSamples) samples 35,250 #else samples 5,10 #end 
        density { gradient -y
          color_map {
                     [0.0 rgb <.000051,.000051,.000051>]
                     [1.0 rgb <.000071,.000071,.000071>] 
                    } 
        } scale 4000
}

#declare Media2 = 
     media{ 
	absorption <.1,.1,.05>
	method 3
	intervals 1
        #if (High_MSamples) samples 35,250 #else samples 5,10 #end 
        density { agate  
          color_map {
//                     [0.0 rgb <.0001,.0001,.0001>]
//                     [1.0 rgb <.003,.003,.003>] //.3 - .4
                     [0.0 rgb <.00001,.00001,.00001>]
                     [0.8 rgb <.0001,.0001,.0001>]
                     [1.0 rgb <.002,.002,.002>] //.002
                    } 
        } scale 150   //50
}

#declare GrassMesh= 
#object{Grass }
                                                      
 camera {
   location  <0.0, 2., -5.0>*1000
   look_at   <0.0, .0,  0.0>
   right     x*image_width/image_height
   rotate -45*y // 90 degree azimuth difference from light source
 } 


box{<-1,-1,-1>,<1,1,1>
    pigment{color rgbt<1,1,1,1>}
    scale <10000,2000,10000>
    rotate<20,0,0> 
    hollow
    interior{media{Media2}}
    rotate -45*y          
}  

#if(SlowLight)

light_source {
  0*x                 // light's position (translated below)
  color rgb <.5,.5,.7>       // light's color   .8,.8,1
  fade_distance 2500   //increase to brighten
  fade_power 2
  translate  <0, .5, -5.>*1000 //y=1.8
  rotate -45*y // 90 degree azimuth difference from light source 
  shadowless
} 
  
light_source {
  0*x                 // light's position (translated below)
  color rgb 1       // light's color
  area_light
  <1000, 0, 0> <0, 0, 1000> // lights spread out across this distance (x * z)
  2, 2                // total number of lights in grid (4x*4z = 16 lights)
  adaptive 0          // 0,1,2,3...
  jitter              // adds random softening of light
  circular
  orient 
  translate <-2.0, 1.9, 2.0> * 1000   // <x y z> position of light
  fade_power 2
  fade_distance 4000 
}

#else 
light_source {
  0*x                 // light's position (translated below)
  color rgb 2       // light's color
  translate  <0., 1.8, 0.>*1000 
  shadowless
} 
#end

sky_sphere{pigment{color White} }


#declare T_Snow=
texture {
  pigment {
    agate
    color_map {
      [0.0 color rgb <0.90, 0.90, 0.90> ]
      [0.5 color rgb <0.70, 0.70, 0.70>]
      [1.0 color rgb <1.00, 1.00, 1.00> ]
    }
    scale 0.2
    warp { turbulence 0.5 }
  }


  normal {
    granite 0.4
    scale 0.5
  }
  scale 1/20 
}
 

#declare Ice = 
           texture {
             pigment { color rgbf <0, .75, .9, 1>
              }
             finish {
               ambient 0.0
               diffuse 0.0
               reflection {
                            0.0, 1.0
                            fresnel on                                  
                           }
               specular 0.4
               roughness 0.003
             }
             normal {
               function {
                 f_ridged_mf(x, y, z, 0.1, 3.0, 7, 0.7, 0.7, 2) + sin(x*2.5)*.4
               } .8
               scale 0.13 warp{turbulence 1.5}
             } 
             scale 4
           }

#declare Ice1 =                                                           
           texture {
             pigment { color SeaGreen 
              }
             finish { ambient 0.3 diffuse 0.5
               reflection {
                            0.0, 1.0
                            fresnel on
                           }
               specular 0.4
               roughness 0.003
             }
             normal {
               function {
                 f_ridged_mf(x, y, z, 0.1, 3.0, 7, 0.7, 0.7, 2) + sin(x*2.5)*.4
               } .8
               scale 0.13 warp{turbulence 1.5}
             } 
             scale 4
           } 
           
#declare Ice2 =                                                           
           texture {
             pigment { color ForestGreen
              }
             finish {
               reflection {
                            0.0, 1.0
                            fresnel on
                           }
               specular 0.4
               roughness 0.003
             }
             normal {
               function {
                 f_ridged_mf(x, y, z, 0.1, 3.0, 7, 0.7, 0.7, 2) + sin(x*2.5)*.4
               } .8
               scale 0.13 warp{turbulence 1.5}
             } 
             scale 4
           }
                      
//T_Ground and T_Rock used in background 
#declare T_Ground=
texture
     {
       pigment { granite
                 pigment_map{
                              [0 DarkGreen * 1.3]
                              [1 DarkBrown * 1.3]
                             }
               } scale 200
       normal{granite 200 scale 200 no_bump_scale} 
     } 

#declare T_Rock=
texture {
  pigment {
    agate
    color_map {
      [0.2 color rgb <0.55, 0.50, 0.40> ]  
      [0.6 color rgb <0.75, 0.50, 0.50> ]  
      [1.0 color rgb <0.70, 0.60, 0.50> ]  
    }
    scale 1
    warp { turbulence 0.5 }
  }
  finish {ambient <0.8, 0.9, 1.4>* .65
          specular .01 roughness 1
          diffuse 0.8
         }

  normal {
          granite 0.6
          scale 10 //0.1
  }
  scale 1/40
} 


//Surface
#if(Surface)
box { <-20000,2000,-5000>, <20000,2010,20000>
  texture{ agate   scale <40000, 50000, 40000>
           texture_map{
                       [0.0 Ice scale .08  ]
                       [1.0 T_Snow  ]
                      }
           
         } 
  hollow
  interior {
            ior 1.55
           } 
  rotate<20,-45,0>
  translate<500,1000,500>
} 
#else
box { <-20000,2000,-5000>, <20000,2010,20000>
  pigment{color Blue}
  rotate<20,-45,0>
  translate<500,1000,500>
} 
#end 

      
#if(Bubbles)
  #local N = 0;
  #local One = -5000;
  #local Two =  100;
  #local Three =-5000;
  #while (N < 150)
        sphere { <(  One +  (10000 * rand(R1))), 
                  (  Two +   (2500*rand(R1))), 
                  (Three + (10000*rand(R1)))>, 
                  30  
                  pigment{color rgbt<2,2,2,.85>}
                  hollow
                  interior {
                             ior 1.3
                           } 
                  no_shadow
               } 
        #local N = N + 1; 
  #end //N 
#end //if  


//Ground 

 #declare fnpigment1 =function {
 pigment
 {
 agate
 color_map {
  [0 rgb 0]
  [.5 rgb .2]
  [1.0 rgb 1.0]
 } scale 5000
 }
 }

 #declare fnpigment2 =function {
 pigment
 {
 granite
 color_map {
  [0 rgb 0]
  [.2 rgb .8]
  [.7 rgb .2]
  [1.0 rgb 1]
 } scale 5000
 }
 }

 #declare fnpigment3 =function {
 pigment
 {
 bumps
 color_map {
  [0 rgb 0]
  [1 rgb 1]
 } scale 5000
 }
 }


 #declare SeaFloor =
   isosurface
   {
     function
     {
       (y - fnpigment2(x,y,z).gray*80)//100 
       -  
       (fnpigment1(x,y,z).gray 
       + 
       fnpigment1(x,y,z).gray*10 
       + 
       fnpigment2(x,y,z).gray*10 
       - 
       fnpigment3(x,y,z).gray*5) 
     } 
     contained_by
     {
       box
       {
         <-5000,0,-5000>,<5000,125,5000>
       }
     }
     max_gradient 1

   texture {  
             slope {<0,-1,0>,0,0.5}   
             texture_map {
                          [0.0  T_Ground finish{ambient .2 diffuse 1}]  //ambient .2
                          [0.50  T_Ground finish{ambient .2 diffuse 1}]
                          [0.70  T_Rock scale 150 finish{ambient .2 diffuse 1}]
                          [0.80  T_Stone10 scale 150 finish{ambient .2 diffuse 1}]
                          [1.0  T_Stone10 scale 150 finish{ambient .2 diffuse 1}]    
                      } scale <1,1/3.5,1>
   } 
 
     scale <1,3.7,1> //3.5
   } 
   


#if (Ground)
 object {SeaFloor}
#end
 
  
//CameraProbe

#if (CameraProbe)
union{ 

  #local N = 0;
  #local One = -250;
  #local Two =  -4000;
  #local Three =-250;
  #while (N < 300)
        sphere { <(  One +  (500 * rand(R1))), 
                  (  Two +   (3000*rand(R1))), 
                  (Three + (500*rand(R1)))>, 
                  25  //20-100
                  pigment{color rgbt<2,2,2,.85>}
                  hollow
                  interior {
                             ior 1.3
                           }
                  no_shadow 
               } 
        #local N = N + 1; 
  #end //N 
  

cylinder {
  -1000.1*y,  -600*y,  250
  texture{T_Silver_1A}      
}  

cone {
  -600.1*y,  250,
  -200*y,  300
  texture{T_Silver_1A}
}  
  
cylinder {
  -200.1*y,  600*y,  300
  texture{T_Silver_1A}      
}

box{<-450,200,0>,<450,400,30> 
    texture{T_Silver_1A}
    rotate<0,-20,0>
   } 
  

#declare N = 0;
#while (N < 360)
box{<300,-200,0>,<500,100,30> 
    rotate <30,0,0>         
    rotate <0,N,0>
    texture {T_Silver_1A}
   }
#declare N = N + 30;
#end //while
            
difference{
cylinder {
  600.1*y,  800*y,  300
  texture{pigment{color Black}}
  finish {
      ambient .1
      diffuse 0
      reflection .25
      specular .5
      roughness .1
   }      
}
sphere{<0,900,0>,280} 
cutaway_textures 
} //difference

light_source {
  <0, 801, 0>                 // light's position (translated below)
  color rgb 1      // light's color  1.5
  spotlight
  radius 30
  falloff 70
  tightness 50
  fade_power 2
  fade_distance 4000
  point_at <0,1000,0> 
} 
light_source {
  <0, 801, 0>                 // light's position (translated below)
  color rgb 1      // light's color
  fade_power 2
  fade_distance 500
} 

cone {
  600.1*y,  300,
  6000*y,  250 
  pigment{rgbt<1,1,1,1>}
  hollow on 
  no_shadow
  interior{media{Media1}}      
}                                
  normal{crackle scale 30}
  no_shadow      
  rotate<100,120,0>  //y-=116
  translate<-1500,1000,1000>
} //end union

#end //end if 

//DeliveryProbe

#if(DeliveryProbe)
union{ 
cone {
  0*y,  10,
  200*y,  100
}

difference{

cylinder {
  200.1*y,  500*y,  100
}

cylinder {
  <0,220,10>, <0,480,10>,  100
}
rotate<0,60,0>
}  //difference 

box{<-100,220,100>,<100,480,120>
    Rotate_Around_Trans(<0,-20,0>,<-100,220,100>)
}

cone {
  500.1*y,  100,
  800*y,  300
}

cylinder {
  800.1*y,  1200*y,  300
}

  rotate<20,0,20>
  texture{T_Silver_1A}
  normal{crackle scale 30}
  no_shadow      
  translate<-3000,1200,-1000>
} //union

#end //if 

#macro Trace_It (Start, Object, Offset)  
    #local Norm = <0, 0, 0>;
    #local Pos = trace (
                  SeaFloor,     // object to test
                  Start,           // starting point
                  -y,              // direction
                  Norm );          // normal
    #if (vlength(Norm)!=0)   // if intersection is found, normal differs from 0
        object {
          Object
          translate Pos + <0,Offset,0>
        }
    #end 
#end

#if(Grasses)

//cluster center
Trace_It(< 1300,   
           2000,
           -400>,  
         #object{GrassMesh 
                 scale (50 + (50*rand(R1)))
                 rotate<0,180*rand(R1),0> 
                },
         0
)

Trace_It(< 2000,   
           2000,
           -400>,  
         #object{GrassMesh 
                 scale (50 + (50*rand(R1)))
                 rotate<0,180*rand(R1),0> 
                },
         0
) 

Trace_It(< 1700,   
           2000,
           -800>,  
         #object{GrassMesh 
                 scale (50 + (50*rand(R1)))
                 rotate<0,180*rand(R1),0> 
                },
         0
) 

Trace_It(< 1500,   
           2000,
           -200>,  
         #object{GrassMesh 
                 scale (50 + (50*rand(R1))) 
                 rotate<0,180*rand(R1),0> 
                },
         0
) 

Trace_It(< 1700,   
           2000,
           -100>,  
         #object{GrassMesh 
                 scale (50 + (50*rand(R1))) 
                 rotate<0,180*rand(R1),0> 
                },
         0
) 


Trace_It(< 1650,   
           2000,
           -500>,  
         #object{GrassMesh 
                 scale (50 + (50*rand(R1))) 
                 rotate<0,180*rand(R1),0> 
                },
         0
) 

#declare N = 0;
#while (N<40)
Trace_It(< -3000 + (9000 * rand(R1)),  
           2000,
           -3000 + (9000 * rand(R1))>, 
         #object{GrassMesh 
                 scale (50 + (50*rand(R1))) 
                 rotate<0,180*rand(R1),0> 
                 double_illuminate
                },
         0
) 
#declare N = N + 1;
#end //while

  #local N = 0;
  #local One = 1100;
  #local Two =  0;
  #local Three =-1000;
  #while (N < 300)
        sphere { <(  One +  (900 * rand(R1))), 
                  (  Two +   (2500*rand(R1))), 
                  (Three + (800*rand(R1)))>, 
                  (10 + (7 * rand(R1)))  
                  pigment{color rgbt<2,2,2,.85>}
                  hollow
                  interior {
                             ior 1.3
                           }
               } 
        #local N = N + 1; 
  #end //N 


 
#end //Grasses 

#if(Ground)
 
#declare Terrain=
            height_field {
            tga "Land1.tga" 
            smooth
            rotate y*(45)
            scale <8000 ,800 ,8000 > 
            translate<-8000,-300,2000>  
          }                                       

   
object {
  Terrain  
   texture {  
             slope {<0,-1,0>,0,0.5}   
             texture_map {
                          [0.0  T_Ground finish{ambient .3 diffuse 1}]  
                          [0.30 T_Ground finish{ambient .3 diffuse 1}]
                          [0.50 T_Rock scale 150 finish{ambient .3 diffuse 1}]
                          [0.60 T_Stone10 scale 150 finish{ambient .3 diffuse 1}]
                          [1.0  T_Stone10 scale 150 finish{ambient .3 diffuse 1}]    

                      } 
   } 
}

#end //if Ground) 


#if (Creatures)

#include "Creature1.inc"
#include "Creature2.inc"
#include "Creature3.inc" 

Trace_It(< 1700,   
           2000,
           -2800>,  
           #object {Horn
                   texture {pigment { color DarkWood} } 
                   normal {granite .8}
                   finish{ambient .3 diffuse .8}
                   scale 57
                   rotate <100, 0, 0>
           }, 
           //cylinder{0*y,2000*y,100 pigment{color Red}},
         80
)

#declare R1 = seed(98765);  
#declare N = 0;
#declare Pt = <1650,0,-500>;          
#declare Radius = 1500;
#while (N<10)
#declare ScaleSize = 30 + (rand(R1) * 20);
Trace_It(< (Pt.x - (Radius/2)) + (rand(R1)*Radius),   
           2000,
           (Pt.z - (Radius/2)) + (rand(R1)*Radius)>,  
           object {FanWorm
                   texture {pigment { color Green * .5 transmit .9} scale <1,1,1> rotate <0,0,0>} 
                  // finish{ambient .3 diffuse .5}
                   scale <ScaleSize,40 - (rand(R1) * 30),ScaleSize>
                   rotate <150 + (rand(R1) * 70), 0, -30 + (rand(R1) * 70)>
           },
  
         300 + rand(R1) * 1500   
)
#declare N=N+1;
#end //while 


Trace_It(< -2000,   
           2000,
           0>,  
           object {FanWorm2
                   texture{ agate   scale 2
                            texture_map{
                                         [0.0 Ice1 scale .08  ]
                                         [1.0 T_Snow  ]
                            }     
                   } 
                   scale <80,75,80>
                   rotate <0, 0, 0>
                  }, 
         0
)

Trace_It(< -3000,   
           2000,
           -100>,  
           object {FanWorm2
                   texture{ agate   scale 2
                            texture_map{
                                         [0.0 Ice1 scale .08  ]
                                         [1.0 T_Snow  ]
                                        }     
                   } 
                   scale <80,75,80>
                   rotate <0, 0, 0>
                  }, 
         0
)

#end //if creatures 
           
                                        