 monitor2.pov
ZmZ  8"mY* HGt

4
H
   mZ 
iTEXTPOV3         =  !N                       qN  // Persistence of Vision Ray Tracer Scene Description File
// File: monitor2.pov
// Vers: 3.5
// Desc: Planet Getting blown up with static
// Date: 12/29/03
// Auth: Josh English
// Rendering time 51 min 15 sec
//
#version 3.5;
#include "colors.inc"
#include "strings.inc"
#include "stars.inc"
#include "screen.inc"

global_settings {
  assumed_gamma 1.0
}
// ----------------------------------------
#declare zoom = 50;
Set_Camera(<0.0, 0, -zoom>, <0.0, 0.0,  0.0>, degrees(atan2(1.5,zoom))*2) // set location, look_at and angle
Set_Camera_Aspect(4,3) // set width in relation to height
Set_Camera_Sky(<0,1,0>) // set the sky vector

#declare static = color_map {
	[ 0.5 color rgb 1 transmit 0 ]
	[ 0.5 color rgb 0 transmit 0 ]
	}
#declare static2 = color_map {
	[ 0.3 color rgb 1 transmit 0.5 ]
	[ 0.3 color rgb 0 transmit 1 ]
	}
#declare MyScreenTexture = // screen texture with black borders
texture {
   pigment {
      gradient y
      pigment_map {
         [0.0, granite scale 0.001 color_map { static }]
         [0.2, granite scale 0.001 color_map { static2 }]
         [0.2, color rgb 1 transmit 1]
      }
      frequency 4
      triangle_wave
      turbulence 0.1
      //lambda 1.5
      //octaves 8
      //omega 0.9
   }
   
   finish {ambient 1 diffuse 0}
}

// Make screen plane with the texture MyScreenTexture and scale
// it by 0.02 to bring it closer to the camera.
// Make the texture fill out the entire screen from <0,0> to <1,1>.
Screen_Plane ( MyScreenTexture, 0.02, <0,0>, <1,1> )


plane { z, 2 hollow
	texture { Starfield1 } }
light_source {
  <0, 0, 0>            // light's position (translated below)
  color rgb <1, 1, 1>  // light's color
  translate <-30000, 0, 0>
}
// ----------------------------------------
#declare planet=sphere { 0, 1 
	pigment { rgb 0.1 }
	normal { wrinkles bump_size 1}
	 }

#declare cyl = cylinder { <-1,1,-1> <-1,1,1> 1 }


#declare explode_object=
	object {planet 
	clipped_by { box { <-1,0.8,-1> <1,1,1> } } }


object { planet 
clipped_by { box { <-0.32,-0.8,-1> <1,0.8,1> } } }

//#declare object_center = (max_extent(explode_object)+min_extent(explode_object))/2;
//#declare object_size =max_extent(explode_object)-min_extent(explode_object);
#declare l = sqrt(1-pow(0.8,2));
#declare object_corner1 = <-l,0.8,-l>;
#declare object_corner2 = <l,1,l>;
#declare object_hollow = false;
#declare particle_res = <16,6,16>;
//#declare particle_object = sphere { 0,1 scale <0.5,0.5,0.5>} 
#declare particle_texture = texture {
	pigment { spherical 
		color_map { 
			[ 0.0 rgb 0 ]
			[ 0.01 rgb 0.1 ]
			[ 0.2 rgb <1,0.1,0>*2]
			[ 0.5 rgb <1,0.5,0>*3 ] }
			}
	finish { ambient 0.4 }
	}
#declare exp_location = <-10000,0,0>;
#declare exp_spin=<0.1,0.1,0.1>;
#declare exp_strength =1;
#declare disintegration = 3;
#declare explode_clock = 0.002;
#declare dir_turb=0;
#declare scale_turb = 0.8;
#declare vel_turb = 0.1;
#declare rotate_turb=0.2;
#declare spin_turb=0.7;
#declare exp_turb = 0.4;
#include "explode.inc"

#declare explode_object= 
	object {planet 
	clipped_by { box { <-1,-0.8,-1> <1,-1,1> } } }

#declare object_corner1 = <-l,-1,-l>;
#declare object_corner2 = <l,-0.8,l>;
#declare vel_turb =0.9;
#declare exp_spin=0.11;
#declare spin_turb =0.4;
#include "explode.inc"

#declare explode_object=
	object { planet 
	clipped_by { box { <-1,-0.8,-1> <-0.3,0.8,1> } } }
#declare object_corner1 = <-1,-0.8,-1>;
#declare object_corner2 = <-0.3,0.8,1>;
#declare vel_turb =0.9;
#declare exp_spin=0.11;
#declare spin_turb =0.4;
#declare explode_clock = 0.0015;
#declare particle_res=<6,25,4>;
#declare particle_object = box { <-0.5,-0.5,-0.5> <0.5,0.5,0.5>} 
#include "explode.inc"
                                                                        4  4   }                                                                                                                                                                                                                                                   D   @      PRec   @      WKin   @                   Q 5   D   @      PRec   @      WKin   @                   0      @      )ADep   @      LAEFr   @      AFCl   @     AFFr   @      AIFr   @      AJit   @      <AMet   @     (ASFr   @      AThr   @      DBPCo   @      BThr   @      ZCIma   @      DACh   @      DAni   @      DAnt   @      6DBSl   @      TDCom   @      DFAc   @     "DFRe   @     
DMPE   @       DMPS   @      DMPr   @      DPIm   @     DPre   @      DSAc   @     DSUn   @      hHeig   @      IFTy   @      IPat   @     0LVer   @      OBSi   @      QTSp   @      QTTe   	@      Qual   @      (RINI   @     RUBo   @      bRadi   @      0ULBu   @      nUOBu   @      zUVBu   @      tWidt   @              P   7    @                  	    V             >                    @                       2             TPIC                   a   png                 
                                  ?   ?      j         !                         Marvin                     4|BD    =future                                                          шG                     Scenes    =  G  Marvin:POV-Ray:Scenes:future       4  4   }SORTB   J  POVR  
           &       H    Window PreferencesWindow PreferencesRender Prefs                                                                               