// Objekjen POV Ray mesh generating macros and obj export macros
// (c) and created by Nathan Watson 2003
// version 0.0.4.rc.1d
// license GPL. www.gnu.org
// 
/*
---------------------------------------------------------------------------
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA 
------------------------------------------------------------------------------
*/
//
// Notice: These macros writes potentially several files to hard disk,
// make sure you dont have files with same names in same directory. Put all
// these files in their own directory.
// Much thanks to author of Poseray program. Poseray program was very helpful
// in developing these macros.

// These macros have several bugs. These macros have only been
// somewhat tested on my machine.


#version 3.5;


// angle 330 with 7 or 8 segments causes incorrect results  
// error with pi. try to fix with other definition of pi.

#declare pi_val = 3.14159265;

// bugs with k_ifsor when segs is 6, 11, 13, 15, 17, 18, and other numbers
// try to fix with pi=3.14 or pi=3.141
// if model come out wierd, change pival to 3.14 or 3.141.

// produces degenerate triangles in obj file
// macro for correcting pi error bug
// used in k_ifsor

#include "pvalercc.pov"

//macro from transforms.inc

#macro vtranzform(vec, trans)
   #local fn = function { transform { trans } }
   #local result = (fn(vec.x, vec.y, vec.z));
   result
#end

//macro from math.inc
#macro veql(V1, V2) (V1.x = V2.x & V1.y = V2.y & V1.z = V2.z) #end

#macro veqb(V1, V2) (

  V1.x = V2.x & 
  V1.y = V2.y & 
  V1.z = V2.z) 

#end



#ifndef(writobjfil)	#declare writobjfil = 1; #end	
#ifndef(readmeshfil)    #declare readmeshfil = 0; #end  //default no read mesh file
#ifndef(writmeshfil)    #declare writmeshfil = 0; #end
#ifndef(bildshap)       #declare bildshap = 1; #end    //default build pov triangle meshes and obj meshes
#ifndef(bildmesh)       #declare bildmesh = 1; #end   //default make pov triangle mesh

#ifndef(objfilnam)     #declare objfilnam = "objmesh1.obj";  #end
#ifndef(objclnfilnam)  #declare objclnfilnam = concat("cln", substr(objfilnam, 4, strlen(objfilnam)-3)); #end

#ifndef(meshfilnam)    #declare meshfilnam = "povmesh.inc"; #end
#ifndef(meshtex)       #declare meshtex = texture{pigment {rgb 0.5}}; #end
#ifndef(texnam)        #declare texnam = "meshtex"; #end


#ifndef(prez)          #declare prez = 30; #end //default mesh resolution

#ifndef(fsjen)         #declare fsjen = 2; #end  //default ifsor jenerator
#ifndef(gtran) #declare gtran = 1; #end //default apply global transformation


                           //test.obj to test.mtl
#declare objmtlfilnam = concat(substr(objfilnam, 1, strlen(objfilnam)-4), ".mtl");

#declare vcnt = 0;    //vertex count 
#declare tricnt = 0;  //triangle count
#declare mtlcnt = 0;   //material count
#declare objcnt = 0;   //object count
#declare vrtxcnt = 0;  //vertex count for rem dups



                                
#if(readmeshfil)   //if we read pov mesh file
   #declare writmeshfil = 0;  //dont write mesh file
   #declare writobjfil = 0;  //dont write obj file
   #declare bildshap = 0;    //dont build mesh 
   
   #include meshfilnam       //include previously bilt mesh file
   ////#debug concat("mesh file name is: ", meshfilnam,"\n") 
    
#end



#if(writobjfil)  //if we write to obj geometry file
 #fopen ofilid objfilnam write    //write       
 #write(ofilid, "# pov object export script\n")
 
#end




#if(writmeshfil )  //if we write to pov mesh file
 #fopen mfilid meshfilnam write    //write        
 #write(mfilid, "//pov mesh export script\n")

#end


//mesh file object prolog macro, name of object
#macro mshflprlg(nam)
 #if(writmeshfil)
   #write(mfilid, "// ", nam, " \n")
   #write(mfilid, "mesh{    \n")                                                                  
 #end                           
#end


//mesh file object epilog macro
#macro mshfleplg()
 #if(writmeshfil)
     #write(mfilid, "\nscale <1,1,-1>\n")
   
     #write(mfilid, "\ntexture{ ", texnam, " }\n") 
    
     
     
     #write(mfilid, "\n}\n")
     #write(mfilid, "\n//subtotal triangles: ", str(tricnt,1,0), "\n\n\n") 
 #end
#end


//object groups and materials
#macro mkobjgrp(nam) 
 #if(writobjfil)   
   
   #declare mtlcnt = mtlcnt+1; 
      
   #write(ofilid, "usemtl m", str(mtlcnt, 1,0), "\n")   //make unique material
    
   #declare objcnt = objcnt+1;
   #write(ofilid, "g", " ", nam, str(objcnt,1,0), "\n")   //make unique group
    
 #end
#end


#macro fm(coord)     //formats floats
  str(coord, 3, -1)

#end


#macro fmb(coord)     //formats floats
  str(coord, 3, 15)

#end


//initialize transform identifiers
#declare tf2 = transform{scale <1,1,1> rotate <0,  0,  0> translate <0,0,0>}

#declare tf1 = transform{scale <1,1,1> rotate <0,  0,  0> translate <0,0,0>}
#declare tfp = transform{scale <1,1,1> rotate <0,  0,  0> translate <0,0,0>}
#declare tfc = transform{scale <1,1,1> rotate <0,  0,  0> translate <0,0,0>}
#declare tfp2 = transform{scale <1,1,1> rotate <0,  0,  0> translate <0,0,0>}
#declare tfc2 = transform{scale <1,1,1> rotate <0,  0,  0> translate <0,0,0>}


//default set of transforms
#macro tf(scl, rtt, sh)
 
 
 
 #local sh1 = <sh.x, sh.y, -sh.z>;
 #local shp = sh;
 #local shc = <sh.x, sh.y, -sh.z>;
 
 //global
 #declare tf1 = transform{scale scl rotate rtt translate sh1}

 #local rttp = <-rtt.x, -rtt.y, rtt.z>;   //backwards x rotation axis
 
 //global
 #declare tfp = transform{scale scl rotate rttp translate shp}  //transform for pov object
 
  
 #local rttc = <-(rtt.x+180), -rtt.y, rtt.z>;
 //global
 #declare tfc = transform{scale scl rotate rttc translate shc} //pov clip object transform
  
 
#end

//default global transforms 
#macro tfg(scl, rtt, sh)
 
 #local sh1 = <sh.x, sh.y, -sh.z>;
 #local shp = sh;
 #local shc = <sh.x, sh.y, -sh.z>;
 
 //global
 #declare tf2 = transform{scale scl rotate rtt translate sh1}

 #local rttp = <-rtt.x, -rtt.y, rtt.z>;   //backwards x rotation axis
 
 //global
 #declare tfp2 = transform{scale scl rotate rttp translate shp}  //transform for pov object
 
  
 #local rttc = <-(rtt.x+180), -rtt.y, rtt.z>;
 //global
 #declare tfc2 = transform{scale scl rotate rttc translate shc} //pov clip object transform
  
  
#end



#macro resetranz()

 //reset transform back to default
 #declare tf1 = transform{scale <1,1,1> rotate <0,0,0> translate <0,0,0>} 
 #declare tfp = transform{scale <1,1,1> rotate <0,0,0> translate <0,0,0>}
 #declare tfc = transform{scale <1,1,1> rotate <-180, 0,  0> translate <0,0,0>}  

#end



#macro triangl(k1, k2, k3)

    #local kt1 = vtranzform(k1, tf1);
    #local kt2 = vtranzform(k2, tf1);
    #local kt3 = vtranzform(k3, tf1); 
    
    #if(gtran)
       #local kt1 = vtranzform(kt1, tf2);
       #local kt2 = vtranzform(kt2, tf2);
       #local kt3 = vtranzform(kt3, tf2); 
    #end
    
    //chek for invalid triangl 
    #if(veql(kt1, kt2) | veql(kt1, kt3) | veql(kt2, kt3))
       //do nothing
    #else
      
      
      triangle{kt1, kt2, kt3}
      #declare tricnt = tricnt + 1;
      
      
      
      #if(writmeshfil)
        #write(mfilid, "triangle{ ", kt1, ", " kt2, ", ", kt3, " }\n" )
      #end
    
    #end //chk dgnrt trngls

#end //triangl



#macro vwrite(v1)

   #local vt1 = vtranzform(v1, tf1);
   
   #if(gtran)
       #local vt1 = vtranzform(vt1, tf2);
   #end
        
   #write(ofilid, "v", " ", fm(vt1.x), " ", fm(vt1.y), " ", fm(vt1.z), "\n") 
   
   
#end


#macro vfwrite(k1, k2, k3)
    
    //this macro produces lots of redundant vertexes in obj file
    
    // references tf1 before each shape macro
    // tf1 = transform{scale scl rotate rtt translate sh}
    
    #local kt1 = vtranzform(k1, tf1);
    #local kt2 = vtranzform(k2, tf1);
    #local kt3 = vtranzform(k3, tf1); 
    
    #if(gtran)
       #local kt1 = vtranzform(kt1, tf2);
       #local kt2 = vtranzform(kt2, tf2);
       #local kt3 = vtranzform(kt3, tf2); 
    #end
    
     //chek for invalid or dgnrt trngl
    #if(veql(kt1, kt2) | veql(kt1, kt3) | veql(kt2, kt3))
       //do nothing
    #else
    
            
      
      #if(writobjfil) 
        
        //#write(dfilid, "triangle{ ", triarry[tricnt][0], ", " triarry[tricnt][1], ", ", triarry[tricnt][2], " } ", "writ flag: ", triarry[tricnt][3], "\n" )
        //------------------------------
        
        #write(ofilid, "v", " ", fm(kt1.x), " ", fm(kt1.y), " ", fm(kt1.z), "\n") 
        #write(ofilid, "v", " ", fm(kt2.x), " ", fm(kt2.y), " ", fm(kt2.z), "\n") 
        #write(ofilid, "v", " ", fm(kt3.x), " ", fm(kt3.y), " ", fm(kt3.z), "\n") 
        #declare vcnt = vcnt + 3;  ///3 more vertexes
      
       
        
         
        ///#write(ofilid, "# vcnt = ", str(vcnt, 1,0), " \n") 
          //                        3-2=1                   3-1=2             3-0=3
        #write(ofilid, "f ", str(vcnt-2, 1,0), " ", str(vcnt-1, 1,0), " " str(vcnt, 1,0), " \n" )
         
      
    
    
      #end  //if writobjfil
    
      
    #end //if dgnrt trngl
    
#end  //vfwrite




#macro trianglvf(k1, k2, k3)
    
    //this macro produces lots of redundant vertexes in obj file
    
    // references tf1 before each shape macro
    // tf1 = transform{scale scl rotate rtt translate sh}
    
    #local kt1 = vtranzform(k1, tf1);
    #local kt2 = vtranzform(k2, tf1);
    #local kt3 = vtranzform(k3, tf1); 
    
    
    #if(gtran)
       #local kt1 = vtranzform(kt1, tf2);
       #local kt2 = vtranzform(kt2, tf2);
       #local kt3 = vtranzform(kt3, tf2); 
    #end
   
    
     //chek for invalid or dgnrt trngl
    #if(veql(kt1, kt2) | veql(kt1, kt3) | veql(kt2, kt3))
       //do nothing
    #else
    
      
      triangle{kt1, kt2, kt3}
      #declare tricnt = tricnt + 1;
      
      
      #if(writobjfil)
        
       
       
        //#write(dfilid, "triangle{ ", triarry[tricnt][0], ", " triarry[tricnt][1], ", ", triarry[tricnt][2], " } ", "writ flag: ", triarry[tricnt][3], "\n" )
        //------------------------------
        
        #write(ofilid, "v", " ", fm(kt1.x), " ", fm(kt1.y), " ", fm(kt1.z), "\n") 
        #write(ofilid, "v", " ", fm(kt2.x), " ", fm(kt2.y), " ", fm(kt2.z), "\n") 
        #write(ofilid, "v", " ", fm(kt3.x), " ", fm(kt3.y), " ", fm(kt3.z), "\n") 
        #declare vcnt = vcnt + 3;  ///3 more vertexes
      
      
        
        
             
        ///#write(ofilid, "# vcnt = ", str(vcnt, 1,0), " \n") 
         //                        3-2=1                   3-1=2             3-0=3
        #write(ofilid, "f ", str(vcnt-2, 1,0), " ", str(vcnt-1, 1,0), " " str(vcnt, 1,0), " \n" )
        
     
    
    
      #end //if writobjfil
    
      #if(writmeshfil)
        #write(mfilid, "triangle{ ", kt1, ", " kt2, ", ", kt3, " }\n" )
      #end
    
    #end //if dgnrt trngl
#end //end trianglvf









//------------------------------------
//        shapes macros
//------------------------------------


             
#macro j_plane()
 
 
 
 #if(bildshap)  
  
  
  mshflprlg("plan")
  
  #if(bildmesh)
   mesh{
     //front face 
    
   
    
     triangl( < 1,   1,  0>,
             < 1,  -1,  0>,
             <-1,  -1,  0>
             )
            
    
     triangl(<-1,  -1,  0>,
            <-1,   1,  0>,
            < 1,   1,  0>
            )             
           
      
    scale <1,1,-1> 
 
    texture{meshtex}
 
 
  
    } //end mesh
 
   #end //bildmesh
 
 
 #if(writobjfil)
    
    mkobjgrp("plane")
  
    
    vwrite(<1, 1, 0>)
    
    vwrite(<1, -1, 0>)
    
    vwrite(<-1, -1, 0>)
   
    vwrite(<-1,  1,  0>)
    
    
    #declare vcnt = vcnt + 4;
   
                 //     1                        2                    3                       4
    #write(ofilid, "f ", str(vcnt-3, 1,0), " ", str(vcnt-2, 1,0), " " str(vcnt-1, 1,0), " ", str(vcnt, 1,0), " \n" )
    
   
    
    #write(ofilid, "\n")
 
 
 #end //writobjfil 
 
 
  
  mshfleplg()
 #end //if bildshap 
 
 //reset transform back to default
 resetranz()
 
 
#end //macro j_plane


#macro p_plane()

   polygon {4, <1, 1>, <1, -1>, <-1, -1>, <-1, 1> scale <1,1,-1> 
            texture{meshtex} 
            transform{tfp}
            transform{tfp2}
            }
   #declare bildmesh = 0; //turn off pov mesh bilding
   j_plane()
   
   #declare bildmesh = 1; //turn back on pov mesh bilding        
   resetranz()
#end //p_plane






          
#macro j_box()
 
 
 
 #if(bildshap)  
  
  
 
  mshflprlg("box")
  
  #if(bildmesh)
  
   mesh{ 
   
    
    //back face 
    
   
    
    triangl(< 1,   1,  -1>,
            <-1,  -1,  -1>,
            < 1,  -1,  -1>)
            
   
  
    
    triangl(<-1, -1,  -1>,
            < 1,  1,  -1>,
            <-1,  1,  -1>
           )
    
    
    
   
    
    triangl(< 1,   1,  1>,
            < 1,  -1,  1>,
            <-1,  -1,  1>
           )
                         
    
    
    triangl(< 1,   1,  1>,
            <-1,  -1,  1>,
            <-1,   1,  1>
           )             
           
   
    
    triangl(<1,   1,  -1>,
            <1,  -1,  -1>,
            <1,   1,   1>
           )
    
   
    
    triangl(<1,   1,   1>,
            <1,  -1,  -1>,
            <1,  -1,   1>
           )
    
   
   
    triangl(<-1,   1,   -1>,
            <-1,   1,    1>,
            <-1,  -1,   -1>
           )
     
    
    
    triangl(<-1,   1,    1>,
            <-1,  -1,    1>,
            <-1,  -1,   -1>
           )
   
   
    
    //top face
    
    triangl(< 1,   1,   -1>,
            < 1,   1,    1>,
            <-1,   1,   -1>
           )
    
    
    
    
    triangl(< 1,   1,    1>,
            <-1,   1,    1>,
            <-1,   1,   -1>
           )
    
    
    
   
    //bottom face
     
    triangl(< 1,  -1,   -1>,
            <-1,  -1,   -1>,
            < 1,  -1,    1>
           )
    
    
    triangl(< 1,  -1,    1>,
            <-1,  -1,   -1>,
            <-1,  -1,    1>
    
           )
    
   scale <1,1,-1>
   texture{meshtex}
   
       
   } //end mesh
   
  #end //if bildmesh     
    
    
   #if(writobjfil)
     
     mkobjgrp("cube")
    
     
     vwrite(<1, 1, -1>)
     
     vwrite(<1, -1, -1>)
      
       
     vwrite(<-1, -1, -1>)
      
     vwrite(<-1,  1, -1>)
      
      
     vwrite(<1,  1,  1>)  
     
     vwrite(<1,  -1,   1>)
     
     vwrite(<-1,  -1,   1>)
      
     
     vwrite(<-1,  1,   1>)
         
     #declare vcnt = vcnt + 8;     //8 more vertexes
      
      //make 6 faces for cube
    
      ///4 3 2 1              8-4=4                   8-5=3                 8-6=2                 8-7=1
     #write(ofilid, "f ", str(vcnt-4, 1,0), " ", str(vcnt-5, 1,0), " " str(vcnt-6, 1,0), " ", str(vcnt-7, 1,0), " \n" )
      ///6 7 8 5              8-2=6                   8-1=7                 8-0=8                 8-3=5
     #write(ofilid, "f ", str(vcnt-2, 1,0), " ", str(vcnt-1, 1,0), " " str(vcnt, 1,0), " ", str(vcnt-3, 1,0), " \n" )
      ///2 6 5 1              8-6=2                   8-2=6                 8-3=5                 8-7=1
     #write(ofilid, "f ", str(vcnt-6, 1,0), " ", str(vcnt-2, 1,0), " " str(vcnt-3, 1,0), " ", str(vcnt-7, 1,0), " \n" )
      ///3 7 6 2              8-5=3                   8-1=7                 8-2=6                 8-6=2
     #write(ofilid, "f ", str(vcnt-5, 1,0), " ", str(vcnt-1, 1,0), " " str(vcnt-2, 1,0), " ", str(vcnt-6, 1,0), " \n" )
      //4 8 7 3               8-4=4                   8-0=8                 8-1=7                 8-5=3
     #write(ofilid, "f ", str(vcnt-4, 1,0), " ", str(vcnt, 1,0), " "   str(vcnt-1, 1,0), " ", str(vcnt-5, 1,0), " \n" )
      //8 4 1 5               8-0=8                   8-4=4                 8-7=1                 8-3=5
     #write(ofilid, "f ", str(vcnt, 1,0), " ",   str(vcnt-4, 1,0), " "  str(vcnt-7, 1,0), " ", str(vcnt-3, 1,0), " \n" )
       
                                                                                  
      
     #write(ofilid, "\n")
                                                                                    
   #end //if writobjfil
   
  
   
   mshfleplg()
   
 #end //if bildshap
 

 //reset transform back to default
 resetranz()
   
#end  //j_box


#macro p_box()

  box{<-1,-1,-1>, <1,1,1> scale <1,1,-1> texture{meshtex} 
   transform{tfp}
   transform{tfp2}
   }
  
  #declare bildmesh = 0; //turn off pov mesh bilding
  
    j_box()
  
  #declare bildmesh = 1; //turn back on pov mesh bilding        
  
  resetranz()


#end //p_box






       //segments, arc, 
#macro j_gon(segs, arc)  
  
 
 
 #if(bildshap)  
  
 
  
  
  #if(segs < 3) #local segs = 3; #end  //at least 3
  #local segs = int(segs);  //only integer number of segments
  
  #if(arc > 360) #local arc = arc - 360; #end  //no arcs greater than 360 d
  
 
  #local arc = (arc*pi_val)/180.0;
  
  
  #local j = 0; 
  
  
  #local crot = arc;
  
  mshflprlg("sgon")
  
 #if(bildmesh)
  mesh{
  
  
   #while(j < crot)
    
      //make union or mesh of triangles for base of s_gon
      //default y axis
      
       
       triangl(<0,0,0>,
               <cos(j), 0, sin(j)>,
               <cos(j+(1/segs)*crot), 0, sin(j+(1/segs)*crot)>
              )
    
     #local j = j + (1/segs)*crot;
   #end //end while
  
  scale <1,1,-1>
  texture{meshtex}
  
  } //end mesh
 #end //if bildmesh 
                              

 #if(writobjfil)   //if we export to obj file
   
   mkobjgrp("polygon")
  
   
   //center of base
   //#write(ofilid, "# center of base, vertex number: ",str(vcnt+1,1,0), "\n")
  
   
   vwrite(<0,0,0>)     
   
   
   #declare vcnt = vcnt + 1;   //added 1 vertex
   #local orignum = vcnt;  //grab that vertex number
   
   
   ///---------------------
   #if(arc = 2*pi_val)
   
    #local k = 0;   //set counter to 0
   
    ///add vertexes 
    #while(k < crot)  
        
        vwrite(<cos(k), 0, sin(k)>)
          
        #declare vcnt = vcnt + 1;  //added another vertex
      
        #local k = k + (1/segs)*crot;
    #end //while
    
    
    #local m = orignum;    //put origin vertex number in counter variable
    #local tel = (m - 1) + segs;
   
    //make faces for base  
 
    #while(m < tel)
   
        #write(ofilid, "f", " ", orignum, " ", m+1, " ", m+2, "\n")
        #local m = m + 1;
       
    #end //end while
   
    
    #write(ofilid, "f", " ", orignum, " ", m+1, " ", orignum +1 , "\n") //last face on base
  
    
   #else   //otherwise if arc <> 2*pi
    
     #local k = 0;   //set counter to 0
   
    //add vertexes 
     #while(k <= crot)  //one more vertex than case of 2*pi
     
        vwrite(<cos(k), 0, sin(k)>)
        
        #declare vcnt = vcnt + 1;  //added another vertex
      
        #local k = k + (1/segs)*crot;
     #end //while
     
     #local m = orignum;    //put origin vertex number in counter variable
     #local tel = (m - 0) + segs;
   
     //make faces for base  
 
     #while(m < tel)
   
        #write(ofilid, "f", " ", orignum, " ", m+1, " ", m+2, "\n")
        #local m = m + 1;
       
     #end //end while
   
    
    
    #end //end if
  
 
    
 #end //if writobjfil
 

  
  mshfleplg()
  
 #end // if bildshap

 //reset transform back to default
 resetranz()
 
#end //macro j_gon

    
    



            //baspnt, toppoint, baseradius, segments, arc
#macro j_cone(baspnt, toppnt, brad, segs, arc)  
 
 #if(bildshap)   
  
 
  #if(brad <= 0) brad = 1; #end  //no zero base radius
  
  
  
  #if(segs < 3) #local segs = 3; #end  //at least 3
  #local segs = int(segs);  //only integer number of segments
  
  #if(toppnt.x = 0 & toppnt.y = 0 & toppnt.z = 0)
      #local toppnt = <0,1,0>;
  #end                                                                     
  
  #if(arc > 360) #local arc = arc - 360; #end  //no arcs greater than 360 d
  

  #local arc = (arc*pi_val)/180.0;  //convert to radians. e.c.c.
  
  #local j = 0; 
  
 
  #local crot = arc;
  
  mshflprlg("con")
  
 #if(bildmesh)
  mesh{
 
  
   #while(j < crot)
      
      
      
      //make union of triangles for base
      //default y axis
        
       triangl( 
               <0, 0+baspnt, 0>
               
              
               <cos(j+(1/segs)*crot)*brad, 0+baspnt, sin(j+(1/segs)*crot)*brad>,
               
               
               <cos(j)*brad, 0+baspnt, sin(j)*brad>
               
              )
       
       
     #local j = j + (1/segs)*crot;
   #end //end while
  
  #undef j
  
  
  #if(arc = 2*pi_val)   //if arc is a full circle
  
    #local j = 0;  //loop again for sides of cone
  
  
    #while(j < crot)
       
    
       triangl(toppnt,
               
               <cos(j)*brad, 0+baspnt, sin(j)*brad>,
               
              
               <cos(j+(1/segs)*crot)*brad, 0+baspnt, sin(j+(1/segs)*crot)*brad>
               
               
              )
       
       #local j = j + (1/segs)*crot;
  
    #end //end while
 
  #else // if arc not is a full circle  
    
    //make closed face for first triangle
    
       
    triangl( 
            
            <0, 0+baspnt, 0>,
            
            ///<cos(0), 0+baspnt, sin(0)>
            
            <1*brad, 0+baspnt, 0>,
            toppnt
           )
    
    
   
    #local j = 0;  //loop again for sides of cone
  
  
    #while(j < crot)
      
       
       triangl(toppnt,
       
             
               <cos(j)*brad, 0+baspnt, sin(j)*brad>,
       
              
               <cos(j+(1/segs)*crot)*brad, 0+baspnt, sin(j+(1/segs)*crot)*brad>
               
               
              )
              
       
       #local j = j + (1/segs)*crot;
  
    #end //end while
  
      //make closed face for last triangle
      
           
      triangl(
              <0, 0+baspnt, 0>
              toppnt,
             
              <cos(j)*brad, 0+baspnt, sin(j)*brad>
      
              
             )
    
 
  #end //if arc is a circle
    
  scale <1,1,-1>  //to match obj axis
  texture{meshtex}
 
  }  //end mesh 
 
 #end //if bildmesh 

                              

 #if(writobjfil)   //if we export to obj file
   
   mkobjgrp("cone")
   
   
   //add vertex of center of base
   //#write(ofilid, "# center of base, vertex number: ",str(vcnt+1,1,0), "\n")
  
    
   vwrite(<0, 0+baspnt, 0>)     
   
   
   #declare vcnt = vcnt + 1;   //added 1 vertex
   #local orignum = vcnt;  //grab that vertex number
   
   
   ///---------------------
   #if(arc = 2*pi_val)
   
    #local k = 0;   //set counter to 0
   
    //add vertexes for base
    #while(k < crot)  
       
       
        vwrite(<cos(k)*brad, 0+baspnt, sin(k)*brad>)
        
        
        #declare vcnt = vcnt + 1;  //added another vertex
      
        #local k = k + (1/segs)*crot;
    #end //while
    
    
    #local m = orignum;    //put origin vertex number in counter variable
    #local tel = (m - 1) + segs;
   
    //make faces for base  
 
    #while(m < tel)
    
        #write(ofilid, "f", " ", orignum, " ", m+1, " ", m+2, "\n")
        #local m = m + 1;
       
    #end //end while
   
    
    #write(ofilid, "f", " ", orignum, " ", m+1, " ", orignum +1 , "\n") //last face on base
  
    
   #else   //otherwise if arc <> 2*pi
    
     #local k = 0;   //set counter to 0
   
    //add vertexes for base
     #while(k <= crot)  //one more vertex than case of 2*pi
     
        
       
        vwrite(<cos(k)*brad, 0+baspnt, sin(k)*brad>)
        
          
        #declare vcnt = vcnt + 1;  //added another vertex
      
        #local k = k + (1/segs)*crot;
     #end //while
     
     #local m = orignum;    //put origin vertex number in counter variable
     #local tel =  (m + segs);
   
      //add faces for base
    
      #while(m < tel)
    
        #write(ofilid, "f", " ", orignum, " ", m+1, " ", m+2, "\n")
        #local m = m + 1;
       
      #end //end while
   
    
    
    #end //end if
  
   
   
   
   
   #if(arc = 2*pi_val)
  
   
     //write top point vertex
     //#write(ofilid, "# top vertex point, vertex: ", str(vcnt+1,1,0),"\n")
     
    
     vwrite(toppnt)
        
     #declare vcnt = vcnt + 1;   //added 1 more vertex
     #local topnum = vcnt;  //grab that vertex number
   
  
   
     //now make faces for sides 
     #local mb = orignum;
     #local tel = (mb - 1) + segs;
     
   
     
     #while(mb < tel)
    
         #write(ofilid, "f", " ", topnum, " ", mb+1, " ", mb+2, "\n")
         #local mb = mb + 1;
       
     #end //end while
    
     #write(ofilid, "f", " ", topnum, " ", mb+1, " ", orignum+1 , "\n") //last face on base
     
     
   #else  //if arc is not a full circle
   
     //write top point vertex
     //#write(ofilid, "# top vertex point, vertex: ", str(vcnt+1,1,0),"\n")
    
     vwrite(toppnt)   
    
     #declare vcnt = vcnt + 1;   //added 1 more vertex
     #local topnum = vcnt;  //grab that vertex number
    
     //make close face for first triangle
     
     #write(ofilid, "f", " ", orignum, " ", topnum, " ", orignum+1, "\n") //first face on side
   
      //now make sides 
     #local mb = orignum;
     #local tel = (mb + segs);
     
   
     #while(mb < tel)
     
         #write(ofilid, "f", " ", topnum, " ", mb+1, " ", mb+2, "\n")
         #local mb = mb + 1;
       
     #end ///end while
    
     ///make close face for last triangle
     
     #write(ofilid, "f", " ", orignum, " ", topnum, " ", topnum-1, "\n") //last face on side
   
   
     
   #end //if arc = 2 * pi
    
 #end //if writobjfil
 

 
 mshfleplg()
 
 #end //if bildshap
 
 //reset transform back to default
 resetranz()
 
#end //macro j_cone



#macro p_cone(baspnt, toppnt, brad)
  
  #if(brad <= 0) brad = 1; #end  //no zero base radius
  
  #local segs = prez;
  
  cone{<0, baspnt, 0>, brad, <0, toppnt, 0>, 0  
     texture{meshtex} 
     transform{tfp}
     transform{tfp2}
     }    
     
  #declare bildmesh = 0; //turn off pov mesh bilding
     //baspnt, toppnt, brad, segs, arc
    j_cone(baspnt, <0, toppnt, 0>, brad, prez, 360)
  
  #declare bildmesh = 1; //turn back on pov mesh bilding        
  
  resetranz()
  

#end  
  
  
  
  



          //baspnt, toppoint, topradius, baseradius, segments, arc
#macro j_cyl(baspnt, toppnt,  trad,        brad,      segs,     arc)  
 
 
 
 #if(bildshap)   
  
 
  #if(brad <= 0) brad = 1; #end  //no zero base radius
  
                
  
  #if(segs < 3) #local segs = 3; #end  //at least 3
  #local segs = int(segs);  //only integer number of segments
  
  #if(toppnt.x = 0 & toppnt.y = 0 & toppnt.z = 0)
      #local toppnt = <0,1,0>;
  #end                                                                     
  
  #if(arc > 360) #local arc = arc - 360; #end  //no arcs greater than 360 d
  
 
  #local arc = (arc*pi_val)/180.0;  //convert to radians. e.c.c.
  
  
  
 
  #local crot = arc;
 
  mshflprlg("cyl")
  
  //mesh mor efficient than union of triangles
  
 #if(bildmesh) 
  mesh{
  
   #local j = 0; 
   #while(j < crot)
    
      //make union of triangles for base
      //default y axis
      
       triangl(<0, baspnt, 0>, 
               
              <cos(j+(1/segs)*crot)*brad, 0+baspnt, sin(j+(1/segs)*crot)*brad>,
                           
              <cos(j)*brad, 0+baspnt, sin(j)*brad>
                
              )
    
     #local j = j + (1/segs)*crot;
   #end //end while
   
  
   
   
   #local j = 0;
   
   
  
   #while(j < crot)
    
      //make union of triangles for top of cylinder
      //default y axis 
       //use the power of pov transforms
      
       
       
       triangl(toppnt,
               <cos(j)*trad+toppnt.x, 0+toppnt.y, sin(j)*trad+toppnt.z>,
               <cos(j+(1/segs)*crot)*trad+toppnt.x, 0+toppnt.y, sin(j+(1/segs)*crot)*trad+toppnt.z>
       
              )
       
     #local j = j + (1/segs)*crot;
   #end //end while
 
   
                   


  
  #if(arc = 2*pi_val)   //if arc is a full circle
  
    #local j = 0;  //loop again for sides of cyl
  
  
    #while(j < crot)
     
      
       
       triangl(<cos(j)*trad+toppnt.x, 0+toppnt.y, sin(j)*trad+toppnt.z>,
               
               <cos(j)*brad, 0+baspnt , sin(j)*brad>,
               
               <cos(j+(1/segs)*crot)*trad+toppnt.x, 0+toppnt.y, sin(j+(1/segs)*crot)*trad+toppnt.z>
              )
       
      
       
       triangl(<cos(j+(1/segs)*crot)*trad+toppnt.x, 0+toppnt.y, sin(j+(1/segs)*crot)*trad+toppnt.z>, 
               
               <cos(j)*brad, 0+baspnt, sin(j)*brad>, 
               
               <cos(j+(1/segs)*crot)*brad, 0, sin(j+(1/segs)*crot)*brad>
       
              )
       
       #local j = j + (1/segs)*crot;
  
    #end //end while
 
  #else // if arc not is a full circle  
     
     //make closed face for first triangle
     #local j = 0; 
    
     
     triangl(<cos(j)*trad+toppnt.x, 0+toppnt.y, sin(j)*trad+toppnt.z>, 
             <0+toppnt.x,0+toppnt.y,0+toppnt.z>, 
             <cos(j)*brad, 0+baspnt , sin(j)*brad>
             
              )
    
     
     triangl(<0+toppnt.x, 0+toppnt.y, 0+toppnt.z>, 
             <0, baspnt, 0>,
           
             <cos(j)*brad, 0+baspnt , sin(j)*brad>
             
            )
     
     
     #local j = 0;  //loop again for sides of cyl
  
   
     #while(j < crot)
     
      
      
       
       triangl(<cos(j)*trad+toppnt.x, 0+toppnt.y, sin(j)*trad+toppnt.z>, 
              
               <cos(j)*brad, 0+baspnt , sin(j)*brad>,
              
               <cos(j+(1/segs)*crot)*trad+toppnt.x, 0+toppnt.y, sin(j+(1/segs)*crot)*trad+toppnt.z>
     
              )
    
     
      
       triangl(<cos(j+(1/segs)*crot)*trad+toppnt.x, 0+toppnt.y, sin(j+(1/segs)*crot)*trad+toppnt.z>, 
               
               <cos(j)*brad, 0+baspnt , sin(j)*brad>, 
               
               <cos(j+(1/segs)*crot)*brad, 0+baspnt, sin(j+(1/segs)*crot)*brad>
                
               
               )
    
       
      #local j = j + (1/segs)*crot;
  
    #end //end while
    
     //make closed face for last triangle
    
     
     triangl(<cos(j)*trad+toppnt.x, 0+toppnt.y, sin(j)*trad+toppnt.z>, 
            
             <cos(j)*brad, 0+baspnt , sin(j)*brad>, 
            
             <0+toppnt.x,0+toppnt.y,0+toppnt.z>   
     
            )
    
   
     
     
     triangl(
             <0, baspnt, 0>
              
             <0+toppnt.x,0+toppnt.y,0+toppnt.z>, 
             
             <cos(j)*brad, 0+baspnt , sin(j)*brad>
             
             
            )
            
     
   
  #end //if arc is a circle
    
 
  scale <1,1,-1>  //to match obj axis
  texture{meshtex}
  } //end mesh

 #end //if bildmesh
 
                              

 #if(writobjfil)   //if we export to obj file
   
   mkobjgrp("cylinder")
   
   
   //add vertex of center of base
   //#write(ofilid, "# center of base, vertex number: ",str(vcnt+1,1,0), "\n")
  
   vwrite(<0, 0+baspnt, 0>)
   
   #declare vcnt = vcnt + 1;   //added 1 vertex
   #local orignum = vcnt;  //grab that vertex number
   
   
   
   ///---------------------
   #if(arc = 2*pi_val)  //if arc is a full circle
   
    #local k = 0;   //set counter to 0
   
    //add vertexes for base
    #while(k < crot)  
        
      
        vwrite(<cos(k)*brad, 0+baspnt, sin(k)*brad>)
          
              
        #declare vcnt = vcnt + 1;  //added another vertex
      
        #local k = k + (1/segs)*crot;
    #end //while
    
   
    
    #local m = orignum;    //put origin vertex number in counter variable
    #local tel = (m - 1) + segs;
   
    //add faces on base
    #while(m < tel)
    
    
        #write(ofilid, "f", " ", orignum, " ", m+1, " ", m+2, "\n")
        #local m = m + 1;
       
    #end //end while
   
    
    #write(ofilid, "f", " ", orignum, " ", m+1, " ", orignum +1 , "\n") //last face on base
   
   
   
    
   //add vertex of center of top
   
    //#write(ofilid, "# center of top, vertex number: ",str(vcnt+1,1,0), "\n")
    
    vwrite(<0+toppnt.x, 0+toppnt.y, 0+toppnt.z>)   
    
    #declare vcnt = vcnt + 1;   //added 1 vertex
    #local toporignum = vcnt;  //grab that vertex number
    
  
    
    #local k = 0;   //set counter to 0
    
    //add vertexes for top of cylinder
    #while(k < crot)  
         
        vwrite(<cos(k)*trad+toppnt.x, 0+toppnt.y, sin(k)*trad+toppnt.z>)
         
        #declare vcnt = vcnt + 1;  //added another vertex
      
        #local k = k + (1/segs)*crot;
    #end //while
    
    
     //make faces for top
      
    
      #local m = toporignum;
      #local tel = (m - 1) + segs;
      
     
      #while(m < tel)
    
        #write(ofilid, "f", " ", toporignum, " ", m+1, " ", m+2, "\n")
        #local m = m + 1;
       
      #end //end while
   
    
      #write(ofilid, "f", " ", toporignum, " ", m+1, " ", toporignum +1 , "\n") //last face on top
  
    
   
    
    #else   //otherwise if arc <> 2*pi
    
   
   
    
    
     #local k = 0;   //set counter to 0
   
    //add vertexes for base
     #while(k <= crot)  //one more vertex than case of 2*pi
     
        vwrite(<cos(k)*brad, 0+baspnt, sin(k)*brad>)
          
            
        #declare vcnt = vcnt + 1;  //added another vertex
      
        #local k = k + (1/segs)*crot;
     #end //while
     
     
     #local m = orignum;    //put origin vertex number in counter variable
     #local tel = (m + segs);
   
     //make faces for base
   
     #while(m < tel)
    
        #write(ofilid, "f", " ", orignum, " ", m+1, " ", m+2, "\n")
        #local m = m + 1;
       
     #end //end while
     
     //add vertex of center of top
     //#write(ofilid, "# center of top, vertex number: ",str(vcnt+1,1,0), "\n")
      
     vwrite(<0+toppnt.x, 0+toppnt.y, 0+toppnt.z>)
       
        
     #declare vcnt = vcnt + 1;   //added 1 vertex
     #local toporignum = vcnt;  //grab that vertex number
     
     
     
     
     //add vertexes for top
   
     #local k = 0;   //set counter to 0
   
   
     #while(k <= crot)  //one more vertex than case of 2*pi
        
        vwrite(<cos(k)*trad+toppnt.x, 0+toppnt.y, sin(k)*trad+toppnt.z>)
        
        #declare vcnt = vcnt + 1;  //added another vertex
      
        #local k = k + (1/segs)*crot;
     #end //while
    
    //make faces for top
     
      #local m = toporignum;
      #local tel = (m  + segs);
     
      #while(m < tel)
    
        #write(ofilid, "f", " ", toporignum, " ", m+1, " ", m+2, "\n")
        #local m = m + 1;
       
      #end //end while
   
   
    
    #end //end if
  
   
   
    
   
  
   
   ///#write(ofilid, "# side faces... ", "\n")
  
       
   #if(arc = 2*pi_val)  //if arc is full circle
  
      
     //now make sides of cylinder
     #local mb = orignum;
     #local mq = toporignum;
     #local tel = (mb - 1) + segs;  //so always loop 1 less than segs number of times
     
    
   
     #while(mb < tel) 
    
         #write(ofilid, "f", " ", mb+1, " ", mb+2, " ", mq+2, " ", mq+1"\n")
         #local mb = mb + 1;
         #local mq = mq + 1;
        
     #end //end while
                              //5            2                  7             10
     #write(ofilid, "f", " ", mb+1, " ", orignum+1, " ", toporignum+1, " ", mq+1,"\n")
     
  
     
   #else  //if arc is not a full circle
     #local mb = orignum;
     #local mq = toporignum;
     //make close face for first face
    
      #write(ofilid, "f", " ", mb, " ", mq, " ", mq+1, " ", mb+1, "\n")
     
     //make sides of cylinder   
      #local tel = (mb  + segs);  //so always loop segs number of times
      #while(mb < tel) 
      
         #write(ofilid, "f", " ", mb+1, " ", mb+2, " ", mq+2, " ", mq+1, "\n")
         #local mb = mb + 1;
         #local mq = mq + 1;
      
      #end
     //make close face for last face
      #write(ofilid, "f", " ", toporignum, " ", orignum, " ", toporignum-1, " ", mq+1, "\n")
      
     
   #end //if arc = 2 * pi
   
 #end //if writobjfil
 

 
 mshfleplg()
  
 #end ///if bildshap 
 
 //reset transform back to default
 resetranz()
 
#end //macro j_cyl



#macro p_cyl(baspnt, toppnt, brad)
  
  #local segs = prez;
  
  cylinder{<0, baspnt, 0>, <0, toppnt, 0>, brad scale <1,1,1> 
             texture{meshtex} 
             transform{tfp}
             transform{tfp2} //global tranz
             } 
   
  #declare bildmesh = 0; //turn off pov mesh bilding
        //baspnt, toppoint,    topradius, baseradius, segments, arc
    j_cyl(baspnt, <0, toppnt, 0>, brad,     brad,      prez,    360)
  
  #declare bildmesh = 1; //turn back on pov mesh bilding        
  
  resetranz()

#end //p_cyl







          //baspnt, toppoint, topradius, baseradius, segments, arc, topinrad, binrad 
#macro j_tub(baspnt, toppnt,    trad,      brad,       segs,    arc,  tinrad, binrad)  
 
 
 #if(bildshap)   
  
 
   
 
  #if(brad <= 0) brad = 1; #end  //no zero base radius
  #if(tinrad <= 0) inrad = 0.5; #end  //no zero base inner radius
  #if(binrad <= 0) inrad = 0.5; #end  //no zero top inner radius
  
  
  #if(segs < 3) #local segs = 3; #end  //at least 3
  #local segs = int(segs);  //only integer number of segments
  
  #if(toppnt.x = 0 & toppnt.y = 0 & toppnt.z = 0)
      #local toppnt = <0,1,0>;
  #end                                                                     
  
  #if(arc > 360) #local arc = arc - 360; #end  //no arcs greater than 360 d
  
 
  #local arc = (arc*pi_val)/180.0;  //convert to radians. e.c.c.
  
  #local j = 0; 
  
 
  #local crot = arc;
  
  mshflprlg("tub")

 #if(bildmesh)
  
  mesh{
 
  
 
  
  #if(arc = 2*pi_val)   //if arc is a full circle
    
    //make top of tube
    #local j = 0;  
     
    #while(j < crot)
     
      
      triangl(
      
             
              <cos(j)*tinrad*trad+toppnt.x, 0+toppnt.y, sin(j)*tinrad*trad+toppnt.z>, 
              
              <cos(j)*trad+toppnt.x, 0+toppnt.y, sin(j)*trad+toppnt.z>, 
              
              <cos(j+(1/segs)*crot)*tinrad*trad+toppnt.x, 0+toppnt.y, sin(j+(1/segs)*crot)*tinrad*trad+toppnt.z>
      
             )
      
      
      triangl(
              
              <cos(j+(1/segs)*crot)*tinrad*trad+toppnt.x, 0+toppnt.y, sin(j+(1/segs)*crot)*tinrad*trad+toppnt.z>, 
              
              <cos(j)*trad+toppnt.x, 0+toppnt.y, sin(j)*trad+toppnt.z>, 
              
              <cos(j+(1/segs)*crot)*trad+toppnt.x, 0+toppnt.y, sin(j+(1/segs)*crot)*trad+toppnt.z>
      
             )
      
        
             
      #local j = j + (1/segs)*crot;
    #end //end while         
    
    //make bottom of tube
    
    #local j = 0;  
     
    #while(j < crot)
       
     
      
      triangl(
              
              <cos(j)*binrad*brad, 0+baspnt, sin(j)*binrad*brad>,
      
              <cos(j+(1/segs)*crot)*binrad*brad, 0+baspnt, sin(j+(1/segs)*crot)*binrad*brad>, 
              
              
              <cos(j)*brad, 0+baspnt, sin(j)*brad>
              
      
             ) 
       
     
      
      triangl(
            
              <cos(j+(1/segs)*crot)*binrad*brad, 0+baspnt, sin(j+(1/segs)*crot)*binrad*brad>, 
      
              <cos(j+(1/segs)*crot)*brad, 0+baspnt, sin(j+(1/segs)*crot)*brad>, 
              
              <cos(j)*brad, 0+baspnt, sin(j)*brad>
       
             )
      
     
     
      #local j = j + (1/segs)*crot;
    #end //end while         
    
             
    #local j = 0;  //loop again for outer wall sides of tube  
     
    #while(j < crot)
      
      
      
      triangl(<cos(j)*trad+toppnt.x, 0+toppnt.y, sin(j)*trad+toppnt.z>, 
              
              <cos(j)*brad, 0+baspnt, sin(j)*brad>,
              
              <cos(j+(1/segs)*crot)*trad+toppnt.x, 0+toppnt.y, sin(j+(1/segs)*crot)*trad+toppnt.z>
      
             )
    
     
      
      triangl(<cos(j+(1/segs)*crot)*trad+toppnt.x, 0+toppnt.y, sin(j+(1/segs)*crot)*trad+toppnt.z>, 
              
              <cos(j)*brad, 0+baspnt, sin(j)*brad>, 
              
              <cos(j+(1/segs)*crot)*brad, 0+baspnt, sin(j+(1/segs)*crot)*brad>
      
             )
     
       
       #local j = j + (1/segs)*crot;
  
    #end //end while
    
    
    
    
    #local j = 0;  //loop again for inner wall sides of tube
  
  
    #while(j < crot)
      
      
      
      triangl(
      
              <cos(j+(1/segs)*crot)*tinrad*trad+toppnt.x, 0+toppnt.y, sin(j+(1/segs)*crot)*tinrad*trad+toppnt.z>,
              
              <cos(j)*binrad*brad, 0+baspnt, sin(j)*binrad*brad>, 
              
              
              <cos(j)*tinrad*trad+toppnt.x, 0+toppnt.y, sin(j)*tinrad*trad+toppnt.z>
      
             )
    
    
    
      
      triangl(
              <cos(j)*binrad*brad, 0+baspnt, sin(j)*binrad*brad>, 
      
              <cos(j+(1/segs)*crot)*tinrad*trad+toppnt.x, 0+toppnt.y, sin(j+(1/segs)*crot)*tinrad*trad+toppnt.z>, 
              
              <cos(j+(1/segs)*crot)*binrad*brad, 0+baspnt, sin(j+(1/segs)*crot)*binrad*brad>
     
             )
      
                    
       #local j = j + (1/segs)*crot;
  
    #end //end while
 
  #else // if arc not is a full circle   ----------------------------
    
    
    #local j = 0; 
    //make closed face for first triangle  joining outer wall to inner wall  of tube
   
   
    
    triangl(
            
            <cos(j)*trad+toppnt.x, 0+toppnt.y, sin(j)*trad+toppnt.z>, 
           
            <cos(j)*tinrad*trad+toppnt.x, 0+toppnt.y, sin(j)*tinrad*trad+toppnt.z>, 
            
            <cos(j)*brad, 0+baspnt, sin(j)*brad>
     
    
           )  
    
   
   
    
    triangl(
    
            <cos(j)*tinrad*trad+toppnt.x, 0+toppnt.y, sin(j)*tinrad*trad+toppnt.z>, 
            
            <cos(j)*binrad*brad, 0+baspnt, sin(j)*binrad*brad>, 
             
            <cos(j)*brad, 0+baspnt, sin(j)*brad>
    
           ) 
     
     
   
    
    #local j = 0;  //loop again for sides of outer wall of tube
        
    #while(j < crot)
      
      
      triangl(
      
              <cos(j)*trad+toppnt.x, 0+toppnt.y, sin(j)*trad+toppnt.z>, 
              
              <cos(j)*brad, 0+baspnt, sin(j)*brad>, 
              
              <cos(j+(1/segs)*crot)*trad+toppnt.x, 0+toppnt.y, sin(j+(1/segs)*crot)*trad+toppnt.z>
     
             )
      
     
      
      
      
      triangl(<cos(j+(1/segs)*crot)*trad+toppnt.x, 0+toppnt.y, sin(j+(1/segs)*crot)*trad+toppnt.z>, 
              
              <cos(j)*brad, 0+baspnt, sin(j)*brad>, 
              
              <cos(j+(1/segs)*crot)*brad, 0+baspnt, sin(j+(1/segs)*crot)*brad>
     
             )
      
     
       
       #local j = j + (1/segs)*crot;
  
    #end //end while
  
  
    #local j = 0;  //loop again for sides of inner wall of tube
    #while(j < crot)
     
      
      
      triangl(
              
              <cos(j)*binrad*brad, 0+baspnt, sin(j)*binrad*brad>, 
      
              <cos(j)*tinrad*trad+toppnt.x, 0+toppnt.y, sin(j)*tinrad*trad+toppnt.z>, 
            
              <cos(j+(1/segs)*crot)*tinrad*trad+toppnt.x, 0+toppnt.y, sin(j+(1/segs)*crot)*tinrad*trad+toppnt.z>
     
             )
      
     
      
      
      triangl(
             
              <cos(j)*binrad*brad, 0+baspnt, sin(j)*binrad*brad>, 
      
              <cos(j+(1/segs)*crot)*tinrad*trad+toppnt.x, 0+toppnt.y, sin(j+(1/segs)*crot)*tinrad*trad+toppnt.z>, 
     
              <cos(j+(1/segs)*crot)*binrad*brad, 0+baspnt, sin(j+(1/segs)*crot)*binrad*brad>
     
             )
      
     
       
       #local j = j + (1/segs)*crot;
  
    #end //end while
    
    
     
       
    //make closed face for last triangle  joining outer wall to inner wall
     
     triangl(<cos(j)*trad+toppnt.x, 0+toppnt.y, sin(j)*trad+toppnt.z>, 
             
             <cos(j)*brad, 0+baspnt, sin(j)*brad>, 
             
             <cos(j)*tinrad*trad+toppnt.x, 0+toppnt.y, sin(j)*tinrad*trad+toppnt.z>
     
            )
    
   
    
     
     triangl(
     
             <cos(j)*tinrad*trad+toppnt.x, 0+toppnt.y, sin(j)*tinrad*trad+toppnt.z>, 
             
             <cos(j)*brad, 0+baspnt, sin(j)*brad>, 
             
             <cos(j)*binrad*brad, 0+baspnt, sin(j)*binrad*brad>
     
            )
     
     
          
      
     
     //make top of tube
    #local j = 0;  
     
    #while(j < crot)
  
         
      triangl(
      
              <cos(j)*tinrad*trad+toppnt.x, 0+toppnt.y, sin(j)*tinrad*trad+toppnt.z>, 
              
              <cos(j)*trad+toppnt.x, 0+toppnt.y, sin(j)*trad+toppnt.z>, 
              
              <cos(j+(1/segs)*crot)*tinrad*trad+toppnt.x, 0+toppnt.y, sin(j+(1/segs)*crot)*tinrad*trad+toppnt.z>
     
             ) 
     
     
      triangl(
      
              <cos(j+(1/segs)*crot)*tinrad*trad+toppnt.x, 0+toppnt.y, sin(j+(1/segs)*crot)*tinrad*trad+toppnt.z>,
              
              <cos(j)*trad+toppnt.x, 0+toppnt.y, sin(j)*trad+toppnt.z>, 
              
              <cos(j+(1/segs)*crot)*trad+toppnt.x, 0+toppnt.y, sin(j+(1/segs)*crot)*trad+toppnt.z>
     
             )  
       
          
             
     #local j = j + (1/segs)*crot;
    #end //end while         
    
    //make bottom of tube
    
    #local j = 0;  
     
    #while(j < crot)
      
      
      
      triangl(
               <cos(j)*binrad*brad, 0+baspnt, sin(j)*binrad*brad>, 
              
               <cos(j+(1/segs)*crot)*binrad*brad, 0+baspnt, sin(j+(1/segs)*crot)*binrad*brad>, 
              
               <cos(j)*brad, 0+baspnt, sin(j)*brad>
     
             ) 
       
     
      
      triangl(
        
              <cos(j+(1/segs)*crot)*binrad*brad, 0+baspnt, sin(j+(1/segs)*crot)*binrad*brad>, 
      
              <cos(j+(1/segs)*crot)*brad, 0+baspnt, sin(j+(1/segs)*crot)*brad>, 
              
              <cos(j)*brad, 0+baspnt, sin(j)*brad>
     
             )                             
             
     
      #local j = j + (1/segs)*crot;
    #end //end while         
    
     
     
    
  #end //if arc is a circle
 
 
  scale <1,1,-1>  //to match obj axis
  texture{meshtex}
 
  } //end union or mesh

 #end //if bildmesh
                              

 #if(writobjfil)   //if we export to obj file
   
   mkobjgrp("tube")
   
   
   #if(arc = 2*pi_val)  //if arc is a full circle
    
    
    //make outer wall
    #local basvtks1 = vcnt+1; //grab that vertex number
    //#write(ofilid, "# line number of first vertex of base of outer wall: ", str(basvtks1,1,0), "\n")
    //#write(ofilid, "# base vertexes of outer wall...", "\n")
  
  
   
    //add vertexes for base of outer wall
    #local k = 0;   //set counter to 0
    #while(k < crot)  
       
       vwrite(<cos(k)*brad, 0+baspnt, sin(k)*brad>) 
         
            
       #declare vcnt = vcnt + 1;  //added another vertex
      
       #local k = k + (1/segs)*crot;
    #end //while
    
    
    #local topvtks1 = vcnt+1; //grab that vertex number
    //#write(ofilid, "# line number of first vertex of top of outer wall: ", str(topvtks1,1,0), "\n")
    //#write(ofilid, "# top vertexes of outer wall... ", "\n")
    
    
    //add vertexes for top of outer wall
    #local k = 0;   //set counter to 0
    #while(k < crot)  
         
        vwrite(<cos(k)*trad+toppnt.x, 0+toppnt.y, sin(k)*trad+toppnt.z>)
        
            
        #declare vcnt = vcnt + 1;  //added another vertex
      
        #local k = k + (1/segs)*crot;
    #end //while
    
    
    
   
   
   //make faces for outer wall
    #local m = basvtks1;    //first vertex of base, line number
    #local n = topvtks1;    //first vertex of top, line number
    #local tel = (m - 1) + segs;  //so always loop 1 less than segs number of times
     
  
    #while(m < tel)
    
    
    
        #write(ofilid, "f", " ", m, " ", m+1, " ", n+1, " ", n, "\n")
        #local m = m + 1;
        #local n = n + 1;
        
    #end //end while
   
    
    #write(ofilid, "f", " ", m, " ", basvtks1, " ", topvtks1, " ", n, "\n") //last face on outer wall
  
    
    //make inner wall
    #local basvtks2 = vcnt+1; //grab that vertex number
    //#write(ofilid, "# line number of first vertex of base of inner wall: ", str(basvtks2,1,0), "\n")
    //#write(ofilid, "# base vertexes of inner wall...", "\n")
  
    //add vertexes for base of inner wall
    #local k = 0;   //set counter to 0
    #while(k < crot)  
        
        vwrite(<cos(k)*binrad*brad, 0+baspnt, sin(k)*binrad*brad>)
          
                     
        #declare vcnt = vcnt + 1;  //added another vertex
      
        #local k = k + (1/segs)*crot;
    #end //while
    
    
    #local topvtks2 = vcnt+1; //grab that vertex number
    //#write(ofilid, "# line number of first vertex of top of inner wall: ", str(topvtks2,1,0), "\n")
    //#write(ofilid, "# top vertexes of inner wall... ", "\n")
    
     //add vertexes for top of inner wall
    #local k = 0;   //set counter to 0
    #while(k < crot)  
        
        vwrite(<cos(k)*tinrad*trad+toppnt.x, 0+toppnt.y, sin(k)*tinrad*trad+toppnt.z>)
              
        #declare vcnt = vcnt + 1;  //added another vertex
      
        #local k = k + (1/segs)*crot;
    #end //while
    
    
    //make faces for inner wall
    #local m = basvtks2;    //first vertex of inner base, line number
    #local n = topvtks2;    //first vertex of inner top, line number
    #local tel = (m - 1) + segs;  //so always loop 1 less than segs number of times
     
  
    #while(m < tel)
   
    
    
        #write(ofilid, "f", " ", m, " ", m+1, " ", n+1, " ", n, "\n")
        #local m = m + 1;
        #local n = n + 1;
        
    #end //end while
   
    
    #write(ofilid, "f", " ", m, " ", basvtks2, " ", topvtks2, " ", n, "\n") //last face on outer wall
  
    //make faces for base
    
    #local m = basvtks1;    //first vertex of outer base, line number
    #local n = basvtks2;    //first vertex of inner base, line number
    #local tel = (m - 1) + segs;  //so always loop 1 less than segs number of times
     
  
    #while(m < tel)
    
    
        #write(ofilid, "f", " ", n, " ", m, " ", m+1, " ", n+1, "\n")
        #local m = m + 1;
        #local n = n + 1;
        
    #end //end while
    #write(ofilid, "f", " ", n, " ", m, " ", basvtks1, " ", basvtks2, "\n") //last face on base
  
    //make faces for top
    
    #local m = topvtks1;    //first vertex of outer base, line number
    #local n = topvtks2;    //first vertex of inner base, line number
    #local tel = (m - 1) + segs;  //so always loop 1 less than segs number of times
    
    #while(m < tel) 
    
    
        #write(ofilid, "f", " ", n, " ", m, " ", m+1, " ", n+1, "\n")
        #local m = m + 1;
        #local n = n + 1;
        
    #end //end while
    #write(ofilid, "f", " ", n, " ", m, " ", topvtks1, " ", topvtks2, "\n") //last face on outer wall
  
   
   
   
    
   #else   //otherwise if arc <> 2*pi  -----------------------------
    
   //make outer wall
    #local basvtks1 = vcnt+1; //grab that vertex number
    //#write(ofilid, "# line number of first vertex of base of outer wall: ", str(basvtks1,1,0), "\n")
    //#write(ofilid, "# base vertexes of outer wall...", "\n")
  
     
    //add vertexes for base of outer wall
    #local k = 0;   //set counter to 0 
    //one more vertex than case of 2*pi
    #while(k <= crot)  
         
        vwrite(<cos(k)*brad, 0+baspnt, sin(k)*brad>)
              
        #declare vcnt = vcnt + 1;  //added another vertex
      
        #local k = k + (1/segs)*crot;
    #end //while 

    #local topvtks1 = vcnt+1; //grab that vertex number
    //#write(ofilid, "# line number of first vertex of top of outer wall: ", str(topvtks1,1,0), "\n")
    //#write(ofilid, "# top vertexes of outer wall... ", "\n")
    
    
    //add vertexes for top of outer wall
    #local k = 0;   //set counter to 0 
    //one more vertex than case of 2*pi
    #while(k <= crot)  
        
        vwrite(<cos(k)*trad+toppnt.x, 0+toppnt.y, sin(k)*trad+toppnt.z>)
            
        #declare vcnt = vcnt + 1;  //added another vertex
      
        #local k = k + (1/segs)*crot;
    #end //while
    
   
    //make faces for outer wall
    #local m = basvtks1;    //first vertex of base, line number
    #local n = topvtks1;    //first vertex of top, line number
    #local tel = (m + segs);  //so always loop segs number of times
    
    #while(m < tel) 
   
    
        #write(ofilid, "f", " ", m, " ", m+1, " ", n+1, " ", n, "\n")
        #local m = m + 1;
        #local n = n + 1;
        
    #end //end while
   
    
 ///make inner wall
    #local basvtks2 = vcnt+1; //grab that vertex number
    //#write(ofilid, "# line number of first vertex of base of inner wall: ", str(basvtks2,1,0), "\n")
    //#write(ofilid, "# base vertexes of inner wall...", "\n")
    
    //add vertexes for base of inner wall
    #local k = 0;   //set counter to 0 
    //one more vertex than case of 2*pi
    #while(k <= crot)  
        
        vwrite(<cos(k)*binrad*brad, 0+baspnt, sin(k)*binrad*brad>)
        
            
        #declare vcnt = vcnt + 1;  //added another vertex
      
        #local k = k + (1/segs)*crot;
    #end //while 

    #local topvtks2 = vcnt+1; //grab that vertex number
    //#write(ofilid, "# line number of first vertex of top of inner wall: ", str(topvtks2,1,0), "\n")
    //#write(ofilid, "# top vertexes of inner wall... ", "\n")
    
   //add vertexes for top of inner wall 
    #local k = 0;   //set counter to 0 
    //one more vertex than case of 2*pi
    #while(k <= crot)  
        
        vwrite(<cos(k)*tinrad*trad+toppnt.x, 0+toppnt.y, sin(k)*tinrad*trad+toppnt.z>)
        
            
        #declare vcnt = vcnt + 1;  //added another vertex
      
        #local k = k + (1/segs)*crot;
    #end //while
     
    //make faces for inner wall
    #local m = basvtks2;    //first vertex of base, line number
    #local n = topvtks2;    //first vertex of top, line number
    #local tel = (m + segs);  //so always loop segs number of times
    
    #while(m < tel) 
   
    
        #write(ofilid, "f", " ", m, " ", m+1, " ", n+1, " ", n, "\n")
        #local m = m + 1;
        #local n = n + 1;
        
    #end //end while
    
    //make faces for base
    
    #local m = basvtks1;    //first vertex of outer base, line number
    #local n = basvtks2;    //first vertex of inner base, line number
    #local tel = (m + segs);  //so always loop segs number of times
     
  
    #while(m < tel)
    
    
        #write(ofilid, "f", " ", n, " ", m, " ", m+1, " ", n+1, "\n")
        #local m = m + 1;
        #local n = n + 1;
        
    #end //end while
    
   //make faces for top
   #local m = topvtks1;    //first vertex of outer base, line number
   #local n = topvtks2;    //first vertex of inner base, line number
   #local tel = (m + segs);  //so always loop segs number of times
     
  
    #while(m < tel)
    
    
        #write(ofilid, "f", " ", n, " ", m, " ", m+1, " ", n+1, "\n")
        #local m = m + 1;
        #local n = n + 1;
        
    #end //end while
    
    //close first end face
    #write(ofilid, "f", " ", basvtks2, " ", basvtks1, " ", topvtks1, " ", topvtks2, "\n")
    
    //close last end face
    /////#write(ofilid, "f", " ", n, " ", m, " ", topvtks1-1, " ", topvtks2-1, "\n")
    #write(ofilid, "f", " ", n, " ", m, " ", basvtks1+segs, " ", basvtks2+segs, "\n")
    
 
     
   #end //if arc = 2*pi
   
 

 #end //if writobjfil
 
 
 
 mshfleplg()

 
 #end //if bildshap
 
 //reset transform back to default
 resetranz()
 
#end //macro j_tub





///makes a sor tube of segments, defined by function or inverse function

       //      func1, func2, baseradius, htmlt, stretchvalue,  segments, tsegs,   closedtop, closbtm 
#macro k_ifsor(func1, func2, brad,       htmlt,     stv,        segs,    tsegs,     klostp,  klosbtm)  
  

 
 
 #if(bildshap)  
  
   
 
  #if(brad <= 0) brad = 1; #end  //no zero base radius
  
  
  #if(segs < 3) #local segs = 3; #end  //at least 3
  #local segs = int(segs);  //only integer number of segments
  
  //correcting code for pi error bug
  
  #ifndef(mypival)   //if we dont use users own value for pi     
    pvalercc(segs)   //use error correcting macro
  #else
    #declare pival = mypival;  //use users value for pi
  #end

  
    
  
  #if(tsegs < 3) #local tsegs = 3; #end  //at least 3
  #local tsegs = int(tsegs);  //only integer number of segments
  
 
  //not here use mkobjgrp("j_ifsor")
  
                                                                    
  mshflprlg("ifsor")
 
  //bug here when segs is 6
  
  #local crot = 2*pi_val;
  
  
  #macro imv()
 
   func1(js)
  
  #end
  
  #macro imvb()
   
    func1(js+(1/tsegs)*stv)
   
  #end 
  
  #macro ipv()
   
   func2(js)
  
  #end
  
  #macro ipvb()
  
    func2(js+(1/tsegs)*stv)
  
  #end
  
 #if(bildmesh)
 
  mesh{
 
 
    
  #local js = 0;
  
     
  
  #while(js < stv)
    
             
    #local j = 0;  //loop for sides of outer wall of tube  
     
    #while(j < crot)
      
        
        triangl(
                  
                
                 <cos(j)*brad*imvb(), ipvb()*htmlt, sin(j)*brad*imvb()>, 
                 <cos(j)*brad*imv(),  ipv()*htmlt, sin(j)*brad*imv()>,
                 <cos(j+(1/segs)*crot)*brad*imvb(), ipvb()*htmlt, sin(j+(1/segs)*crot)*brad*imvb()>
                              
                
                
             )
        
        
        triangl(
                
               
               <cos(j+(1/segs)*crot)*brad*imvb(), ipvb()*htmlt, sin(j+(1/segs)*crot)*brad*imvb()>, 
               <cos(j)*brad*imv(), ipv()*htmlt, sin(j)*brad*imv()>, 
               <cos(j+(1/segs)*crot)*brad*imv(), ipv()*htmlt,    sin(j+(1/segs)*crot)*brad*imv()>
      
             )
     
    
       
       #local j = j + (1/segs)*crot;
  
    #end //end while j < crot
    
    
      
    
   
   #local js = js + (1/tsegs)*stv;
  
      
  #end //while js < stv
  
  
  

  #local tmp = js;  //save js value
  
  #if(klosbtm)
    #local js = 0;
    #local j = 0;  
     
    #while(j < crot)    //not use for now
       
     
    
      
      triangl(
               
                //<0,ipv(), 0>,
                <0, 0, 0>,
                
               // <cos(j+(1/segs)*crot)*brad*imv(), ipv(), sin(j+(1/segs)*crot)*brad*imv()>,
                <cos(j+(1/segs)*crot)*brad*imv(), 0, sin(j+(1/segs)*crot)*brad*imv()>,
                 
               // <cos(j)*brad*imv(), ipv(), sin(j)*brad*imv()>
                <cos(j)*brad*imv(), 0, sin(j)*brad*imv()>
                 
              )
    
      #local j = j + (1/segs)*crot;
    #end //end while         
    
  #end
  
  
  #local js = tmp;  //restore js value
  
  #if(klostp) //if close top
  //make top of tube
    #local j = 0;
  
    #while(j < crot)
       
     
       
        //were in j_ifsor
      
        triangl(
                  
                  
                  <0, ipv()*htmlt, 0>,
                  <cos(j)*brad*imv(), ipv()*htmlt, sin(j)*brad*imv()>,
                  <cos(j+(1/segs)*crot)*brad*imv(), ipv()*htmlt, sin(j+(1/segs)*crot)*brad*imv()>
              
                )
              
              
        #local j = j + (1/segs)*crot;
     #end //end while         
  
  #end //if clostop
  //----------------------------------
  
  scale <1,1,-1>  //to match obj axis
  texture{meshtex}
 

  
  } //end union or mesh
  
 #end //if bildmesh
  
  
  //if we write to obj file
  #if(writobjfil)
   
  
  
     
   #local forig = vcnt;  //grab that count
   #write(ofilid, "# forig vertex number: ",str(forig,1,0), "\n\n")
   
   #local js = 0;
  
     
  
   #while(js <= stv)
   
     
     // levl
     #local k = 0;   //set counter to 0
   
      ///add vertexes 
     
     #while(k < 2*pival)  
     
        
         
          vwrite(<cos(k)*brad*imv(), ipv()*htmlt, sin(k)*brad*imv()>)
         
                    
          #declare vcnt = vcnt + 1;  //added another vertex
          ///#write(ofilid, "# vertex number: ",str(vcnt,1,0), "\n")
          
         
          #local k = k + (1/segs)*2*pival;
          
     #end //while
     #write(ofilid, "# this level last vertex number: ",str(vcnt,1,0), "\n")
     
  
   
     #local js = js + (1/tsegs)*stv; 
     
   #end //while js < stv  
   //------------------------------
    
    ///#write(ofilid, "# js val: ",str(js,1,0), "\n")
     
   
    #local lev = 1;  //cant be zero
    #local f = forig;
    #local n = 1;
   
   
     #while(lev <= tsegs) 
    
     
     #while(n < segs*lev)
                        //    1          5              6             2
        
        ///#write(ofilid, "inrlup \n") 
                            
       
      ///#write(ofilid, "f ",  n+f, " ", (n+f+segs), " ", (n+f+segs+1), " ", n+f+1, "\n")
       
        #write(ofilid, "f ",  n+f, " ", (n+f+segs), " ", n+f+1, "\n")
        #write(ofilid, "f ",  n+f+1, " ", (n+f+segs), " ", (n+f+segs+1), "\n")
        
      
        #local n = n + 1;
        
     #end 
     
      
      
                          //     4               8               5                1
     
     ///#write(ofilid, "this level last face \n")
     // 4 vertex face
     ///#write(ofilid, "f ",          n+f , " ",     n+f+segs, " ",       n+f+1, " ",    (n+f)-(segs-1), "\n")
     
     //2, 3 vertex face
      #write(ofilid, "f ",              n+f , " ",   n+f+segs, " ",  (n+f)-(segs-1), "\n")
      #write(ofilid, "f ",      (n+f)-(segs-1),  " ", n+f+segs, " ",   n+f+1, "\n")
       
     
     #local n = n + 1;
     
     #local lev = lev + 1;
    
     
    #end //while
        
      //segs: 4
      // 1 5 6 2
      // 2 6 7 3
      // 3 7 8 4
      // 4 8 5 1
  
      //segs: 6
      // 1 7  8  2
      // 2 8  9  3
      // 3 9  10 4
      // 4 10 11 5
      // 5 11 12 6
      // 6 12 7  1
  
    
    #if(klosbtm) 
      
      #local js = 0;
      
      vwrite(<0, 0, 0>)
      #declare vcnt = vcnt + 1;  //added another vertex
      #local orignum = vcnt;    //grab that number
      #local k = 0;   //set counter to 0
   
       ///add vertexes 
     
      #while(k < 2*pival)  
     
        
          //vwrite(<cos(k)*brad, 0, sin(k)*brad>)
          vwrite(<cos(k)*brad*imv(), 0, sin(k)*brad*imv()>)
         
          
          #declare vcnt = vcnt + 1;  //added another vertex
          //#write(ofilid, "# vertex number: ",str(vcnt,1,0), "\n")
          
         
          #local k = k + (1/segs)*2*pival;
          
      #end //while
      
      #local m = orignum;    //put origin vertex number in counter variable
      #local tel = (m - 1) + segs;
   
      //make faces for base  
 
      #while(m < tel)
   
        #write(ofilid, "f", " ", orignum, " ", m+1, " ", m+2, "\n")
        #local m = m + 1;
       
      #end //end while
   
    
      #write(ofilid, "f", " ", orignum, " ", m+1, " ", orignum +1 , "\n") //last face on base
  
       
    #end // if klosbtm
    
    
    
    
    #if(klostp)
    
      #local js = stv;     //not 1 hier
        
      vwrite(<0, ipv()*htmlt, 0>)
           
    
      #declare vcnt = vcnt + 1;   //added 1 vertex
      #local toporignum = vcnt;  //grab that vertex number
      
      #local k = 0;   //set counter to 0
    
      //add vertexes for top of cylinder
      #while(k < 2*pival)  
         
        vwrite(<cos(k)*brad*imv(), ipv()*htmlt, sin(k)*brad*imv()>)
         
        #declare vcnt = vcnt + 1;  //added another vertex
      
        #local k = k + (1/segs)*crot;
      #end //while
    
    
     //make faces for top
      
    
      #local m = toporignum;
      #local tel = (m - 1) + segs;
      
     
      #while(m < tel)
    
        #write(ofilid, "f", " ", toporignum, " ", m+1, " ", m+2, "\n")
        #local m = m + 1;
       
      #end //end while
   
    
      #write(ofilid, "f", " ", toporignum, " ", m+1, " ", toporignum +1 , "\n") //last face on top
  
    
      
    #end //if klostp
    
    
    
    
    
  #end // if writobjfil
  
                               
 mshfleplg()
 
 #end //if bildshap
 
 //reset transform back to default
 resetranz()
 //vanish away users pi value if it exists
 #ifdef(mypival)
   #undef mypival
 #end
 
#end //macro k_ifsor



          
          
///makes a sor tube of segments, defined by function or inverse function
//swap order of f1 with f2 for inverse function

       //      func1, func2, baseradius, htmlt, stretchvalue,  segments, tsegs,   closedtop, closbtm 
#macro j_ifsor(func1, func2, brad,       htmlt,     stv,        segs,    tsegs,     klostp,  klosbtm)  
  

 
 
 #if(bildshap)  
  
   
 
  #if(brad <= 0) brad = 1; #end  //no zero base radius
  
  
  #if(segs < 3) #local segs = 3; #end  //at least 3
  #local segs = int(segs);  //only integer number of segments
  
  #if(tsegs < 3) #local tsegs = 3; #end  //at least 3
  #local tsegs = int(tsegs);  //only integer number of segments
  
 
  ///mkobjgrp("j_ifsor")
  
                                                                    
  mshflprlg("j_ifsor")
 
  
  #local arc = 2*pi_val;
  #local crot = arc;
  
  #macro imv()
 
   func1(js)
  
  #end
  
  #macro imvb()
   
    func1(js+(1/tsegs)*stv)
   
  #end 
  
  #macro ipv()
   
   func2(js)
  
  #end
  
  #macro ipvb()
  
    func2(js+(1/tsegs)*stv)
  
  #end
  
 #if(bildmesh)
 
  mesh{
 
 
  
    
  #local js = 0;
  
     
  
  #while(js < stv)
    
             
    #local j = 0;  //loop for sides of outer wall of tube  
     
    #while(j < crot)
      
        
        trianglvf(
                  
                
                 <cos(j)*brad*imvb(), ipvb()*htmlt, sin(j)*brad*imvb()>, 
                 <cos(j)*brad*imv(),  ipv()*htmlt, sin(j)*brad*imv()>,
                 <cos(j+(1/segs)*crot)*brad*imvb(), ipvb()*htmlt, sin(j+(1/segs)*crot)*brad*imvb()>
                              
                
                
             )
        
        
        trianglvf(
                
               
               <cos(j+(1/segs)*crot)*brad*imvb(), ipvb()*htmlt, sin(j+(1/segs)*crot)*brad*imvb()>, 
               <cos(j)*brad*imv(), ipv()*htmlt, sin(j)*brad*imv()>, 
               <cos(j+(1/segs)*crot)*brad*imv(), ipv()*htmlt,    sin(j+(1/segs)*crot)*brad*imv()>
      
             )
     
    
       
       #local j = j + (1/segs)*crot;
  
    #end //end while j < crot
    
    
      
    
   
   #local js = js + (1/tsegs)*stv;
  
      
  #end //while js < stv
  
  
  

  #local tmp = js;  //save js value
  
  #if(klosbtm)
    #local js = 0;
    #local j = 0;  
     
    #while(j < crot)    //not use for now
       
     
    
      
      trianglvf(
               
                //<0,ipv(), 0>,
                <0, 0, 0>,
                
               // <cos(j+(1/segs)*crot)*brad*imv(), ipv(), sin(j+(1/segs)*crot)*brad*imv()>,
                <cos(j+(1/segs)*crot)*brad*imv(), 0, sin(j+(1/segs)*crot)*brad*imv()>,
                 
               // <cos(j)*brad*imv(), ipv(), sin(j)*brad*imv()>
                <cos(j)*brad*imv(), 0, sin(j)*brad*imv()>
                 
              )
    
      #local j = j + (1/segs)*crot;
    #end //end while         
    
  #end
  
  
  #local js = tmp;  //restore js value
  
  #if(klostp) //if close top
  //make top of tube
    #local j = 0;
  
    #while(j < crot)
       
     
       
        //were in j_ifsor
      
        trianglvf(
                  
                  
                  <0, ipv()*htmlt, 0>,
                  <cos(j)*brad*imv(), ipv()*htmlt, sin(j)*brad*imv()>,
                  <cos(j+(1/segs)*crot)*brad*imv(), ipv()*htmlt, sin(j+(1/segs)*crot)*brad*imv()>
              
                )
              
              
        #local j = j + (1/segs)*crot;
     #end //end while         
  
  #end //if clostop
  
 scale <1,1,-1>  //to match obj axis
 texture{meshtex}
 

  
 } //end union or mesh
#end //if bildmesh                             

 mshfleplg()
 
#end //if bildshap

 //reset transform back to default
 resetranz()
  
#end //macro j_ifsor




 



       //baseradius, segments, meridians, closbtm
#macro j_dom(brad,   segs,     mrds,      closbtm)  

  
 //makes a dom

 
 #local fa1 = function(a){cos(a)};
 
 
 #local fb1 = function(a){sin(a)};  
 
 
 mkobjgrp("dom")
 
 #if(fsjen=2)
   // func1, func2,  basrad,    htmlt,    strval,     segments,     meridians,   clostop, closbtm                         
   k_ifsor(fa1, fb1,   brad,     brad,       pi/2,          segs,        mrds,      0,        closbtm)  
 #else
   j_ifsor(fa1, fb1,   brad,     brad,       pi/2,          segs,        mrds,      0,        closbtm)  

 #end
 
 //reset transforms back to default
 resetranz()
 
#end //j_dom



            //basrad closedbottom
#macro p_dom(brad,   closbtm)
  
 
  
  #if(closbtm)
  
   difference{
     sphere{<0, 0, 0>, brad } 
     box{<-1, -1, -1>*brad, <1, 0, 1>*brad } 
   
     texture{meshtex} 
     transform{tfp}
     transform{tfp2}  //global tranz
    }
  #else
    sphere{<0, 0, 0>, brad clipped_by{box{<-1, -1, -1>*brad, <1, 0, 1>*brad } } 
             texture{meshtex} interior_texture{pigment{rgb <1,0,0>}} 
             transform{tfc}
             transform{tfc2}
             } 
  #end //if closbtm
  
  
  #if(writobjfil)   
  
    
 
   #local fa1 = function(a){cos(a)};
 
 
   #local fb1 = function(a){sin(a)};  
 
 
   mkobjgrp("p_dom")
   
   #declare bildmesh = 0;
   
   #if(fsjen=2)
     k_ifsor(fa1, fb1,   brad,     brad,       pi/2,        prez,         prez,         0,        closbtm)  
  
   #else
     // func1, func2,  basrad,    htmlt,    strval,     segments,     meridians,   clostop,     closbtm                         
     j_ifsor(fa1, fb1,   brad,     brad,       pi/2,        prez,         prez,         0,        closbtm)  
   #end
   
   #declare bildmesh = 1;
    
  #end //writobjfil
  //reset transforms back to default
  resetranz()
  
#end //p_dom











       //baseradius, segments, meridians
#macro j_sfr(brad,   segs,     mrds)  

  
 //makes a sphere
 #local fa1 = function(a){cos(a+pi/2)};


 #local fb1 = function(a){-sin(a+pi/2)};  

 mkobjgrp("sfr")
 
 #if(fsjen=2)
   k_ifsor(fa1, fb1,   brad,     brad,       pi,          segs,        mrds,      0,         0 )  
 #else
   // func1, func2,  basrad,    htmlt,    strval,     segments,     meridians,   clostop, closbtm                         
   j_ifsor(fa1, fb1,   brad,     brad,       pi,          segs,        mrds,      0,         0 )  
 #end
 
 //reset transforms back to default
 resetranz()
 
#end //j-sfr






#macro p_sfr(brad)
 
 
 sphere{<0, 0, 0>, 
        brad 
       
        texture{meshtex} 
        transform{tfp}
        transform{tfp2}
        } 
 
 
 #local fa1 = function(a){cos(a+pi/2)};


 #local fb1 = function(a){-sin(a+pi/2)};
   
  
 
 mkobjgrp("p_sfr")
 
 #declare bildmesh = 0;
 
 #if(fsjen=2)
   k_ifsor(fa1, fb1,  brad,  brad,  pi,       prez,    prez,    0, 0)   
 #else
   j_ifsor(fa1, fb1,  brad,  brad,  pi,       prez,    prez,    0, 0)  
 #end
 
 #declare bildmesh = 1;
 
 //reset transform back to default
 resetranz()
  
#end //p_sfr




#macro j_piltub(bsrad, segz, mrdz)

 //rad of each tube
 #local fpa = function(a){
   
  
  select(a-pi/2, -cos(a+pi/2), select(a-3*pi/2, 1, -cos(a-pi/2)) )
 

 };  

 //ht of each tube
 #local fpb = function(a){
  

 
 select(a-pi/2, -sin(a+pi/2), select(a-pi, a-pi/2, select(a-3*pi/2, a-pi/2, sin(a+pi/2)+pi)) ) 
 
 
 }; 
  
 mkobjgrp("piltub")
 
 #if(fsjen=2)
   k_ifsor(fpa, fpb,     bsrad,  1,    2*pi,          segz,        mrdz,      0, 0)                                                          
 #else
  j_ifsor(fpa, fpb,     bsrad,  1,    2*pi,          segz,        mrdz,      0, 0)                                                          
 #end

 
 //reset transforms back to default
 resetranz()
  
#end //j_piltub



#macro p_piltub(bsrad)
 
  
  union{
    sphere{<0, 0, 0>, bsrad }
    sphere{<0, pi, 0>, bsrad }
    cylinder{<0, 0, 0>, <0, pi, 0>, bsrad}
    texture{meshtex} 
    transform{tfp}
    transform{tfp2}
  } 
  
  #if(writobjfil)
   
    //rad of each tube
    #local fpa = function(a){
   
  
    select(a-pi/2, -cos(a+pi/2), select(a-3*pi/2, 1, -cos(a-pi/2)) )
 

      };  

    //ht of each tube
    #local fpb = function(a){
  

    select(a-pi/2, -sin(a+pi/2), select(a-pi, a-pi/2, select(a-3*pi/2, a-pi/2, sin(a+pi/2)+pi)) ) 
 
    }; 
   
   mkobjgrp("p_piltub")
   
   #declare bildmesh = 0;
   
   #if(fsjen=2)
      k_ifsor(fpa, fpb,     bsrad,   1,    2*pi,          prez,        prez,      0, 0)                                                          
   #else
      j_ifsor(fpa, fpb,     bsrad,   1,    2*pi,          prez,        prez,      0, 0)                                                          
   #end
   
   #declare bildmesh = 1;
   
  
  #end //if writobjfil                                                    
  
  //reset transforms back to default 
  resetranz()
  
 
#end  //p_piltub





