// Persistence of Vision Ray Tracer Scene Description File
// File: terrain_hf.pov
// Vers: 3.5
// Desc: Generates the height field targa file for exodus.pov
// Date: December 14th, 2003
// Auth: Philip Chan

// +W500 +H750
// +FT +A0.1 +W2000 +H3000 -D

global_settings {
	assumed_gamma 2.2
	hf_gray_16
}

camera {
	up y
	right 2/3*x
	location <0, 30, 0>
	look_at <0, 0, 0>
}

#declare Terrain = pigment {
	wrinkles
	color_map {
		[0.00 colour rgb <0.0, 0.0, 0.0>]
		[1.00 colour rgb <1.0, 1.0, 1.0>]
	}
	scale 1/(35*2)
}

#declare Slope = pigment {
	gradient z
	colour_map {
		[0.00 colour rgb <0.00, 0.00, 0.00>]
		[1.00 colour rgb <0.50, 0.50, 0.50>]
	}
	translate z*0.40
	scale 30
}

plane { y, 0
	pigment {
		gradient z
		pigment_map {
			[0.00 Slope]
			[0.40 Terrain]
			[1.00 Terrain]
		}
		translate z*0.475
		scale 35
	}
	finish { ambient 1 }
}

// Flat area for Hub
cylinder { <0, 0.01, 0>, <0, 0.02, 0>, 1
	pigment {
		cylindrical
		turbulence 0.1
		colour_map {
			[ 0.00 colour rgbt <0.5, 0.5, 0.5, 1> ]
			[ 0.50 colour rgbt <0.5, 0.5, 0.5, 0> ]
			[ 1.00 colour rgbt <0.5, 0.5, 0.5, 0> ]
		}
	}
	finish { ambient 1 }
	translate <-1.5, 0, -10>
}

// road going off to the right
box { <0, 0.03, -0.15>, <15, 0.04, 0.15>
	pigment {
		gradient z
		turbulence 0.1
		colour_map {
			[ 0.00 colour rgbt <0.5, 0.5, 0.5, 1> ]
			[ 0.40 colour rgbt <0.5, 0.5, 0.5, 0> ]
			[ 0.60 colour rgbt <0.5, 0.5, 0.5, 0> ]
			[ 1.00 colour rgbt <0.5, 0.5, 0.5, 1> ]
		}
		translate z*0.5
		scale 0.3
	}
	finish { ambient 1 }
	translate <-1, 0, -10>
}

// Flat area for mine
cylinder { <0, 0.01, 0>, <0, 0.02, 0>, 1
	pigment {
		cylindrical
		turbulence 0.1
		colour_map {
			[ 0.00 colour rgbt <0.75, 0.75, 0.75, 1> ]
			[ 0.50 colour rgbt <0.75, 0.75, 0.75, 0> ]
			[ 0.60 colour rgbt <0.75, 0.75, 0.75, 0> ]
			[ 1.00 colour rgbt <0.00, 0.00, 0.00, 0> ]
		}
	}
	finish { ambient 1 }
	scale 0.85
	translate <0, 0, 0>
}

#declare Sloped_Road_1T =pigment {
	gradient x
	colour_map {
		[ 0.00 colour rgbt <0.5, 0.5, 0.5, 1> ]
		[ 1.00 colour rgbt <0.75, 0.75, 0.75, 1> ]
	}
	scale 10
	translate -x*0.2
}
#declare Sloped_Road_1S =pigment {
	gradient x
	colour_map {
		[ 0.00 colour rgbt <0.5, 0.5, 0.5, 0> ]
		[ 1.00 colour rgbt <0.75, 0.75, 0.75, 0> ]
	}
	scale 10
	translate -x*0.2
}

// road to mine
box { <0, 0.03, -0.15>, <9.2, 0.04, 0.15>
	pigment {
		gradient z
		turbulence 0.1
		pigment_map {
			[ 0.00 Sloped_Road_1T ]
			[ 0.40 Sloped_Road_1S ]
			[ 0.60 Sloped_Road_1S ]
			[ 1.00 Sloped_Road_1T ]
		}
		translate z*0.5
		scale <1, 1, 0.3>
	}
	finish { ambient 1 }
	translate x*0.5
	rotate -y*degrees( atan2(10, 1.5) )
	translate <-1.5, 0, -10>
}

#declare Sloped_Road_2T =pigment {
	gradient x
	colour_map {
		[ 0.00 colour rgbt <0.5, 0.5, 0.5, 1> ]
		[ 1.00 colour rgbt <0.3, 0.3, 0.3, 1> ]
	}
	scale 5
	translate -x*0.2
}
#declare Sloped_Road_2S =pigment {
	gradient x
	colour_map {
		[ 0.00 colour rgbt <0.5, 0.5, 0.5, 0> ]
		[ 1.00 colour rgbt <0.3, 0.3, 0.3, 0> ]
	}
	scale 5
	translate -x*0.2
}

// road going into camera
box { <0, 0.03, -0.15>, <5, 0.04, 0.15>
	pigment {
		gradient z
		turbulence 0.1
		pigment_map {
			[ 0.00 Sloped_Road_2T ]
			[ 0.40 Sloped_Road_2S ]
			[ 0.60 Sloped_Road_2S ]
			[ 1.00 Sloped_Road_2T ]
		}
		translate z*0.5
		scale <1, 1, 0.3>
	}
	finish { ambient 1 }
	translate x*0.5
	rotate y*degrees( atan2(5, 2) )
	translate <-1.5, 0, -10>
}

// road going off to left
box { <-5, 0.03, -0.15>, <0, 0.04, 0.15>
	pigment {
		gradient z
		turbulence 0.1
		colour_map {
			[ 0.00 colour rgbt <0.5, 0.5, 0.5, 1> ]
			[ 0.40 colour rgbt <0.5, 0.5, 0.5, 0> ]
			[ 0.60 colour rgbt <0.5, 0.5, 0.5, 0> ]
			[ 1.00 colour rgbt <0.5, 0.5, 0.5, 1> ]
		}
		translate z*0.5
		scale 0.3
	}
	finish { ambient 1 }
	translate <-2, 0, -10>
}

/*
#declare i = -10;
#while( i <= 10 )
	#declare j = -15;
	#while( j <= 15 )
		cylinder { <i, 0, j>, <i, 1, j>, 0.1
			pigment { colour rgb <1, 1, 1> }
			finish { ambient 1 }
		}
		#declare j = j + 3;
	#end
	#declare i = i + 2;
#end
*/