#version unofficial MegaPov 1.0;
#default { texture { pigment { color red 1 filter .5  } finish { ambient 0 } } }

#declare phd = 1.0;	//used in photons
global_settings {
	assumed_gamma 1.8
	max_trace_level 100
	radiosity {
		pretrace_start 0.08
		pretrace_end 0.02
		brightness 1
		count 80
		adc_bailout 0.01/2
		error_bound 1
		gray_threshold 0.0
		low_error_factor 0.5
		minimum_reuse 0.015
		nearest_count 5
		recursion_limit 2
		media on
 	}
	photons {
		gather 20, 100
		media 5, 0.5
		radius 0.1
		count 5000
		jitter 0.4
		expand_thresholds 0.2, 40
		max_trace_level 6
		adc_bailout 1/255
	}
}

#include "colors.inc"
#include "textures.inc"

light_source { 100, rgb 1 scale -z }

light_source {
	0 // <3, 3, -5>
	rgb <1.0, 1.0, 1.0>
	spotlight
 	point_at y-z/2 // <0.0, 0.0, 0.0>
	radius 15
	falloff 10
	tightness 10
	photons {
		refraction on reflection on
	}
	translate z/2
}
light_source {
	< 0, 1, 2 >
	rgb <1.0, 1.0, 1.0>
	spotlight
 	point_at < 0, 2, .2 >
	radius 45
	falloff 15
	tightness 10
	photons {
		refraction on reflection on
	}
	translate z/2
}

#local MartiniGlass = object { #include "MartiniGlass.inc" 

}
object { MartiniGlass 
	scale 1.5
	rotate < -22, 0, 30 >
	translate < 3.2, -6, 3 >
	pigment { rgb < .8, 1, .8> filter 1 }
	interior { 
		ior 1.3333 
		media { emission rgb < 0, 1., .3 > }
	}
	hollow on
}

// Text objects
#local BlowYourResolutions = text {
	ttf "UniversCL.ttf",
	"BLOW YOUR RESOLUTIONS EARLY"
	1/20, x/7
	h_align_center
	scale 1/3
}
#local NYE_text = text {
	ttf "SuburbanBold.ttf"
	"new years eve"
	12, x/12
	h_align_center
	scale 1.5
}
#local AtTheRoseBowl = text {
	ttf "UniversCL.ttf",
	"at the ROSE BOWL LOUNGE"
	1/20, x/16
	h_align_center
	scale 1/2
}
#local Buffet_MixedCase = text {
	ttf "UniversUltCondLight.ttf",
	"The Bowl's Bitchin' Biohazard Buffet"
	0.3,0
	h_align_center
	scale 2/3
}
#local Buffet_UpperCase = text {
	ttf "UniversUltCondLight.ttf",
	"THE BOWL'S BITCHIN' BIOHAZARD BUFFET"
	1/20, x/16
	h_align_center
	scale 1/2
}
#local Buffet_Description = text {
	ttf "SuburbanBold.ttf"
	"that's got 30 items of pure rose bowl love, baby!"
	1/20, x/8
	h_align_center
	scale 1/4
}

#local Buffet_Featuring = text {
	ttf "FuturaL.ttf",
	"featuring"
	1/20, x/16
//	h_align_center
	scale 1/2
}
#local FeaturesText = union {
	text {
		ttf "UniversCB.ttf",
		"Kickin' Tunes,"
		1/20, 0
	}
	text {
		ttf "UniversCB.ttf",
		"Champagne,"
		1/20, 0
		translate -y
	}
	text {
		ttf "UniversCB.ttf",
		"Party Favours"
		1/20, 0
		translate -y*2.1
	}
	text {
		ttf "UniversCLO.ttf",
		"and it's at the Rose Bowl. Yeah!"
		1/20, 0
		scale 2/3
		translate -y*3
	}
	scale 1/5
}
#local AdmissionText = union {
	text {
		ttf "UniversCB.ttf",
		"Dec 31, 2003 (duh)"
		1/20, 0
	}
	text {
		ttf "UniversCB.ttf",
		"Five Bucks In Advance"
		1/20, 0
		translate -y
	}
	text {
		ttf "UniversCB.ttf",
		"$7 at the Door"
		1/20, 0
		translate -y*2
	}
	text {
		ttf "UniversCLO.ttf",
		"Buffet Items Extra"
		1/20, 0
		translate -y*3.2
	}
	scale 1/3
}
#local CreditsText =  text {
	ttf "Futura.ttf",
	"Poster designed by Murray. No, not that one, the other one. Yeah, him."
	1/20, x/16
	h_align_center
	scale 1/6
}


// Text Composition
object { NYE_text
	translate < 0, 2.5, .8 >
	pigment { rgb <1, .6, .3> filter 1 }
	interior { ior 2 media { emission rgb <1, .4, 0> } }
	hollow on
	photons { target 1 refraction on }
}
//object { NYE_text
//	scale <1, 1, 1/72>
//	translate < 0, 2.5, 6.85 >
//	pigment { rgb 1 }
//	finish { ambient .8 }
//}

#local WhiteText = union {
	object { BlowYourResolutions
		translate < 0, 2.3, -.1 >
	}
	object { AtTheRoseBowl
		translate < 0, 1.4, .2 >
	}
	object { Buffet_Featuring
		translate < -2.8, -2.6, 0 >
	}
	object { Buffet_UpperCase
		translate < 0, -3.1, 0 >
	}
	object { Buffet_Description
		translate < 0, -3.3, 0 >
	}
	object { AdmissionText
		translate -3.8*y
	}
	object { FeaturesText
		rotate -15*y
		translate < 0, -5/4, -2 >
	}
}
object { WhiteText
	pigment { rgb 1 }
	finish { ambient .8 }	
}
object { WhiteText // drop-shadow
	pigment { rgb 0 }
	finish { ambient 0 }
	translate <1/1000, 1/1000, 1/30>
}

object { CreditsText
	rotate 30*x
	translate -5.3*y
	pigment { rgb 1 }
	finish { ambient .8 }	
}

// Biohazard Logo
#local Mask_Sphere = sphere { 0,1 
	scale < 2.2, 2.2, .99 >
	translate z
}

object { Mask_Sphere scale .8
	pigment { rgb 1 filter .8 }
	finish {
		ambient 1
		diffuse 0.6
		phong 1.0
		phong_size 100
		reflection .3
	}
	photons {
		target  1.0
		reflection on
		refraction on
		collect on
	}
	interior { ior .9 } //  1.5 }
}
#local BHS = intersection {
	object { Mask_Sphere }
	object { #include "biohazard.inc" }
	pigment { red 1 filter 1 }
	interior { ior 2 }
	photons {
		target  1.0
		reflection on
		refraction on
		collect on
	}
}

object { BHS }

//plane { -z, -.9999999999
//	texture { Brushed_Aluminum scale 1/4 } // pigment { checker rgb .9, rgb .6 }
//}

cylinder {
	<0, 0, 1>, <0, 0, 2>, 2.4
	texture { Brushed_Aluminum scale 1/4 } // pigment { checker rgb .9, rgb .6 }
}

//camera {
//	perspective 
//	location <0, 0, -4>
//	up y*image_height right x*image_width
//	angle 75
//	look_at <0, 0, 0>
//	translate -1.5*y
//}
camera {
	ultra_wide_angle 
	location <0, 0, -4>
	up y*image_height right x*image_width
	angle 78
	look_at <0, 0, 0>
	translate -1.4*y
}

//camera {
//	orthographic 
//	location <0, 0, -10>
//	up y*5 right x*5
//	look_at <0, 0, 0>
//}
#declare Checks = pigment { checker rgb .85, rgb .6 scale 1/32 rotate 30 } 
//sky_sphere { pigment { checker .3, .6 scale .2 } }
#local Stars = pigment {
        granite
        color_map {
            [ 0.000  0.270 color rgb < 0, 0, 0> color rgb < 0, 0, 0> ]
            [ 0.270  0.300 color rgb <.5,.5,.4> color rgb <.8,.8,.4> ]
            [ 0.300  0.470 color rgb < 0, 0, 0> color rgb < 0, 0, 0> ]
            [ 0.470  0.500 color rgb <.4,.4,.5> color rgb <.4,.4,.8> ]
            [ 0.500  0.670 color rgb < 0, 0, 0> color rgb < 0, 0, 0> ]
            [ 0.670  0.700 color rgb <.5,.4,.4> color rgb <.8,.4,.4> ]
            [ 0.700  0.870 color rgb < 0, 0, 0> color rgb < 0, 0, 0> ]
            [ 0.870  0.900 color rgb <.5,.5,.5> color rgb < 1, 1, 1> ]
            [ 0.900  1.000 color rgb < 0, 0, 0> color rgb < 0, 0, 0> ]
        }
    turbulence 1
    sine_wave
    scale .125
}

sky_sphere { 
	pigment {
		gradient y
		pigment_map {
			[ 0.0 rgb < .8, .3, 1 > ]
			[ 0.7 Stars ] //Checks ]
			[ .85 rgb <0, .4, .5> ]
			[ 1 Stars ]
		}
		scale 2
		translate -y
	}
	rotate 15*x-15*z
}
