
// Glenn's POV-Ray Scene File - Speeder Graphics Overlay
// created 13-Dec-03 for the Internet Raytracing Competition (www.irtc.org)
// last update 31-Dec-03
// copyright 2003 Glenn McCarter (glenn@mccarters.net)
//
// This adds the text overlays onto the image.
// Image is placed on Y-Z plane, at X=0, and is viewed from -X direction
// Used RH coordinate system with Z=up
                                                   
#include "GIncludeRH.inc"
//#include "GRuler.inc"

#version 3.5;
global_settings {
	adc_bailout 1/255 // default 1/255
	ambient_light <1.0,1.0,1.0> // default <1,1,1>, use 0 for radiosity
//	ambient_light <0.5,0.5,0.5>
//	ambient_light <0.1,0.1,0.1>
//	ambient_light <0.05,0.05,0.05>
//	ambient_light <0.01,0.01,0.01>
//	ambient_light <0.003,0.003,0.003> // test
//	ambient_light <0.0,0.0,0.0> // this is most realistic with radiosity on
//	ambient_light <-0.1,-0.1,-0.1> // not bad
//	ambient_light <-2,-2,-2> // spoiled orange
	assumed_gamma 2.2
	hf_gray_16 off
	irid_wavelength <0.25,0.18,0.14>
	max_intersections 64
	max_trace_level 20
	number_of_waves 10
	noise_generator 2
}

//===============================================
//             Variables
//===============================================

#declare ImageHeight = 6;                        // height of the image in units (inches)
#declare IH = ImageHeight;
#declare AspectRatio = 4/3;
#declare AR = AspectRatio;
#declare ImageWidth = ImageHeight * AspectRatio;
#declare IW = ImageWidth;

// Setting the image height is useful if you want to place objects
// in front of the image.  If you leave the ImageHeight at 1, the total
// image will be 1 unit tall.  So objects placed in front of the image
// would have to be very small to be visible.

//===============================================
//             Cameras
//===============================================

#declare Ortho_Cam =
	camera {
		orthographic
		direction <0.0,     1.0,  0.0>
		sky       <0.0,     0.0,  1.0>  // Use right handed-system!
		up        <0.0,     0.0,  IH >  // Where Z is up
		right     <IW,      0.0,  0.0>
//	location  <-1, .5, .5>
//	look_at   < 0, .5, .5>
	location  <-1, IW/2, IH/2>
	look_at   < 0, IW/2, IH/2>
}

#declare Special_Cam =
	camera {
		perspective
		direction <0.0,     1.0,  0.0>
		sky       <0.0,     0.0,  1.0>  // Use right handed-system
		up        <0.0,     0.0,  1.0>  // Where Z is up
		right     <4/3,     0.0,  0.0>
	angle 35
	location <-0,-15,15>
	look_at <0,IW/2,IH/2>
	}


camera {
//	Special_Cam
	Ortho_Cam
  }

//===============================================
//             Textures
//===============================================

#declare WhiteBoxTex =
	texture {
		pigment { color rgb<1,1,1>*1.0 }
//		finish { ambient 0.95 specular .3 roughness .01 }
		finish { ambient 0.6 specular .3 roughness .1 }
	}		             

#declare BlueBoxTex =
	texture {
		pigment { color rgb<.21,.21,.86> }
		finish { ambient .95 specular .3 roughness .01 }
	}		             
#declare AllNewInk =
	texture {
//		pigment { color rgb<215/255,245/255,11/255> } // yellow
		pigment { color rgb<1,1,1> }
		finish { ambient 0.95 specular .3 roughness .01 }
	}		             
#declare WhiteInk =
	texture {
		pigment { color rgb<1,1,1> }
		finish { ambient 1.5 specular .3 roughness .01 }
	}		             
#declare GreyInk =
	texture {
		pigment { color rgb<1,1,1>*0.23 }
		finish { ambient 1.0 specular .3 roughness .01 }
	}		             
#declare DarkInk =
	texture {
		pigment { color rgb<1,1,1>*0.3 }
		finish { ambient 1.5 specular .3 roughness .01 }
	}		             
#declare BlueInk =
	texture {
		pigment { color rgb<.1,.1,.86> }
		finish { ambient .95 specular 2.3 roughness .01 }
	}		             
#declare LogoTex =
	texture {
		pigment { color rgb<.1,.1,.86> }
		finish { ambient .95 specular 2.3 roughness .01 }
	}		             
#declare LightLogoTex =
	texture {
//		pigment { color rgb<.21,.21,.86> } // light blue
		pigment { color rgb<.51,.51,.86> } // light blue
		finish { ambient .95 specular 2.3 roughness .01 }
	}		             

           
//===============================================
//             Lighting
//===============================================

#declare OverheadSpot =
  light_source {
    <-20,20,20>
    color rgb <1, 1, 1>*50/100 // watts
    area_light <0,5,0>, <0,0,5>, 4, 4
    spotlight
    point_at <0,0,0>
    radius 12    // degrees fully lit (*2)
    falloff 35*1.5   // degrees no lighting (*2)
    tightness 1
  }
object { OverheadSpot }

//===============================================
//             Environment
//===============================================

background { color rgb <0.0, 0.0, 0.0> } // black
//object {GroundPlaneWhite translate z*-0}

//===============================================
//             Objects
//===============================================

//#declare ImageHeight = 1;
//#declare ImageWidth = AspectRatio; 
                          	
#declare ImageBox =
	box {
		<0,0,-.1>,<1,1,0> // the box is initially square
		texture { WhiteInk }
		texture {
			pigment {
				image_map { // image is always projected from -z, with front facing +z, top to +Y
					png "SpeederCity.png"
//					bmp "SpeederCity.bmp"
					once
					interpolate 4
				}
			}
			finish { ambient 1 }
			scale <1,1,1> // the image is initially square
		}
		rotate <90,0,-90> // align to camera
//		translate <0,1-.001,-.001> // align to camera (with slight overscan)
		translate <0,1,0> // align to camera (with slight overscan)
//		scale <1,ImageWidth*1.002,ImageHeight*1.002> // scale it up to match camera view
		scale <1,ImageWidth,ImageHeight> // scale it up to match camera view
	}

#declare TBH = 0.6;
#declare TopBox =
	union {
/*
		box {
			<0,0,0>,<1,1,1> // the box is initially square
			scale <1,ImageWidth+1,TBH+1> // scale it up to match camera view
			translate <0,0,ImageHeight-TBH>
			texture { WhiteBoxTex }
//			texture { BlueInk }
		}
*/
		box {
			<0,0,-1>,<1,1,0> // the box is initially square
			scale <1,ImageWidth+1,0.035> // scale it up to match camera view
			translate <0,0,ImageHeight-TBH>
			texture { BlueBoxTex }
		}
	} // end union

#declare BottomBox =
	box {
		<0,0,0>,<1,1,1> // the box is initially square
		scale <1,ImageWidth,1.0> // scale it up to match camera view
		texture { WhiteBoxTex }
	}

//----------------- Text -----------------

#declare MainFont = "FRABK.TTF";
#declare AllNewFont = "FRADM.TTF";
#declare MainFontBD = "FRAHV.TTF";
//#declare MainFont = "ARIAL.TTF";
//#declare AllNewFont = "ARIALBD.TTF";
//#declare MainFontBD = "ARIALBD.TTF";

#declare TopLine =
	text {
		ttf MainFontBD,
		"Cleared for takeoff.",
		.001,     // THICKNESS_FLOAT, extruded into +Z
		0       //OFFSET_VECTOR
		scale .6
		rotate <90,0,-90>
		texture { WhiteInk }
	}
#declare AllNew =
	text {
		ttf AllNewFont,
		"The All-New Superconducting Speeder",
		.05,     // THICKNESS_FLOAT, extruded into +Z
		0       //OFFSET_VECTOR
		scale .4
		rotate <90,0,-90>
		texture { AllNewInk }
	}
#declare Blurb1Line1 =
	text {
		ttf MainFont,
		"High torque antigrav turbine",
		.001,     // THICKNESS_FLOAT, extruded into +Z
		0       //OFFSET_VECTOR
		scale .13
		rotate <90,0,-90>
		texture { GreyInk }
	}
#declare Blurb1Line2 =
	text {
		ttf MainFont,
		"New SuperFlux  magnetic inducer",
		.001,     // THICKNESS_FLOAT, extruded into +Z
		0       //OFFSET_VECTOR
		scale .13
		rotate <90,0,-90>
		texture { GreyInk }
	}
#declare Blurb1Line2TM =
	text {
		ttf MainFont,
		"TM",
		.001,     // THICKNESS_FLOAT, extruded into +Z
		0       //OFFSET_VECTOR
		scale .045
		rotate <90,0,-90>
		texture { GreyInk }
	}
#declare Blurb1Line3 =
	text {
		ttf MainFont,
		"Full dynamic stabilization",
		.001,     // THICKNESS_FLOAT, extruded into +Z
		0       //OFFSET_VECTOR
		scale .13
		rotate <90,0,-90>
		texture { GreyInk }
	}
#declare Blurb1Line4 =
	text {
		ttf MainFont,
		"Automated collision avoidance",
		.001,     // THICKNESS_FLOAT, extruded into +Z
		0       //OFFSET_VECTOR
		scale .13
		rotate <90,0,-90>
		texture { GreyInk }
	}
#declare Blurb2Line1 =
	text {
		ttf MainFont,
		"Improved 3D HUD capability",
		.001,     // THICKNESS_FLOAT, extruded into +Z
		0       //OFFSET_VECTOR
		scale .13
		rotate <90,0,-90>
		texture { GreyInk }
	}
#declare Blurb2Line2 =
	text {
		ttf MainFont,
		"Optional set-and-forget autopilot",
		.001,     // THICKNESS_FLOAT, extruded into +Z
		0       //OFFSET_VECTOR
		scale .13
		rotate <90,0,-90>
		texture { GreyInk }
	}
#declare Blurb2Line3 =
	text {
		ttf MainFont,
		"Biometric ignition recognizes only you",
		.001,     // THICKNESS_FLOAT, extruded into +Z
		0       //OFFSET_VECTOR
		scale .13
		rotate <90,0,-90>
		texture { GreyInk }
	}
#declare Blurb2Line4 =
	text {
		ttf MainFont,
		"Smart perimeter defense system",
		.001,     // THICKNESS_FLOAT, extruded into +Z
		0       //OFFSET_VECTOR
		scale .13
		rotate <90,0,-90>
		texture { GreyInk }
	}
#declare BottomLine =
	text {
		ttf MainFont,
		"C2014 Glenn McCarter            Pilot responsibly, always wear a VR helmet",
		.001,     // THICKNESS_FLOAT, extruded into +Z
		0       //OFFSET_VECTOR
		scale .10
		rotate <90,0,-90>
		texture { DarkInk }
	}

//----------------- Logo -----------------
#declare Yamitsu =
	text {
		ttf MainFontBD,
		"YAMITSU",
		.1,     // THICKNESS_FLOAT, extruded into +Z
		0       //OFFSET_VECTOR
		scale .3
		rotate <90,0,-90>
		texture { BlueInk }
	}
#declare YamitsuTag =
	text {
		ttf MainFont,
		"INTO THE FUTURE",
		.001,     // THICKNESS_FLOAT, extruded into +Z
		<0.08,0,0>       //OFFSET_VECTOR <x,y,z>
		scale .14
		rotate <90,0,-90>
		texture { BlueInk }
	}
#declare YamitsuBadge =
	union {
		sphere { <0,0,0>,0.25 scale <0.5,1,1> texture { LogoTex } }
		#declare Spokes = 0;
		#while ( Spokes < 3 )
			box { <-0.15,-0.02,0>,<0,0.02,0.18> texture { LightLogoTex } translate <0,-0.03,0> rotate y*10 rotate x*(60+120*Spokes) }
			box { <-0.15,-0.02,0>,<0,0.02,0.18> texture { LightLogoTex } translate <0, 0.03,0> rotate y*10 rotate x*(60+120*Spokes) }
			#declare Spokes = Spokes + 1;
		#end
	}

#declare YamitsuLogo =
	union {
		object { Yamitsu translate <0.0,1.8,0.5> }
		object { YamitsuTag translate <0.0,1.72,0.5-0.20> }
//		object { YamitsuBadge scale 0.6 translate <0.0,2.1,0.56> }
		object { YamitsuBadge scale 0.8 translate <0.0,2.1,0.56> }
	} // end union

//===============================================
//             Object Placement
//===============================================

// Scene Coordinates:
// Camera is in -X direction
// Image is at X=0, extending width into +Y and height into +Z

object { ImageBox translate <10,0,0> } // put it behind any overlays

object { TopBox translate <0.002,0,0> }
object { BottomBox translate <0.002,0,0> }

object { TopLine translate <0.0,ImageWidth-0.2,ImageHeight-0.54> }
object { AllNew translate <0.0,ImageWidth-0.2,1> }

#declare BLS = 0.16; // Blurb Line Spacing
object { Blurb1Line1 translate <0.0,ImageWidth-0.2,0.82> }
object { Blurb1Line2 translate <0.0,ImageWidth-0.2,0.82-BLS> }
object { Blurb1Line2TM translate <0.0,ImageWidth-0.2-0.80,0.82-BLS+.05> }
object { Blurb1Line3 translate <0.0,ImageWidth-0.2,0.82-BLS*2> }
object { Blurb1Line4 translate <0.0,ImageWidth-0.2,0.82-BLS*3> }

object { Blurb2Line1 translate <0.0,ImageWidth-2.5,0.82> }
object { Blurb2Line2 translate <0.0,ImageWidth-2.5,0.82-BLS> }
object { Blurb2Line3 translate <0.0,ImageWidth-2.5,0.82-BLS*2> }
object { Blurb2Line4 translate <0.0,ImageWidth-2.5,0.82-BLS*3> }
object { BottomLine  translate <0.0,ImageWidth-0.2,0.82-BLS*4.5> }

object { YamitsuLogo }



